
package com.smartgwt.client.docs;

/**
 * <h3>Waiting for asynchronous actions</h3>
 * In Smart GWT automated testing, certain actions may trigger asynchronous operations, such as
 * DataSource requests, deferred UI updates, or queued redraws. Attempting to interact with
 * application components before these operations complete can cause unstable or inconsistent test
 * results. <P> The {@link com.smartgwt.client.util.AutoTest#waitForSystemDone
 * AutoTest.waitForSystemDone()} API ensures that all pending asynchronous Smart GWT actions have
 * completed before proceeding. This method relies on {@link
 * com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} to determine when the
 * system is ready for further input. <P> <b>Key considerations</b> <ul> <li><b>System
 * readiness:</b> Waiting for the framework to report that it is "system done" ensures that all
 * queued Smart GWT actions have been processed before continuing.</li> <li><b>Limitations:</b>
 * {@link com.smartgwt.client.util.AutoTest#isSystemDone AutoTest.isSystemDone()} only tracks
 * asynchronous processes managed by Smart GWT. Actions outside of Smart GWT?s control (e.g.,
 * third-party widget rendering, non-Smart GWT network requests) may require additional
 * waits.</li> <li><b>Targeted waits:</b> In scenarios where only a specific component?s readiness
 * matters, you can wait for a specific element using {@link
 * com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()} instead of waiting
 * for the entire system.</li> <li><b>Timeout control:</b> Waiting methods support timeouts to
 * avoid indefinite waits if a condition cannot be satisfied.</li> </ul>
 */
public interface WaitingForAsyncActions {
}
