
package com.smartgwt.client.docs;

/**
 * The history mechanism automatically maintains a list of the last N actions taking by an AI as
 * part of
 *  executing a CoTProcess, to help the AI maintain context when it needs to execute a series of
 *   CoTTasks as part of an overall, logical task.
 *  <p>
 * This is needed to support the more predictable {@link
 * com.smartgwt.client.docs.CoTExecutionModels "AI Workflow"} execution model for
 *  enterprise AI workflows.
 *  <p>
 *  <h4>What is recorded</h4>
 * History is tracked automatically for: (a) transitions (the model emitted
 * {goTo,intent,stepAfter}),
 *  and (b) successful non?transition results that were validated and applied to
 * {@link com.smartgwt.client.util.workflow.Process#getState state} (for example via 
 * CoTTask.stateUpdates).
 *  <p>
 *  <h4>History storage</h4>
 *  The primary list is kept on the process as  history. For ease of
 *  serialization and prompt access, a bounded mirror is also maintained at
 *  <code>process.state.history</code>. Both lists are append?only during a run.
 *  <p>
 *  <h4>Including history in prompts</h4>
 *  History is typically referenced from  standard prompt template via
 *  the "${promptPart('history')}", which includes the  CoTProcess.historyPrimer and history data.
 *  <p>
 *  <h4>Manual entries</h4>
 *  Add entries programmatically via  CoTProcess.addHistory(). This appends to the process
 *  history and mirrors to <code>state.history</code> within configured limits.
 *  <pre>
 *  process.addHistory({
 *    taskID: task.ID,
 *    summary: "Added field 'orderDate'",
 *    ts: Date.now()
 *  });
 *  </pre>
 *  <p>
 *  <h4>Maximum history entries</h4>
 *  The in?memory maximum is controlled by  CoTProcess.historyMaxItems. The mirrored
 *  <code>state.history</code> maximum is controlled by  CoTProcess.stateHistoryMaxItems and
 *  defaults to the in?memory maximum if unset. Older entries are dropped when limits are reached.
 *  Implementations may summarize older entries into a compact note before dropping them.
 */
public interface CoTHistory {
}
