
package com.smartgwt.client.docs;

/**
 * <h3>Writing AutoTests for multiple environments</h3>
 * Smart GWT has powerful features for integrating with a variety of third party testing tools.
 * See the {@link com.smartgwt.client.docs.AutomatedTesting Automated Testing overview} for an
 * overview of how to use testing tools with Smart GWT. <P> The {@link
 * com.smartgwt.client.docs.AutoTestLocator} system ensures that user interface elements can be
 * reliably identified when recording or playing back tests independently of the DOM structure
 * generated by Smart GWT components. Using locators insulates developers from changes to the
 * generated DOM structure due to  different Smart GWT builds, different browsers and different
 * skins.  <P> See the documentation topic {@link com.smartgwt.client.docs.ReliableLocators} for
 * best practices with respect to building applications that will generate robust and reliable
 * locators. <P> The AutoTest system also has some advanced features to facilitate recording and
 * playing back tests across environments with significant differences including:
 * <ul><li>Different data: multiple environments with different data sets          (for example,
 * test vs staging vs production)</li>     <li>Embedded UI: your application or user interface may
 * be embedded         within a larger application or portal</li>     <li>Per-User presentation:
 * an application may present the same functionality         differently per user. For example if
 * an application has separately licensable         modules, the user interface to navigate to
 * some functional area may differ         depending on which modules are available to the
 * user</li>     <li>Customer customizations: an application may allow users to add        
 * additional UI or rearrange screens</li> </ul> <P> <b>AutoTest variables</b> <P> The {@link
 * com.smartgwt.client.util.AutoTest#setVariable variables} feature allows developers to specify
 * explicit variable names and corresponding values for use when resolving AutoTest locators. <P>
 * Variables may be used anywhere within a locator string, but a common use case would be handling
 * different data in different deployments. For example the locator for a ListGrid cell element
 * might be as follows: <P>
 * <code>//ListGrid[ID="countryList"]/body/row[pk=47||countryCode=WS||countryName=Western%20Samoa||2]/col[fieldName=countryName||1]</code>
 * <P> This locator includes various fallback attributes to identify the row and column (see the
 * {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator overview} for information about
 * fallback attributes in locator segments). <P> If you want to identify the cell by primary key
 * field value and column name only, this could be simplified to be just: <P>
 * <code>//ListGrid[ID="countryList"]/body/row[pk=47]/col[fieldName=countryName]</code> <P> In a
 * different data set, the equivalent record might have a different  primary key field value,
 * meaning any locators that referenced it via hardcoded values like <code>pk=47</code> would fail
 * to resolve to the correct target. This can be handled by setting up an AutoTest variable before
 * the test executes - for example recording the target record as <code>testRecord</code>, and
 * referring to it directly in the locators: <P>
 * <code>//ListGrid[ID="countryList"]/body/row[pk=&#36;{testRecord.pk}]/col[fieldName=countryName]</code>
 * <P> <b>AutoTestLocator root</b> <P> The {@link com.smartgwt.client.util.AutoTest#testRoot
 * testRoot} attribute allows developers to designate some component as the "root" for an
 * autoTest. With this setting in place,  locators for elements anywhere within that root
 * component will be generated as a path from the testRoot to the target component. These locators
 * will always start with the special prefix <code>//testRoot[]</code>. <P> If the same UI
 * elements are then rendered inside another container in  a different environment, configuring
 * {@link com.smartgwt.client.util.AutoTest#testRoot testRoot} to point to this container will
 * allow the locators to resolve correctly. <P> If no global testRoot was specified, any component
 * with an explicit {@link com.smartgwt.client.widgets.Canvas#getID ID} will be treated as the
 * root component for the elements it contains. This means that locators for components with
 * explicit IDs will resolve correctly regardless of where these components are in the page's
 * structure. <P> Components with an explicit ID are located by ID and widget class name by
 * default. You can also set {@link com.smartgwt.client.widgets.Canvas#getLocateByIDOnly
 * Canvas.locateByIDOnly} - this will cause the generated locator for the component to omit the
 * widget class name altogether and create a very compact locator of the format
 * <code>///componentID</code>
 */
public interface PortableAutoTests {
}
