package com.smartgwt.sample.showcase.client.dataintegration.java.union;

import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class UnionDataSourceSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "<i>Union DataSources</i> bond two or more dataSources such that the returned dataset"+
        "contains records from all the member dataSources. They support normal dataSource "+
        "facilities like sorting, filtering and includeFrom, and they can be nested (ie, a "+
        "unionDataSource can contain other unionDataSources among its members)."+
        "<p>"+
        "Union dataSources can have any type of dataSource as a member, but one common special "+
        "case is that all member dataSources are SQL dataSources. In this case, the union is "+
        "implemented with a SQL UNION operation, for maximum efficiency and performance."+
        "<p>"+
        "The sample below demonstrates a SQL Union DataSource. It shows how three different "+
        "types of Human Resources - employees, subcontractors and agency workers - can be "+
        "unioned to show an overall view of all staff, a view that can be filtered, sorted, etc."+
        "Note how the member dataSources simply contribute null values for inapplicable fields "+
        "(only agency workers have a value for \"Agency Name\", for example). Also note how the "+
        "\"staff\" dataSource uses field declarations to cause member fields to be unioned when they "+
        "have different names, but does not need to in cases where the fields can be automatically "+
        "bound by name (as with \"Email\", for example). This example also demonstrates a union "+
        "dataSource working with included fields (agency name)";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            UnionDataSourceSample panel = new UnionDataSourceSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

        Canvas canvas = new Canvas();
        DataSource staffDS = DataSource.get("staff");
        
        final ListGrid staffList = new ListGrid();
        staffList.setWidth(1000);
        staffList.setHeight(448);
        staffList.setAutoFetchData(true);
        staffList.setShowFilterEditor(true);
        staffList.setDataSource(staffDS);

        canvas.addChild(staffList);

        return canvas;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

}