/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.BitSet;
import java.util.Map;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmMapEntryResult<K, V, R extends Map.Entry<K, V>>
implements DomainResult<R> {
    private final DomainResult<K> keyResult;
    private final DomainResult<V> valueResult;
    private final JavaType<R> javaType;
    private final String alias;

    public SqmMapEntryResult(DomainResult<K> keyResult, DomainResult<V> valueResult, String alias, JavaType<R> javaType) {
        this.alias = alias;
        this.keyResult = keyResult;
        this.valueResult = valueResult;
        this.javaType = javaType;
    }

    @Override
    public String getResultVariable() {
        return this.alias;
    }

    @Override
    public DomainResultAssembler<R> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        final DomainResultAssembler<K> keyAssembler = this.keyResult.createResultAssembler(null, creationState);
        final DomainResultAssembler<V> valueAssembler = this.valueResult.createResultAssembler(null, creationState);
        return new DomainResultAssembler<R>(){

            @Override
            public R assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
                Object key = keyAssembler.assemble(rowProcessingState, options);
                Object value = valueAssembler.assemble(rowProcessingState, options);
                return Map.entry(key, value);
            }

            @Override
            public JavaType<R> getAssembledJavaType() {
                return SqmMapEntryResult.this.javaType;
            }
        };
    }

    public JavaType<R> getResultJavaType() {
        return this.javaType;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        this.keyResult.collectValueIndexesToCache(valueIndexes);
        this.valueResult.collectValueIndexesToCache(valueIndexes);
    }
}

