/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.openqa.selenium.net.EphemeralPortRangeDetector;
import org.openqa.selenium.net.FixedIANAPortRange;

public class LinuxEphemeralPortRangeDetector
implements EphemeralPortRangeDetector {
    private final int firstEphemeralPort;
    private final int lastEphemeralPort;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LinuxEphemeralPortRangeDetector getInstance() {
        File file = new File("/proc/sys/net/ipv4/ip_local_port_range");
        if (!file.exists()) return new LinuxEphemeralPortRangeDetector(new StringReader("49152 65535"));
        if (!file.canRead()) return new LinuxEphemeralPortRangeDetector(new StringReader("49152 65535"));
        try (FileReader inputFil = new FileReader(file);){
            LinuxEphemeralPortRangeDetector linuxEphemeralPortRangeDetector = new LinuxEphemeralPortRangeDetector(inputFil);
            return linuxEphemeralPortRangeDetector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    LinuxEphemeralPortRangeDetector(Reader inputFil) {
        FixedIANAPortRange defaultRange = new FixedIANAPortRange();
        int lowPort = defaultRange.getLowestEphemeralPort();
        int highPort = defaultRange.getHighestEphemeralPort();
        try (BufferedReader in = new BufferedReader(inputFil);){
            String[] split = in.readLine().split("\\s");
            lowPort = Integer.parseInt(split[0]);
            highPort = Integer.parseInt(split[1]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.firstEphemeralPort = lowPort;
        this.lastEphemeralPort = highPort;
    }

    @Override
    public int getLowestEphemeralPort() {
        return this.firstEphemeralPort;
    }

    @Override
    public int getHighestEphemeralPort() {
        return this.lastEphemeralPort;
    }
}

