/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.ILogger;
import com.isomorphic.log.Level;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.util.Loader;

public class Log4j2Logger
implements ILogger {
    private static final Map<Level, org.apache.logging.log4j.Level> toLog4j = new HashMap<Level, org.apache.logging.log4j.Level>(){
        {
            this.put(Logger.ALL, org.apache.logging.log4j.Level.ALL);
            this.put(Logger.OFF, org.apache.logging.log4j.Level.OFF);
            this.put(Logger.FATAL, org.apache.logging.log4j.Level.FATAL);
            this.put(Logger.ERROR, org.apache.logging.log4j.Level.ERROR);
            this.put(Logger.WARN, org.apache.logging.log4j.Level.WARN);
            this.put(Logger.INFO, org.apache.logging.log4j.Level.INFO);
            this.put(Logger.DEBUG, org.apache.logging.log4j.Level.DEBUG);
        }
    };
    public static final Map<org.apache.logging.log4j.Level, Level> fromLog4j = new HashMap<org.apache.logging.log4j.Level, Level>(){
        {
            this.put(org.apache.logging.log4j.Level.ALL, Logger.ALL);
            this.put(org.apache.logging.log4j.Level.OFF, Logger.OFF);
            this.put(org.apache.logging.log4j.Level.FATAL, Logger.FATAL);
            this.put(org.apache.logging.log4j.Level.ERROR, Logger.ERROR);
            this.put(org.apache.logging.log4j.Level.WARN, Logger.WARN);
            this.put(org.apache.logging.log4j.Level.INFO, Logger.INFO);
            this.put(org.apache.logging.log4j.Level.DEBUG, Logger.DEBUG);
            this.put(org.apache.logging.log4j.Level.TRACE, Logger.ALL);
        }
    };
    private static LoggerContext context;
    private org.apache.logging.log4j.Logger log;

    public static LoggerContext getLoggerContext() {
        if (context == null) {
            context = (LoggerContext)LogManager.getContext((boolean)false);
        }
        return context;
    }

    public static void setLoggerContext(Object newContext) {
        if (!(newContext instanceof LoggerContext)) {
            throw new IllegalArgumentException("Expected argument of org.apache.logging.log4j.core.LoggerContext type");
        }
        context = (LoggerContext)newContext;
    }

    protected static void init(boolean logEnabled) throws Exception {
        if (!logEnabled) {
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            builder.setStatusLevel(org.apache.logging.log4j.Level.ERROR);
            builder.add(builder.newRootLogger(org.apache.logging.log4j.Level.OFF));
            context = Configurator.initialize((Configuration)((Configuration)builder.build()));
            return;
        }
        String iscLogConfig = System.getProperty("iscLog4jConfiguration");
        URL configURL = null;
        if (iscLogConfig != null && !iscLogConfig.trim().isEmpty()) {
            configURL = Loader.getResource((String)iscLogConfig, (ClassLoader)Logger.class.getClassLoader());
        }
        if (configURL == null) {
            configURL = Loader.getResource((String)"log4j2.isc.project.config.xml", (ClassLoader)Logger.class.getClassLoader());
        }
        if (configURL == null) {
            configURL = Loader.getResource((String)"log4j2.isc.config.xml", (ClassLoader)Logger.class.getClassLoader());
        }
        if (configURL == null) {
            System.out.println("=== SmartClient Init: log4j2.isc.config.xml not found in CLASSPATH. Assuming log4j2 configuration for com.isomorphic is located in some other log4j2 configuration file.");
            context = (LoggerContext)LogManager.getContext((boolean)false);
        } else {
            System.out.println("ISC: Configuring log4j2 from: " + String.valueOf(configURL));
            context = Configurator.initialize((String)"ISC", (ClassLoader)Logger.class.getClassLoader(), (String)configURL.getPath());
        }
    }

    public static Level getLevelForCategory(String category) {
        org.apache.logging.log4j.core.Logger logger;
        if (context != null && (logger = context.getLogger(category)) != null) {
            return fromLog4j.get(logger.getLevel());
        }
        return null;
    }

    public static void setLevelForCategory(String category, Level level) {
        LoggerConfig cfg;
        if (context != null && (cfg = context.getConfiguration().getLoggerConfig(category)) != null) {
            cfg.setLevel(toLog4j.get(level));
            context.updateLoggers();
        }
    }

    public static void setLevelForCategory(String category, String level) {
        LoggerConfig cfg;
        if (context != null && (cfg = context.getConfiguration().getLoggerConfig(category)) != null) {
            cfg.setLevel(org.apache.logging.log4j.Level.toLevel((String)level));
            context.updateLoggers();
        }
    }

    public static List getCurrentLoggers() {
        ArrayList<DataTypeMap> loggers = new ArrayList<DataTypeMap>();
        if (context != null) {
            Map cfgMap = context.getConfiguration().getLoggers();
            for (LoggerConfig cfg : cfgMap.values()) {
                loggers.add(DataTools.buildMap("category", cfg.getName(), "threshold", cfg.getLevel().toString()));
            }
        }
        return loggers;
    }

    protected Log4j2Logger(String subsystem) {
        this.log = context.getLogger(subsystem);
    }

    @Override
    public void fatal(String message) {
        this.log.fatal(message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.fatal(message, t);
    }

    @Override
    public void error(String message) {
        this.log.error(message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.error(message, t);
    }

    @Override
    public void warn(String message) {
        this.log.warn(message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.warn(message, t);
    }

    @Override
    public void info(String message) {
        this.log.info(message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.info(message, t);
    }

    @Override
    public void debug(String message) {
        this.log.debug(message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.debug(message, t);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isEnabled(org.apache.logging.log4j.Level.FATAL);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isEnabled(org.apache.logging.log4j.Level.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isEnabled(org.apache.logging.log4j.Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabled(org.apache.logging.log4j.Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabled(org.apache.logging.log4j.Level.ERROR);
    }

    @Override
    public Level getLevel() {
        return fromLog4j.get(this.log.getLevel());
    }

    @Override
    public void setLevel(Level level) {
        LoggerConfig cfg = context.getConfiguration().getLoggerConfig(this.log.getName());
        cfg.setLevel(toLog4j.get(level));
        context.updateLoggers();
    }

    @Override
    public void clearMDC() {
        ThreadContext.clearMap();
    }

    @Override
    public void putMDC(String key, Object o) {
        if (o == null) {
            this.removeMDC(key);
            return;
        }
        ThreadContext.put((String)key, (String)o.toString());
    }

    @Override
    public void removeMDC(String key) {
        ThreadContext.remove((String)key);
    }

    @Override
    public Object getMDC(String key) {
        return ThreadContext.get((String)key);
    }

    @Override
    public Map getMDC() {
        return ThreadContext.getContext();
    }

    @Override
    public Map convertEvent(Object eventObj, Map mdc, String pk) throws Exception {
        Throwable t;
        LogEvent event = (LogEvent)eventObj;
        HashMap<String, Object> scEvent = new HashMap<String, Object>();
        scEvent.put("pk", pk);
        String loggerName = event.getLoggerName();
        int lastDotIndex = loggerName.lastIndexOf(".");
        if (lastDotIndex != -1) {
            loggerName = loggerName.substring(lastDotIndex + 1);
        }
        scEvent.put("loggerName", loggerName);
        scEvent.put("timeStamp", new Date(event.getTimeMillis()));
        scEvent.put("logMessage", event.getMessage());
        scEvent.put("threadName", event.getThreadName());
        scEvent.put("level", fromLog4j.get(event.getLevel()).toInteger());
        if (mdc != null) {
            scEvent.put("mdc", mdc);
        }
        if ((t = event.getThrown()) != null) {
            scEvent.put("throwable", ExceptionUtils.getStackTrace((Throwable)Reflection.getRealTargetException(t)));
        }
        return scEvent;
    }
}

