/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class ReifyDataSourceValidator {
    private Set<String> whitelisted = new LinkedHashSet<String>();
    private static final Logger LOGGER = new Logger(ReifyDataSourceValidator.class);
    private String smartclientRuntimeBasePath;
    private String workingDataSourcesBasePath;
    private String mockDataSourcesBasePath;

    public ReifyDataSourceValidator(String smartclientRuntimeBasePath, String workingDataSourcesBasePath) {
        this.setSmartclientRuntimeBasePath(smartclientRuntimeBasePath);
        this.setWorkingDataSourcesBasePath(workingDataSourcesBasePath);
        this.setMockDataSourcesBasePath(this.getWorkingDataSourcesBasePath() + "/mock");
        this.ignoreField("internalId");
    }

    public List<ErrorReport> verify() throws Exception {
        ArrayList<ErrorReport> result = new ArrayList<ErrorReport>();
        File runtimeBaseDirectory = new File(this.getSmartclientRuntimeBasePath());
        File workDatasourcesBaseDirectory = new File(this.getWorkingDataSourcesBasePath());
        File mockDatasourcesBaseDirectory = new File(this.getMockDataSourcesBasePath());
        if (Config.getGlobal((boolean)false) == null) {
            Config.getGlobal().setProperty((Object)"webRoot", (Object)runtimeBaseDirectory.getParent());
            Config.getGlobal().setProperty((Object)"isomorphicPathRootRelative", (Object)runtimeBaseDirectory.getName());
            Config.getGlobal().setProperty((Object)"project.datasources", (Object)(workDatasourcesBaseDirectory.getCanonicalPath() + "," + mockDatasourcesBaseDirectory.getCanonicalPath()));
        }
        IOFileFilter dsFilter = new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return this.isDataSource(name);
            }

            public boolean accept(File file) {
                return this.isDataSource(file.getName());
            }

            private boolean isDataSource(String name) {
                return name.endsWith(".ds.xml");
            }
        };
        List mockDataSources = (List)FileUtils.listFiles((File)mockDatasourcesBaseDirectory, (IOFileFilter)dsFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File ds : mockDataSources) {
            File x1 = new File(mockDatasourcesBaseDirectory, ds.getName());
            File x2 = new File(workDatasourcesBaseDirectory, ds.getName());
            DataSource mock = DataSource.fromXML((String)FileUtils.readFileToString((File)x1), null);
            if (!x2.exists()) {
                ErrorReport skip = new ErrorReport(mock.getID());
                ErrorMessage em = new ErrorMessage(ErrorMessage.Severity.INFO, String.format("There is no equivalent of the '%s' mock DataSource at '%s'.  Skipping validation.'", mock.getID(), x2.getCanonicalPath()));
                skip.addError(em);
                result.add(skip);
                continue;
            }
            DataSource live = DataSource.fromXML((String)FileUtils.readFileToString((File)x2), null);
            ErrorReport report = this.verifyDataSourcePair(live, mock);
            if (report.isEmpty()) continue;
            result.add(report);
        }
        return result;
    }

    public ErrorReport verifyDataSourcePair(DataSource live, DataSource mock) throws Exception {
        ErrorMessage msg;
        String txt;
        Object val;
        List<String> security;
        DSField lf;
        ErrorMessage msg2;
        String txt2;
        LOGGER.debug((Object)String.format("Comparing mock ds '%s' to live ds '%s'", mock.getID(), live.getID()));
        ErrorReport result = new ErrorReport(mock.getID());
        List mockFields = mock.getFields();
        List liveFields = live.getFields();
        List mockOperations = mock.getOperationBindings();
        List liveOperations = live.getOperationBindings();
        if (mockOperations != null && liveOperations != null) {
            for (Object mo : mockOperations) {
                String id = (String)mo.get("operationId");
                List operationsById = DataTools.findAll((List)liveOperations, (Object)"operationId", (Object)id);
                if (operationsById.isEmpty()) continue;
                Map lo = (Map)operationsById.get(0);
                List<String> security2 = this.getOperationBindingSecurityAttributes();
                for (String key : security2) {
                    Object val2 = mo.get(key);
                    if (val2 == null || val2.equals(lo.get(key))) continue;
                    txt2 = String.format("OperationBinding '%s' in mock has '%s' declarative security setting value ('%s') that live ('%s') lacks.", id, key, val2);
                    msg2 = new ErrorMessage(ErrorMessage.Severity.WARN, txt2);
                    result.addError(msg2);
                }
            }
        }
        final ArrayList<String> notPresentInLive = new ArrayList<String>();
        for (DSField mf : mockFields) {
            String name = mf.getName();
            lf = live.getField(name);
            if (this.whitelisted.contains(name)) {
                LOGGER.info((Object)String.format("Field '%s' is whitelisted, skipping all verification.", name));
                continue;
            }
            if (DataTools.findAll((List)liveFields, (Object)"name", (Object)name).isEmpty()) {
                ErrorMessage msg3 = new ErrorMessage(ErrorMessage.Severity.WARN, "Field is present in mock but not live.");
                result.addError(name, msg3);
                notPresentInLive.add(name);
                continue;
            }
            boolean typesEqual = lf.getType().equals(mf.getType());
            boolean typeInherited = mock.simpleTypeInheritsFrom(lf.getType(), mf.getType());
            if (!typesEqual && !typeInherited) {
                String txt3 = String.format("Field in mock has different type in live, and live type '%s' is a not a sub-type of mock type '%s'.", lf.getType(), mf.getType());
                ErrorMessage msg4 = new ErrorMessage(ErrorMessage.Severity.WARN, txt3);
                result.addError(name, msg4);
            }
            security = this.getFieldSecurityAttributes();
            for (String key : security) {
                val = mf.get((Object)key);
                if (val == null || val.equals(lf.get((Object)key))) continue;
                txt = String.format("Field in mock has '%s' declarative security setting value ('%s') that live ('%s') lacks.", key, val, lf.get((Object)key));
                msg = new ErrorMessage(ErrorMessage.Severity.WARN, txt);
                result.addError(name, msg);
            }
        }
        if (liveOperations != null && mockOperations != null) {
            for (Map lo : liveOperations) {
                String id = (String)lo.get("operationId");
                List operationsById = DataTools.findAll((List)mockOperations, (Object)"operationId", (Object)id);
                if (operationsById.isEmpty()) continue;
                Map mo = (Map)operationsById.get(0);
                List<String> security3 = this.getOperationBindingSecurityAttributes();
                for (String key : security3) {
                    Object val3 = lo.get(key);
                    if (val3 == null || val3.equals(mo.get(key))) continue;
                    String txt4 = String.format("OperationBinding in live has '%s' declarative security setting value ('%s') that mock ('%s') lacks.", key, val3);
                    ErrorMessage msg5 = new ErrorMessage(ErrorMessage.Severity.INFO, txt4);
                    result.addError(id, msg5);
                }
            }
        }
        mockFields.removeIf(new Predicate<DSField>(){

            @Override
            public boolean test(DSField dsField) {
                return notPresentInLive.contains(dsField.getName());
            }
        });
        int distance = 0;
        int blockIndex = 0;
        for (int idx = 0; idx < liveFields.size(); ++idx) {
            int mi;
            String title;
            lf = (DSField)liveFields.get(idx);
            String name = lf.getName();
            DSField mf = mock.getField(name);
            if (this.whitelisted.contains(name)) {
                LOGGER.info((Object)String.format("Field '%s' is whitelisted, skipping all verification.", name));
                continue;
            }
            if (DataTools.findAll((List)mockFields, (Object)"name", (Object)name).isEmpty()) {
                ErrorMessage msg6 = new ErrorMessage(ErrorMessage.Severity.INFO, "Field in live is not present in mock.");
                result.addError(name, msg6);
                continue;
            }
            security = this.getFieldSecurityAttributes();
            for (String key : security) {
                val = lf.get((Object)key);
                if (val == null || mf.get((Object)key) != null) continue;
                txt = String.format("Field in live has '%s' declarative security setting ('%s') not present in mock.", key, val);
                msg = new ErrorMessage(ErrorMessage.Severity.WARN, txt);
                result.addError(name, msg);
            }
            if (lf.getTitleKey() == null && (title = lf.getTitle()) != null && !title.equals(mf.getTitle())) {
                txt2 = String.format("Field in live has different title ('%s') than mock ('%s').", title, mf.getTitle());
                msg2 = new ErrorMessage(ErrorMessage.Severity.WARN, txt2);
                result.addError(name, msg2);
            }
            if ((mi = mock.getFieldNames().indexOf(name)) != idx && mi != blockIndex + 1 && mi != idx + distance && mi != idx - distance) {
                distance = Math.abs(idx - mi);
                txt2 = String.format("Field in mock has different order (%s) than live (%s).", mi, idx);
                msg2 = new ErrorMessage(ErrorMessage.Severity.WARN, txt2);
                result.addError(name, msg2);
                continue;
            }
            if (mi != blockIndex + 1) continue;
            blockIndex = mi;
        }
        return result;
    }

    public void ignoreField(String name) {
        this.whitelisted.add(name);
    }

    public String getSmartclientRuntimeBasePath() {
        return this.smartclientRuntimeBasePath;
    }

    public void setSmartclientRuntimeBasePath(String smartClientRuntimeBasePath) {
        this.smartclientRuntimeBasePath = smartClientRuntimeBasePath;
    }

    public String getWorkingDataSourcesBasePath() {
        return this.workingDataSourcesBasePath;
    }

    public void setWorkingDataSourcesBasePath(String projectDataSourcesBasePath) {
        this.workingDataSourcesBasePath = projectDataSourcesBasePath;
    }

    public String getMockDataSourcesBasePath() {
        return this.mockDataSourcesBasePath;
    }

    public void setMockDataSourcesBasePath(String mockDataSourcesBasePath) {
        this.mockDataSourcesBasePath = mockDataSourcesBasePath;
    }

    private List<String> getFieldSecurityAttributes() {
        return DataTools.buildList((Object[])new String[]{"viewRequiresAuthentication", "editRequiresAuthentication", "initRequiresAuthentication", "updateRequiresAuthentication", "viewRequiresRole", "editRequiresRole", "initRequiresRole", "updateRequiresRole", "viewRequires", "editRequires", "initRequires", "updateRequires", "creatorOverrides"});
    }

    private List<String> getOperationBindingSecurityAttributes() {
        return DataTools.buildList((Object[])new String[]{"requiresAuthentication", "requiresRole", "requires", "creatorOverrides"});
    }

    private List<String> getDataSourceSecurityAttributes() {
        return DataTools.buildList((Object[])new String[]{"requiresAuthentication", "requiresRole", "requires", "creatorOverrides"});
    }

    public static void main(String[] args) throws IOException, Exception {
        List<ErrorReport> result;
        Option h = Option.builder((String)"h").longOpt("help").desc("Prints this help/usage documentation").build();
        Option r = Option.builder((String)"r").longOpt("runtime").required(true).hasArg(true).desc("The absolute path to the directory containing the Isomorphic runtime.  Required.  Example: c:/dev/myproj/war/isomorphic.").build();
        Option d = Option.builder((String)"d").longOpt("datasources").required(true).hasArg(true).desc("The absolute path to the directory containing your working datasources.  Required.  Example: c:/dev/myproj/war/shared/ds.").build();
        Option m = Option.builder((String)"m").longOpt("mock-datasources").required(false).hasArg(true).desc("The absolute path to the directory containing your mock datasources.  Optional, default value ${datasources}/'mock'.  Example: c:/dev/myproj/war/shared/ds/mock.").build();
        Options helpOptions = new Options();
        helpOptions.addOption(h);
        Options pathOptions = new Options();
        pathOptions.addOption(r);
        pathOptions.addOption(d);
        pathOptions.addOption(m);
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(helpOptions, args, true);
        if (line.hasOption("h")) {
            ReifyDataSourceValidator.displayHelp(pathOptions);
        }
        try {
            line = parser.parse(pathOptions, args);
        }
        catch (MissingOptionException e) {
            ReifyDataSourceValidator.displayHelp(pathOptions);
        }
        ReifyDataSourceValidator validator = new ReifyDataSourceValidator(line.getOptionValue("r"), line.getOptionValue("d"));
        if (line.hasOption("m")) {
            validator.setMockDataSourcesBasePath(line.getOptionValue("m"));
        }
        if (!(result = validator.verify()).isEmpty()) {
            for (ErrorReport report : result) {
                for (String key : report.keySet()) {
                    List errors = report.getErrors(key);
                    for (ErrorMessage msg : errors) {
                        String output = null;
                        output = key.equals(report.getDataSourceId()) ? String.format("%s: %s", report.getDataSourceId(), msg.getErrorString()) : String.format("%s.%s: %s", report.getDataSourceId(), key, msg.getErrorString());
                        ErrorMessage.Severity severity = msg.getSeverity();
                        if (severity == ErrorMessage.Severity.INFO) {
                            LOGGER.info((Object)output);
                        }
                        if (msg.getSeverity() == ErrorMessage.Severity.WARN) {
                            LOGGER.warn((Object)output);
                        }
                        if (msg.getSeverity() != ErrorMessage.Severity.ERROR) continue;
                        LOGGER.error((Object)output);
                    }
                }
            }
        } else {
            LOGGER.info((Object)"No validation errors were found.");
        }
    }

    private static void displayHelp(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java com.isomorphic.tools.ReifyDataSourceValidator", opts);
        System.exit(0);
    }
}

