/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet.jmx;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.openqa.jetty.jetty.servlet.WebApplicationContext;
import org.openqa.jetty.jetty.servlet.jmx.ServletHttpContextMBean;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LifeCycleEvent;
import org.openqa.jetty.util.LifeCycleListener;

public class WebApplicationContextMBean
extends ServletHttpContextMBean {
    private static final Log log = LogFactory.getLog(WebApplicationContextMBean.class);
    private WebApplicationContext _webappContext;
    private Map _configurations = new HashMap();

    @Override
    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("displayName", false);
        this.defineAttribute("defaultsDescriptor", true);
        this.defineAttribute("WAR", true);
        this.defineAttribute("extractWAR", true);
        this._webappContext = (WebApplicationContext)this.getManagedResource();
        this._webappContext.addEventListener(new LifeCycleListener(){

            @Override
            public void lifeCycleStarting(LifeCycleEvent event) {
            }

            @Override
            public void lifeCycleStarted(LifeCycleEvent event) {
                WebApplicationContextMBean.this.getConfigurations();
            }

            @Override
            public void lifeCycleFailure(LifeCycleEvent event) {
            }

            @Override
            public void lifeCycleStopping(LifeCycleEvent event) {
            }

            @Override
            public void lifeCycleStopped(LifeCycleEvent event) {
                WebApplicationContextMBean.this.destroyConfigurations();
            }
        });
    }

    @Override
    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        this.getConfigurations();
    }

    @Override
    public void postDeregister() {
        this.destroyConfigurations();
        super.postDeregister();
    }

    public ObjectName[] getConfigurations() {
        return this.getComponentMBeans(this._webappContext.getConfigurations(), this._configurations);
    }

    public void destroyConfigurations() {
        MBeanServer mbeanServer = this.getMBeanServer();
        Iterator itor = this._configurations.values().iterator();
        while (itor.hasNext()) {
            try {
                ObjectName o = (ObjectName)itor.next();
                log.debug((Object)("Unregistering: " + o));
                if (mbeanServer == null) continue;
                mbeanServer.unregisterMBean(o);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        this._configurations.clear();
    }
}

