/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBSandbox;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.lang3.SystemUtils;

public class HSQLDBDriver
extends SQLDriver {
    private static Logger log = new Logger(HSQLDBDriver.class.getName());
    public static final int UNIQUE_CONSTRAINT_VIOLATED = 1;
    boolean supportsSQLLimit = true;
    private static final Map<String, String> formulaReplacements;
    private static final SQLDriver.FormulaConfig formulaConfig;

    public HSQLDBDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return true;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        boolean addLeadingDotStar;
        String regexpSQL = "REGEXP_MATCHES(" + escapedColumnOrExpression + ", '";
        boolean bl = addLeadingDotStar = !((String)regexp).startsWith("^");
        if ("iregexp".equals(operator)) {
            regexp = "(?i).*" + (String)regexp;
        }
        if (addLeadingDotStar) {
            regexpSQL = regexpSQL + ".*";
        }
        regexpSQL = regexpSQL + this.escapeRegexpUnquoted((String)regexp);
        if (!((String)regexp).endsWith("$")) {
            regexpSQL = regexpSQL + ".*";
        }
        regexpSQL = regexpSQL + "')";
        return regexpSQL;
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        Object q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? (String)q + " ORDER BY " : (String)q + ", ";
            q = (String)q + computedOrderClause;
        }
        boolean useLegacySyntax = false;
        try {
            if (this.getDatabaseMajorVersion() < 2) {
                useLegacySyntax = true;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception attempting to determine the HSQLDB version; I am going to assume we are on 2.0 or later, and continue");
        }
        if (useLegacySyntax) {
            if (context == null || !DataTools.getBoolean((Map)context, (Object)"isUnionFetch")) {
                return "SELECT LIMIT " + startRow + " " + totalRows + " " + ((String)q).substring("SELECT".length());
            }
            return "SELECT LIMIT " + startRow + " " + totalRows + " * FROM (" + (String)q + ")";
        }
        if (context == null || !DataTools.getBoolean((Map)context, (Object)"isUnionFetch")) {
            return (String)q + " LIMIT " + totalRows + " OFFSET " + startRow;
        }
        return "SELECT * FROM (" + (String)q + ") LIMIT " + totalRows + " OFFSET " + startRow;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("HSQLDB can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            String obj = HSQLDBDriver.getScalarResult("CALL IDENTITY()", this.dbConnection, this.dbName, this, req).toString();
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
            } else {
                Long sequenceValue = Long.valueOf(obj.toString());
                primaryKeys.put(sequenceName, sequenceValue);
            }
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        Object output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = (String)output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + (String)output;
        }
        return output;
    }

    @Override
    protected SQLDriver.FormulaConfig getFormulaConfig() {
        return formulaConfig;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause(Object value) {
        return " ESCAPE '\\'";
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        return this.caseExpression(column, valueMap.entrySet().iterator(), request);
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (type != null && DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"integer")) {
            return "CAST(" + result + " AS INT)";
        }
        return super.sqlCast(result, field);
    }

    private String caseExpression(String column, Iterator entries, DSRequest request) {
        if (!entries.hasNext()) {
            return "CAST (" + column + " AS LONGVARCHAR)";
        }
        Map.Entry entry = (Map.Entry)entries.next();
        String rawValue = (String)entry.getKey();
        String actualValue = this.transformActualValueForSort(rawValue, column, request);
        String displayValue = this.getLocalizedDisplayValue(entry.getValue(), request);
        displayValue = this.escapeValue(displayValue);
        return "CASEWHEN(" + column + "=" + actualValue + ", " + displayValue + ", " + this.caseExpression(column, entries, request) + ")";
    }

    @Override
    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        Timestamp adjustedTimestamp = rs.getTimestamp(index, calendar);
        long millis = timestamp.getTime();
        if (millis != adjustedTimestamp.getTime()) {
            return adjustedTimestamp;
        }
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    @Override
    public boolean canSetFetchSize() {
        return false;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String sqlConcat(String ... strings) {
        return super.sqlConcat(strings);
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM (VALUES(0))";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        snapshotFile.deleteOnExit();
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " snapshot " + this.defaultSchemaName + " " + snapshotFileName;
        Class<HSQLDBDriver> clazz = HSQLDBDriver.class;
        synchronized (HSQLDBDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " restore " + this.defaultSchemaName + " " + snapshotFileName;
        Class<HSQLDBDriver> clazz = HSQLDBDriver.class;
        synchronized (HSQLDBDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSandbox(String sandboxName) throws Exception {
        String schema = this.defaultSchemaName;
        String dbDir = this._sqlConfig.getPath("database.baseDir");
        String cmd = !SystemUtils.IS_OS_WINDOWS ? "cd " + dbDir + " && cp -p " + schema + ".data " + sandboxName + ".data; cp -p " + schema + ".properties " + sandboxName + ".properties; cp -p " + schema + ".script " + sandboxName + ".script; if [ -e " + schema + ".backup ]; then cp -p " + schema + ".backup " + sandboxName + ".backup; fi" : "cd " + dbDir + " & copy /Y " + schema + ".data " + sandboxName + ".data & copy /Y " + schema + ".properties " + sandboxName + ".properties & copy /Y " + schema + ".script " + sandboxName + ".script &if exist " + schema + ".backup copy /Y " + schema + ".backup " + sandboxName + ".backup";
        String string = sandboxName.intern();
        synchronized (string) {
            if (this.lastModified(sandboxName) != -1L) {
                log.debug((Object)("Sandboxed db " + sandboxName + " already exists, not rebuilding"));
                return;
            }
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSandbox(String sandboxName) throws Exception {
        String dbDir = this._sqlConfig.getPath("database.baseDir");
        String cmd = !SystemUtils.IS_OS_WINDOWS ? "cd " + dbDir + " && rm -rf " + sandboxName.trim() + "*" : "cd " + dbDir + " && erase /F /Q " + sandboxName.trim() + "* && rmdir /S /Q " + sandboxName.trim() + ".tmp";
        String string = sandboxName.intern();
        synchronized (string) {
            try {
                Connection conn = DBSandbox.openSandboxConnection(this.dbName, sandboxName);
                Statement stmt = conn.createStatement();
                stmt.execute("COMMIT");
                stmt.execute("SHUTDOWN");
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception se) {
                log.warn((Object)("Error while attempting to shutdown sandbox: " + sandboxName));
            }
            File lockFile = new File(dbDir + "/" + sandboxName + ".lck");
            if (lockFile.exists()) {
                throw new Exception("Can't remove sandbox: " + sandboxName + " - db failed to shutdown");
            }
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
        }
    }

    @Override
    public long lastModified(String schemaName) throws Exception {
        String dbDir = this._sqlConfig.getPath("database.baseDir");
        File sandboxedScriptFile = new File(dbDir + "/" + schemaName + ".script");
        if (!sandboxedScriptFile.exists()) {
            return -1L;
        }
        return sandboxedScriptFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listAvailableDatabases(String pattern) throws Exception {
        if (!pattern.matches("[A-Za-z0-9_$*?]+")) {
            throw new Exception("Globbing pattern is limited to alphanumerics, '*', and '?'");
        }
        String dbDir = this._sqlConfig.getPath("database.baseDir");
        String cmd = !SystemUtils.IS_OS_WINDOWS ? "find " + dbDir + " -maxdepth 1 -name '" + pattern + ".script' -printf '%f\n'" : "cd " + dbDir + " && if exist " + pattern + ".script dir " + pattern + ".script";
        Class<HSQLDBDriver> clazz = HSQLDBDriver.class;
        synchronized (HSQLDBDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            String out = iscSystem.getStdout();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            ArrayList<String> matches = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(out);
            while (tokenizer.hasMoreTokens()) {
                String filename = (String)tokenizer.nextElement();
                matches.add(filename.substring(0, filename.length() - 7));
            }
            return matches;
        }
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        return "varchar_ignorecase(" + length + ")";
    }

    @Override
    public String getFloatType() {
        return "double";
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("max", "greatest");
        m.put("min", "least");
        m.put("pow", "power");
        m.put("random", "rand");
        m.put("currentDateTime()", "current_timestamp");
        m.put("now()", "current_timestamp");
        m.put("year(", "extract(year from");
        m.put("month(", "extract(month from");
        m.put("day(", "extract(day from");
        m.put("hour(", "extract(hour from");
        m.put("minute(", "extract(minute from");
        m.put("second(", "extract(second from");
        formulaReplacements = Collections.synchronizedMap(m);
        formulaConfig = new SQLDriver.FormulaConfig(formulaReplacements);
    }
}

