package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 */
public enum ValueClass implements ValueEnum {
    /**
     * Any kind of data. Usually this is textual, but not necessarily always so. An example would be a "2-4 sentence summary".
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "general".
     */
    GENERAL("general"),
    /**
     * A fixed list of categories or nominal values.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "categorical".
     */
    CATEGORICAL("categorical"),
    /**
     * An extension of CATEGORICAL, where the categories are also strictly ordered.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "ordinal".
     */
    ORDINAL("ordinal"),
    /**
     * Strictly numerical data.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "interval".
     */
    INTERVAL("interval"),
    /**
     * An extension of INTERVAL, where 0 means the absence of something, and ratios between values are meaningful.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "ratio".
     */
    RATIO("ratio");
    private String value;

    ValueClass(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
