/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import org.springframework.jdbc.datasource.embedded.DerbyEmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.embedded.H2EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.HsqlEmbeddedDatabaseConfigurer;
import org.springframework.util.Assert;

final class EmbeddedDatabaseConfigurerFactory {
    private EmbeddedDatabaseConfigurerFactory() {
    }

    public static EmbeddedDatabaseConfigurer getConfigurer(EmbeddedDatabaseType type) throws IllegalStateException {
        Assert.notNull((Object)((Object)type), (String)"EmbeddedDatabaseType is required");
        try {
            return switch (type) {
                case EmbeddedDatabaseType.HSQL -> HsqlEmbeddedDatabaseConfigurer.getInstance();
                case EmbeddedDatabaseType.H2 -> H2EmbeddedDatabaseConfigurer.getInstance();
                case EmbeddedDatabaseType.DERBY -> DerbyEmbeddedDatabaseConfigurer.getInstance();
                default -> throw new UnsupportedOperationException("Embedded database type [" + type + "] is not supported");
            };
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            throw new IllegalStateException("Driver for test database type [" + type + "] is not available", ex);
        }
    }
}

