/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.logging.impl.FormatterImpl;
import com.google.gwt.logging.impl.StackTracePrintStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HtmlLogFormatter
extends FormatterImpl {
    private boolean showStackTraces;

    public HtmlLogFormatter(boolean showStackTraces) {
        this.showStackTraces = showStackTraces;
    }

    @Override
    public String format(LogRecord event) {
        final StringBuilder html = new StringBuilder();
        html.append(this.getHtmlPrefix(event));
        html.append(this.getRecordInfo(event, "<br>"));
        html.append(this.getEscaped(event.getMessage()));
        if (this.showStackTraces && event.getThrown() != null) {
            html.append("<br>");
            event.getThrown().printStackTrace(new StackTracePrintStream(this, html){
                final /* synthetic */ HtmlLogFormatter this$0;
                {
                    this.this$0 = this$0;
                    super(builder);
                }

                @Override
                public void append(String str) {
                    html.append(this.this$0.getEscaped(str));
                }

                @Override
                public void newLine() {
                    html.append("<br>");
                }
            });
        }
        html.append(this.getHtmlSuffix(event));
        return html.toString();
    }

    protected String getHtmlPrefix(LogRecord event) {
        StringBuilder prefix = new StringBuilder();
        prefix.append("<span style='color:");
        prefix.append(this.getColor(event.getLevel().intValue()));
        prefix.append("'>");
        prefix.append("<code>");
        return prefix.toString();
    }

    protected String getHtmlSuffix(LogRecord event) {
        return "</code></span>";
    }

    private String getColor(int logLevel) {
        if (logLevel == Level.OFF.intValue()) {
            return "#000";
        }
        if (logLevel >= Level.SEVERE.intValue()) {
            return "#F00";
        }
        if (logLevel >= Level.WARNING.intValue()) {
            return "#E56717";
        }
        if (logLevel >= Level.INFO.intValue()) {
            return "#20b000";
        }
        if (logLevel >= Level.CONFIG.intValue()) {
            return "#2B60DE";
        }
        if (logLevel >= Level.FINE.intValue()) {
            return "#F0F";
        }
        if (logLevel >= Level.FINER.intValue()) {
            return "#F0F";
        }
        if (logLevel >= Level.FINEST.intValue()) {
            return "#F0F";
        }
        return "#000";
    }

    private String getEscaped(String text) {
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("\t", "&nbsp;&nbsp;&nbsp;");
        return text;
    }
}

