package com.smartgwt.client.docs;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * For properties that refer to images by URL, such as {@link com.smartgwt.client.widgets.Img#getSrc Img.src} and {@link
 * com.smartgwt.client.widgets.Button#getIcon Button.icon},
 *  Smart GWT provides various capabilities to allow for simpler and more uniform settings,
 *  and to allow applications to be restructured more easily.
 *  <P>
 *  <b> StockIcons</b>
 *  <p>
 *  Smart GWT defines a list of  known-icons which can be used
 * by name in src-strings.  For example, setting a button's {@link com.smartgwt.client.widgets.Button#getIcon icon}
 * property 
 *  to "Edit" will show the  current image mapped to the builtin StockIcon 
 *  with that name.  You can also modify the image currently assigned to the "Edit" icon by 
 *  calling  Media.updateIconMapping("Edit", "new src").
 *  <p>
 *  When using a StockIcon-name as a src, you may also include additional settings to extend the
 *   StockIcon if applicable.  For example, a src of "Edit:size:24,24;"
 *  will take the "Edit" stockIcon's current src and, if that src represents a sprite-string, 
 *  apply the additional size attributes and render the Edit icon at a larger size.
 *  <p>
 *  These features are especially useful in combination with 
 *  {@link com.smartgwt.client.docs.SvgSymbols SVG Symbols} using runtime-styling, where colors can be easily 
 *  modified on a per usage-basis, for example with "Edit:color:red;".
 *  <b>the application image directory</b>
 *  <P>
 *  When specifying URLs to image files via Smart GWT component properties such as
 * {@link com.smartgwt.client.widgets.StretchImg#getSrc StretchImg.src}, any relative path is assumed to be relative to the
 * "application image
 *  directory" (<code>appImgDir</code>).  The application image directory can be set via
 * {@link com.smartgwt.client.util.Page#setAppImgDir Page.setAppImgDir()}, and defaults to "images/", representing the
 * typical practice of
 *  placing images in a subdirectory relative to the URL at which the application is accessed.
 *  <P>
 *  For applications that may be launched from multiple URLs, the <code>appImgDir</code> can be
 *  set to the correct relative path to the image directory by calling
 * {@link com.smartgwt.client.util.Page#setAppImgDir Page.setAppImgDir()} before any Smart GWT components are created. 
 * This enables
 *  applications or components of an application to be launched from multiple locations, or to
 *  be relocated, without changing any image URLs supplied to Smart GWT components.
 *  <P>
 *  <b>the "[SKIN]" URL prefix</b>
 *  <P>
 *  The special prefix "[SKIN]" can be used to refer to images within the skin folder
 *  whenever image URLs are supplied to Smart GWT components.
 *  <P>
 *  The value of "[SKIN]" is the combination of:
 *  <ul>
 * <li> the "skin directory", established in <code>load_skin.js</code> via {@link com.smartgwt.client.util.Page#setSkinDir
 * Page.setSkinDir()},
 *  plus..
 * <li> the setting for {@link com.smartgwt.client.widgets.Canvas#getSkinImgDir skinImgDir} on the component where you set
 * an
 *  image URL property
 *  </ul>
 *  <code>skinImgDir</code> defaults to "images/", so creating an {@link com.smartgwt.client.widgets.Img} component with
 * {@link com.smartgwt.client.widgets.Img#getSrc Img.src} set to "[SKIN]myButton/button.gif" will expand to
 * <code>Page.getSkinDir() +
 *  "/images/myButton/button.gif"</code>.
 *  <P>
 *  Some components that use a large number of images use <code>skinImgDir</code> to group them
 *  together and make it possible to relocate all the media for the component with a single setting.
 * For example, the {@link com.smartgwt.client.widgets.tree.TreeGrid} class sets <code>skinImgDir</code> to
 * "images/TreeGrid/".
 * This allows {@link com.smartgwt.client.widgets.tree.TreeGrid#getFolderIcon TreeGrid.folderIcon} to be set to just
 * "[SKIN]folder.gif" but refer to
 *  <code>Page.getSkinDir() + "/images/TreeGrid/folder.gif"</code>.
 *  <P>
 *  A custom subclass of TreeGrid can set <code>skinImgDir</code> to a different path, such as
 *  "/images/MyTreeGrid", to source all media from a different location.
 *  <P>
 *  <i>TIPS:</i>
 *  <ul>
 *  <li> subcomponents do not automatically share the parent component's setting for skinImgDir.  For
 * example, the {@link com.smartgwt.client.widgets.Window#getMinimizeButton Window.minimizeButton} has the default setting
 * for "skinImgDir"
 *  ("images/"), so the {@link com.smartgwt.client.widgets.Img#getSrc src} property used with this component is set to
 *  "[SKIN]/Window/minimize.png" (in the "Smart GWT" sample skin).
 *  <li> for a particular image, the skinImgDir setting on the component may not be
 *  convenient.  The prefix "[SKINIMG]" can be used to refer to <code>Page.getSkinDir() +
 *  "/images"</code> regardless of the setting for <code>skinImgDir</code>
 *  </ul>
 *  <B>Using a css class instead of an image URL</B>
 *  <P>
 *  In some cases, instead of an explicit image URL, developers may wish to apply a named
 *  css class with a background-image to an image based component. This may be achieved
 *  by specifying your image URL in the format <b>"style:<i>&lt;styleName&gt;</i>"</b>.
 *  <P>
 *  For example if your application loads the following css class:
 *  <pre>
 *  .starImg {
 *     width: 48px; height: 48px;
 *     background: url(/images/star.gif) 0 0;    
 *  }
 *  </pre>
 * It may be displayed in an Img component by setting {@link com.smartgwt.client.widgets.Img#getSrc Img.src} to
 * <code>"style:startImg"</code>.
 *  <P>
 *  <B>Sprited images</B>
 *  <P>
 *  In addition to the <code>"style:..."</code> prefix for specifying a css class instead of a 
 *  simple image URL, the prefix <code>"sprite:..."</code> may be used to specify properties 
 *  required to extract an image from an image
 *  <a href='https://www.w3schools.com/Css/css_image_sprites.asp' target='_blank'>sprite</a>.
 *  <P>
 *  For details on how this format may be used, see the {@link com.smartgwt.client.docs.SCSpriteConfig} documentation.
 *  <P>
 *  <B>Stateful image URLs</B>
 *  <P>
 *  Many Smart GWT components support changing their appearance to reflect their current
 *  "state" [<i>"Focused"</i>, <i>"Disabled"</i>, etc]. As such they may display different 
 *  image media to reflect their current state.<br>
 *  See the {@link com.smartgwt.client.docs.StatefulImages Stateful Images overview}
 *  for details on how image states are managed in Smart GWT.
 *  <P>
 *  <b>SVG Images</b>
 *  <P>
 *  <i>For more information about using stylable SVGs for spriting in a way that doesn't involve 
 *  lots of file-loads or the flickering typically associated with modifying SVGs in-browser, 
 *  see the {@link com.smartgwt.client.docs.SvgSymbols SVG Symbols Overview}.</i>
 *  <p>
 *  If the URL represents an SVG image, you may specify <code>tag</code> as a query param to
 *  control whether it's rendered in an object or image tag, provided
 * {@link com.smartgwt.client.widgets.Canvas#getUseImageForSVG Canvas.useImageForSVG} isn't set.  If that query param is
 * present and has any value
 *  other than <code>object</code>, then the SVG image will be rendered in an image tag.
 *  Otherwise, it will be rendered in an object tag.  For example, an <code>SCImgURL</code> of
 *  "circle.svg?tag=image" will render in an image tag.
 *  <P>
 *  <b>the special "blank" constant</b>
 *  <P>
 *  If you don't have to show any image for any reason or you need to reset the area where an 
 *  image is, you can call <i>myImage.setSrc('blank')</i> or set:
 *  
 *  
 *  <pre>
 *  Img myImage = new Img();
 *  myImage.setWidth(48);
 *  myImage.setHeight(48);
 *  myImage.setSrc("blank");
 *  </pre>
 *  
 *  This will render an empty space, where the blank.gif image, that each skin has, will be used 
 *  for this purpose.
 */
public interface SCImgURL extends URL {
}
