/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.log.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="DataSourceAppender", category="Core", elementType="appender", printObject=true)
public class Log4j2DataSourceAppender
extends AbstractAppender {
    public static LinkedBlockingQueue dispatchQueue = new LinkedBlockingQueue();
    public static boolean requiresDataSourceDispatcher = false;

    @PluginFactory
    public static Log4j2DataSourceAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new Log4j2DataSourceAppender(name, filter, null, false, null);
    }

    public Log4j2DataSourceAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
        requiresDataSourceDispatcher = true;
    }

    public void append(LogEvent event) {
        if (Logger.threadIgnored() || Logger.threadDisabled()) {
            return;
        }
        Map mdc = Logger.getMDC();
        if (mdc != null) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("event", event);
            m.put("mdc", mdc);
            dispatchQueue.add(m);
        } else {
            dispatchQueue.add(event);
        }
    }
}

