/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.mail;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.MailMessageParseMode;
import com.isomorphic.mail.RecipientNotSetException;
import com.isomorphic.mail.SenderNotSetException;
import com.isomorphic.mail.SubjectNotSetException;
import com.isomorphic.naming.DNS;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.angus.mail.smtp.SMTPMessage;

public class MailMessage
extends Base {
    protected Session session;
    protected SMTPMessage message;
    private static final String subjectPrefix = config.getString("mail.subjectPrefix");
    protected Map recipients;
    protected Map headers;
    protected String subject;
    protected String sender;
    protected List<String> replyTo = new ArrayList<String>();
    protected StringWriter body;
    protected String priority;
    protected List attachments = new ArrayList();
    protected String host;
    protected String port;
    protected String auth;
    protected String user;
    protected String password;
    protected Properties additionalProps;
    protected MailMessageParseMode parseMode;
    private static Logger log = new Logger(MailMessage.class.getName());
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    protected Map contextMap;
    private static final Pattern MAIL_FROM_PATTERN;
    private static final Pattern MAIL_FROM_ANGLE_BRACKETS_PATTERN;
    private static final Pattern MAIL_SUBJECT_PATTERN;
    private static final Pattern MAIL_TO_PATTERN;
    private static final Pattern MAIL_CC_PATTERN;
    private static final Pattern MAIL_BCC_PATTERN;
    private static final Pattern MAIL_PATTERNPLY_TO_RE;

    public MailMessage() {
        this.reset();
    }

    public void setContextMap(Map value) {
        this.contextMap = value;
    }

    public Map getContextMap() {
        return this.contextMap;
    }

    public void setFrom(String sender) {
        if (sender != null) {
            this.sender = sender.trim();
        }
    }

    public void addReplyTo(String replyTo) {
        if (replyTo != null) {
            this.replyTo.add(replyTo.trim());
        }
    }

    public void setReplyTo(String replyTo) {
        if (replyTo == null) {
            return;
        }
        this.replyTo.clear();
        String[] cs = replyTo.split(",");
        for (int i = 0; i < cs.length; ++i) {
            this.replyTo.add(cs[i].trim());
        }
    }

    public void setReplyTo(List replyTo) {
        this.replyTo = new ArrayList<String>(replyTo);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setHost(String host) {
        if (host != null) {
            this.host = host.trim();
        }
    }

    public void setPort(String port) {
        if (port != null) {
            this.port = port;
        }
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void setUser(String user) {
        if (user != null) {
            this.user = user;
        }
    }

    public void setPassword(String password) {
        if (password != null) {
            this.password = password;
        }
    }

    public void addHeader(String field, String value) {
        this.headers.put(field, value);
    }

    public void addHeaders(Map headers) {
        DataTools.mapMerge(headers, this.headers);
    }

    public void addRecipient(String recipient) {
        this.addRecipient(recipient, Message.RecipientType.TO);
    }

    public void setRecipient(String recipient) {
        this.addRecipient(recipient);
    }

    public void addRecipients(List recipients) {
        this.addRecipients(recipients, Message.RecipientType.TO);
    }

    public void addRecipients(String recipients) {
        this.addRecipients(recipients, Message.RecipientType.TO);
    }

    public void addRecipient(String recipient, Message.RecipientType type) {
        if (recipient == null) {
            return;
        }
        this.recipients.put(recipient.trim(), type);
    }

    public void addRecipients(List recipients, Message.RecipientType type) {
        if (recipients == null) {
            return;
        }
        Iterator re = recipients.iterator();
        while (re.hasNext()) {
            this.addRecipient((String)re.next(), type);
        }
    }

    public void addRecipients(String recipients, Message.RecipientType type) {
        if (recipients == null) {
            return;
        }
        StringTokenizer rt = new StringTokenizer(recipients, ",");
        while (rt.hasMoreTokens()) {
            this.addRecipient((String)rt.nextElement(), type);
        }
    }

    public void setBody(String newBody) {
        if (newBody == null) {
            return;
        }
        this.body = new StringWriter();
        this.body.write(newBody);
    }

    public void addAttachment(DataSource ds) {
        this.attachments.add(ds);
    }

    public void resetAttachments() {
        this.attachments = new ArrayList();
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setProperty(String name, String value) {
        if (name != null && !"".equals(name.trim()) && value != null && !"".equals(value.trim())) {
            if (this.additionalProps == null) {
                this.additionalProps = new Properties();
            }
            this.additionalProps.setProperty("mail.smtp." + name, value.trim());
        }
    }

    public Writer getBodyWriter() {
        if (this.body == null) {
            this.body = new StringWriter();
        }
        return this.body;
    }

    void buildMessage() throws Exception {
        if (this.message == null) {
            this.initMessage();
        }
        this.processMessageText();
        if (this.sender == null) {
            String configuredSender = config.getString("mail.system.mail.smtp.from");
            if (configuredSender != null) {
                this.sender = configuredSender;
            } else {
                throw new SenderNotSetException("Must specify the sender");
            }
        }
        if (this.recipients.size() == 0) {
            throw new RecipientNotSetException("Must specify a recipient");
        }
        if (this.subject == null) {
            throw new SubjectNotSetException("Must set a subject");
        }
        if (subjectPrefix != null) {
            this.subject = subjectPrefix + this.subject;
        }
        if (this.headers.size() > 0) {
            for (String field : this.headers.keySet()) {
                String value = (String)this.headers.get(field);
                this.message.addHeader(field, value);
            }
        }
        this.message.setFrom((Address)new InternetAddress(this.sender));
        if (this.replyTo.size() > 0) {
            Address[] replyToAddress = new Address[this.replyTo.size()];
            for (int i = 0; i < this.replyTo.size(); ++i) {
                replyToAddress[i] = new InternetAddress(this.replyTo.get(i));
            }
            this.message.setReplyTo(replyToAddress);
        }
        for (String mail : this.recipients.keySet()) {
            Message.RecipientType type = (Message.RecipientType)this.recipients.get(mail);
            this.message.addRecipients(type, (Address[])new InternetAddress[]{new InternetAddress(mail)});
        }
        this.message.setSubject(this.subject);
        if (this.priority != null) {
            this.message.addHeader("X-Priority", this.priority);
        }
        this.message.setSentDate(new Date());
    }

    void processMessageText() throws Exception {
    }

    private void initMessage() throws Exception {
        Map mxMap;
        Properties defaultProps = Config.buildProperties((Map)((Object)config.getSubtree("mail.system")));
        String hostProp = null;
        if (this.additionalProps != null && this.additionalProps.containsKey("mail.smtp.host")) {
            hostProp = Velocity.evaluateAsString(this.additionalProps.getProperty("mail.smtp.host"), this.contextMap);
        }
        if (hostProp == null) {
            hostProp = this.host != null ? Velocity.evaluateAsString(this.host, this.contextMap) : defaultProps.getProperty("mail.smtp.host");
        }
        if ((mxMap = DNS.mxMapForList(hostProp)) == null || mxMap.isEmpty()) {
            log.error((Object)"No SMTP host list was returned for", hostProp);
            throw new Exception("No SMTP host list was returned");
        }
        TreeMap treemap = new TreeMap(mxMap);
        Properties props = Config.buildProperties((Map)((Object)config.getSubtree("mail.system")));
        if (this.port != null) {
            props.setProperty("mail.smtp.port", Velocity.evaluateAsString(this.port, this.contextMap));
        }
        if (this.auth != null) {
            props.setProperty("mail.smtp.auth", Velocity.evaluateAsString(this.auth, this.contextMap));
        }
        if (this.user != null) {
            props.setProperty("mail.smtp.user", Velocity.evaluateAsString(this.user, this.contextMap));
        }
        if (this.password != null) {
            props.setProperty("mail.smtp.password", Velocity.evaluateAsString(this.password, this.contextMap));
        }
        if (this.additionalProps != null) {
            for (Object key : this.additionalProps.keySet()) {
                String value = this.additionalProps.getProperty((String)key);
                if (value == null || "".equals(value.trim())) continue;
                props.setProperty((String)key, Velocity.evaluateAsString(value, this.contextMap));
            }
        }
        boolean connected = false;
        for (List hosts : treemap.values()) {
            Iterator ii = hosts.iterator();
            while (ii.hasNext()) {
                block19: {
                    String host = ((String)ii.next()).trim();
                    log.info("trying to connect to " + host);
                    props.setProperty("mail.smtp.host", host);
                    try {
                        boolean authEnabled = props.getProperty("mail.smtp.auth", "false") != "false";
                        final String smtpUser = props.getProperty("mail.smtp.user", null);
                        final String smtpPassword = props.getProperty("mail.smtp.password", null);
                        if (authEnabled) {
                            if (smtpUser != null && smtpPassword != null) {
                                Authenticator auth = new Authenticator(){

                                    protected PasswordAuthentication getPasswordAuthentication() {
                                        return new PasswordAuthentication(smtpUser, smtpPassword);
                                    }
                                };
                                this.session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
                            } else {
                                log.warn("SMTP authentication enabled, but mail.smtp.user or mail.smtp.password are not set. Disabling authentication.");
                                this.session = Session.getDefaultInstance((Properties)props);
                            }
                        } else {
                            this.session = Session.getDefaultInstance((Properties)props);
                        }
                        Transport transport = this.session.getTransport("smtp");
                        transport.connect();
                        if (transport != null && transport.isConnected()) {
                            connected = true;
                        }
                    }
                    catch (MessagingException e) {
                        if (!log.isDebugEnabled()) break block19;
                        log.debug((Object)"Caught MessagingException", e);
                    }
                }
                if (!connected) continue;
                break;
            }
            if (!connected) continue;
            break;
        }
        if (!connected) {
            log.error((Object)"no smtp servers available, I tried", hostProp);
            throw new Exception("no SMTP servers available");
        }
        this.message = new SMTPMessage(this.session);
    }

    public void send() throws Exception {
        if (this.message == null) {
            this.buildMessage();
        }
        if (this.body != null) {
            this.body.flush();
        }
        Object contentType = this.getContentType();
        String encoding = this.getEncoding();
        if (contentType == null) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        if (encoding == null) {
            encoding = config.getString("mail.system.default.encoding");
        }
        if (((String)contentType).indexOf("charset=") == -1) {
            contentType = (String)contentType + "; charset=" + encoding;
        }
        if (this.attachments.size() == 0) {
            this.message.setContent((Object)this.body.toString(), (String)contentType);
        } else {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setContent((Object)this.body.toString(), (String)contentType);
            mp.addBodyPart((BodyPart)textPart);
            for (DataSource mds : this.attachments) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler(mds));
                part.setFileName(mds.getName());
                mp.addBodyPart((BodyPart)part);
            }
            this.message.setContent((Multipart)mp);
        }
        Transport.send((Message)this.message);
        this.reset();
    }

    public void reset() {
        this.sender = null;
        this.recipients = new HashMap();
        this.headers = new HashMap();
        this.subject = null;
        this.body = null;
        this.attachments = new ArrayList();
        this.host = null;
        this.port = null;
        this.auth = null;
        this.user = null;
        this.password = null;
    }

    public void parse(String message) throws IOException {
        if (this.parseMode == MailMessageParseMode.None) {
            this.setBody(message);
        } else {
            this._parse(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void _parse(String message) throws IOException {
        String to = "";
        String cc = "";
        String bcc = "";
        BufferedReader mr = new BufferedReader(new StringReader(message));
        this.body = new StringWriter();
        Matcher matcher = null;
        try {
            String line;
            block2: while ((line = mr.readLine()) != null) {
                StringTokenizer st;
                matcher = MAIL_FROM_PATTERN.matcher(line);
                if (line.startsWith("From:")) {
                    if (matcher.find()) {
                        this.setFrom(matcher.group(1));
                        continue;
                    }
                    if (!matcher.reset().usePattern(MAIL_FROM_ANGLE_BRACKETS_PATTERN).find()) continue;
                    this.setFrom(matcher.group(1));
                    continue;
                }
                if (line.startsWith("To:")) {
                    if (!matcher.reset().usePattern(MAIL_TO_PATTERN).find()) continue;
                    to = matcher.group(1);
                    st = new StringTokenizer(to, ",");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block2;
                        this.addRecipient(st.nextToken());
                    }
                }
                if (line.startsWith("Cc:") && matcher.reset().usePattern(MAIL_CC_PATTERN).find()) {
                    cc = matcher.group(1);
                    st = new StringTokenizer(cc, ",");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block2;
                        this.addRecipient(st.nextToken(), Message.RecipientType.CC);
                    }
                }
                if (line.startsWith("Bcc:") && matcher.reset().usePattern(MAIL_BCC_PATTERN).find()) {
                    bcc = matcher.group(1);
                    st = new StringTokenizer(bcc, ",");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block2;
                        this.addRecipient(st.nextToken(), Message.RecipientType.BCC);
                    }
                }
                if (line.startsWith("Reply-To:") && matcher.reset().usePattern(MAIL_PATTERNPLY_TO_RE).find()) {
                    this.setReplyTo(matcher.group(1));
                    continue;
                }
                if (line.startsWith("Subject:")) {
                    if (matcher.reset().usePattern(MAIL_SUBJECT_PATTERN).find()) {
                        this.setSubject(matcher.group(1));
                    }
                    if (this.parseMode != MailMessageParseMode.Header) continue;
                    while ((line = mr.readLine()) != null) {
                        this.body.write(line + "\r\n");
                    }
                    break block2;
                    return;
                }
                this.body.write(line + "\r\n");
            }
            return;
        }
        catch (IOException ioe) {
            String error = "Error parsing mail message";
            log.error((Object)error, ioe);
            throw ioe;
        }
    }

    protected String getContentType() throws MessagingException {
        String[] contentType = this.message.getHeader("Content-Type");
        if (contentType == null || contentType.length == 0) {
            return null;
        }
        return contentType[0];
    }

    protected String getEncoding() {
        return null;
    }

    static {
        config.setIfNull("mail.system.mail.smtp.port", "25");
        config.setIfNull("mail.system.mail.smtp.host", "localhost");
        config.setIfNull("mail.system.mail.smtp.connectiontimeout", "2000");
        config.setIfNull("mail.system.mail.smtp.sendpartial", "true");
        config.setIfNull("mail.system.default.encoding", "UTF-8");
        MAIL_FROM_PATTERN = Pattern.compile("^From:\\s*(\\S+.*)$");
        MAIL_FROM_ANGLE_BRACKETS_PATTERN = Pattern.compile("^From:.*<([^>]+)>");
        MAIL_SUBJECT_PATTERN = Pattern.compile("^Subject:\\s*(\\S+.*)");
        MAIL_TO_PATTERN = Pattern.compile("^To:\\s*(\\S+.*)$");
        MAIL_CC_PATTERN = Pattern.compile("^Cc:\\s*(\\S+.*)$");
        MAIL_BCC_PATTERN = Pattern.compile("^Bcc:\\s*(\\S+.*)$");
        MAIL_PATTERNPLY_TO_RE = Pattern.compile("^Reply-To:\\s*(\\S+.*)$");
    }
}

