/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import org.hibernate.JDBCException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.DataException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerEnabledImpl;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.WrapperOptions;

public class JdbcValuesResultSetImpl
extends AbstractJdbcValues {
    private final QueryCachePutManager queryCachePutManager;
    private final ResultSetAccess resultSetAccess;
    private final JdbcValuesMapping valuesMapping;
    private final ExecutionContext executionContext;
    private final SqlSelection[] sqlSelections;
    private final BitSet initializedIndexes;
    private final Object[] currentRowJdbcValues;
    private final int[] valueIndexesToCacheIndexes;
    private final int rowToCacheSize;

    public JdbcValuesResultSetImpl(ResultSetAccess resultSetAccess, QueryKey queryCacheKey, String queryIdentifier, QueryOptions queryOptions, JdbcValuesMapping valuesMapping, JdbcValuesMetadata metadataForCache, ExecutionContext executionContext) {
        this.queryCachePutManager = JdbcValuesResultSetImpl.resolveQueryCachePutManager(executionContext, queryOptions, queryCacheKey, queryIdentifier, metadataForCache);
        this.resultSetAccess = resultSetAccess;
        this.valuesMapping = valuesMapping;
        this.executionContext = executionContext;
        int rowSize = valuesMapping.getRowSize();
        this.sqlSelections = new SqlSelection[rowSize];
        Iterator<SqlSelection> iterator = valuesMapping.getSqlSelections().iterator();
        while (iterator.hasNext()) {
            SqlSelection sqlSelection;
            this.sqlSelections[sqlSelection.getValuesArrayPosition()] = sqlSelection = iterator.next();
        }
        this.initializedIndexes = new BitSet(rowSize);
        this.currentRowJdbcValues = new Object[rowSize];
        if (this.queryCachePutManager == null) {
            this.valueIndexesToCacheIndexes = null;
            this.rowToCacheSize = -1;
        } else {
            BitSet valueIndexesToCache = new BitSet(rowSize);
            for (DomainResult<?> domainResult : valuesMapping.getDomainResults()) {
                domainResult.collectValueIndexesToCache(valueIndexesToCache);
            }
            if (valueIndexesToCache.nextClearBit(0) == -1) {
                this.valueIndexesToCacheIndexes = null;
                this.rowToCacheSize = -1;
            } else {
                int n;
                int n2;
                int i;
                int[] nArray = new int[rowSize];
                boolean bl = false;
                for (i = 0; i < nArray.length; ++i) {
                    nArray[i] = valueIndexesToCache.get(i) ? ++n2 : -1;
                }
                this.valueIndexesToCacheIndexes = nArray;
                if (n2 == 1) {
                    for (i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == -1) continue;
                        n = -i;
                        break;
                    }
                }
                this.rowToCacheSize = n;
            }
        }
    }

    private static QueryCachePutManager resolveQueryCachePutManager(ExecutionContext executionContext, QueryOptions queryOptions, QueryKey queryCacheKey, String queryIdentifier, JdbcValuesMetadata metadataForCache) {
        if (queryCacheKey != null) {
            SessionFactoryImplementor factory = executionContext.getSession().getFactory();
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            return new QueryCachePutManagerEnabledImpl(queryCache, factory.getStatistics(), queryCacheKey, queryIdentifier, metadataForCache);
        }
        return null;
    }

    @Override
    protected final boolean processNext(RowProcessingState rowProcessingState) {
        return this.advance(this.advanceNext());
    }

    @Override
    protected boolean processPrevious(RowProcessingState rowProcessingState) {
        return this.advance(this.advancePrevious());
    }

    @Override
    protected boolean processScroll(int numberOfRows, RowProcessingState rowProcessingState) {
        return this.advance(this.scrollRows(numberOfRows));
    }

    private boolean scrollRows(int numberOfRows) {
        try {
            return this.resultSetAccess.getResultSet().relative(numberOfRows);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing (scroll) ResultSet position", e);
        }
    }

    @Override
    public int getPosition() {
        try {
            return this.resultSetAccess.getResultSet().getRow() - 1;
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#getRow", e);
        }
    }

    @Override
    protected boolean processPosition(int position, RowProcessingState rowProcessingState) {
        return this.advance(this.advanceToPosition(position));
    }

    private boolean advanceToPosition(int position) {
        try {
            return this.resultSetAccess.getResultSet().absolute(position);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing (scroll) ResultSet position", e);
        }
    }

    @Override
    public boolean isBeforeFirst(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isBeforeFirst();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isBeforeFirst()", e);
        }
    }

    @Override
    public void beforeFirst(RowProcessingState rowProcessingState) {
        try {
            this.resultSetAccess.getResultSet().beforeFirst();
            Arrays.fill(this.currentRowJdbcValues, null);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#beforeFirst()", e);
        }
    }

    @Override
    public boolean isFirst(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isFirst();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isFirst()", e);
        }
    }

    @Override
    public boolean first(RowProcessingState rowProcessingState) {
        return this.advance(this.advanceToFirst());
    }

    @Override
    public boolean isAfterLast(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isAfterLast();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isAfterLast()", e);
        }
    }

    @Override
    public void afterLast(RowProcessingState rowProcessingState) {
        try {
            this.resultSetAccess.getResultSet().afterLast();
            Arrays.fill(this.currentRowJdbcValues, null);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#afterLast()", e);
        }
    }

    @Override
    public boolean isLast(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isLast();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isLast()", e);
        }
    }

    @Override
    public boolean last(RowProcessingState rowProcessingState) {
        return this.advance(this.advanceToLast());
    }

    private boolean advanceNext() {
        try {
            return this.resultSetAccess.getResultSet().next();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing (next) ResultSet position", e);
        }
    }

    private boolean advanceToLast() {
        try {
            return this.resultSetAccess.getResultSet().last();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing (last) ResultSet position", e);
        }
    }

    private boolean advanceToFirst() {
        try {
            return this.resultSetAccess.getResultSet().first();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing (first) ResultSet position", e);
        }
    }

    private boolean advancePrevious() {
        try {
            return this.resultSetAccess.getResultSet().previous();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing (previous) ResultSet position", e);
        }
    }

    private boolean advance(boolean hasResult) {
        if (!hasResult) {
            return false;
        }
        this.readCurrentRowValues();
        return true;
    }

    private ExecutionException makeExecutionException(String message, SQLException cause) {
        JDBCException jdbcException = this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(cause, message);
        if (jdbcException instanceof QueryTimeoutException || jdbcException instanceof DataException || jdbcException instanceof LockTimeoutException) {
            throw jdbcException;
        }
        return new ExecutionException(message + " [" + cause.getMessage() + "]", (Throwable)((Object)jdbcException));
    }

    private void readCurrentRowValues() {
        this.initializedIndexes.clear();
    }

    @Override
    public final void finishUp(SharedSessionContractImplementor session) {
        if (this.queryCachePutManager != null) {
            this.queryCachePutManager.finishUp(session);
        }
        this.resultSetAccess.release();
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.valuesMapping;
    }

    @Override
    public void finishRowProcessing(RowProcessingState rowProcessingState) {
        super.finishRowProcessing(rowProcessingState, false);
    }

    @Override
    public void finishRowProcessing(RowProcessingState rowProcessingState, boolean wasAdded) {
        if (this.queryCachePutManager != null) {
            Object objectToCache;
            if (this.valueIndexesToCacheIndexes == null) {
                objectToCache = Arrays.copyOf(this.currentRowJdbcValues, this.currentRowJdbcValues.length);
            } else if (this.rowToCacheSize < 1) {
                if (!wasAdded) {
                    return;
                }
                objectToCache = this.currentRowJdbcValues[-this.rowToCacheSize];
            } else {
                Object[] rowToCache = new Object[this.rowToCacheSize];
                for (int i = 0; i < this.currentRowJdbcValues.length; ++i) {
                    int cacheIndex = this.valueIndexesToCacheIndexes[i];
                    if (cacheIndex == -1) continue;
                    rowToCache[cacheIndex] = this.initializedIndexes.get(i) ? this.currentRowJdbcValues[i] : null;
                }
                objectToCache = rowToCache;
            }
            this.queryCachePutManager.registerJdbcRow(objectToCache);
        }
    }

    @Override
    public Object getCurrentRowValue(int valueIndex) {
        if (!this.initializedIndexes.get(valueIndex)) {
            this.initializedIndexes.set(valueIndex);
            SqlSelection sqlSelection = this.sqlSelections[valueIndex];
            try {
                this.currentRowJdbcValues[valueIndex] = sqlSelection.getJdbcValueExtractor().extract(this.resultSetAccess.getResultSet(), sqlSelection.getJdbcResultSetIndex(), (WrapperOptions)this.executionContext.getSession());
            }
            catch (SQLException e) {
                throw this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "Could not extract column [" + sqlSelection.getJdbcResultSetIndex() + "] from JDBC ResultSet");
            }
        }
        return this.currentRowJdbcValues[valueIndex];
    }

    @Override
    public void setFetchSize(int fetchSize) {
        try {
            this.resultSetAccess.getResultSet().setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet.setFetchSize()", e);
        }
    }
}

