/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractEntityBatchLoader;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class EntityBatchLoaderArrayParam<T>
extends AbstractEntityBatchLoader<T>
implements SqlArrayMultiKeyLoader {
    private final int domainBatchSize;
    private final BasicEntityIdentifierMapping identifierMapping;
    private final JdbcMapping arrayJdbcMapping;
    private final JdbcParameter jdbcParameter;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelectOperation;

    public EntityBatchLoaderArrayParam(int domainBatchSize, EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.domainBatchSize = domainBatchSize;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching enabled for `%s` (entity) using ARRAY strategy : %s", (Object)entityDescriptor.getEntityName(), (Object)domainBatchSize);
        }
        this.identifierMapping = (BasicEntityIdentifierMapping)this.getLoadable().getIdentifierMapping();
        Class<?> arrayClass = Array.newInstance(this.identifierMapping.getJavaType().getJavaTypeClass(), 0).getClass();
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping(sessionFactory.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(arrayClass), this.identifierMapping.getJdbcMapping(), arrayClass, sessionFactory);
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
        this.sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.identifierMapping, new LoadQueryInfluencers(sessionFactory), LockOptions.NONE, this.jdbcParameter, sessionFactory);
        this.jdbcSelectOperation = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    @Override
    protected Object[] resolveIdsToInitialize(Object pkValue, SharedSessionContractImplementor session) {
        Class<?> idType = this.identifierMapping.getJavaType().getJavaTypeClass();
        Object[] idsToLoad = (Object[])Array.newInstance(idType, this.domainBatchSize);
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableEntityIds(this.domainBatchSize, (index, value) -> {
            idsToLoad[index] = value;
        }, pkValue, this.getLoadable());
        return MultiKeyLoadHelper.trimIdBatch(this.domainBatchSize, idsToLoad);
    }

    @Override
    protected void initializeEntities(Object[] idsToInitialize, Object id, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Ids to batch-fetch initialize (`%s#%s`) %s", (Object)this.getLoadable().getEntityName(), id, (Object)Arrays.toString(idsToInitialize));
        }
        for (Object initializedId : idsToInitialize) {
            if (initializedId == null) continue;
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(initializedId, this.getLoadable(), session);
        }
        LoaderHelper.loadByArrayParameter(idsToInitialize, this.sqlAst, this.jdbcSelectOperation, this.jdbcParameter, this.arrayJdbcMapping, id, entityInstance, this.getLoadable().getRootEntityDescriptor(), lockOptions, readOnly, session);
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityBatchLoaderArrayParam(%s [%s])", this.getLoadable().getEntityName(), this.domainBatchSize);
    }
}

