/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import java.io.IOException;

public class Util {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static String escapeString(final String s) {
        int quote = 34;
        String doublequoteEscape = "\\\"";
        String singlequoteEscape = "'";
        String backslashEscape = "\\\\";
        final StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append('\"');
        final class UnescapedRegion {
            int unescapedRegionStart = 0;
            int unescapedRegionEnd = 0;

            UnescapedRegion() {
            }

            void appendUnescaped() {
                if (this.unescapedRegionStart != this.unescapedRegionEnd) {
                    sb.append(s.substring(this.unescapedRegionStart, this.unescapedRegionEnd));
                }
                this.unescapedRegionStart = this.unescapedRegionEnd;
            }

            void incrementForNormalChar() {
                ++this.unescapedRegionEnd;
            }

            void incrementForEscapedChar() {
                if (this.unescapedRegionStart != this.unescapedRegionEnd) {
                    throw new IllegalStateException();
                }
                ++this.unescapedRegionStart;
                ++this.unescapedRegionEnd;
            }

            void appendForEscapedChar(String escaped) {
                this.appendUnescaped();
                this.incrementForEscapedChar();
                sb.append(escaped);
            }
        }
        UnescapedRegion region = new UnescapedRegion();
        int length = s.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    region.appendForEscapedChar("\\n");
                    continue block10;
                }
                case '\r': {
                    region.appendForEscapedChar("\\r");
                    continue block10;
                }
                case '\t': {
                    region.appendForEscapedChar("\\t");
                    continue block10;
                }
                case '\\': {
                    region.appendForEscapedChar("\\\\");
                    continue block10;
                }
                case '\"': {
                    region.appendForEscapedChar("\\\"");
                    continue block10;
                }
                case '\'': {
                    region.appendForEscapedChar("'");
                    continue block10;
                }
                case '>': {
                    if (i >= 2 && (s.charAt(i - 1) == '-' && s.charAt(i - 2) == '-' || s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']')) {
                        region.appendForEscapedChar("\\u003e");
                        continue block10;
                    }
                    region.incrementForNormalChar();
                    continue block10;
                }
                case '<': {
                    String END_SCRIPT = "/script";
                    String START_COMMENT = "!--";
                    if (s.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        region.appendForEscapedChar("\\u003c");
                        continue block10;
                    }
                    if (s.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        region.appendForEscapedChar("\\u003c");
                        continue block10;
                    }
                    region.incrementForNormalChar();
                    continue block10;
                }
                default: {
                    if (c > '\u001f' && c <= '\u007f') {
                        region.incrementForNormalChar();
                        continue block10;
                    }
                    region.appendUnescaped();
                    region.incrementForEscapedChar();
                    Util.appendHexJavaScriptRepresentation(sb, c);
                }
            }
        }
        region.appendUnescaped();
        sb.append('\"');
        return sb.toString();
    }

    public static void appendHexJavaScriptRepresentation(StringBuilder sb, char c) {
        try {
            Util.appendHexJavaScriptRepresentation(c, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            Util.appendHexJavaScriptRepresentation(surrogates[0], out);
            Util.appendHexJavaScriptRepresentation(surrogates[1], out);
            return;
        }
        out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
    }

    private Util() {
    }
}

