/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.velocity.IOWrapper;
import com.isomorphic.velocity.Velocity;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;

public class ISCReferenceInsertionEventHandler
implements ReferenceInsertionEventHandler {
    private static final String[] ESCAPING_EXCEPTIONS = new String[]{"$defaultSelectClause", "$defaultTableClause", "$defaultWhereClause", "$defaultValuesClause", "$defaultGroupClause", "$defaultGroupWhereClause", "$defaultOrderClause", "$rawValue", "$filter", "$equals", "$substringMatches", "$fields", "$qfields", "$defaultJoinWhereClause", "$defaultAnsiJoinClause", "$log", "$defaultGroupWithAliasClause", "$sql"};
    private static Logger log = new Logger(ISCReferenceInsertionEventHandler.class.getName());
    static String parseAsJSONAttr = Config.getGlobal().getString("velocity.parseAsJSON.attribute.name", "__parseAsJSON");
    static JSTranslater jsTranslater = new JSTranslater();
    private boolean quoteAndEscapeValues;
    private boolean escapeStrings;
    private DataSource ds;
    private boolean rawMode = false;
    private List externals = new ArrayList();
    public Object foundObject;
    boolean nullReferences = false;
    private Set<String> additionalEscapingExclusions;

    public ISCReferenceInsertionEventHandler(Context ctx) {
        this(ctx, null, false, false, null);
    }

    public ISCReferenceInsertionEventHandler(Context ctx, DataSource ds, boolean quoteAndEscapeValues, boolean escapeStringValues, Set<String> additionalEscapingExclusions) {
        this.quoteAndEscapeValues = quoteAndEscapeValues;
        this.escapeStrings = escapeStringValues;
        this.ds = ds;
        if (ds != null) {
            this.rawMode = "raw".equals(ds.getConfig().getString("templateQuotingMode"));
        }
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)this);
        ec.attachToContext(ctx);
        String[] keys = ctx.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.externals.add(keys[i].toString());
        }
        this.additionalEscapingExclusions = additionalEscapingExclusions;
    }

    public Object referenceInsert(Context ctx, String reference, Object data) {
        if (data instanceof IOWrapper) {
            data = data.toString();
        }
        if (data == null) {
            this.nullReferences = true;
        }
        this.foundObject = data;
        if (Boolean.TRUE.equals(ctx.get(parseAsJSONAttr)) && data != null && (data instanceof Map || data instanceof List || data.getClass().isArray())) {
            jsTranslater.setStrictJSONMode(true);
            try {
                return jsTranslater.toJS(data);
            }
            catch (UnconvertableException e) {
                log.warn((Object)("Error converting value object for '" + (String)reference + "' to JSON"), e);
                return data;
            }
        }
        if (this.quoteAndEscapeValues && this.ds == null) {
            log.warn("getParameter() called but DataSource has not been set - returning warning");
            return "'Unsafe to retrieve " + (String)reference + " - DataSource has not been set'";
        }
        if (((String)reference).charAt(1) == '{') {
            reference = ((String)reference).substring(0, 1) + ((String)reference).substring(2, ((String)reference).length() - 1);
        }
        if (this.quoteAndEscapeValues) {
            for (int i = 0; i < ESCAPING_EXCEPTIONS.length; ++i) {
                if (!((String)reference).equals(ESCAPING_EXCEPTIONS[i]) && !((String)reference).startsWith(ESCAPING_EXCEPTIONS[i] + ".")) continue;
                return data;
            }
            String trimmedReference = ((String)reference).substring(1);
            if (this.additionalEscapingExclusions != null) {
                for (String snippetName : this.additionalEscapingExclusions) {
                    if (!trimmedReference.equals(snippetName) && !trimmedReference.startsWith(snippetName + ".")) continue;
                    return data;
                }
            }
            boolean quoteAndEscape = false;
            for (int i = 0; i < this.externals.size(); ++i) {
                String external = "$" + (String)this.externals.get(i);
                if (!((String)reference).equals(external) && !((String)reference).startsWith(external + ".")) continue;
                quoteAndEscape = true;
                break;
            }
            if (quoteAndEscape) {
                try {
                    return this.ds.escapeValueForWhereClause(data, reference);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to escape value for where clause", e);
                    return data;
                }
            }
            return data;
        }
        if (!this.escapeStrings || this.rawMode || data != null && !(data instanceof String)) {
            return data;
        }
        if (Boolean.TRUE.equals(ctx.get("__rawValueProcessing"))) {
            return data;
        }
        for (int i = 0; i < ESCAPING_EXCEPTIONS.length; ++i) {
            if (!((String)reference).equals(ESCAPING_EXCEPTIONS[i]) && !((String)reference).startsWith(ESCAPING_EXCEPTIONS[i] + ".") || !"$rawValue".equals(ESCAPING_EXCEPTIONS[i])) continue;
            if (data != null) {
                return data;
            }
            String wrappedRef = ((String)reference).substring("$rawValue.".length());
            if (ctx.containsKey(wrappedRef)) {
                return ctx.get(wrappedRef);
            }
            ctx.put("__rawValueProcessing", (Object)true);
            StringWriter out = new StringWriter();
            try {
                Velocity.getEngine().evaluate(ctx, (Writer)out, "Inner rawValue lookup", "$" + wrappedRef);
            }
            catch (Exception e) {
                log.warn((Object)("Error running inner Velocity eval to resolve $rawValue." + wrappedRef), e);
            }
            ctx.remove("__rawValueProcessing");
            String value = out.toString();
            if (value != null && !value.equals("$" + wrappedRef)) {
                return value;
            }
            return data;
        }
        return this.escapeString((String)data);
    }

    private String escapeString(String string) {
        return StringEscapeUtils.escapeJava((String)string);
    }
}

