/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.ConfigLoader;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexRule;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.RegexRule;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.LRUMap;

public class URIRegexFilter
extends BaseFilter {
    protected boolean useURICache = true;
    public int uriCacheSize = 4096;
    protected Map uriCache;
    public String defaultAction = null;
    protected URIRegexRule defaultRule = null;
    public String webXmlSetResponseHeaders;
    public LinkedHashMap<String, String> setResponseHeaders;
    public String webXmlAddResponseHeaders;
    public LinkedHashMap<String, String> addResponseHeaders;
    public String matchURI = "current";
    public String rulesFile;
    public Map configOverrides = null;
    public String webXmlConfigOverrides = null;
    public String webXmlRules;
    protected List rules;

    public void setUseURICache(String value) {
        this.useURICache = Boolean.valueOf(value);
    }

    public void setUriCacheSize(String value) {
        this.uriCacheSize = Integer.valueOf(value);
    }

    public void setDefaultAction(String value) {
        this.defaultAction = value;
        try {
            this.defaultRule = new URIRegexRule(value + ":/.*/", "defaultAction");
        }
        catch (Exception e) {
            this.log.error((Object)"Error initializing known good regex rule", e);
        }
    }

    public void setSetResponseHeaders(String value) {
        this.webXmlSetResponseHeaders = value;
    }

    public void setAddResponseHeaders(String value) {
        this.webXmlAddResponseHeaders = value;
    }

    public void setMatchURI(String value) {
        this.matchURI = value;
    }

    public void setRulesFile(String value) {
        this.rulesFile = value;
    }

    public void setConfigOverrides(String value) {
        this.webXmlConfigOverrides = value;
    }

    public void setRules(String value) {
        this.webXmlRules = value;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String headerValue;
        String headerName;
        String[] responseHeaderSplit;
        super.init(filterConfig);
        try {
            if (this.defaultRule == null && this.defaultAction == null) {
                if (this.webXmlRules == null && this.rulesFile == null) {
                    this.setDefaultAction("match");
                } else {
                    this.setDefaultAction("ignore");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error initializing known good regex rule", e);
        }
        if (this.webXmlSetResponseHeaders != null) {
            for (String responseHeader : DataTools.simpleSplit(this.webXmlSetResponseHeaders, "\n")) {
                if ((responseHeader = responseHeader.trim()).length() <= 1) continue;
                responseHeaderSplit = responseHeader.split(":", 2);
                if (responseHeaderSplit.length != 2) {
                    this.log.warn("Unable to parse responseHeader set in web.xml: " + responseHeader);
                    continue;
                }
                if (this.setResponseHeaders == null) {
                    this.setResponseHeaders = new LinkedHashMap();
                }
                headerName = responseHeaderSplit[0].trim();
                headerValue = responseHeaderSplit[1].trim();
                this.log.info("Initializing responseHeader " + headerName + ": " + headerValue);
                this.setResponseHeaders.put(headerName, headerValue);
            }
        }
        if (this.webXmlAddResponseHeaders != null) {
            for (String responseHeader : DataTools.simpleSplit(this.webXmlAddResponseHeaders, "\n")) {
                if ((responseHeader = responseHeader.trim()).length() <= 1) continue;
                responseHeaderSplit = responseHeader.split(":", 2);
                if (responseHeaderSplit.length != 2) {
                    this.log.warn("Unable to parse responseHeader set in web.xml: " + responseHeader);
                    continue;
                }
                if (this.addResponseHeaders == null) {
                    this.addResponseHeaders = new LinkedHashMap();
                }
                headerName = responseHeaderSplit[0].trim();
                headerValue = responseHeaderSplit[1].trim();
                this.log.info("Initializing responseHeader " + headerName + ": " + headerValue);
                this.addResponseHeaders.put(headerName, headerValue);
            }
        }
        if (this.webXmlConfigOverrides != null) {
            try {
                this.configOverrides = ConfigLoader.load(new StringReader(this.webXmlConfigOverrides));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Initialized configOverrides: " + DataTools.prettyPrint(this.configOverrides));
                }
            }
            catch (Exception e) {
                this.log.error("Failed to load config overrides from web.xml: " + this.webXmlConfigOverrides);
            }
        }
        if (this.webXmlRules != null) {
            for (String rule : DataTools.simpleSplit(this.webXmlRules, "\n")) {
                if ((rule = rule.trim()).length() <= 1) continue;
                try {
                    if (this.rules == null) {
                        this.rules = new ArrayList();
                    }
                    this.rules.add(new URIRegexRule(rule, "rules init-param in web.xml"));
                }
                catch (Exception e) {
                    this.log.warn(e.toString() + " - dropping this rule.");
                }
            }
        }
        if (this.rulesFile != null) {
            if (this.webXmlRules != null) {
                this.log.warn("Both the rules and rulesFile params are defined in web.xml. Rules defined in the rulesFile: " + this.rulesFile + " will be appended to those defined in the rules param in web.xml");
            }
            if (!this.rulesFile.startsWith("/")) {
                this.rulesFile = "/" + this.rulesFile;
            }
            List rulesFromFile = null;
            try {
                rulesFromFile = DataStructCache.getSingleList(webRoot + this.rulesFile);
            }
            catch (Exception e) {
                this.log.error("Failed to parse rules file: " + webRoot + this.rulesFile);
            }
            if (rulesFromFile != null) {
                for (String rule : rulesFromFile) {
                    try {
                        if (this.rules == null) {
                            this.rules = new ArrayList();
                        }
                        this.rules.add(new URIRegexRule(rule, "rulesFile: " + this.rulesFile));
                    }
                    catch (Exception e) {
                        this.log.warn(e.toString() + " - dropping this rule.");
                    }
                }
            }
        }
        if (this.rules == null) {
            this.useURICache = false;
        }
        if (this.useURICache) {
            this.uriCache = Collections.synchronizedMap(new LRUMap(this.uriCacheSize));
            this.log.info("URI Cache enabled - max size: " + this.uriCacheSize + " entries");
        }
        if (!"initial".equals(this.matchURI) && !"current".equals(this.matchURI)) {
            throw new ServletException("Invalid matchURI: " + this.matchURI + " specified.  Must be either 'initial' or 'current'");
        }
        this.log.info("Matching " + this.matchURI + " URIs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Object initialPath = ServletTools.getInitialRequestURI(request);
        Object currentPath = ServletTools.getCurrentRequestURI(request);
        String queryString = request.getQueryString();
        if (queryString != null) {
            initialPath = (String)initialPath + "?" + queryString;
            currentPath = (String)currentPath + "?" + queryString;
        }
        URIRegexRule matchedRule = this.applyRules((String)initialPath, (String)currentPath, this.matchURI);
        boolean appliedConfigOverrides = false;
        if ("match".equals(matchedRule.getAction())) {
            this.applyResponseHeaders(response, matchedRule);
            appliedConfigOverrides = this.applyConfigOverrides(matchedRule);
        }
        try {
            this.matchedRule(matchedRule, req, res, chain);
        }
        finally {
            if (appliedConfigOverrides) {
                config.popThreadLocal();
            }
        }
    }

    public void applyResponseHeaders(HttpServletResponse response) throws ServletException, IOException {
        this.applyResponseHeaders(response, null);
    }

    public void applyResponseHeaders(HttpServletResponse response, RegexRule matchedRule) throws ServletException, IOException {
        if (this.setResponseHeaders != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setting response headers" + (String)(matchedRule != null ? "(matched rule: " + String.valueOf(matchedRule) + ")" : "") + ": " + DataTools.prettyPrint(this.setResponseHeaders));
            }
            for (String headerName : this.setResponseHeaders.keySet()) {
                response.setHeader(headerName, this.setResponseHeaders.get(headerName));
            }
        }
        if (this.addResponseHeaders != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding response headers" + (String)(matchedRule != null ? "(matched rule: " + String.valueOf(matchedRule) + ")" : "") + ": " + DataTools.prettyPrint(this.addResponseHeaders));
            }
            for (String headerName : this.addResponseHeaders.keySet()) {
                response.addHeader(headerName, this.addResponseHeaders.get(headerName));
            }
        }
    }

    public boolean applyConfigOverrides(RegexRule matchedRule) {
        if (this.configOverrides == null) {
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Applying per-thread config overrides (matched rule: " + String.valueOf(matchedRule) + "): " + DataTools.prettyPrint(this.configOverrides));
        }
        config.pushThreadLocal(this.configOverrides);
        return true;
    }

    public URIRegexRule applyRules(String comparePath) {
        if ("initial".equals(this.matchURI)) {
            return this.applyRules(comparePath, null, this.matchURI);
        }
        return this.applyRules(null, comparePath, this.matchURI);
    }

    public URIRegexRule applyRules(String initialPath, String currentPath, String matchURI) {
        URIRegexRule matchedRule = null;
        if (this.rules != null) {
            MultiKey cacheKey = null;
            if (this.useURICache) {
                cacheKey = new MultiKey((Object)initialPath, (Object)currentPath);
                matchedRule = (URIRegexRule)this.uriCache.get(cacheKey);
            }
            if (matchedRule == null) {
                String comparePath = "initial".equals(matchURI) ? initialPath : currentPath;
                for (URIRegexRule rule : this.rules) {
                    boolean match;
                    block17: {
                        match = false;
                        try {
                            if (rule.hasMatchType()) {
                                switch (rule.getMatchType()) {
                                    case INITIAL: {
                                        if (initialPath != null) {
                                            match = rule.match(initialPath);
                                            break;
                                        }
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Rule " + String.valueOf(rule) + " targeting the initial URI cannot be matched since that URI is not available");
                                            break;
                                        }
                                        break block17;
                                    }
                                    default: {
                                        if (currentPath != null) {
                                            match = rule.match(currentPath);
                                            break;
                                        }
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Rule " + String.valueOf(rule) + " targeting the current URI cannot be matched since that URI is not available");
                                            break;
                                        }
                                        break block17;
                                    }
                                }
                                break block17;
                            }
                            match = rule.match(comparePath);
                        }
                        catch (Exception e) {
                            this.log.warn("Syntax error in rule: " + rule.toString() + " [" + e.getMessage() + "] - ignoring rule.");
                        }
                    }
                    if (!match) continue;
                    matchedRule = rule;
                    break;
                }
                if (matchedRule == null) {
                    matchedRule = this.defaultRule;
                }
                if (this.useURICache) {
                    this.uriCache.put(cacheKey, matchedRule);
                }
            }
        } else {
            matchedRule = this.defaultRule;
        }
        return matchedRule;
    }

    public void matchedRule(RegexRule rule, ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        Object comparePath = ServletTools.getInitialRequestURI(request);
        String queryString = request.getQueryString();
        if (queryString != null) {
            comparePath = (String)comparePath + "?" + queryString;
        }
        if (rule.getAction().equals("block")) {
            this.log.info("Access to URI " + (String)comparePath + " BLOCKED by rule:" + rule.toString());
            this.block(rule, req, res, chain);
        } else if (rule.getAction().equals("ignore")) {
            this.ignore(rule, req, res, chain);
        } else {
            this.match(rule, req, res, chain);
        }
    }

    public void block(RegexRule rule, ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        this.block(req, res, chain);
    }

    public void block(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        ((HttpServletResponse)res).sendError(404);
    }

    public void match(RegexRule rule, ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        this.match(req, res, chain);
    }

    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        chain.doFilter(req, res);
    }

    public void ignore(RegexRule rule, ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        this.ignore(req, res, chain);
    }

    public void ignore(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        chain.doFilter(req, res);
    }
}

