/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.CriteriaUtils;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.DateRangeCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.RelativeDateRangeCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.AuditDSGenerator;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.Committable;
import com.isomorphic.datasource.CustomDSLoader;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSourceDMI;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DataTranslator;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.FieldDataTranslator;
import com.isomorphic.datasource.FileSourceCaches;
import com.isomorphic.datasource.FrameworkDynamicDSGenerator;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.ISCGregorianCalendar;
import com.isomorphic.datasource.ISCMapBean;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.OperationNotSupportedException;
import com.isomorphic.datasource.ProvidesAdditionalFields;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.RelationContext;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.RelationInfo;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.Validator;
import com.isomorphic.datasource.cachesync.CacheSyncStrategy;
import com.isomorphic.datasource.cachesync.GenericRefetchStrategy;
import com.isomorphic.datasource.cachesync.GenericRequestValuesPlusKeysStrategy;
import com.isomorphic.datasource.cachesync.NoOpStrategy;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import com.isomorphic.datasource.cachesync.ResponseValuesStrategy;
import com.isomorphic.interfaces.ISpringTransactionObjectProvider;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IContextBeanFilter;
import com.isomorphic.js.IContextBeanFilterWithNullControl;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.scripting.IScript;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.util.JXPathBeanPointer;
import com.isomorphic.util.JXPathBeanPointerFactory;
import com.isomorphic.util.JXPathContextObjectFactory;
import com.isomorphic.util.date.DateUtil;
import com.isomorphic.util.date.Period;
import com.isomorphic.util.date.RelativeDate;
import com.isomorphic.util.date.RelativeDateRangePosition;
import com.isomorphic.util.date.RelativeDateShortcut;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.CompiledScript;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSource
extends Base
implements Committable,
IType,
IToJSON,
FreeResourcesHandler,
Serializable {
    private static final String TIMING_TRANSFORM_MULTIPLE_FIELDS = "transformMultipleFields processing";
    protected static final int DEFAULT_PROGRESSIVE_LOADING_THRESHOLD = 200000;
    protected static final int DEFAULT_LOOKAHEAD = 1;
    protected static final int DEFAULT_END_GAP = 20;
    private static Logger log = new Logger(DataSource.class.getName());
    private static Logger configLog = new Logger(ConfigLogger.class.getName());
    protected String dsName;
    protected String dsConfigFile;
    protected DataTypeMap<String, Object> dsConfig;
    protected DataTypeMap<String, Object> originalConfig;
    protected DataTypeMap<String, Object> dsConfigAnnotated;
    protected List<String> fieldList;
    protected long configTimestamp = -1L;
    protected String templateConfigToken;
    protected Map<String, CacheSyncStrategy> registeredCacheSyncStrategies = new HashMap<String, CacheSyncStrategy>();
    protected static final ThreadLocal<Stack> loadFlagsStackContainer = new ThreadLocal();
    protected Thread owner = null;
    public static int totalInstantiationTime = 0;
    public static int totalDataSources = 0;
    protected static AtomicLong nextInstanceId = new AtomicLong();
    protected long instanceId;
    protected boolean omitNullMapValuesInResponse;
    private final String TRANSACTION_OBJECT_KEY;
    private static ThreadLocal<HashMap<String, DataSource>> inInitStateThreadLocal = new ThreadLocal();
    protected Map<String, RelationFieldInfo> relationFields;
    protected Map<String, IncludeFromInfo> includeFromFields;
    public static final String OP_VIEW_FILE = "viewFile";
    public static final String OP_DOWNLOAD_FILE = "downloadFile";
    public static final String OP_LOAD_SCHEMA = "loadSchema";
    public static final String OP_FETCH = "fetch";
    public static final String OP_ADD = "add";
    public static final String OP_REMOVE = "remove";
    public static final String OP_UPDATE = "update";
    public static final String OP_CUSTOM = "custom";
    public static final String OP_VALIDATE = "validate";
    public static final Set<String> OPS_VALID_FOR_FIELDVALUEEXPRESSION = new HashSet<String>(Arrays.asList("fetch", "add", "update", "remove", "custom"));
    public static final String OP_CLIENT_EXPORT = "clientExport";
    public static final String OP_GET_FILE = "getFile";
    public static final String OP_ID_XML_TO_JS = "xmlToJs";
    public static final String OP_ID_ALL_OWNERS = "allOwners";
    public static final String OP_ID_ALL_OWNERS_XML_TO_JS = "allOwnersXmlToJs";
    public static final String OP_HAS_FILE = "hasFile";
    public static final String OP_LIST_FILES = "listFiles";
    public static final String OP_SAVE_FILE = "saveFile";
    public static final String OP_RENAME_FILE = "renameFile";
    public static final String OP_REMOVE_FILE = "removeFile";
    public static final String OP_LIST_FILE_VERSIONS = "listFileVersions";
    public static final String OP_GET_FILE_VERSION = "getFileVersion";
    public static final String OP_HAS_FILE_VERSION = "hasFileVersion";
    public static final String OP_REMOVE_FILE_VERSION = "removeFileVersion";
    public static final String OP_UNIQUE_NAME = "uniqueName";
    public static final Set<String> OP_FILE_SOURCE = new HashSet<String>(Arrays.asList("getFile", "hasFile", "listFiles", "saveFile", "renameFile", "removeFile", "listFileVersions", "getFileVersion", "hasFileVersion", "removeFileVersion", "uniqueName"));
    public static final Set<String> RESPONSE_PROPS_VALID_FOR_FIELDVALUEEXPRESSION = new HashSet<String>(Arrays.asList("totalRows", "startRow", "endRow", "status"));
    public static final String FS_FILE_CONTENTS = "fileContents";
    public static final String FS_FILE_TYPE = "fileType";
    public static final String FS_FILE_FORMAT = "fileFormat";
    public static final String FS_FILE_NAME = "fileName";
    public static final String FS_FILE_NAME_LENGTH = "fileNameLength";
    public static final String FS_FILE_LAST_MODIFIED = "fileLastModified";
    public static final String FS_FILE_SIZE = "fileSize";
    public static final String FS_FILE_ENCODING = "fileEncoding";
    public static final String FS_FILE_TENANT_ID = "tenantId";
    public static final String FS_FILE_CONTENTS_AS_JS = "fileContentsJS";
    public static final String FS_EXT_FIELDS = "fileSourceExtensionFields";
    public static final String FS_MAX_FILE_VERSIONS_PROPERTY = "maxFileVersions";
    public static final int FS_MAX_FILE_VERSIONS_DEFAULT = 20;
    public static final List<String> FS_PRIMARY_KEYS = Arrays.asList("fileName", "fileType", "fileFormat", "tenantId");
    public static final String OP_STORE_TEST_DATA = "storeTestData";
    public static final String OP_GET_TEST_DATA = "getTestData";
    static final String DEFAULT_CACHE_TYPENAME = "datasources";
    static final String CACHE_TYPENAME_PROPERTY = "storeCacheType";
    private static final int dsPrefixLen = "ds://".length();
    private static Map dynamicDSGenerators = new LinkedHashMap();
    private static Stack<DynamicDSGenerator> defaultDDSGs = new Stack();
    private static Object ddsgSyncFlag = new Object();
    protected static final ThreadLocal<Stack> gettingDynamicStackContainer = new ThreadLocal();
    public static Map creationCount = new HashMap();
    static String serializeAsJSONAttr = config.getString("velocity.parseAsJSON.attribute.name", "__parseAsJSON");
    static final String builtinTypesFile = "builtinTypes.xml";
    static Map builtinTypes;
    private static boolean builtinTypesInitialized;
    private static boolean builtinTypesInitializing;
    private static final Object builtinTypesLock;
    protected DataTypeMap globalServerConfig = null;
    protected DataTypeMap serverConfigByOperationId = new DataTypeMap();
    private static int count;
    private static int failCount;
    private static long nanosecs;
    private List<String> fieldNames = null;
    private List<String> directFields = null;
    protected List<String> nonIncludedFields = null;
    static String dynamicBeanMarkerName;
    static Class dynamicBeanMarker;
    public static long beanConversionLapse;
    public static long subValuesLapse;
    public static long subValDSMLapse;
    public static long subValVCLapse;
    public static long subValVCHit;
    public static long subValVCMiss;
    public static long inSubValueLapse;
    public static long inSubValueLapse0;
    public static long inSubValueLapse1;
    public static long inSubValueLapse2;
    public static long subPropsLapse;
    protected Map<String, String> fileSourceFieldMapToNative = new HashMap<String, String>();
    protected Map<String, String> fileSourceFieldMapFromNative = new HashMap<String, String>();
    protected boolean fileSourceFieldMapInitialized = false;
    private boolean preventFileContentsRecursion = false;
    private boolean _stateCleared = false;
    protected DataSource auditDS = null;
    boolean _isAutoGeneratedAuditDS = false;
    public static final String USE_SPRING_TRANSACTION = "useSpringTransaction";
    public static boolean useAxisForSQLDS;
    Evaluator evaluator;
    private Map<String, RelationInfo> cachedRelations = new HashMap<String, RelationInfo>();
    protected Map<String, String> filenameField = new HashMap<String, String>();
    protected Map<String, String> filesizeField = new HashMap<String, String>();
    protected Map<String, String> dateCreatedField = new HashMap<String, String>();
    private Map<String, String> ambiguousIncFrom;
    private Map<DSField, Class> convertedProps = new HashMap<DSField, Class>();
    Boolean _isCacheable = null;
    private static ConcurrentHashMap<String, Boolean> sandboxEligibleCache;
    static SimpleDateFormat dateFmt;
    static SimpleDateFormat dateTimeFmt;
    static SimpleDateFormat timeFmt;
    protected Map<String, CompiledScript> compiledScripts = new HashMap<String, CompiledScript>();

    public static void addLoadFlags(DataTypeMap addLoadFlags) {
        DataSource.pushLoadFlags((DataTypeMap)((Object)DataTools.cascadeMaps(new Map[]{DataSource.getLoadFlags(), addLoadFlags, new DataTypeMap()})));
    }

    public static void addLoadFlag(String key, Object value) {
        DataTypeMap<String, Object> flags = new DataTypeMap<String, Object>();
        flags.put(key, value);
        DataSource.addLoadFlags(flags);
    }

    public static void pushLoadFlags(DataTypeMap loadFlags) {
        Stack<DataTypeMap> loadFlagsStack = loadFlagsStackContainer.get();
        if (loadFlagsStack == null) {
            loadFlagsStack = new Stack<DataTypeMap>();
            loadFlagsStackContainer.set(loadFlagsStack);
        }
        loadFlagsStack.push(loadFlags);
    }

    public static DataTypeMap getLoadFlags() {
        Stack loadFlagsStack = loadFlagsStackContainer.get();
        if (loadFlagsStack != null && !loadFlagsStack.isEmpty()) {
            return (DataTypeMap)((Object)loadFlagsStack.peek());
        }
        return new DataTypeMap();
    }

    public static DataTypeMap popLoadFlags() {
        Stack loadFlagsStack = loadFlagsStackContainer.get();
        if (loadFlagsStack != null) {
            try {
                return (DataTypeMap)((Object)loadFlagsStack.pop());
            }
            catch (EmptyStackException ese) {
                log.warn((Object)"No stack in popLoadFlags()", ese);
            }
        }
        return null;
    }

    public static boolean assertLoadFlag(String key, Object value, boolean defaultValue) {
        DataTypeMap map;
        Stack loadFlagsStack = loadFlagsStackContainer.get();
        if (loadFlagsStack != null && !loadFlagsStack.isEmpty() && (map = (DataTypeMap)((Object)loadFlagsStack.peek())).containsKey(key)) {
            return value.equals(map.get(key));
        }
        return defaultValue;
    }

    public static void purgeLoadFlags() {
        loadFlagsStackContainer.remove();
    }

    public Thread getOwningThread() {
        return this.owner;
    }

    public boolean belongsToThread(Thread returner) {
        return returner == this.owner;
    }

    public void activateOnThread(Thread activator) {
        this.owner = activator;
    }

    public void passivate() {
        this.owner = null;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public boolean getOmitNullMapValuesInResponse() {
        return this.omitNullMapValuesInResponse;
    }

    public void setOmitNullMapValuesInResponse(boolean omitNullMapValuesInResponse) {
        this.omitNullMapValuesInResponse = omitNullMapValuesInResponse;
    }

    protected static final HashMap<String, DataSource> getInInitState() {
        HashMap<String, DataSource> work = inInitStateThreadLocal.get();
        if (work == null) {
            log.debug("Initializing inInitState");
            work = new HashMap();
            DataSource.setInInitState(work);
        }
        return work;
    }

    protected static final void setInInitState(HashMap<String, DataSource> value) {
        log.debug("Setting inInitState");
        inInitStateThreadLocal.set(value);
    }

    protected static final void clearInInitState() {
        HashMap<String, DataSource> work = inInitStateThreadLocal.get();
        if (work == null) {
            log.debug("In clearInInitState, the cache was already null; nothing to do");
            return;
        }
        log.debug("Clearing inInitState; it contained " + work.size() + " entries");
        work.clear();
        inInitStateThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource forName(String dsName, DSRequest dsRequest) throws Exception {
        DataSource ds;
        boolean dsNameIsDataSource = "DataSource".equals(dsName);
        if (dsNameIsDataSource) {
            DataStructCache.disableDsPaths();
        }
        try {
            ds = DataSource.getDynamicDataSource(dsName, dsRequest);
            if (ds == null) {
                ds = DataSource.loadDS(dsName, dsRequest, config -> config);
            }
        }
        finally {
            if (dsNameIsDataSource) {
                DataStructCache.enableDsPaths();
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataSource loadDS(String dsName, DSRequest dsRequest, CustomDSLoader loader) throws Exception {
        DataSource ds;
        Object autoDerive;
        Object dsConfig;
        String ID = null;
        String dsConfigFile = null;
        DataTypeMap flags = new DataTypeMap();
        String cacheTypeName = loader.getCacheTypeName();
        if ("Object".equals(dsName)) {
            ID = "Object";
            dsConfig = DataTools.buildMap("ID", ID);
        } else {
            HashMap instanceFileContext;
            Object dsObject;
            if (DEFAULT_CACHE_TYPENAME.equals(cacheTypeName) && (dsObject = DataStructCache.getCachedObjectWithNoConfigFile(dsName)) != null && dsObject instanceof DataSource) {
                return (DataSource)dsObject;
            }
            Map fileConfig = DataSource.getLoadDSFileConfig(dsName, dsRequest);
            dsConfigFile = DataStructCache.getInstanceFile(dsName, cacheTypeName, "DS", null, fileConfig, instanceFileContext = new HashMap(), dsRequest);
            if (dsConfigFile == null) {
                return null;
            }
            dsConfig = (Map)DataStructCache.loadInstance(dsConfigFile, dsName, "DS", flags, fileConfig, (ISCFile)instanceFileContext.get("iscFileInstance"), dsRequest);
            if (dsConfig == null) {
                throw new Exception("Can't locate datasource for name: " + dsName);
            }
            ID = (String)dsConfig.get("ID");
            if (ID != null && !dsName.equals(ID)) {
                if (log.isDebugEnabled()) {
                    log.debug("dsName case sensitivity mismatch - looking for: " + dsName + ", but got: " + ID);
                }
                return null;
            }
            if (dsConfig == null) {
                return null;
            }
            dsConfig.put("isServerDS", true);
        }
        List configOverrides = config.getList("datasources." + ID + ".config.xpath.set");
        if (configOverrides != null) {
            if (config.threadLocalInEffect() || config.globalOverridesInEffect()) {
                dsConfig = (Map)DataTools.deepClone(dsConfig);
            }
            Iterator i = configOverrides.iterator();
            while (i.hasNext()) {
                String xpath = (String)i.next();
                Object value = i.next();
                log.debug("Applying dsConfig xpath override for DS " + ID + " " + xpath + " = " + String.valueOf(value));
                DataTools.xpathSet(dsConfig, xpath, value);
            }
        }
        if ((autoDerive = dsConfig.get("autoDeriveSchema")) != null && "true".equals(autoDerive.toString()) && Boolean.TRUE.equals(flags.get("objectWasStale"))) {
            DataStructCache.removeCachedObjectWithNoConfigFile(dsName + "_inheritsFrom");
        }
        dsConfig = loader.getDynamicConfigOverrides((Map)dsConfig);
        boolean hasCacheTypeLoadFlag = !DataSource.assertLoadFlag(CACHE_TYPENAME_PROPERTY, DEFAULT_CACHE_TYPENAME, true);
        try {
            if (hasCacheTypeLoadFlag) {
                DataSource.addLoadFlag(CACHE_TYPENAME_PROPERTY, DEFAULT_CACHE_TYPENAME);
            }
            long start = System.currentTimeMillis();
            ds = DataSource.fromConfig((Map)dsConfig, dsRequest);
            long l = System.currentTimeMillis();
        }
        finally {
            if (hasCacheTypeLoadFlag) {
                DataSource.popLoadFlags();
            }
        }
        if (dsConfigFile != null) {
            String parentDatasourceId;
            ds.dsConfigFile = dsConfigFile;
            if (config.getBoolean((Object)"datasources.enableUpToDateCheck", false)) {
                ds.configTimestamp = ISCFile.newInstance(dsConfigFile).lastModified();
            }
            if ((parentDatasourceId = DataSource.parentDataSourceId(dsConfigFile)) != null) {
                ds.getConfig().put("sourceDataSourceID", parentDatasourceId);
            }
        }
        return ds;
    }

    public static DataSource loadTenantDataSource(String dsName, String tenantId) throws Exception {
        DSRequest dsRequest = new DSRequest(dsName, OP_FETCH).setTenantId(tenantId);
        return DataSource.getDynamicDataSource(dsName, dsRequest);
    }

    public static String parentDataSourceId(String dsPath) {
        boolean isDSPath = dsPath.startsWith("ds:/");
        if (!isDSPath) {
            return null;
        }
        String parentDatasourceId = dsPath.substring(dsPrefixLen, dsPath.indexOf("/", dsPrefixLen));
        return parentDatasourceId;
    }

    protected static Map getLoadDSFileConfig(String dsName, DSRequest dsRequest) {
        Boolean exactCaseMatch = config.getBoolean((Object)"datasource.load.exactCaseNameMatch", true);
        return exactCaseMatch != false ? DataTools.buildMap("textMatchStyle", "exactCase") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg) {
        if (ddsg != null && log.isDebugEnabled()) {
            log.debug("Adding new default DynamicDSGenerator with hashcode '" + ddsg.hashCode() + "'");
        }
        Object object = ddsgSyncFlag;
        synchronized (object) {
            defaultDDSGs.push(ddsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicDSGenerator removeDynamicDSGenerator() {
        DynamicDSGenerator ddsg = null;
        Object object = ddsgSyncFlag;
        synchronized (object) {
            if (!defaultDDSGs.isEmpty()) {
                ddsg = defaultDDSGs.pop();
            }
        }
        if (log.isDebugEnabled()) {
            DynamicDSGenerator newDft = null;
            Object object2 = ddsgSyncFlag;
            synchronized (object2) {
                if (!defaultDDSGs.isEmpty()) {
                    newDft = defaultDDSGs.peek();
                }
            }
            String newHash = newDft == null ? "null" : "" + newDft.hashCode();
            log.debug("Removed current default DynamicDSGenerator '" + String.valueOf(ddsg == null ? "null" : Integer.valueOf(ddsg.hashCode())) + "' from the stack.  New default is '" + newHash + "'");
        }
        return ddsg;
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg, String prefix) {
        dynamicDSGenerators.put(prefix, ddsg);
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg, Pattern regex) {
        dynamicDSGenerators.put(regex, ddsg);
    }

    public static DynamicDSGenerator getDefaultDynamicDSGenerator() {
        if (defaultDDSGs.isEmpty()) {
            return null;
        }
        return defaultDDSGs.peek();
    }

    public static Map getDynamicDSGenerators() {
        return dynamicDSGenerators;
    }

    public static DynamicDSGenerator removeDynamicDSGenerator(String prefix) {
        if (dynamicDSGenerators.containsKey(prefix)) {
            DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(prefix);
            dynamicDSGenerators.remove(prefix);
            return ddsg;
        }
        return null;
    }

    public static DynamicDSGenerator removeDynamicDSGenerator(Pattern regex) {
        if (dynamicDSGenerators.containsKey(regex)) {
            DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(regex);
            dynamicDSGenerators.remove(regex);
            return ddsg;
        }
        return null;
    }

    public static void clearDynamicDSGenerators() {
        DataSource.clearDynamicDSGenerators(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearDynamicDSGenerators(boolean removeFrameworkGenerators) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing all DynamicDSGenerators", new Exception());
        }
        Object object = ddsgSyncFlag;
        synchronized (object) {
            Stack<DynamicDSGenerator> work = new Stack<DynamicDSGenerator>();
            int entries = defaultDDSGs.size();
            int i = 0;
            while (i++ < entries) {
                DynamicDSGenerator ddsg = defaultDDSGs.pop();
                if (removeFrameworkGenerators || !(ddsg instanceof FrameworkDynamicDSGenerator)) continue;
                work.push(ddsg);
            }
            entries = work.size();
            i = 0;
            while (i++ < entries) {
                defaultDDSGs.push((DynamicDSGenerator)work.pop());
            }
            if (removeFrameworkGenerators) {
                dynamicDSGenerators.clear();
            } else {
                Iterator j = dynamicDSGenerators.keySet().iterator();
                while (j.hasNext()) {
                    Object key = j.next();
                    DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(key);
                    if (ddsg instanceof FrameworkDynamicDSGenerator) continue;
                    j.remove();
                }
            }
        }
    }

    public static void pushThreadDynamicId(String id) {
        Stack<String> gettingDynamicStack = gettingDynamicStackContainer.get();
        if (gettingDynamicStack == null) {
            gettingDynamicStack = new Stack<String>();
            gettingDynamicStackContainer.set(gettingDynamicStack);
        }
        gettingDynamicStack.push(id);
    }

    public static boolean threadDynamicContainsId(String id) {
        Stack gettingDynamicStack = gettingDynamicStackContainer.get();
        if (gettingDynamicStack != null && !gettingDynamicStack.isEmpty()) {
            return gettingDynamicStack.contains(id);
        }
        return false;
    }

    public static String popThreadDynamicId() {
        Stack gettingDynamicStack = gettingDynamicStackContainer.get();
        if (gettingDynamicStack != null && !gettingDynamicStack.isEmpty()) {
            return (String)gettingDynamicStack.pop();
        }
        return null;
    }

    public static void purgeThreadDynamicId() {
        gettingDynamicStackContainer.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource getDynamicDataSource(String id, DSRequest dsRequest) throws Exception {
        if (DataSource.threadDynamicContainsId(id)) {
            return null;
        }
        DataSource ds = null;
        DataSource.pushThreadDynamicId(id);
        try {
            DynamicDSGenerator ddsg = null;
            for (Object keyObj : dynamicDSGenerators.keySet()) {
                if (keyObj instanceof String) {
                    if (id.indexOf((String)keyObj) != 0) continue;
                    ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                    break;
                }
                if (keyObj instanceof Pattern) {
                    Pattern p = (Pattern)keyObj;
                    Matcher m = p.matcher(id);
                    if (!m.find()) continue;
                    ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                    break;
                }
                log.warn("In the dynamicDSGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
            }
            if (ddsg != null) {
                ds = ddsg.getDataSource(id, dsRequest);
            }
            if (ds == null) {
                ds = DataSource.getDataSourceFromStack(id, dsRequest, defaultDDSGs);
            }
        }
        finally {
            DataSource.popThreadDynamicId();
            if (ds != null && id != null && !id.equals(ds.getName())) {
                String msg = "A DynamicDSGenerator returned a DataSource named '" + ds.getName() + "' in response to a request for '" + id + "'.  This is a bug in your DynamicDSGenerator.  Abandoning now to avoid unpredictable errors later in the code flow";
                log.warn(msg);
                throw new Exception(msg);
            }
        }
        return ds;
    }

    private static DataSource getDataSourceFromStack(String id, DSRequest dsRequest, Stack<DynamicDSGenerator> stackIn) {
        Stack<DynamicDSGenerator> stackWork = new Stack<DynamicDSGenerator>();
        stackWork.addAll(stackIn);
        DynamicDSGenerator ddsg = null;
        if (!stackWork.isEmpty()) {
            ddsg = (DynamicDSGenerator)stackWork.pop();
        }
        if (ddsg == null) {
            return null;
        }
        DataSource ds = ddsg.getDataSource(id, dsRequest);
        if (ds != null) {
            return ds;
        }
        return DataSource.getDataSourceFromStack(id, dsRequest, stackWork);
    }

    private static DynamicDSGenerator getDynamicDSGenerator(String id) {
        DynamicDSGenerator ddsg = null;
        for (Object keyObj : dynamicDSGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicDSGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        return ddsg != null ? ddsg : DataSource.getDefaultDynamicDSGenerator();
    }

    static boolean isUnPooledDynamicDS(String id, boolean poolDynamicDataSources, DSRequest request) {
        DynamicDSGenerator ddsg = DataSource.getDynamicDSGenerator(id);
        if (ddsg == null) {
            return false;
        }
        if (!ddsg.isAuthorized(id, request)) {
            return true;
        }
        Boolean poolable = ddsg.isPoolable(id);
        return poolable != null ? !poolable.booleanValue() : !poolDynamicDataSources;
    }

    static boolean isUnPooledDynamicDS(DataSource ds, boolean poolDynamicDataSources) {
        String id = ds.getID();
        DynamicDSGenerator ddsg = DataSource.getDynamicDSGenerator(id);
        if (ddsg == null) {
            return false;
        }
        Boolean poolable = ddsg.isPoolable(id);
        return poolable != null ? !poolable.booleanValue() : !poolDynamicDataSources;
    }

    public static DataSource fromConfig(Map theConfig, DSRequest dsRequest) throws Exception {
        return BasicDataSource.fromConfig(theConfig, dsRequest);
    }

    public final void initialize(Map theConfig, DSRequest dsRequest) throws Exception {
        this.registerCacheSyncStrategy("requestValues", new RequestValuesStrategy());
        this.registerCacheSyncStrategy("requestValuesPlusSequences", new GenericRequestValuesPlusKeysStrategy());
        this.registerCacheSyncStrategy("responseValues", new ResponseValuesStrategy());
        this.registerCacheSyncStrategy("refetch", new GenericRefetchStrategy());
        this.registerCacheSyncStrategy("none", new NoOpStrategy());
        this.init(theConfig, dsRequest);
        this.initialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        this.instanceId = nextInstanceId.getAndIncrement();
        this.dsConfig = (DataTypeMap)((Object)DataTools.mapMerge(theConfig, new DataTypeMap()));
        this.dsName = this.dsConfig.getString("ID");
        this.fieldList = new ArrayList<String>();
        if (this.dsName == null) {
            log.warn("dsConfig with no ID: " + DataTools.prettyPrint(this.dsConfig));
        }
        if (log.isDebugEnabled()) {
            if (config.getBoolean((Object)"debug.dataSource.creation", false)) {
                log.debug("Creating instance of DataSource '" + this.dsName + "' with instanceId " + this.instanceId);
            }
            Map map = creationCount;
            synchronized (map) {
                DataTools.incrementIntInMap(creationCount, this.dsName);
            }
            ++totalDataSources;
        }
    }

    public Object deepCloneWithVelocityEval(Object source, String operationName, Map templateContext) throws Exception {
        if (source == null) {
            return null;
        }
        if (source instanceof String || source instanceof Number || source instanceof Boolean || source instanceof Character) {
            return this.doVelocityEval(source, operationName, templateContext);
        }
        if (source instanceof Map) {
            Map target = (Map)Reflection.newInstance(source.getClass());
            for (Object key : ((Map)source).keySet()) {
                Object value = ((Map)source).get(key);
                if (this.shouldSerializeAsJSON(key.toString(), value)) {
                    templateContext.put(serializeAsJSONAttr, true);
                }
                if (this.shouldDeferParsing(key.toString(), value)) {
                    target.put(key, value);
                } else {
                    target.put(key, this.deepCloneWithVelocityEval(value, operationName, templateContext));
                }
                templateContext.remove(serializeAsJSONAttr);
            }
            return target;
        }
        if (source instanceof Collection) {
            Collection target = (Collection)Reflection.newInstance(source.getClass());
            for (Object value : (Collection)source) {
                target.add(this.deepCloneWithVelocityEval(value, operationName, templateContext));
            }
            return target;
        }
        Method cloneMethod = null;
        try {
            cloneMethod = Reflection.findMethod(source, "clone");
        }
        catch (NoSuchMethodException i) {
            // empty catch block
        }
        if (cloneMethod != null) {
            return this.doVelocityEval(cloneMethod.invoke(source, null), operationName, templateContext);
        }
        Class[] paramTypes = new Class[]{source.getClass()};
        Constructor<?> copyConstructor = null;
        try {
            copyConstructor = source.getClass().getConstructor(paramTypes);
        }
        catch (NoSuchMethodException value) {
            // empty catch block
        }
        if (copyConstructor != null) {
            Object[] params = new Object[]{source};
            return this.doVelocityEval(copyConstructor.newInstance(params), operationName, templateContext);
        }
        return this.doVelocityEval(source, operationName, templateContext);
    }

    public Object deepCloneWithSimpleConfigRefReplacement(Object source, DataTypeMap config) throws Exception {
        if (source == null) {
            return null;
        }
        if (source instanceof String || source instanceof Number || source instanceof Boolean || source instanceof Character) {
            return this.replaceSimpleConfigRefs(source, config);
        }
        if (source instanceof Map) {
            Map target = (Map)Reflection.newInstance(source.getClass());
            for (Object key : ((Map)source).keySet()) {
                Object value = ((Map)source).get(key);
                if (!"templateConfigToken".equals(key)) {
                    value = this.deepCloneWithSimpleConfigRefReplacement(value, config);
                }
                target.put(key, value);
            }
            return target;
        }
        if (source instanceof Collection) {
            Collection target = (Collection)Reflection.newInstance(source.getClass());
            for (Object value : (Collection)source) {
                target.add(this.deepCloneWithSimpleConfigRefReplacement(value, config));
            }
            return target;
        }
        Method cloneMethod = null;
        try {
            cloneMethod = Reflection.findMethod(source, "clone");
        }
        catch (NoSuchMethodException i) {
            // empty catch block
        }
        if (cloneMethod != null) {
            return this.replaceSimpleConfigRefs(cloneMethod.invoke(source, null), config);
        }
        Class[] paramTypes = new Class[]{source.getClass()};
        Constructor<?> copyConstructor = null;
        try {
            copyConstructor = source.getClass().getConstructor(paramTypes);
        }
        catch (NoSuchMethodException value) {
            // empty catch block
        }
        if (copyConstructor != null) {
            Object[] params = new Object[]{source};
            return this.replaceSimpleConfigRefs(copyConstructor.newInstance(params), config);
        }
        return source;
    }

    public Object replaceSimpleConfigRefs(Object source, DataTypeMap config) {
        if (!(source instanceof String)) {
            return source;
        }
        String sourceStr = (String)source;
        if (this.templateConfigToken == null) {
            this.templateConfigToken = config.getString("templateConfigToken", "$config");
        }
        StringBuffer work = new StringBuffer();
        int ix = 0;
        int foundIx = 0;
        while ((foundIx = sourceStr.indexOf(this.templateConfigToken, ix)) != -1) {
            work.append(sourceStr.substring(ix, foundIx));
            int bracketIx = foundIx + this.templateConfigToken.length();
            if (sourceStr.charAt(bracketIx) != '[') {
                log.warn("Ignoring invalid config template definition at position " + bracketIx + " of text string '" + sourceStr + "' when evaluatiing config for DataSource '" + String.valueOf(config.get("ID")) + "': Expected '[' character, found '" + sourceStr.charAt(bracketIx) + "'");
                ix = bracketIx;
                continue;
            }
            char quoteChar = sourceStr.charAt(bracketIx + 1);
            if (quoteChar != '\'' && quoteChar != '\"') {
                log.warn("Ignoring invalid config template definition at position " + (bracketIx + 1) + " of text string '" + sourceStr + "' when evaluatiing config for DataSource '" + String.valueOf(config.get("ID")) + "': Expected ' or \" character, found '" + sourceStr.charAt(bracketIx + 1) + "'");
                ix = bracketIx + 1;
                continue;
            }
            int closeQuoteIx = sourceStr.indexOf(quoteChar, bracketIx + 2);
            if (closeQuoteIx == -1) {
                log.warn("Ignoring invalid config template definition at position " + (bracketIx + 1) + " of text string '" + sourceStr + "' when evaluatiing config for DataSource '" + String.valueOf(config.get("ID")) + "': No closing " + quoteChar + " character found");
                ix = bracketIx + 1;
                continue;
            }
            if (sourceStr.charAt(closeQuoteIx + 1) != ']') {
                log.warn("Ignoring invalid config template definition at position " + (closeQuoteIx + 1) + " of text string '" + sourceStr + "' when evaluatiing config for DataSource '" + String.valueOf(config.get("ID")) + "': Expected ']' character, found '" + sourceStr.charAt(closeQuoteIx + 1) + "'");
                ix = closeQuoteIx;
                continue;
            }
            String propName = sourceStr.substring(bracketIx + 2, closeQuoteIx);
            Object value = Config.getGlobal().get(propName);
            if (value == null) {
                value = sourceStr.substring(foundIx, closeQuoteIx + 2) + "*NOT FOUND IN CONFIG*";
            }
            work.append(value);
            ix = closeQuoteIx + 2;
        }
        work.append(sourceStr.substring(ix));
        return work.toString();
    }

    public boolean shouldSerializeAsJSON(String key, Object value) {
        return false;
    }

    public boolean shouldDeferParsing(String key, Object value) {
        return false;
    }

    protected Object doVelocityEval(Object o, String operationName, Map contextMap) throws Exception {
        return this.doVelocityEval(o, operationName, contextMap, false);
    }

    protected Object doVelocityEval(Object o, String operationName, Map contextMap, boolean escapeStringValues) throws Exception {
        if (!(o instanceof String)) {
            return o;
        }
        String str = (String)o;
        if (str.indexOf("$") == -1 && str.indexOf("#") == -1) {
            return str;
        }
        Object val = Velocity.evaluate(str, contextMap, operationName, this, false, false, null, escapeStringValues);
        if (val instanceof String) {
            return ((String)val).trim();
        }
        return val;
    }

    protected void initialized() throws Exception {
    }

    public static DataSource fromXML(Element elem) throws Exception {
        return DataSource.fromXML(elem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource fromXML(Element elem, DSRequest dsRequest) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            vc.setSource("ds");
            DataSource dataSource = DataSource.fromConfig((Map)XML.toDSRecords(elem, vc), dsRequest);
            return dataSource;
        }
        finally {
            vc.freeResources();
        }
    }

    public static DataSource fromXML(Document doc) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement());
    }

    public static DataSource fromXML(Document doc, DSRequest dsRequest) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement(), dsRequest);
    }

    public static DataSource fromXML(String xml) throws Exception {
        return DataSource.fromXML(new StringReader(xml));
    }

    public static DataSource fromXML(String xml, DSRequest dsRequest) throws Exception {
        return DataSource.fromXML(new StringReader(xml), dsRequest);
    }

    public static DataSource fromXML(Reader reader) throws Exception {
        return DataSource.fromXML(reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource fromXML(Reader reader, DSRequest dsRequest) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            vc.setSource("ds");
            DataSource dataSource = DataSource.fromConfig((Map)XML.toDSRecords(reader, vc), dsRequest);
            return dataSource;
        }
        finally {
            vc.freeResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getBuiltinTypes() {
        if (!builtinTypesInitialized) {
            Object object = builtinTypesLock;
            synchronized (object) {
                if (!builtinTypesInitialized) {
                    if (builtinTypesInitializing) {
                        return new HashMap();
                    }
                    builtinTypesInitializing = true;
                    try {
                        DataSource.initializeBuiltinTypes();
                        builtinTypesInitialized = true;
                    }
                    finally {
                        builtinTypesInitializing = false;
                    }
                }
            }
        }
        return builtinTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeBuiltinTypes() {
        DataStructCache.disableDsPaths();
        try {
            builtinTypes = new HashMap();
            List paths = config.getCommaSeparatedList("framework.datasources");
            LinkedHashMap<CallSite, Exception> triedPaths = new LinkedHashMap<CallSite, Exception>();
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                String dsDirPath = ISCFile.canonicalizePath((String)j.next());
                String fileName = null;
                try {
                    fileName = dsDirPath + "/builtinTypes.xml";
                    builtinTypes = (Map)XML.toDSRecords(fileName);
                    if (builtinTypes == null) continue;
                    break;
                }
                catch (Exception e) {
                    triedPaths.put((CallSite)((Object)fileName), e);
                }
            }
            if (builtinTypes.size() == 0) {
                System.out.println("Problem loading builtinTypes.xml");
                for (String path : triedPaths.keySet()) {
                    Exception e = (Exception)triedPaths.get(path);
                    System.out.println("Exception when loading from " + path + ":\n" + DataTools.getStackTrace(e));
                }
            }
            for (String key : builtinTypes.keySet()) {
                Map map = (Map)builtinTypes.get(key);
                Object valObj = map.get("validators");
                if (valObj instanceof List) {
                    List valList = (List)valObj;
                    for (int j2 = 0; j2 < valList.size(); ++j2) {
                        valObj = valList.get(j2);
                        if (!(valObj instanceof Map)) continue;
                        valList.set(j2, new Validator((Map)valObj));
                    }
                    continue;
                }
                if (!(valObj instanceof Map)) continue;
                map.put("validators", new Validator((Map)valObj));
            }
        }
        finally {
            DataStructCache.enableDsPaths();
        }
    }

    public static Map getBuiltinType(String typeID) {
        if (typeID == null) {
            return null;
        }
        return (Map)DataSource.getBuiltinTypes().get(typeID);
    }

    public boolean isStale() {
        if (this.configTimestamp == -1L) {
            return false;
        }
        try {
            ISCFile configFile = ISCFile.newInstance(this.dsConfigFile);
            return configFile.lastModified() != this.configTimestamp;
        }
        catch (IOException ex) {
            log.warn("isStale caught exception: " + ex.toString());
            return true;
        }
    }

    public String getID() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.dsName;
    }

    public String getTableName() {
        return (String)this.dsConfig.get("tableName");
    }

    public boolean hasTenantId() {
        return this.getTenantId() != null;
    }

    public String getTenantId() {
        return this.dsConfig.getString(FS_FILE_TENANT_ID);
    }

    String getBaseName() {
        String baseName = this.dsConfig.getString("baseId");
        return baseName != null ? baseName : this.getName();
    }

    String getCacheTypeName() {
        String cacheType = this.dsConfig.getString("cacheType");
        return cacheType != null ? cacheType : DEFAULT_CACHE_TYPENAME;
    }

    public String getRelatedTableAlias() {
        return (String)this.dsConfig.get("relatedTableAlias");
    }

    public boolean broadcastUpdates() {
        return this.dsConfig.get("broadcastUpdates") != null && (Boolean)this.dsConfig.get("broadcastUpdates") != false;
    }

    public String getConfigFilename() {
        return this.dsConfigFile;
    }

    public Map getServerObjectConfig() {
        return (Map)this.dsConfig.get("serverObject");
    }

    public DataTypeMap getGlobalServerConfig(DSRequest dsRequest) throws Exception {
        if (!this.dsConfig.getBoolean((Object)"__hadServerConfig", false)) {
            return this.dsConfig;
        }
        this.globalServerConfig = (DataTypeMap)((Object)this.deepCloneWithVelocityEval(this.dsConfig, "serverConfig", Velocity.getStandardContextMap(dsRequest)));
        return this.globalServerConfig;
    }

    public DataTypeMap mergeServerConfig() throws Exception {
        if (this.dsConfig.get("serverConfig") == null) {
            return this.dsConfig;
        }
        this.dsConfig.put("__hadServerConfig", true);
        DataTypeMap mergedConfig = (DataTypeMap)((Object)DataTools.deepClone(this.dsConfig));
        DataTypeMap serverConfig = mergedConfig.getMap("serverConfig");
        mergedConfig.remove("serverConfig");
        DataTypeMap serverConfigBindings = this.createOperationBindingsIndex(serverConfig);
        if (serverConfigBindings != null) {
            DataTypeMap dsConfigBindings = this.createOperationBindingsIndex(mergedConfig);
            mergedConfig.put("operationBindings", dsConfigBindings);
            serverConfig.put("operationBindings", serverConfigBindings);
        }
        DataTools.deepMerge((Object)serverConfig, (Object)mergedConfig, true);
        if (serverConfigBindings != null) {
            mergedConfig.put("operationBindings", new ArrayList(mergedConfig.getMap("operationBindings").values()));
        }
        return mergedConfig;
    }

    public DataTypeMap applyBaseTemplating(DataTypeMap config) throws Exception {
        if (config != null) {
            String allowTemplateRefs = config.getString("allowTemplateReferences");
            if (allowTemplateRefs == null) {
                allowTemplateRefs = this.getDefaultAllowTemplateRefs();
            }
            if ("all".equals(allowTemplateRefs)) {
                config = (DataTypeMap)((Object)this.deepCloneWithVelocityEval((Object)config, "templateBaseConfig", Velocity.getStandardContextMap(null)));
            } else if ("configOnly".equals(allowTemplateRefs)) {
                config = (DataTypeMap)((Object)this.deepCloneWithSimpleConfigRefReplacement((Object)config, config));
            }
        }
        return config;
    }

    protected String getDefaultAllowTemplateRefs() {
        return "none";
    }

    protected DataTypeMap createOperationBindingsIndex(DataTypeMap config) {
        List bindings = config.getList("operationBindings");
        if (bindings == null) {
            return null;
        }
        DataTypeMap<CallSite, Map> index = new DataTypeMap<CallSite, Map>();
        for (int i = 0; i < bindings.size(); ++i) {
            Map binding = (Map)bindings.get(i);
            String key = String.valueOf(binding.get("operationType")) + "_" + String.valueOf(binding.get("operationId"));
            index.put((CallSite)((Object)key), binding);
        }
        return index;
    }

    public DataTypeMap getServerConfig(DSRequest dsRequest) throws Exception {
        if (dsRequest.getAttribute("_serverConfig") != null) {
            return (DataTypeMap)((Object)dsRequest.getAttribute("_serverConfig"));
        }
        String operationType = dsRequest.getOperationType();
        String operationId = dsRequest.getOperationId();
        DataTypeMap globalServerConfig = this.getGlobalServerConfig(dsRequest);
        DataTypeMap opBindingServerConfig = this.getOperationBinding(operationType, operationId, (Map)((Object)globalServerConfig));
        if (operationId != null) {
            DataTypeMap defaultOpBindingServerConfig = this.getOperationBinding(operationType, null, (Map)((Object)globalServerConfig));
            if (opBindingServerConfig != null && defaultOpBindingServerConfig != null) {
                opBindingServerConfig = (DataTypeMap)((Object)DataTools.deepClone((Object)opBindingServerConfig));
                opBindingServerConfig = (DataTypeMap)((Object)DataTools.deepMerge((Object)defaultOpBindingServerConfig, (Object)opBindingServerConfig, false));
            }
        }
        if (opBindingServerConfig != null) {
            if (globalServerConfig != null) {
                opBindingServerConfig = (DataTypeMap)((Object)DataTools.deepMerge((Object)opBindingServerConfig, DataTools.deepClone((Object)globalServerConfig), true));
            }
            if (opBindingServerConfig.containsKey("serverConfig")) {
                DataTools.deepMerge(opBindingServerConfig.get("serverConfig"), (Object)opBindingServerConfig, true);
            }
            opBindingServerConfig = (DataTypeMap)((Object)this.applyValueSetToTemplate(dsRequest, 0, (Object)opBindingServerConfig));
            dsRequest.setAttribute("_serverConfig", (Object)opBindingServerConfig);
            return opBindingServerConfig;
        }
        if (globalServerConfig != null) {
            globalServerConfig = (DataTypeMap)((Object)this.applyValueSetToTemplate(dsRequest, 0, (Object)globalServerConfig));
        }
        dsRequest.setAttribute("_serverConfig", (Object)globalServerConfig);
        return globalServerConfig;
    }

    public Object applyValueSetToTemplate(DSRequest dsRequest, int valueSetIndex, Object template) throws Exception {
        return this.applyValueSetToTemplate(dsRequest, valueSetIndex, template, null);
    }

    public Object applyValueSetToTemplate(DSRequest dsRequest, int valueSetIndex, Object template, String key) throws Exception {
        String opType = dsRequest.getOperationType();
        String opId = dsRequest.getOperationId();
        Map<Object, Object> contextMap = Velocity.getStandardContextMap(dsRequest, valueSetIndex);
        if (this.shouldSerializeAsJSON(key, template)) {
            contextMap.put(serializeAsJSONAttr, true);
        }
        return this.deepCloneWithVelocityEval(template, "serverConfig operationType=" + opType + ", operationId=" + opId, contextMap);
    }

    public String getConfigName() {
        return "";
    }

    public List getOperationBindings() {
        return DataSource.getOperationBindings(this.dsConfig);
    }

    public static List getOperationBindings(Map dsConfig) {
        return (List)dsConfig.get("operationBindings");
    }

    public String getAutoOperationId(String operationType) {
        return this.getName() + "_" + operationType;
    }

    public DataTypeMap getOperationBinding(DSRequest req) {
        if (req == null) {
            return null;
        }
        return this.getOperationBinding(req.getOperationType(), req.getOperationId());
    }

    public DataTypeMap getOperationBinding(String operationType) {
        return this.getOperationBinding(operationType, this.getAutoOperationId(operationType));
    }

    public DataTypeMap getOperationBinding(String operationType, String operationId) {
        return this.getOperationBinding(operationType, operationId, null);
    }

    public DataTypeMap getOperationBinding(String operationType, String operationId, Map config) {
        List operationBindings;
        List list = operationBindings = config == null ? this.getOperationBindings() : DataSource.getOperationBindings(config);
        if (operationBindings == null || operationType == null) {
            return null;
        }
        boolean operationIdIsAuto = operationId != null && operationId.equals(this.getAutoOperationId(operationType));
        DataTypeMap autoOperationBinding = null;
        Iterator i = operationBindings.iterator();
        while (i.hasNext()) {
            DataTypeMap operationBinding = new DataTypeMap((Map)i.next());
            String bindingOperationType = operationBinding.getString("operationType");
            if (bindingOperationType == null) {
                log.error("Skipping invalid operation binding on datasource '" + this.getID() + "' - (missing operationType): " + DataTools.prettyPrint(operationBinding));
                continue;
            }
            if (!operationType.equals(bindingOperationType)) continue;
            String bindingOperationId = (String)operationBinding.get("operationId");
            if (operationId != null && operationId.equals(bindingOperationId)) {
                return operationBinding;
            }
            if (bindingOperationId != null) continue;
            autoOperationBinding = operationBinding;
        }
        if (autoOperationBinding != null) {
            return autoOperationBinding;
        }
        return null;
    }

    private boolean transformRequestScriptExists(DSRequest dsRequest) {
        DataTypeMap op = this.getOperationBinding(dsRequest);
        return this.dsConfig.get("transformRequestScript") != null || op != null && op.get("transformRequestScript") != null;
    }

    private boolean transformResponseScriptExists(DSRequest dsRequest) {
        DataTypeMap op = this.getOperationBinding(dsRequest);
        return this.dsConfig.get("transformResponseScript") != null || op != null && op.get("transformResponseScript") != null;
    }

    public Object getTransformRequestScript(DSRequest dsRequest, boolean getOpBindingScript) throws Exception {
        if (getOpBindingScript) {
            DataTypeMap opBinding = this.getOperationBinding(dsRequest);
            if (opBinding != null && opBinding.containsKey("transformRequestScript")) {
                return opBinding.get("transformRequestScript");
            }
            return null;
        }
        return this.dsConfig.get("transformRequestScript");
    }

    public Object getTransformResponseScript(DSRequest dsRequest, boolean getOpBindingScript) throws Exception {
        if (getOpBindingScript) {
            DataTypeMap opBinding = this.getOperationBinding(dsRequest);
            if (opBinding != null && opBinding.containsKey("transformResponseScript")) {
                return opBinding.get("transformResponseScript");
            }
            return null;
        }
        return this.dsConfig.get("transformResponseScript");
    }

    public boolean dropExtraFieldsDefined() {
        return this.dsConfig.get("dropExtraFields") != null;
    }

    public boolean dropExtraFields() {
        Boolean dropExtraFields = (Boolean)this.dsConfig.get("dropExtraFields");
        return dropExtraFields == null || dropExtraFields != false;
    }

    public String getTestFileName() throws Exception {
        String testFileName = (String)this.dsConfig.get("dbImportFileName");
        if (testFileName == null) {
            testFileName = (String)this.dsConfig.get("testFileName");
        }
        return this.canonicalizeTestFileName(testFileName);
    }

    public boolean shouldAllowFieldFileRefs() {
        return this.dsConfig.getBoolean((Object)"allowFieldFileRefs", false);
    }

    protected String canonicalizeTestFileName(String testFileName) throws Exception {
        Object testFilePath;
        boolean relativeOK = this.dsConfig.getBoolean((Object)"relativeTestPaths", false);
        String baseDSName = this.getBaseName();
        String cacheTypeName = this.getCacheTypeName();
        if (testFileName == null) {
            testFileName = baseDSName + ".data";
        }
        if (((String)(testFilePath = testFileName)).indexOf("/") == -1 || relativeOK && !((String)testFilePath).startsWith("/")) {
            String sourceDataSourceID = this.getSourceDataSourceID();
            if (sourceDataSourceID != null) {
                DataSource sourceDataSource = DataSourceManager.getDataSource(sourceDataSourceID, null);
                if (sourceDataSource != null) {
                    DataSource testDataFileSource;
                    Object testDataFileSourceName = sourceDataSource.getConfig().getString("testDataFileSource");
                    if (testDataFileSourceName == null) {
                        testDataFileSourceName = sourceDataSourceID + "_testData";
                    }
                    if ((testDataFileSource = DataSourceManager.getDataSource((String)testDataFileSourceName, null)) != null) {
                        testFilePath = "ds://" + (String)testDataFileSourceName + "/" + (String)testFileName;
                        if ((testFilePath = this.tryExtension((String)testFilePath, ".xml")) != null) {
                            return testFilePath;
                        }
                    }
                    testFilePath = "ds://" + sourceDataSourceID + "/test_data/" + (String)testFileName + ".xml";
                    if ((testFilePath = this.tryExtension((String)testFilePath, ".xml")) != null) {
                        return testFilePath;
                    }
                }
                return null;
            }
            testFilePath = DataStructCache.getInstanceDir(baseDSName, cacheTypeName, "ds") + "/test_data/" + (String)testFileName;
        } else {
            testFilePath = String.valueOf(Config.getGlobal().get("webRoot")) + (String)testFileName;
        }
        String finalPath = this.tryExtension((String)testFilePath, ".xml");
        if (finalPath == null) {
            finalPath = this.tryExtension((String)testFilePath, ".csv");
        }
        if (finalPath == null) {
            finalPath = this.tryExtension((String)testFilePath, ".js");
        }
        if (finalPath == null) {
            log.info("No test data file for datasource '" + this.getName() + "'.  Tried " + (String)testFilePath + " with extensions .xml, .csv and .js");
        }
        return finalPath;
    }

    private String tryExtension(String baseName, String extension) throws Exception {
        String fullName = baseName.endsWith(extension) ? baseName : baseName + extension;
        log.debug("Look for test file at path " + fullName);
        ISCFile iscFile = ISCFile.newInstance(fullName);
        if (iscFile.exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public static boolean simpleTypeInheritsFromBuiltInType(String typeId, String parentTypeId) {
        if (typeId == null) {
            return false;
        }
        if (parentTypeId.equals(typeId)) {
            return true;
        }
        Map typeDef = DataSource.getBuiltinType(typeId);
        while (typeDef != null) {
            typeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId.equals(typeId)) {
                return true;
            }
            typeDef = DataSource.getBuiltinType(typeId);
        }
        return false;
    }

    protected Map getSimpleTypeDef(String typeId) {
        Map typeDef = DataSource.getBuiltinType(typeId);
        if (typeDef != null) {
            return typeDef;
        }
        typeDef = this.getLocalType(typeId);
        if (typeDef != null && typeDef.get("fields") == null) {
            return typeDef;
        }
        return null;
    }

    public String getSimpleBaseType(String typeId) {
        Map typeDef = this.getSimpleTypeDef(typeId);
        while (typeDef != null) {
            String parentTypeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId == null) {
                return typeId;
            }
            Map parentTypeDef = this.getSimpleTypeDef(parentTypeId);
            if (parentTypeDef == null) {
                log.warn("type: " + typeId + " declares inheritsFrom: " + parentTypeId + " but parentTypeId could not be found");
                return typeId;
            }
            typeId = parentTypeId;
            typeDef = parentTypeDef;
        }
        return null;
    }

    public boolean simpleTypeInheritsFrom(String typeId, String parentTypeId) throws Exception {
        if (typeId == null) {
            return false;
        }
        if (parentTypeId.equals(typeId)) {
            return true;
        }
        ++count;
        long start = System.nanoTime();
        Map typeDef = this.getSimpleTypeDef(typeId);
        nanosecs += System.nanoTime() - start;
        while (typeDef != null) {
            typeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId.equals(typeId)) {
                return true;
            }
            typeDef = this.getSimpleTypeDef(typeId);
        }
        ++failCount;
        return false;
    }

    protected Map getLocalType(String typeID) {
        return this.getLocalType(typeID, null);
    }

    protected Map getLocalType(String typeID, ValidationContext context) {
        if (typeID == null) {
            return null;
        }
        Map types = (Map)this.dsConfig.get("types");
        if (types != null && types.get(typeID) != null) {
            return (Map)types.get(typeID);
        }
        DataSource superDataSource = this.getSuper(context);
        if (superDataSource != null) {
            return superDataSource.getLocalType(typeID, context);
        }
        return null;
    }

    public List<String> getFieldNames() {
        return this.getFieldNames(true);
    }

    public List<String> getFieldNames(boolean dropIgnored) {
        if (!dropIgnored) {
            return this.fieldList;
        }
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>(this.fieldList);
            Iterator<String> i = this.fieldNames.iterator();
            while (i.hasNext()) {
                DSField field = this.getField(i.next());
                if (!field.ignore()) continue;
                i.remove();
            }
        }
        return this.fieldNames;
    }

    public List<String> getDirectFields() {
        if (this.directFields == null) {
            this.directFields = new ArrayList<String>(this.fieldList);
            Iterator<String> i = this.directFields.iterator();
            while (i.hasNext()) {
                DSField field = this.getField(i.next());
                if (!field.ignore() && field.getIncludeFrom() == null && field.getProperty("includeSummaryFunction") == null && field.getProperty("customSQL") == null && field.getProperty("customSelectExpression") == null) continue;
                i.remove();
            }
        }
        return this.directFields;
    }

    public List<String> getNonIncludedFields() {
        if (this.nonIncludedFields == null) {
            this.nonIncludedFields = new ArrayList<String>(this.fieldList);
            Iterator<String> i = this.nonIncludedFields.iterator();
            while (i.hasNext()) {
                DSField field = this.getField(i.next());
                if (!field.ignore() && field.getIncludeFrom() == null) continue;
                i.remove();
            }
        }
        return this.nonIncludedFields;
    }

    public List<DSField> getFields() {
        return this.getFields(true);
    }

    public List<DSField> getFields(boolean dropIgnored) {
        List<String> fieldNames = this.getFieldNames(dropIgnored);
        if (fieldNames == null) {
            return null;
        }
        ArrayList<DSField> fields = new ArrayList<DSField>();
        for (String fieldName : fieldNames) {
            fields.add(this.getField(fieldName));
        }
        return fields;
    }

    protected void trimCriteria(DSRequest request) {
        String opType = request.getOperationType();
        if ((DataSource.isRemove(opType) || DataSource.isUpdate(opType) || "replace".equals(opType)) && !request.isCriteriaTrimmed()) {
            if (!request.getAllowMultiUpdate()) {
                Map criteria = request.getCriteria();
                List<String> pkList = this.getPrimaryKeys();
                if (request.getIsAdvancedCriteria()) {
                    if ((criteria = this._trimCriteria(criteria, pkList)) != null) {
                        criteria.put("_constructor", "AdvancedCriteria");
                    }
                    request.setCriteria(criteria);
                } else {
                    HashMap newCriteria = new HashMap();
                    for (String fieldName : criteria.keySet()) {
                        if (!pkList.contains(fieldName)) continue;
                        newCriteria.put(fieldName, criteria.get(fieldName));
                    }
                    request.setCriteria(newCriteria);
                }
            } else {
                Map criteria = request.getCriteria();
                Iterator i = criteria.keySet().iterator();
                while (i.hasNext()) {
                    String fieldName = (String)i.next();
                    DSField field = this.getField(fieldName);
                    if (field == null || field.get("includeFrom") == null) continue;
                    i.remove();
                }
            }
            request.setCriteriaTrimmed(true);
        }
    }

    private Map _trimCriteria(Map criteria, List pkList) {
        if (criteria == null) {
            return null;
        }
        if (pkList == null) {
            return criteria;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList newCrit = new ArrayList();
            for (Object c : (List)criteria.get("criteria")) {
                if ((c = this._trimCriteria((Map)c, pkList)) == null) continue;
                newCrit.add(c);
            }
            criteria.put("criteria", newCrit);
            return criteria;
        }
        if (criteria.containsKey("fieldName")) {
            String fieldName = (String)criteria.get("fieldName");
            return pkList.contains(fieldName) ? criteria : null;
        }
        return null;
    }

    public List<String> getPrimaryKeys() {
        return new ArrayList<String>();
    }

    public String getPrimaryKey() {
        List<String> pks = this.getPrimaryKeys();
        if (pks == null || pks.size() == 0 || pks.get(0) == null) {
            return null;
        }
        return pks.get(0).toString();
    }

    public DataTypeMap<String, Object> getConfig() {
        return this.dsConfig;
    }

    public int getVersion() {
        return Integer.valueOf(this.dsConfig.get("dataSourceVersion").toString());
    }

    public String getSourceDataSourceID() {
        return this.dsConfig.getString("sourceDataSourceID");
    }

    public static String getType(Map<String, Object> dsConfig) {
        Object type = dsConfig.get("serverType");
        if (type == null) {
            type = dsConfig.get("type");
        }
        if (type == null) {
            type = dsConfig.get("dataSourceType");
        }
        if (type == null && dsConfig.get("constructor") != null && !"DataSource".equals(dsConfig.get("constructor"))) {
            type = dsConfig.get("constructor");
        }
        if (type == null && dsConfig.get("__autoConstruct") != null && "MockDataSource".equals(dsConfig.get("__autoConstruct"))) {
            type = "mock";
        }
        if (type == null && dsConfig.get("serviceNamespace") != null) {
            type = "webService";
        }
        if (type == null) {
            type = dsConfig.get("dataFormat");
        }
        if (type == null && dsConfig.get("recordXPath") != null) {
            type = "xml";
        }
        return (String)type;
    }

    public String getType() {
        String type = DataSource.getType(this.dsConfig);
        if (type == null) {
            type = "generic";
        }
        return type;
    }

    public boolean getUseStrictJSON() {
        Object useStrictJSON = this.dsConfig.get("useStrictJSON");
        return useStrictJSON == null ? false : (Boolean)useStrictJSON;
    }

    public boolean inheritsFrom(String dsName) {
        return false;
    }

    public Map getRawFields() {
        return (Map)this.dsConfig.get("fields");
    }

    public void _cloneConfigForSecurityAnnotations() throws Exception {
        this.dsConfigAnnotated = new DataTypeMap();
        for (String key : this.originalConfig.keySet()) {
            Object value = this.originalConfig.get(key);
            if (value instanceof Map) {
                work = (Map)value.getClass().newInstance();
                work.putAll((Map)value);
                value = work;
            } else if (value instanceof List) {
                work = (List)value.getClass().newInstance();
                work.addAll((List)value);
                value = work;
            }
            this.dsConfigAnnotated.put(key, value);
        }
    }

    public Map<String, Object> getAnnotatedConfig() {
        return this.dsConfigAnnotated;
    }

    public void clearAnnotatedConfig() {
        this.dsConfigAnnotated = null;
    }

    public DSField getField(String fieldName) {
        return null;
    }

    public String getFieldTitle(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getTitle();
    }

    public Map getValueMaps() {
        return this.getValueMaps(this.getFieldNames());
    }

    public Map getValueMaps(List fieldNames) {
        HashMap valueMaps = new HashMap();
        if (fieldNames == null || fieldNames.size() == 0) {
            return valueMaps;
        }
        for (String fieldName : fieldNames) {
            Object valueMap;
            DSField field = this.getField(fieldName);
            if (field == null || (valueMap = field.get("valueMap")) == null || !(valueMap instanceof Map)) continue;
            valueMaps.put(fieldName, valueMap);
        }
        return valueMaps;
    }

    public String getRecordXPath() {
        return (String)this.dsConfig.get("recordXPath");
    }

    public boolean isAdvancedCriteria(Map criteria) {
        return AdvancedCriteria.isAdvancedCriteria(criteria, this);
    }

    public Map normalizeAdvancedCriteria(Map criteria) throws Exception {
        return this.normalizeAdvancedCriteria(criteria, false);
    }

    public Map normalizeAdvancedCriteria(Map criteria, boolean force) throws Exception {
        return this.normalizeAdvancedCriteria(criteria, force, false);
    }

    public Map normalizeAdvancedCriteria(Map criteria, boolean force, boolean subLevel) throws Exception {
        if (criteria == null || Boolean.TRUE.equals(criteria.get("__normalized")) && !force || !subLevel && !this.isAdvancedCriteria(criteria)) {
            return criteria;
        }
        String[] canNormalizeArray = new String[]{"equals", "iEquals", "notEqual", "iNotEqual", "startsWith", "iStartsWith", "notStartsWith", "iNotStartsWith", "endsWith", "iEndsWith", "notEndsWith", "iNotEndsWith", "contains", "iContains", "notContains", "iNotContains", "equalsField", "notEqualField", "containsField", "startsWithField", "endsWithField"};
        List<String> canNormalize = Arrays.asList(canNormalizeArray);
        String[] negatedArray = new String[]{"notEqual", "iNotEqual", "notStartsWith", "iNotStartsWith", "notEndsWith", "iNotEndsWith", "notContains", "iNotContains", "notEqualField"};
        List<String> negated = Arrays.asList(negatedArray);
        HashMap<String, Object> norm = new HashMap<String, Object>();
        norm.put("__normalized", true);
        if (!subLevel) {
            norm.put("_constructor", "AdvancedCriteria");
            if (criteria.get("strictSQLFiltering") != null) {
                norm.put("strictSQLFiltering", criteria.get("strictSQLFiltering"));
            }
        }
        if (criteria.containsKey("criteria")) {
            String operator = (String)criteria.get("operator");
            norm.put("operator", operator == null ? "and" : operator);
            ArrayList<Map> normSubCrit = new ArrayList<Map>();
            for (Object subObj : DataTools.makeListIfSingle(criteria.get("criteria"))) {
                if (!(subObj instanceof Map)) {
                    throw new Exception("Invalid AdvancedCriteria structure - expected a Map");
                }
                normSubCrit.add(this.normalizeAdvancedCriteria((Map)subObj, true, true));
            }
            norm.put("criteria", normSubCrit);
        } else {
            String operator = (String)criteria.get("operator");
            if (operator == null) {
                operator = "equals";
                criteria.put("operator", operator);
                if (criteria.get("value") == null) {
                    criteria.put("value", true);
                }
            }
            if (canNormalize.contains(operator)) {
                if (criteria.get("value") instanceof List) {
                    DSField field;
                    boolean resolved = false;
                    if ((operator.equals("equals") || operator.equals("iEquals")) && (field = this.getField((String)criteria.get("fieldName"))) != null) {
                        String baseType = this.getSimpleBaseType(field.getType());
                        boolean isValidType = "text".equals(baseType) || "integer".equals(baseType) || "float".equals(baseType);
                        Boolean useOr = this.getConfig().getBoolean("simplifyCriteriaListsToOrClause");
                        if (useOr == null) {
                            useOr = Config.getGlobal().getBoolean((Object)"sql.simplifyCriteriaListsToOrClause", false);
                        }
                        if (isValidType && !useOr.booleanValue()) {
                            norm.put("operator", "inSet");
                            norm.put("fieldName", criteria.get("fieldName"));
                            norm.put("value", criteria.get("value"));
                            resolved = true;
                        }
                    }
                    if (!resolved) {
                        Iterator i = ((List)criteria.get("value")).iterator();
                        if (i.hasNext()) {
                            ArrayList normSubCrit = new ArrayList();
                            norm.put("operator", negated.contains(operator) ? "and" : "or");
                            while (i.hasNext()) {
                                HashMap<String, Object> normSubCriterion = new HashMap<String, Object>();
                                normSubCriterion.put("fieldName", criteria.get("fieldName"));
                                normSubCriterion.put("operator", operator);
                                normSubCriterion.put("value", i.next());
                                normSubCrit.add(normSubCriterion);
                            }
                            norm.put("criteria", normSubCrit);
                        } else {
                            norm.put("operator", operator);
                            norm.put("fieldName", criteria.get("fieldName"));
                            norm.put("value", null);
                        }
                    }
                } else {
                    norm.putAll(criteria);
                }
            } else {
                norm.putAll(criteria);
            }
        }
        return norm;
    }

    public boolean allowAdvancedCriteria() {
        Object obj = this.dsConfig.get("allowAdvancedCriteria");
        return DataTools.asBoolean(obj, this.getDefaultAllowAdvancedCriteria());
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    public boolean allowAggregation() {
        Object obj = this.dsConfig.get("allowAggregation");
        return DataTools.asBoolean(obj, this.getDefaultAllowAggregation());
    }

    protected boolean getDefaultAllowAggregation() {
        return true;
    }

    public List extractFieldNamesFromAdvancedCriteria(Map advancedCriteria) {
        return this.extractFieldNamesFromAdvancedCriteria(advancedCriteria, false);
    }

    public List extractFieldNamesFromAdvancedCriteria(Map advancedCriteria, boolean includeOtherFields) {
        ArrayList fieldNames = new ArrayList();
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        return this.extractFieldNamesRecursively(criteria, fieldNames, includeOtherFields);
    }

    public List extractFieldNamesRecursively(List criteria, List fieldNames, boolean includeOtherFields) {
        for (Map criterion : criteria) {
            String operator;
            if (criterion.containsKey("criteria")) {
                this.extractFieldNamesRecursively((List)criterion.get("criteria"), fieldNames, includeOtherFields);
                continue;
            }
            if (!criterion.containsKey("fieldName")) continue;
            String fieldName = (String)criterion.get("fieldName");
            if (!fieldNames.contains(fieldName)) {
                fieldNames.add(fieldName);
            }
            if (!includeOtherFields || !AdvancedCriteria.isFieldComparisonOperator(operator = (String)criterion.get("operator")).booleanValue() || (fieldName = (String)criterion.get("value")) == null || fieldNames.contains(fieldName)) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    public Map extractValuesFromAdvancedCriteria(Map advancedCriteria) {
        HashMap values = new HashMap();
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        return this.extractValuesRecursively(criteria, values);
    }

    public Map extractValuesRecursively(List criteria, Map values) {
        for (Map criterion : criteria) {
            if (criterion.containsKey("criteria")) {
                this.extractValuesRecursively((List)criterion.get("criteria"), values);
                continue;
            }
            if (!criterion.containsKey("fieldName")) continue;
            String fieldName = (String)criterion.get("fieldName");
            Object value = criterion.get("value");
            if (values.containsKey(fieldName)) continue;
            values.put(fieldName, value);
        }
        return values;
    }

    public static DataSource getElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        String constructor = element.getAttribute("constructor");
        BasicDataSource ds = context.getType(constructor);
        if (ds != null) {
            return ds;
        }
        ds = context.getType(tagName);
        return ds;
    }

    public static Object recordsFromXML(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = DataSource.recordsFromXML(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public static Object recordsFromXML(Object data, ValidationContext context) throws Exception {
        String loadID;
        if (data instanceof List) {
            return DataSource.recordsFromXML((List)data, context);
        }
        if (!(data instanceof Element)) {
            return data;
        }
        Element element = (Element)data;
        DataSource ds = DataSource.getElementType(element, context);
        if (ds == null) {
            if ("true".equals(element.getAttribute("xsi:nil"))) {
                return null;
            }
            if (element.hasAttributes() || !XML.getElementChildren(element).isEmpty()) {
                ds = context.getType("Object");
            } else {
                return XML.toSimpleValue(element);
            }
        }
        Object result = ds.toRecords(element, context);
        if (("DataSource".equals(ds.getName()) || "DataSources".equals(ds.getName())) && (loadID = (String)((Map)result).get("loadID")) != null) {
            Boolean loadParents = (Boolean)((Map)result).get("loadParents");
            if (loadParents == null) {
                loadParents = false;
            }
            if (!loadParents.booleanValue()) {
                loadParents = "DataSources".equals(ds.getName());
            }
            result = DataSource._recordsFromLoadID(loadID, result, loadParents, context);
        }
        if (context.hasErrors()) {
            Logger.validation.warning("Validation errors validating a '" + ds.getName() + "':\n" + DataTools.prettyPrint(context.getErrors()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object _recordsFromLoadID(String loadID, Object result, Boolean loadParents, ValidationContext context) throws Exception {
        String[] ids = loadID.split(",");
        ArrayList<Object> dsList = new ArrayList<Object>();
        Set<String> excludedDS = context.getExcludedDS();
        String projectName = context.getRetrieverProject();
        HashMap<String, DataSource> processed = new HashMap<String, DataSource>();
        DSRequest contextReq = context.getDSRequest();
        boolean freeContextReq = false;
        if (contextReq == null) {
            contextReq = new DSRequest();
            freeContextReq = true;
        }
        if (context.excludeAllDS()) {
            return dsList;
        }
        try {
            for (String id : ids) {
                DataSource refDS = context.typeCache.get(id);
                if (refDS != null) {
                    context.addToTypeCache(id, (BasicDataSource)refDS);
                    if (contextReq != null) {
                        contextReq.cacheDataSourceInstance(id, refDS);
                    }
                } else if (contextReq != null) {
                    refDS = contextReq.getCachedDataSourceInstance(id);
                    context.addToTypeCache(id, (BasicDataSource)refDS);
                }
                if (refDS == null) {
                    refDS = DataSourceManager.get(id, contextReq);
                    contextReq.cacheDataSourceInstance(id, refDS);
                    context.addToTypeCache(id, (BasicDataSource)refDS);
                }
                if (refDS == null) {
                    if (!Boolean.TRUE.equals(context.get("missingDSIsNotFatal"))) throw new Exception("Unable to load DataSource referenced by loadID: " + id);
                    DataTypeMap<String, Object> stub = new DataTypeMap<String, Object>();
                    stub.put("ID", id);
                    stub.put("unableToLoad", true);
                    stub.put("__autoConstruct", "DataSource");
                    dsList.add(stub);
                } else {
                    processed.put(id, refDS);
                    dsList.add(refDS.getClientSafeConfig());
                }
                if (!loadParents.booleanValue()) continue;
                String inheritsFrom = (String)((Map)result).get("inheritsFrom");
                while (inheritsFrom != null) {
                    DataSource parentDS = null;
                    if (!processed.containsKey(inheritsFrom)) {
                        parentDS = contextReq.getCachedDataSourceInstance(inheritsFrom);
                        if (parentDS == null) {
                            parentDS = DataSourceManager.getDataSource(inheritsFrom, contextReq);
                            contextReq.cacheDataSourceInstance(inheritsFrom, parentDS);
                        }
                        if (parentDS == null) {
                            throw new Exception("Unable to load DataSource for ID '" + DataTools.escapeHTML(inheritsFrom) + "' when loading parent DataSources for DataSource '" + DataTools.escapeHTML(id) + "'");
                        }
                        processed.put(inheritsFrom, parentDS);
                        dsList.add(parentDS.getClientSafeConfig());
                    } else {
                        parentDS = (DataSource)processed.get(inheritsFrom);
                    }
                    inheritsFrom = parentDS.getConfig().getString("inheritsFrom");
                }
            }
            if (excludedDS != null) {
                CollectionUtils.filter(dsList, dsConfig -> !excludedDS.contains(dsConfig.get("ID")));
            }
            if (projectName != null && dsList.size() > 0) {
                context.addProjectDataSources(processed);
                ArrayList arrayList = new ArrayList();
                dsList.forEach(dsConfig -> arrayList.add(dsConfig.get("ID")));
                DataTypeMap dataTypeMap = DataTools.buildMap("__autoConstruct", "DataSourceRetriever", "projectName", projectName, "dataSources", arrayList);
                return dataTypeMap;
            }
            ArrayList<Object> arrayList = dsList.size() == 1 ? dsList.get(0) : dsList;
            return arrayList;
        }
        finally {
            if (projectName != null && freeContextReq) {
                Iterator dsIter = processed.keySet().iterator();
                while (dsIter.hasNext()) {
                    DataSourceManager.free((DataSource)processed.get(dsIter.next()));
                }
            }
            if (freeContextReq) {
                contextReq.setRequestStarted(true);
                contextReq.freeAllResources();
            }
        }
    }

    public static Object recordsFromXML(List elements) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = DataSource.recordsFromXML(elements, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public static Object recordsFromXML(List elements, ValidationContext context) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator e = elements.iterator();
        while (e.hasNext()) {
            values.add(DataSource.recordsFromXML(e.next(), context));
        }
        return values;
    }

    @Override
    public Object create(Object data, ValidationContext context) throws Exception {
        return this.toRecords(data, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toRecords(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = this.toRecords(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public Object toRecords(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toRecord(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = this.toRecord(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    public void ds2Schema(DataSource ds, Writer out) throws Exception {
        out.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        out.write("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n");
        out.write("<xs:element name='" + ds.getName() + "'>");
        out.write("<xs:complexType>");
        out.write("<xs:any processContents='lax'>");
        List<String> fields = ds.getFieldNames();
        for (String fieldName : fields) {
            String xmlType = ds.getField(fieldName).getType();
            out.write("<xs:attribute name='" + fieldName + "' type='" + xmlType + "'>");
        }
        out.write("<xs:anyAttribute processContents='lax'>");
        out.write("</xs:complexType>");
        out.write("</xs:element>");
        out.write("</xs:schema>");
    }

    public static boolean isModificationOperation(String operationType) {
        return DataSource.isAdd(operationType) || DataSource.isRemove(operationType) || DataSource.isUpdate(operationType) || "replace".equals(operationType);
    }

    public boolean isModificationOperation(String opType, String opId) {
        if (DataSource.isModificationOperation(opType)) {
            return true;
        }
        DataTypeMap opBinding = this.getOperationBinding(opType, opId);
        return opBinding != null && OP_UPDATE.equals(opBinding.get("sqlType"));
    }

    public boolean isModificationRequest(DSRequest req) {
        return this.isModificationOperation(req.getOperationType(), req.getOperationId());
    }

    public static boolean isFetch(String opType) {
        return OP_FETCH.equals(opType) || "select".equals(opType) || "filter".equals(opType);
    }

    public static boolean isAdd(String opType) {
        return OP_ADD.equals(opType) || "insert".equals(opType);
    }

    public static boolean isRemove(String opType) {
        return OP_REMOVE.equals(opType) || "delete".equals(opType);
    }

    public static boolean isUpdate(String opType) {
        return OP_UPDATE.equals(opType);
    }

    public static boolean isDownload(String opType) {
        return OP_DOWNLOAD_FILE.equals(opType) || OP_VIEW_FILE.equals(opType);
    }

    public static boolean isCustom(String opType) {
        return OP_CUSTOM.equals(opType);
    }

    public static boolean isCrud(String opType) {
        return DataSource.isAdd(opType) || DataSource.isFetch(opType) || DataSource.isUpdate(opType) || DataSource.isRemove(opType);
    }

    public static boolean isAddOrUpdate(String opType) {
        return DataSource.isAdd(opType) || DataSource.isUpdate(opType);
    }

    public static boolean isValidate(String opType) {
        return OP_VALIDATE.equals(opType);
    }

    public static boolean isFileSource(String opType) {
        return OP_FILE_SOURCE.contains(opType);
    }

    public static boolean isFileSourceSubrequest(String opType, String opID) {
        if (DataSource.isFetch(opType)) {
            return OP_GET_FILE.equals(opID) || OP_HAS_FILE.equals(opID) || OP_LIST_FILES.equals(opID) || OP_LIST_FILE_VERSIONS.equals(opID) || OP_GET_FILE_VERSION.equals(opID) || OP_HAS_FILE_VERSION.equals(opID) || OP_UNIQUE_NAME.equals(opID);
        }
        if (DataSource.isAddOrUpdate(opType)) {
            return OP_SAVE_FILE.equals(opID) || OP_RENAME_FILE.equals(opID);
        }
        if (DataSource.isRemove(opType)) {
            return OP_REMOVE_FILE.equals(opID) || OP_RENAME_FILE.equals(opID) || OP_REMOVE_FILE_VERSION.equals(opID);
        }
        return false;
    }

    public void transformMultipleFields(DSRequest req) {
    }

    public void transformMultipleFields(DSResponse res, DSRequest req) {
    }

    public void transformMultipleFields(DSResponse res) {
        this.transformMultipleFields(res, null);
    }

    public DSResponse execute(DSRequest req) throws Exception {
        DSResponse validationFailure;
        req.registerFreeResourcesHandler(this);
        String operationType = req.getOperationType();
        if (!DataSource.isCustom(operationType) && (validationFailure = this.validateDSRequest(req)) != null) {
            return validationFailure;
        }
        req.setRequestStarted(true);
        req.recordTimingData(TIMING_TRANSFORM_MULTIPLE_FIELDS, DSRequest.TimingLogType.START);
        this.transformMultipleFields(req);
        req.recordTimingData(TIMING_TRANSFORM_MULTIPLE_FIELDS, DSRequest.TimingLogType.END);
        DSResponse res = null;
        if (DataSource.isFetch(operationType)) {
            DataSource ds = req.getDataSource();
            try {
                res = this.executeFetch(req);
                String string = res.getDataSource() != null ? res.getDataSource().getName() : "null";
            }
            catch (Exception ex) {
                BasicDataSource bds = (BasicDataSource)ds;
                if (BasicDataSource.auditGenerator != null) {
                    if (BasicDataSource.auditGenerator.hasMappingFor(this.getID())) {
                        if (bds.canQueryTable()) {
                            throw ex;
                        }
                        if (bds.isAutoCreateAuditTableActive()) {
                            log.debug("There was an issue fetching data - possibly missing storage. Trying to auto-generate the underlying audit storage for " + ds.getName());
                            ds.createStorage(false);
                            res = this.executeFetch(req);
                        }
                        log.warn("There was an error fetching data. Cannot create underlying audit storage as it is disabled for " + ds.getName() + " DataSource.");
                        throw ex;
                    }
                }
                throw ex;
            }
            if (res != null && !Boolean.TRUE.equals(req.getAttribute("_isConcatFetch"))) {
                this.transformMultipleFields(res, req);
            }
        } else if (DataSource.isAdd(operationType)) {
            res = this.executeAdd(req);
        } else if (DataSource.isRemove(operationType)) {
            req.setAttribute("_previousValues", this.getUpdateAuditLastValues(req));
            res = this.executeRemove(req);
        } else if (DataSource.isUpdate(operationType)) {
            req.setAttribute("_previousValues", this.getUpdateAuditLastValues(req));
            res = this.executeUpdate(req);
        } else if (operationType.equals("replace")) {
            res = this.executeReplace(req);
        } else if (operationType.equals(OP_LOAD_SCHEMA)) {
            res = this.executeLoadDS(req);
        } else if (DataSource.isDownload(operationType)) {
            res = this.executeDownload(req);
        } else if (operationType.equals(OP_VALIDATE)) {
            res = new DSResponse(this);
            res.setSuccess();
        } else {
            res = operationType.equals(OP_CLIENT_EXPORT) ? this.executeClientExport(req) : (DataSource.isFileSource(operationType) ? this.executeFileSource(req) : (operationType.equals(OP_STORE_TEST_DATA) ? this.executeStoreTestData(req) : (operationType.equals(OP_GET_TEST_DATA) ? this.executeGetTestData(req) : this.executeCustom(req))));
        }
        if (res != null) {
            res.setParameter("_cameThruDsExecute", true);
        }
        return res;
    }

    public void executePostUpdateDataSourceOperations(DSRequest req, DSResponse resp) throws Exception {
        Map lastValues = (Map)req.getAttribute("_previousValues");
        if (this.requestRequiresChildUpdates(req)) {
            this.performChildUpdates(req, resp);
            if (this.childUpdatesRequireRefetch(req)) {
                if (DataSource.isAdd(req.getOperationType())) {
                    Map dataRecord = resp.getDataMap();
                    List<String> keys = this.getPrimaryKeys();
                    for (int i = 0; i < keys.size(); ++i) {
                        String key = keys.get(i);
                        if (!dataRecord.containsKey(key)) continue;
                        req.getValues().put(key, dataRecord.get(key));
                    }
                }
                this.getCacheSyncStrategy("refetch").applyCacheSyncStrategy(req, resp);
            }
        }
        this.transformMultipleFields(resp, req);
        this.makeAuditIfRequired(req, resp, lastValues);
        this.dataChangedNotify(req, resp);
    }

    protected void performChildUpdates(DSRequest req, DSResponse res) throws Exception {
        log.debug("DataSource '" + this.getName() + "': Base DataSource implementation does not support performChildUpdates()");
    }

    protected boolean childUpdatesRequireRefetch(DSRequest req) {
        return false;
    }

    private DSResponse dataChangedNotify(DSRequest req, DSResponse res) {
        if (!res.statusIsSuccess()) {
            return null;
        }
        try {
            boolean dataChangedNotify = this.dsConfig.getBoolean((Object)"realtimeUpdates", false);
            String notifyDataSource = "DataSourceDataChanged";
            DataTypeMap<String, Object> serverConfig = this.getConfig();
            if (serverConfig != null) {
                notifyDataSource = serverConfig.getString("dataChangedDataSource", notifyDataSource);
                dataChangedNotify = serverConfig.getBoolean((Object)"dataChangedNotify", dataChangedNotify);
            }
            if (!dataChangedNotify) {
                return null;
            }
            Map data = DataTools.cascadeMaps(req.getValues(), res.getRecord(), new HashMap());
            DataTypeMap notifyRecord = DataTools.buildMap("dataSourceName", req.getDataSourceName(), "operationType", req.getOperationType(), "operationId", req.getOperationId(), "userId", req.getUserId(), "timestamp", req.getCurrentDate(), "threadIgnored", Logger.threadIgnored(), "data", DataTools.makeListIfSingle(data));
            return new DSRequest(notifyDataSource, OP_ADD).setValues((Object)notifyRecord).execute();
        }
        catch (Exception e) {
            log.error((Object)"Failed to send dataChanged notification", e);
            return null;
        }
    }

    private DSResponse makeAuditIfRequired(DSRequest req, DSResponse res) throws Exception {
        return this.makeAuditIfRequired(req, res, null);
    }

    public boolean shouldAuditRequest(DSRequest req) throws Exception {
        BasicDataSource ds = (BasicDataSource)req.getDataSource();
        if (!ds.getConfig().getBoolean((Object)"audit", false)) {
            return false;
        }
        if (req.isAuditSkipped()) {
            log.debug("Skipping auditing process. Auditing disabled in the request or operationBinding.");
            return false;
        }
        return true;
    }

    private DSResponse makeAuditIfRequired(DSRequest req, DSResponse res, Map lastValues) throws Exception {
        if (res == null || res.statusIsError()) {
            return null;
        }
        if (!this.shouldAuditRequest(req)) {
            return null;
        }
        BasicDataSource ds = (BasicDataSource)req.getDataSource();
        if (req.getValueSets() != null && req.getValueSets().size() > 1 && OP_ADD.equals(req.getOperationType())) {
            boolean allowAudit = config.getBoolean((Object)"sql.multi.insert.allowAudit", false);
            if (!allowAudit) {
                log.debug("Skipping auditing process because multiple valueSets were provided for an 'add' request, but the 'sql.multi.insert.allowAudit' flag was not set");
                return null;
            }
            Map sequences = this.getSequences();
            if (sequences != null && sequences.keySet().size() > 0) {
                log.debug("writeMultiAudits() called for dataSource '" + this.getID() + "', but the dataSource has at least one sequence field.  We cannot write multi-audit records for dataSources with sequence fields - bailing");
                return null;
            }
            ds.writeMultiAudits(res.getDataList(), req);
            return res;
        }
        if (res.getAffectedRows() > 1L) {
            log.debug("Skipping auditing process because multiple records were affected by request");
            return null;
        }
        DataSource auditDS = ds.getAuditDataSource(req);
        if (auditDS == null) {
            return null;
        }
        DSRequest audit = new DSRequest();
        Map values = new HashMap();
        if (OP_REMOVE.equals(req.getOperationType())) {
            if (lastValues != null) {
                values.putAll(lastValues);
            }
        } else if ("jpa".equals(ds.getType())) {
            log.warn("DataSource is JPA, using getProperties to retrieve values from the response");
            values = ds.getProperties(res.getData());
        } else if (res.getDataMap() != null) {
            if (lastValues != null) {
                values.putAll(lastValues);
            }
            values.putAll(req.getValues());
            values.putAll(res.getDataMap());
            for (Object val : values.keySet()) {
                if (!(values.get(val) instanceof ByteArrayInputStream)) continue;
                ((ByteArrayInputStream)values.get(val)).reset();
            }
        } else {
            log.warn("When saving the audit record, getDataMap() returned null for DataSource " + ds.getID());
        }
        values = ds.getAuditRecord(req, values, req.getOldValues());
        audit.setValues(values);
        audit.setOldValues(req.getOldValues());
        audit.setDataSource(auditDS);
        audit.setOperationType(OP_ADD);
        audit.setRPCManager(req.getRPCManager());
        if (config.getBoolean((Object)"audit.skipCacheSync", true)) {
            audit.setSkipCacheSync(true);
        }
        DSResponse resp = null;
        Exception auditWriteException = null;
        try {
            resp = audit.execute();
        }
        catch (Exception e) {
            auditWriteException = e;
        }
        if (resp == null || resp.statusIsError()) {
            if (!auditDS.canQueryTable() && ds.isAutoCreateAuditTableActive()) {
                log.debug("Audit table missing, attempting to rebuild");
                auditDS.createStorage(false);
                try {
                    resp = audit.execute();
                }
                catch (Exception e) {
                    String message = "Unable to write to audit DS: " + auditDS.getID();
                    if (auditWriteException == null) {
                        auditWriteException = new Exception(message);
                    }
                    log.error((Object)message, auditWriteException);
                    throw auditWriteException;
                }
            }
            if (resp == null || resp.statusIsError()) {
                String message = "Unable to write to audit DS: " + auditDS.getID();
                if (auditWriteException == null) {
                    auditWriteException = new Exception(message);
                }
                log.error((Object)message, auditWriteException);
                throw auditWriteException;
            }
        }
        return resp;
    }

    private Map getUpdateAuditLastValues(DSRequest req) throws Exception {
        if (!this.shouldAuditRequest(req)) {
            return null;
        }
        List<DSField> auditChangeBinaryFields = this.getAuditChangeBinaryFields(req);
        List<DSField> missingAuditAlwaysBinaryFields = this.getMissingAuditAlwaysBinaryFields(req);
        if (!this.dsConfig.getBoolean((Object)"secureChange", false) && auditChangeBinaryFields.size() == 0 && missingAuditAlwaysBinaryFields.size() == 0 && req.getOldValues() != null && !req.getOldValues().isEmpty()) {
            return req.getOldValues();
        }
        HashMap values = new HashMap(req.getValues());
        if (values == null) {
            log.error("null request values during secureChange update audit");
            return null;
        }
        values.putAll(req.getCriteria());
        Map<String, Object> record = null;
        try {
            record = this.fetchById(values, req.getRPCManager(), null, true);
        }
        catch (Exception e) {
            log.error((Object)"failed to retrieve current record for secureChange update audit", e);
            return null;
        }
        if (record == null) {
            log.error("No current record found for secureChange update audit");
        }
        return record;
    }

    private List<DSField> getAuditChangeBinaryFields(DSRequest req) throws Exception {
        ArrayList<DSField> fields = new ArrayList<DSField>();
        for (DSField field : this.getFields()) {
            if (!field.isBinary() || field.get("audit") != null && !"change".equals(field.get("audit"))) continue;
            fields.add(field);
        }
        return fields;
    }

    private List<DSField> getMissingAuditAlwaysBinaryFields(DSRequest req) throws Exception {
        ArrayList<DSField> fields = new ArrayList<DSField>();
        for (DSField field : this.getFields()) {
            if (!field.isBinary() || !"always".equals(field.get("audit")) || req.getValues().get(field.getName()) != null) continue;
            fields.add(field);
        }
        return fields;
    }

    protected List<String> getUpdateChangedFields(DSRequest req, Map lastValues) throws Exception {
        if (!DataSource.isUpdate(req.getOperationType())) {
            return null;
        }
        boolean useOldBehavior = config.getBoolean((Object)"audit.assume.all.updated.are.changed", false);
        Map updatedValues = req.getValues();
        if (updatedValues == null) {
            return null;
        }
        BasicDataSource ds = (BasicDataSource)req.getDataSource();
        List<String> keys = ds.getPrimaryKeys();
        ArrayList<String> updatedFields = new ArrayList<String>();
        for (String updatedFieldName : updatedValues.keySet()) {
            if (keys.contains(updatedFieldName) || this.getField(updatedFieldName) == null || !useOldBehavior && !this.valuesDiffer(updatedFieldName, updatedValues, lastValues)) continue;
            updatedFields.add(updatedFieldName);
        }
        return updatedFields;
    }

    protected boolean valuesDiffer(String fieldName, Map values, Map lastValues) {
        Object oldValue;
        if (this.getField(fieldName) != null && this.getField(fieldName).isBinary()) {
            if (this.dsConfig.getBoolean((Object)"compareMetadataForAuditChangeStatus", true)) {
                return this.binaryMetadataIsDifferent(fieldName, values, lastValues);
            }
            return this.binaryContentIsDifferent(fieldName, values, lastValues);
        }
        Object newValue = values != null ? (Object)values.get(fieldName) : null;
        Object object = oldValue = lastValues != null ? (Object)lastValues.get(fieldName) : null;
        if (newValue == null && oldValue == null) {
            return false;
        }
        if (newValue == null || oldValue == null) {
            return true;
        }
        if (newValue.equals(oldValue)) {
            return false;
        }
        if (newValue.getClass().equals(oldValue.getClass())) {
            return true;
        }
        if (newValue instanceof Number && oldValue instanceof Number) {
            return ((Number)newValue).doubleValue() != ((Number)oldValue).doubleValue();
        }
        return true;
    }

    protected boolean binaryMetadataIsDifferent(String fieldName, Map newValues, Map oldValues) {
        String newName = (String)newValues.get(fieldName + "_filename");
        String oldName = (String)oldValues.get(fieldName + "_filename");
        Number newSize = (Number)newValues.get(fieldName + "_filesize");
        Number oldSize = (Number)oldValues.get(fieldName + "_filesize");
        return newName == null && oldName != null || !newName.equals(oldName) || newSize == null && oldSize != null || oldSize == null && newSize != null || newSize.intValue() != oldSize.intValue();
    }

    protected boolean binaryContentIsDifferent(String fieldName, Map newValues, Map oldValues) {
        int newByte;
        if (!(newValues.get(fieldName) instanceof ByteArrayInputStream)) {
            log.warn("New value of binary field " + fieldName + " is not a ByteArrayInputStream");
            return true;
        }
        ByteArrayInputStream newStream = (ByteArrayInputStream)newValues.get(fieldName);
        ByteArrayInputStream oldStream = null;
        if (!(oldValues.get(fieldName) instanceof ByteArrayInputStream)) {
            List<String> pks = this.getPrimaryKeys();
            if (pks.size() == 0) {
                log.warn("Cannot fetch old value for binary field " + fieldName + " - DataSource has no primary key field");
                return true;
            }
            HashMap criteria = new HashMap();
            for (String keyName : pks) {
                criteria.put(keyName, newValues.get(keyName));
            }
            DSRequest req = new DSRequest(this.getName(), OP_FETCH);
            req.setCriteria(criteria);
            ArrayList<String> outputs = new ArrayList<String>();
            outputs.add(fieldName);
            req.setOutputs(outputs);
            Map data = null;
            try {
                data = req.execute().getDataMap();
            }
            catch (Exception e) {
                log.warn((Object)("Exception trying to retrieve old value of binary field " + fieldName), e);
                return true;
            }
            if (data == null) {
                log.warn("Attempt to fetch old value for binary field " + fieldName + " resulted in no record found");
                return true;
            }
            if (!(data.get(fieldName) instanceof ByteArrayInputStream)) {
                log.warn("Existing value of binary field " + fieldName + " is not a ByteArrayInputStream");
                return true;
            }
            oldStream = (ByteArrayInputStream)data.get(fieldName);
        } else {
            oldStream = (ByteArrayInputStream)oldValues.get(fieldName);
        }
        if (oldStream == null) {
            log.warn("Old value for binary field " + fieldName + " was not provided in lastValues, and we were not able to fetch it");
            return true;
        }
        newStream.reset();
        oldStream.reset();
        do {
            int oldByte;
            if ((newByte = newStream.read()) == (oldByte = oldStream.read())) continue;
            newStream.reset();
            return true;
        } while (newByte != -1);
        return false;
    }

    public String getAuditTypeFieldName() {
        return AuditDSGenerator.getAuditTypeFieldName(this);
    }

    public String getAuditRevisionFieldName() {
        return AuditDSGenerator.getAuditRevisionFieldName(this);
    }

    public String getAuditTimestampFieldName() {
        return AuditDSGenerator.getAuditTimestampFieldName(this);
    }

    public String getAuditUserFieldName() {
        return AuditDSGenerator.getAuditUserFieldName(this);
    }

    public String getAuditChangedFieldsFieldName() {
        return AuditDSGenerator.getAuditChangedFieldsFieldName(this);
    }

    public Object setProperties(Map properties, Object target) {
        return this.setProperties(properties, target, null, true);
    }

    public Object setProperties(Map properties, Object target, DSRequest dsRequest) {
        return this.setProperties(properties, target, dsRequest, true);
    }

    public Object setProperties(Map properties, Object target, DSRequest dsRequest, boolean clearContext) {
        if (properties == null) {
            properties = new HashMap();
        }
        JXPathContext context = null;
        HashMap tryAsBean = null;
        HashMap adaptedProperties = new HashMap();
        for (String fieldName : properties.keySet()) {
            RelationFieldInfo relationFieldInfo;
            DSField field = this.getField(fieldName);
            if (field == null) continue;
            Object value = properties.get(fieldName);
            if (this.handlesRelations() && this.relationFields != null && (relationFieldInfo = this.relationFields.get(fieldName)) != null) {
                try {
                    this.setRelationFieldValue(relationFieldInfo, target, value);
                }
                catch (Exception e) {
                    log.warn("Couldn't set property '" + fieldName + "' for datasource '" + this.getName() + "'. Actual error: " + (log.isDebugEnabled() ? DataTools.getStackTrace(e) : e.toString()));
                }
                continue;
            }
            String valueXPath = field.getValueWriteXPath();
            String string = valueXPath = valueXPath != null ? valueXPath : field.getValueXPath();
            if (valueXPath == null) {
                if (tryAsBean == null) {
                    tryAsBean = new HashMap();
                }
                if (value instanceof Collection || value instanceof Map) {
                    try {
                        PropertyDescriptor pd = null;
                        try {
                            pd = new PropertyDescriptor(fieldName, target.getClass());
                        }
                        catch (IntrospectionException introspectionException) {
                            // empty catch block
                        }
                        if (pd != null) {
                            value = this.adaptValue(pd, field, value, dsRequest);
                            adaptedProperties.put(fieldName, value);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception trying to adapt collection/map: " + fieldName + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                    }
                }
                tryAsBean.put(fieldName, value);
                continue;
            }
            if (context == null) {
                context = JXPathContext.newContext((Object)target);
                context.setFactory((AbstractFactory)JXPathContextObjectFactory.getInstance());
            }
            if (valueXPath.contains("/")) {
                try {
                    context.createPath(valueXPath.substring(0, valueXPath.lastIndexOf("/")));
                }
                catch (Exception e) {
                    log.warn("Exception trying to create path for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                }
            }
            Object adaptedValue = value;
            try {
                Pointer p = context.getPointer(valueXPath);
                if (p instanceof BeanPropertyPointer) {
                    BeanPropertyPointer bpp = (BeanPropertyPointer)p;
                    Object bean = bpp.getBean();
                    PropertyDescriptor pd = new PropertyDescriptor(bpp.getPropertyName(), bean.getClass());
                    if (pd != null) {
                        adaptedValue = this.adaptValue(pd, field, value, dsRequest);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception trying to adapt value for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
            }
            try {
                context.setValue(valueXPath, adaptedValue);
            }
            catch (Exception e) {
                log.warn("Couldn't set value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
        }
        for (Object key : adaptedProperties.keySet()) {
            properties.put(key, adaptedProperties.get(key));
            tryAsBean.put((String)key, adaptedProperties.get(key));
        }
        if (tryAsBean != null) {
            try {
                DataTools.setProperties(tryAsBean, target, this, null, clearContext);
            }
            catch (Exception e) {
                log.warn((Object)("Exception trying to set properties for datasource: " + this.getName() + " from: " + String.valueOf(tryAsBean) + " to: " + String.valueOf(target) + ". Actual error: " + e.toString()), e);
            }
        }
        return target;
    }

    private Object adaptValue(PropertyDescriptor pd, DSField field, Object value, DSRequest dsRequest) throws Exception {
        Class javaClass = null;
        Class javaCollectionClass = null;
        Class javaKeyClass = null;
        try {
            javaClass = this._getPropertyJavaClass(field.getName(), field, value);
            String typeName = field.getProperty("javaCollectionClass");
            if (typeName != null) {
                javaCollectionClass = Reflection.classForName(typeName);
            }
            if ((typeName = field.getProperty("javaKeyClass")) != null) {
                javaKeyClass = Reflection.classForName(typeName);
            }
        }
        catch (Exception e) {
            log.warn(e.getClass().getName() + " " + e.getMessage() + " encountered whilst trying to derive Java classes from override class names for DataSource '" + this.getName() + "', field name '" + field.getName() + "'");
        }
        Method method = pd.getWriteMethod();
        Class<?>[] argTypes = method.getParameterTypes();
        List genericInfo = VersionSafeChecker.getGenericParameterTypes(method);
        VersionSafeChecker.GenericParameterNode targetGenericInfo = null;
        if (genericInfo != null && genericInfo.size() > 0) {
            targetGenericInfo = (VersionSafeChecker.GenericParameterNode)genericInfo.get(0);
        }
        if (targetGenericInfo != null && targetGenericInfo.getClassByIndex(0) == argTypes[0]) {
            targetGenericInfo = targetGenericInfo.getChildNode();
        }
        ReflectionArgument reflectionArg = new ReflectionArgument(value.getClass(), value, true, true);
        if (argTypes.length > 0) {
            String fieldType = field.getType();
            DataSource subDataSource = fieldType == null ? null : DataSourceManager.get(fieldType, dsRequest);
            value = Reflection.adaptValue(argTypes[0], targetGenericInfo, reflectionArg, null, subDataSource, javaClass, javaCollectionClass, javaKeyClass, dsRequest);
        }
        return value;
    }

    public List getListProperties(List list) {
        return this.getListProperties(list, true, true);
    }

    public List getListProperties(List list, boolean dropExtraFields, boolean dropIgnoredFields) {
        ArrayList<Map> rtn = new ArrayList<Map>();
        ValidationContext vc = new ValidationContext();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            rtn.add(this.getProperties(i.next(), dropExtraFields, dropIgnoredFields, vc));
        }
        vc.freeResources();
        return rtn;
    }

    public Map getProperties(Object obj) {
        return this.getProperties(obj, true, true);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields, validationContext);
    }

    public Map getProperties(Object obj, Collection propsToKeep) {
        return this.getProperties(obj, propsToKeep, false, false);
    }

    public Map getProperties(Object obj, Collection propsToKeep, ValidationContext validationContext) {
        return this.getProperties(obj, propsToKeep, false, false, validationContext);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, recursedList, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, Collection propsToDrop) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, recursedList, propsToDrop, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, Collection propsToDrop, boolean omitNullMapValues) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DataSourcePropertiesMap) {
            return (DataSourcePropertiesMap)obj;
        }
        if (DataTools.containsByReference(recursedList = recursedList == null ? new ArrayList<Object>() : new ArrayList<E>(recursedList), obj)) {
            DataSource.log.warn(obj.getClass().getName() + " contains a (potentially indirect) looping reference to itself.  Returning null for recursed value.");
            return null;
        }
        recursedList.add(obj);
        context = null;
        tryAsBean = null;
        ignoredFields = new HashMap<String, String>();
        hadRelation = null;
        hadXPath = null;
        result = new DataSourcePropertiesMap();
        recordIsPlainMap = false;
        if (validationContext != null && validationContext.dsRequest != null && obj instanceof Map) {
            recordIsPlainMap = validationContext.dsRequest.isSummary();
            if (!recordIsPlainMap) {
                v0 = recordIsPlainMap = validationContext.dsRequest.getConsolidatedOutputs() != null && validationContext.dsRequest.getConsolidatedOutputs().size() > 0;
            }
            if (!recordIsPlainMap) {
                recordIsPlainMap = validationContext.dsRequest.getSummaryFunctionFields() != null && validationContext.dsRequest.getSummaryFunctionFields().size() > 0;
            }
        }
        fieldNames = this.getFieldNames(false);
        for (String fieldName : fieldNames) {
            if (propsToKeep != null && !propsToKeep.contains(fieldName) || propsToDrop != null && propsToDrop.contains(fieldName)) continue;
            field = this.getField(fieldName);
            if (dropIgnoredFields && field.getBoolean("ignore")) {
                ignoredFields.put(fieldName, "ignore");
                continue;
            }
            if (dropExtraFields && field.getBoolean("unknownType", false) && !(fields = (Map)this.dsConfig.get("fields")).containsKey(fieldName)) continue;
            if (this.handlesRelations() && this.relationFields != null && !recordIsPlainMap && (!(obj instanceof Map) || obj instanceof ISCMapBean) && (relationFieldInfo = this.relationFields.get(fieldName)) != null) {
                try {
                    result.put(fieldName, this.getRelationFieldValue(relationFieldInfo, obj, recursedList, validationContext));
                    if (hadRelation == null) {
                        hadRelation = new ArrayList<String>();
                    }
                    hadRelation.add(fieldName);
                }
                catch (Exception e) {
                    DataSource.log.warn("Couldn't get value for property '" + fieldName + "' for datasource '" + this.getName() + "' - ignoring. Actual error: " + (DataSource.log.isDebugEnabled() != false ? DataTools.getStackTrace(e) : e.toString()));
                }
                continue;
            }
            valueXPath = field.getValueXPath();
            if (valueXPath == null || recordIsPlainMap) {
                if (tryAsBean == null) {
                    tryAsBean = new ArrayList<String>();
                }
                tryAsBean.add(fieldName);
                continue;
            }
            if (hadXPath == null) {
                hadXPath = new ArrayList<String>();
            }
            hadXPath.add(fieldName);
            if (context == null) {
                context = JXPathContext.newContext((Object)obj);
            }
            context.setLenient(true);
            JXPathBeanPointer.enableAdditionalValidation();
            try {
                value = null;
                if (field.isMultiple()) {
                    valueList = null;
                    valueIterator = context.iterate(valueXPath);
                    while (valueIterator.hasNext()) {
                        if (valueList == null) {
                            valueList = new ArrayList<E>();
                        }
                        valueList.add(valueIterator.next());
                    }
                    value = valueList;
                } else {
                    value = context.getValue(valueXPath);
                }
                subDS /* !! */  = null;
                subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                if (subDS /* !! */  != null) {
                    value = this.getSubValue(subDS /* !! */ , field, value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                }
                result.put(fieldName, value);
            }
            catch (Exception e) {
                DataSource.log.warn("Couldn't get value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
            finally {
                JXPathBeanPointer.disableAdditionalValidation();
            }
        }
        if (!dropExtraFields || tryAsBean != null || propsToKeep != null) {
            block79: {
                beanValues = null;
                if (!(obj instanceof Map) || obj instanceof ISCMapBean) {
                    nanos = System.nanoTime();
                    try {
                        if (propsToKeep != null) {
                            if (hadXPath != null) {
                                propsToKeep = new ArrayList<E>(propsToKeep);
                                propsToKeep.removeAll(hadXPath);
                            }
                            if (hadRelation != null) {
                                propsToKeep = new ArrayList<E>(propsToKeep);
                                propsToKeep.removeAll(hadRelation);
                            }
                            beanValues = DataTools.getProperties(obj, propsToKeep);
                            break block79;
                        }
                        if (hadXPath != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadXPath);
                        }
                        if (hadRelation != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadRelation);
                        }
                        if (dropExtraFields) {
                            beanValues = DataTools.getProperties(obj, tryAsBean);
                            break block79;
                        }
                        beanProperties = DataTools.getPropertyDescriptors(obj).keySet();
                        normalizedProperties = new LinkedHashSet<String>();
                        dsFields = this.getFieldNames();
                        for (String prop : beanProperties) {
                            if (dsFields.contains(prop)) {
                                normalizedProperties.add(prop);
                                continue;
                            }
                            foundNormalized = false;
                            for (i = 0; i < dsFields.size(); ++i) {
                                if (!dsFields.get(i).toLowerCase().equals(prop.toLowerCase())) continue;
                                normalizedProperties.add(dsFields.get(i));
                                foundNormalized = true;
                                break;
                            }
                            if (foundNormalized) continue;
                            normalizedProperties.add(prop);
                        }
                        if (ignoredFields != null) {
                            normalizedProperties.removeAll(ignoredFields.keySet());
                        }
                        if (hadXPath != null) {
                            normalizedProperties.removeAll(hadXPath);
                        }
                        if (hadRelation != null) {
                            normalizedProperties.removeAll(hadRelation);
                        }
                        beanValues = DataTools.getProperties(obj, normalizedProperties);
                    }
                    catch (Exception e) {
                        DataSource.log.warn("Couldn't get values: " + tryAsBean.toString() + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
                    }
                } else {
                    beanValues = new HashMap<K, V>();
                }
            }
            nanos = System.nanoTime();
            i = beanValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next().toString();
                if (propsToDrop != null && propsToDrop.contains(key)) {
                    i.remove();
                    continue;
                }
                field = this.getField(key.toString());
                if (field == null || beanValues.get(key) instanceof IToJSON) continue;
                try {
                    if (validationContext != null) {
                        nanos2 = System.nanoTime();
                        subDS = validationContext.getType(field.getType());
                    } else {
                        subDS = DataSourceManager.get(field.getType(), null);
                    }
                    if (subDS == null) continue;
                    value = this.getSubValue(subDS, field, beanValues.get(key), dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                    beanValues.put(key, value);
                }
                catch (Exception e) {
                    DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                }
            }
            if (obj instanceof Map) {
                i = null;
                i = propsToKeep != null ? propsToKeep.iterator() : (dropExtraFields != false ? tryAsBean.iterator() : DataTools.mapDisjunction((Map)obj, ignoredFields).keySet().iterator());
                objKeys = ((Map)obj).keySet();
                while (i.hasNext()) {
                    key = i.next();
                    if (propsToDrop != null && propsToDrop.contains(key) || beanValues.get(key) != null) continue;
                    value /* !! */  = ((Map)obj).get(key);
                    field = this.getField(key.toString());
                    if (field != null && !(value /* !! */  instanceof IToJSON)) {
                        try {
                            subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                            if (subDS /* !! */  != null) {
                                value /* !! */  = this.getSubValue(subDS /* !! */ , field, value /* !! */ , dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                            }
                        }
                        catch (Exception e) {
                            DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                        }
                    }
                    if (value /* !! */  == null && (omitNullMapValues || !objKeys.contains(key))) continue;
                    beanValues.put(key, value /* !! */ );
                }
            } else if (DataSource.config.getBoolean((Object)"supportDynamicBeans", false) && tryAsBean != null && dropExtraFields && DataSource.dynamicBeanMarker != null && DataSource.dynamicBeanMarker.isAssignableFrom(obj.getClass())) {
                try {
                    getter = Reflection.findMethod(obj, "get");
                    if (getter == null) ** GOTO lbl216
                    for (String propertyName : tryAsBean) {
                        if (beanValues.get(propertyName) != null) continue;
                        params = new String[]{propertyName};
                        value = getter.invoke(obj, params);
                        field = this.getField(propertyName.toString());
                        if (field != null && !(value instanceof IToJSON)) {
                            try {
                                subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                                if (subDS /* !! */  != null) {
                                    value = this.getSubValue(subDS /* !! */ , field, value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                                }
                            }
                            catch (Exception e) {
                                DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                            }
                        }
                        if (value == null) continue;
                        beanValues.put(propertyName, value);
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchMethodException) ** GOTO lbl216
                    DataSource.log.warn("Error trying to mine dynamic bean.  Actual error: " + e.toString());
                }
            }
lbl216:
            // 7 sources

            if (hadXPath != null) {
                for (Object key : hadXPath) {
                    if (!hadXPath.contains(key)) continue;
                    beanValues.remove(key);
                }
            }
            DataTools.putAllNotPresent(result, beanValues);
        }
        for (String fieldName : fieldNames) {
            block80: {
                value /* !! */  = result.get(fieldName);
                if (value /* !! */  != null && value /* !! */  instanceof Date && !(value /* !! */  instanceof ISCDate) && !(value /* !! */  instanceof ISCTime)) {
                    field = this.getField(fieldName);
                    fieldType = null;
                    try {
                        bds_this = (BasicDataSource)this;
                        fieldType = bds_this.getSimpleBaseType(field.getType());
                        if ("date".equals(fieldType)) {
                            value /* !! */  = new ISCDate(((Date)value /* !! */ ).getTime());
                            result.put(fieldName, value /* !! */ );
                            break block80;
                        }
                        if (!"time".equals(fieldType)) break block80;
                        value /* !! */  = new ISCTime(((Date)value /* !! */ ).getTime());
                        result.put(fieldName, value /* !! */ );
                    }
                    catch (Exception e) {
                        DataSource.log.warn((Object)("Unable to look up simpleBaseType for field: " + fieldName), e);
                        continue;
                    }
                }
            }
            if (validationContext == null || !validationContext.getEncodeBinaryFields() || (field = this.getField(fieldName)) == null || !field.shouldEncodeInResponse()) continue;
            if (value /* !! */  instanceof File) {
                try {
                    value /* !! */  = new FileInputStream((File)value /* !! */ );
                }
                catch (FileNotFoundException ex) {
                    DataSource.log.warn((Object)("Failed to open file " + ((File)value /* !! */ ).getName() + ". Skipping."), ex);
                    value /* !! */  = null;
                }
            }
            if (value /* !! */  instanceof InputStream) {
                try {
                    encoded = DataTools.base64Encode((InputStream)value /* !! */ );
                    result.put(fieldName, encoded);
                }
                catch (Exception ex) {
                    DataSource.log.warn((Object)"Failed to read from input stream. Skipping.", ex);
                }
                continue;
            }
            if (value /* !! */  instanceof byte[]) {
                encoded = DataTools.base64Encode((byte[])value /* !! */ );
                result.put(fieldName, encoded);
                continue;
            }
            if (!(value /* !! */  instanceof Byte[])) continue;
            work = new byte[((Byte[])value /* !! */ ).length];
            for (j = 0; j < work.length; ++j) {
                work[j] = ((Byte[])value /* !! */ )[j];
            }
            encoded = DataTools.base64Encode(work);
            result.put(fieldName, encoded);
        }
        return result;
    }

    private Object getSubValue(DataSource subDS, DSField field, Object value, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, boolean omitNullMapValues) {
        long nanos = System.nanoTime();
        dropExtraFields = subDS.dropExtraFields();
        if (value == null) {
            return null;
        }
        if (value instanceof JSONFilter && ((JSONFilter)value).getObj() instanceof Collection) {
            JSONFilter filter = (JSONFilter)value;
            ArrayList<Map> list = new ArrayList<Map>();
            Collection valueCollection = (Collection)filter.getObj();
            for (Object item : valueCollection) {
                IBeanFilter beanFilter = filter.getBeanFilter();
                Map record = subDS.getSubProperties(new JSONFilter(item, beanFilter), dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                list.add(record);
            }
            return list;
        }
        if (value instanceof Collection || field.isMultiple()) {
            ArrayList<Map> list = new ArrayList<Map>();
            if (value instanceof Collection) {
                Iterator i = ((Collection)value).iterator();
                while (i.hasNext()) {
                    Map record = subDS.getSubProperties(i.next(), dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                    list.add(record);
                }
            } else {
                if (value instanceof Map) {
                    LinkedHashMap map = new LinkedHashMap();
                    for (Object key : ((Map)value).keySet()) {
                        Object mapValue = ((Map)value).get(key);
                        if (this.isSerializable(mapValue)) {
                            map.put(key, mapValue);
                            continue;
                        }
                        Map record = subDS.getSubProperties(mapValue, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                        map.put(key, record);
                    }
                    return map;
                }
                list.add(subDS.getSubProperties(value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues));
            }
            return list;
        }
        Map result = subDS.getSubProperties(value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
        return result;
    }

    private Map getSubProperties(Object value, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, boolean omitNullMapValues) {
        long nanos = System.nanoTime();
        Map record = null;
        JSONFilter filter = null;
        IBeanFilter beanFilter = null;
        if (value instanceof JSONFilter) {
            filter = (JSONFilter)value;
            value = filter.getObj();
            beanFilter = filter.getBeanFilter();
        }
        try {
            record = beanFilter instanceof IContextBeanFilterWithNullControl ? ((IContextBeanFilterWithNullControl)beanFilter).filter(value, validationContext, omitNullMapValues) : (beanFilter instanceof IContextBeanFilter ? ((IContextBeanFilter)beanFilter).filter(value, validationContext) : this.getProperties(value, null, dropExtraFields, dropIgnoredFields, validationContext, recursedList, null, omitNullMapValues));
        }
        catch (Exception e) {
            log.warn((Object)"Error trying to get sub-object properties", e);
        }
        return record;
    }

    private boolean isSerializable(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Date || VersionSafeChecker.isEnum(obj);
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields) throws Exception {
        return this.validate(data, reportMissingRequiredFields, null);
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields, ValidationContext context) throws Exception {
        return this.validate(data, reportMissingRequiredFields, context, false);
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields, ValidationContext context, boolean mergeValidatedValues) throws Exception {
        Map errors;
        boolean localContext = false;
        if (context == null) {
            context = new ValidationContext();
            localContext = true;
        }
        context.setPropertiesOnly(!reportMissingRequiredFields);
        Map validated = (Map)this.toRecords(data, context);
        if (mergeValidatedValues) {
            DataTools.mapMergeNonNull(validated, data);
        }
        if (localContext) {
            context.freeResources();
        }
        if ((errors = context.getErrors()) == null) {
            return null;
        }
        return (ErrorReport)errors.values().toArray()[0];
    }

    @Deprecated
    public ErrorReport validate(Map data, ErrorReport errors) throws Exception {
        return errors;
    }

    public ErrorReport validateRecord(Map data, ErrorReport errors, ValidationContext context) throws Exception {
        return errors;
    }

    public DSResponse validateDSRequest(DSRequest dsRequest) throws Exception {
        if (dsRequest.getValidated()) {
            return null;
        }
        boolean isAuditDataSource = this.isAuditDataSource();
        if (isAuditDataSource && !config.getBoolean((Object)"datasource.validateAuditDS", false)) {
            dsRequest.setValues(this.schemaDrivenSafeDeepClone(dsRequest.getValueSets()));
            dsRequest.setValidated(true);
            return null;
        }
        List errors = DataSource.validateDSRequest(this, dsRequest);
        if (errors != null) {
            Logger.validation.info("Validation error: " + DataTools.prettyPrint(errors));
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setStatus(-4);
            dsResponse.setErrors(errors);
            return dsResponse;
        }
        dsRequest.setValidated(true);
        return null;
    }

    public Object schemaDrivenSafeDeepClone(Object src) throws Exception {
        log.warn("This DataSource does not support schema-driven clone - returning the original");
        return src;
    }

    public static List validateDSRequest(DataSource dataSource, DSRequest dsRequest) throws Exception {
        Map errors;
        String operationType = dsRequest.getOperationType();
        if (DataSource.isRemove(operationType) || !DataSource.isModificationOperation(operationType) && !OP_VALIDATE.equals(operationType)) {
            return null;
        }
        ValidationContext context = new ValidationContext();
        if ("partial".equals(dsRequest.getValidationMode())) {
            context.setPropertiesOnly(true);
        }
        context.setRPCManager(dsRequest.getRPCManager());
        context.setRequestContext(dsRequest.getRequestContext());
        if (dsRequest.getOperationType().equals(OP_UPDATE)) {
            context.setPropertiesOnly();
        }
        context.setDSRequest(dsRequest);
        dsRequest.setValidatedValues(dataSource.toRecords(dsRequest.getValueSets(), context));
        context.freeResources();
        if (log.isDebugEnabled()) {
            log.debug("post-validation valueSet: " + DataTools.prettyPrint(dsRequest.getValueSets()));
        }
        if ((errors = context.getErrors()) != null) {
            errors = ErrorReport.toImpliedForm(errors);
            ArrayList<Map> errorList = new ArrayList<Map>();
            errorList.add(errors);
            return errorList;
        }
        return null;
    }

    public Map validateOperationBinding(DSRequest dsRequest, Map operationBinding) throws Exception {
        return operationBinding;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeReplace(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeClientExport(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeStoreTestData(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeGetTestData(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeLoadDS(DSRequest req) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("dsName", this.getName());
        result.put("dsData", JSTranslater.instance().toJS(this.getConfig()));
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setBypassDataFilter(true);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(result);
        dsResponse.setData(list);
        return dsResponse;
    }

    protected DSResponse notSupported(DSRequest req) throws Exception {
        throw new OperationNotSupportedException("Operation type '" + req.getOperationType() + "' not supported by this DataSource (" + this.getName() + ")");
    }

    public boolean usesSCServerProtocol() {
        Object serviceNamespace = this.dsConfig.get("serviceNamespace");
        Object constructor = this.dsConfig.get("constructor");
        Object dataProtocol = this.dsConfig.get("dataProtocol");
        boolean result = serviceNamespace == null && constructor == null && (dataProtocol == null || dataProtocol.equals("iscServer"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSResponse executeFileSource(DSRequest req) throws Exception {
        String fullFilename;
        String operationType;
        String operationId = operationType = req.getOperationType();
        DSRequest work = null;
        String versionField = this.getFileVersionField();
        if (versionField != null) {
            DSField dsField = this.getField(versionField);
            if (dsField == null) {
                if (!versionField.isEmpty()) {
                    log.warn("DataSource " + this.getName() + " specifies fileVersionField: '" + versionField + "', but does not specify a field of that name. Automatic file versioning will be disabled");
                }
                versionField = null;
            } else if (!this.simpleTypeInheritsFrom(dsField.getType(), "datetime")) {
                log.warn("DataSource " + this.getName() + " specifies fileVersionField: '" + versionField + "', but that field is not a 'datetime' or subtype. Automatic file versioning will be disabled");
                versionField = null;
            }
        }
        List<String> extensionFields = this.getFileExtensionFields();
        HashMap<String, Object> values = null;
        Map<String, Object> nativeValues = null;
        Map<String, Object> nativeFileSourcePrimaryKeys = null;
        if (OP_LIST_FILES.equals(operationType)) {
            if (!req.getIsAdvancedCriteria()) {
                values = req.getCriteria();
            }
        } else {
            values = req.getValues();
        }
        String string = fullFilename = OP_LIST_FILES.equals(operationType) ? "" : this.getFullFilename(values);
        if (values != null) {
            DataTools.removeNullValuedKeys(values);
            DataTools.removeEmptyStringValuedKeys(values);
            nativeValues = this.getFileSourceNativeValues(values);
            nativeFileSourcePrimaryKeys = this.getFileSourceNativePrimaryKeys(values);
        }
        Object monitor = new Object();
        if (OP_UNIQUE_NAME.equals(operationType) || OP_SAVE_FILE.equals(operationType) || OP_RENAME_FILE.equals(operationType)) {
            monitor = this.getFileSourcePrimaryKeyMonitor(values);
        }
        Object object = monitor;
        synchronized (object) {
            List data;
            Object defaultTenantId;
            Object defaultFormat;
            Object defaultType;
            DSResponse response;
            if (OP_GET_FILE.equals(operationType) || OP_HAS_FILE.equals(operationType)) {
                String textMatchStyle;
                response = this.requireFileSourceField((Map<String, Object>)values, "Field is required", DataTools.makeList(FS_FILE_NAME));
                if (response != null) {
                    return response;
                }
                this.warnFileSourceField((Map<String, Object>)values, "not provided for fileSource:" + operationType + " operation", FS_FILE_TYPE, FS_FILE_FORMAT, FS_FILE_TENANT_ID);
                if (FileSourceCaches.isInNegativeCache(this, fullFilename)) {
                    return new DSResponse();
                }
                Map file = FileSourceCaches.getFromCache(this, fullFilename);
                if (file != null) {
                    ArrayList data2 = new ArrayList();
                    data2.add(new HashMap(file));
                    DSResponse resp = new DSResponse(data2);
                    this.convertXmlToJsIfRequested(req, resp);
                    return resp;
                }
                if (FileSourceCaches.useCache) {
                    log.debug("FileSource file '" + fullFilename + "' not found in FileSourceCaches.  Ready to look it up in the FileSource system");
                }
                work = new DSRequest(this.getName(), OP_FETCH);
                work.setCriteria(nativeFileSourcePrimaryKeys);
                if ((OP_ID_ALL_OWNERS.equals(req.getOperationId()) || OP_ID_ALL_OWNERS_XML_TO_JS.equals(req.getOperationId())) && values.containsKey("ownerId")) {
                    work.getCriteria().put("ownerId", values.get("ownerId"));
                }
                if (versionField != null) {
                    work.setSortBy("-" + versionField);
                }
                if ((textMatchStyle = req.getTextMatchStyle()) != null && config.getBoolean((Object)"datasource.FileSource.applyRequestMatchStyle", true)) {
                    work.setTextMatchStyle(textMatchStyle);
                }
            } else if (OP_GET_FILE_VERSION.equals(operationType) || OP_HAS_FILE_VERSION.equals(operationType)) {
                if (versionField == null) {
                    String msg = "'getFileVersion' API called for DataSource " + this.getName() + " but that DataSource does not specify a fileVersionField property.  Cannot continue.";
                    log.warn(msg);
                    throw new Exception(msg);
                }
                ArrayList<String> requiredFields = new ArrayList<String>();
                requiredFields.add(FS_FILE_NAME);
                requiredFields.add(versionField);
                response = this.requireFileSourceField((Map<String, Object>)values, "Field is required", requiredFields);
                if (response != null) {
                    return response;
                }
                this.warnFileSourceField(values, "not provided for fileSource:" + operationType + " operation", FS_FILE_TYPE, FS_FILE_FORMAT, FS_FILE_TENANT_ID);
                work = new DSRequest(this.getName(), OP_FETCH);
                work.setCriteria(nativeFileSourcePrimaryKeys);
                work.getCriteria().put(versionField, values.get(versionField));
            } else if (OP_LIST_FILES.equals(operationType)) {
                work = new DSRequest(this.getName(), OP_FETCH);
                if (req.getIsAdvancedCriteria()) {
                    AdvancedCriteria remappedCriteria;
                    Object defaultOwnerId;
                    AdvancedCriteria criteria = req.getAdvancedCriteria();
                    values = new HashMap<String, Object>();
                    defaultType = req.getCriteriaValue(FS_FILE_TYPE);
                    if (defaultType != null) {
                        values.put(FS_FILE_TYPE, defaultType);
                    }
                    if ((defaultFormat = req.getCriteriaValue(FS_FILE_FORMAT)) != null) {
                        values.put(FS_FILE_FORMAT, defaultFormat);
                    }
                    if ((defaultTenantId = req.getCriteriaValue(FS_FILE_TENANT_ID)) != null) {
                        values.put(FS_FILE_TENANT_ID, defaultTenantId);
                    }
                    if ((OP_ID_ALL_OWNERS.equals(req.getOperationId()) || OP_ID_ALL_OWNERS_XML_TO_JS.equals(req.getOperationId())) && (defaultOwnerId = req.getCriteriaValue("ownerId")) != null) {
                        values.put("ownerId", defaultOwnerId);
                    }
                    if ((remappedCriteria = CriteriaUtils.remapFields(criteria, this.getFileSourceFieldMapToNative())) != null) {
                        work.setCriteria(remappedCriteria);
                    }
                } else {
                    work.setCriteria(DataTools.remapRow(values, this.getFileSourceFieldMapToNative(), true));
                }
                if (versionField != null) {
                    HashMap<String, SummaryFunctionType> summ = new HashMap<String, SummaryFunctionType>();
                    summ.put(versionField, SummaryFunctionType.MAX);
                    work.setSummaryFunctions(summ);
                    List<String> groupFields = this.getFileSourceNativeKeys(FS_PRIMARY_KEYS);
                    Map<String, String> remap = this.getFileSourceFieldMapToNative();
                    work.setGroupBy(groupFields);
                    List grouped = work.execute().getDataList();
                    if (grouped.size() == 0) {
                        return new DSResponse();
                    }
                    if (!groupFields.contains(versionField)) {
                        groupFields.add(versionField);
                    }
                    Criterion[] lc = new LogicalCriterion[grouped.size()];
                    for (int i = 0; i < grouped.size(); ++i) {
                        Map record = (Map)grouped.get(i);
                        Criterion[] sc = new SimpleCriterion[groupFields.size()];
                        for (int j = 0; j < sc.length; ++j) {
                            String field = groupFields.get(j);
                            OperatorBase operatorId = field.equals(remap.get(FS_FILE_TYPE)) || field.equals(remap.get(FS_FILE_FORMAT)) ? DefaultOperators.IEquals : DefaultOperators.Equals;
                            sc[j] = new SimpleCriterion(field, operatorId, record.get(field));
                        }
                        lc[i] = new LogicalCriterion(DefaultOperators.And, sc);
                    }
                    AdvancedCriteria ac = new AdvancedCriteria(DefaultOperators.Or, lc);
                    work = new DSRequest(this.getName(), OP_FETCH);
                    work.setAdvancedCriteria(ac);
                }
            } else if (OP_LIST_FILE_VERSIONS.equals(operationType)) {
                if (versionField == null) {
                    String msg = "'listFileVersions' API called for DataSource " + this.getName() + " but that DataSource does not specify a fileVersionField property.  Cannot continue.";
                    log.warn(msg);
                    throw new Exception(msg);
                }
                if (values.containsKey(versionField)) {
                    values.remove(versionField);
                }
                if ((response = this.requireFileSourceField((Map<String, Object>)values, "Field is required", FS_PRIMARY_KEYS)) != null) {
                    return response;
                }
                work = new DSRequest(this.getName(), OP_FETCH);
                work.setCriteria(this.getFileSourceNativeValues(values));
                work.setSortBy("-" + versionField);
            } else {
                if (OP_UNIQUE_NAME.equals(operationType)) {
                    AdvancedCriteria allNamesCrit;
                    long index;
                    char last;
                    String indexSuffix;
                    DSResponse response2 = this.requireFileSourceField((Map<String, Object>)values, "Field is required", FS_PRIMARY_KEYS);
                    if (response2 != null) {
                        return response2;
                    }
                    String baseFileName = (String)values.get(FS_FILE_NAME);
                    String firstFileName = (String)values.get("firstFileName");
                    String indexPrefix = (String)values.get("indexPrefix");
                    if (indexPrefix == null) {
                        indexPrefix = "";
                    }
                    if ((indexSuffix = (String)values.get("indexSuffix")) == null) {
                        indexSuffix = "";
                    }
                    String prefixMode = (String)values.get("prefixMode");
                    if (baseFileName != null && !baseFileName.isEmpty() && !indexPrefix.isEmpty() && "number".equals(prefixMode) && !Character.isDigit(last = baseFileName.charAt(baseFileName.length() - 1))) {
                        indexPrefix = "";
                    }
                    values.remove(FS_FILE_NAME);
                    values.remove("firstFileName");
                    values.remove("indexPrefix");
                    values.remove("indexSuffix");
                    values.remove("prefixMode");
                    Map<String, Object> criteria = this.getFileSourceNativeValues(values);
                    if (versionField != null) {
                        criteria.remove(versionField);
                    }
                    String fileName = (index = this.getNextUniqueNameIndex(FS_FILE_NAME, allNamesCrit = AdvancedCriteria.fromCollections(criteria), firstFileName, baseFileName, indexPrefix, indexSuffix, true, null, req.getRPCManager())) == 1L && firstFileName != null ? firstFileName : baseFileName + (String)(index > 1L ? indexPrefix + index + indexSuffix : "");
                    values.put(FS_FILE_NAME, fileName);
                    boolean skipAdd = "uniqueNameNoAdd".equals(req.getOperationId());
                    values.putAll(req.getCriteria());
                    HashMap<String, Object> uniqueRecord = skipAdd ? values : new DSRequest(this.getName(), OP_ADD, req.getRPCManager()).setValues(values).execute().getRecord();
                    uniqueRecord.remove(FS_FILE_NAME_LENGTH);
                    return new DSResponse(uniqueRecord);
                }
                Date timestamp = new Date();
                response = this.requireFileSourceField(values, "Field is required", FS_PRIMARY_KEYS);
                if (response != null) {
                    return response;
                }
                DSRequest existingFileRequest = new DSRequest(this.getName(), OP_FETCH, req.getRPCManager());
                Object criteria = null;
                if (req.getIsAdvancedCriteria()) {
                    criteria = new AdvancedCriteria(DefaultOperators.And, AdvancedCriteria.fromCollections(nativeFileSourcePrimaryKeys).asCriterion(), req.getAdvancedCriteria().asCriterion());
                } else {
                    criteria = new HashMap<String, Object>(nativeFileSourcePrimaryKeys);
                    ((Map)criteria).putAll(req.getCriteria());
                    if (OP_SAVE_FILE.equals(operationType) && (OP_ID_ALL_OWNERS.equals(req.getOperationId()) || OP_ID_ALL_OWNERS_XML_TO_JS.equals(req.getOperationId()))) {
                        ((Map)criteria).remove("ownerId");
                    }
                }
                existingFileRequest.setCriteria(criteria);
                if (OP_REMOVE_FILE_VERSION.equals(operationType)) {
                    existingFileRequest.setOperationId(OP_HAS_FILE_VERSION);
                    existingFileRequest.getCriteria().put(versionField, values.get(versionField));
                } else {
                    existingFileRequest.setOperationId(OP_HAS_FILE);
                }
                existingFileRequest.setOutputs(this.getPrimaryKeys());
                Map existingFile = existingFileRequest.execute().getDataMap();
                Object replaceVersion = null;
                Map replaceRecord = null;
                if (existingFile != null && versionField != null) {
                    DSRequest versionsRequest = new DSRequest(this.getName(), OP_FETCH, req.getRPCManager());
                    versionsRequest.setOperationId(OP_LIST_FILE_VERSIONS);
                    versionsRequest.setCriteria(nativeFileSourcePrimaryKeys);
                    versionsRequest.setOutputs(this.getCustomFileSourceFieldNames(FS_PRIMARY_KEYS));
                    versionsRequest.getOutputs().add(versionField);
                    versionsRequest.getOutputs().addAll(this.getPrimaryKeys());
                    versionsRequest.setSortBy(versionField);
                    List versions = versionsRequest.execute().getDataList();
                    int maxVersions = this.dsConfig.getInt(FS_MAX_FILE_VERSIONS_PROPERTY, 20);
                    if (versions.size() >= maxVersions) {
                        replaceRecord = (Map)versions.get(0);
                        replaceVersion = (Date)replaceRecord.get(versionField);
                    }
                }
                if (OP_SAVE_FILE.equals(operationType)) {
                    DSField lastModifiedField;
                    String lastModifiedFieldName;
                    if (existingFile == null || versionField != null && replaceVersion == null) {
                        work = new DSRequest(this.getName(), OP_ADD);
                        work.setValues(nativeValues);
                    } else {
                        work = versionField != null && this.getPrimaryKeys().contains(versionField) ? new DSRequest(this.getName(), OP_ADD) : new DSRequest(this.getName(), OP_UPDATE);
                        if (replaceRecord != null) {
                            work.setCriteria(replaceRecord);
                        } else {
                            work.setCriteria(existingFile);
                        }
                        if (versionField != null && this.getPrimaryKeys().contains(versionField)) {
                            DSRequest removeRequest = new DSRequest(this.getName(), OP_REMOVE);
                            HashMap removeCriteria = new HashMap(replaceRecord);
                            removeRequest.setCriteria(removeCriteria);
                            removeRequest.setOperationId(OP_REMOVE_FILE);
                            removeRequest.setRPCManager(req.getRPCManager());
                            removeRequest.setClientRequest(req.isClientRequest());
                            DSResponse removeResponse = removeRequest.execute();
                            if (removeResponse.statusIsError()) {
                                return removeResponse;
                            }
                            work.setValues(nativeValues);
                        }
                        work.setFieldValue(this.getFileContentsField(), values.get(FS_FILE_CONTENTS));
                    }
                    for (String fieldName : extensionFields) {
                        work.setFieldValue(fieldName, values.get(fieldName));
                    }
                    if (versionField != null) {
                        work.setFieldValue(versionField, timestamp);
                    }
                    if ((lastModifiedFieldName = this.getFileLastModifiedField()) != null && (lastModifiedField = this.getField(lastModifiedFieldName)) != null && !"modifierTimestamp".equals(lastModifiedField.getType())) {
                        work.setFieldValue(lastModifiedFieldName, timestamp);
                    }
                } else if (OP_RENAME_FILE.equals(operationType)) {
                    List sourceFileList;
                    boolean mustRemoveAndAdd;
                    if (existingFile != null) {
                        DSResponse error = new DSResponse(this);
                        error.setFailure("destination file already exists");
                        return error;
                    }
                    Map oldValues = req.getOldValues();
                    DSResponse error = this.requireFileSourceField(oldValues, "Field is required in oldValues", FS_PRIMARY_KEYS);
                    if (error != null) {
                        return error;
                    }
                    DSRequest sourceFileRequest = new DSRequest(this.getName(), OP_FETCH);
                    Map<String, Object> sourceNativePrimaryKeys = this.getFileSourceNativePrimaryKeys(oldValues);
                    sourceFileRequest.setCriteria(sourceNativePrimaryKeys);
                    Map updatingPrimaryKeys = DataTools.subsetMap(nativeFileSourcePrimaryKeys, this.getPrimaryKeys());
                    boolean bl = mustRemoveAndAdd = updatingPrimaryKeys.size() > 0;
                    if (!mustRemoveAndAdd) {
                        sourceFileRequest.setOutputs(this.getPrimaryKeys());
                    }
                    if ((sourceFileList = sourceFileRequest.execute().getDataList()) == null || sourceFileList.size() == 0) {
                        error = new DSResponse(this);
                        error.setFailure("source file does not exist");
                        return error;
                    }
                    HashMap sourceFile = new HashMap((Map)sourceFileList.get(0));
                    if (mustRemoveAndAdd) {
                        DSRequest removalRequest = new DSRequest(this.getName(), OP_REMOVE);
                        removalRequest.setCriteria(DataTools.subsetMap(sourceFile, this.getPrimaryKeys()));
                        if (versionField != null) {
                            removalRequest.setAllowMultiUpdate(true);
                            removalRequest.getCriteria().remove(versionField);
                        }
                        removalRequest.setOperationId(OP_REMOVE_FILE);
                        removalRequest.inheritClientContext(req);
                        DSResponse removal = removalRequest.execute();
                        if (removal.statusIsError()) {
                            return removal;
                        }
                        work = new DSRequest(this.getName(), OP_ADD);
                        operationId = OP_SAVE_FILE;
                        if (versionField == null) {
                            work.setValues(DataTools.mapUnion(nativeFileSourcePrimaryKeys, sourceFile));
                        } else {
                            ArrayList<Map> remappedList = new ArrayList<Map>();
                            for (int i = 0; i < sourceFileList.size(); ++i) {
                                String lastMod = this.getFileLastModifiedField();
                                if (lastMod != null) {
                                    ((Map)sourceFileList.get(i)).put(lastMod, timestamp);
                                }
                                remappedList.add(DataTools.mapUnion(nativeFileSourcePrimaryKeys, (Map)sourceFileList.get(i)));
                            }
                            work.setValues(remappedList);
                        }
                    } else {
                        work = new DSRequest(this.getName(), OP_UPDATE);
                        if (versionField == null) {
                            work.setCriteria(sourceFile);
                        } else {
                            work.setAllowMultiUpdate(true);
                            work.setCriteria(sourceNativePrimaryKeys);
                            work.getCriteria().remove(versionField);
                        }
                        work.setValues(nativeFileSourcePrimaryKeys);
                    }
                } else if (OP_REMOVE_FILE.equals(operationType)) {
                    if (existingFile == null) {
                        success = new DSResponse(this);
                        success.setSuccess();
                        return success;
                    }
                    work = new DSRequest(this.getName(), OP_REMOVE);
                    work.setCriteria(existingFile);
                    if (versionField != null) {
                        work.setAllowMultiUpdate(true);
                        work.setCriteria(new HashMap<String, Object>(nativeFileSourcePrimaryKeys));
                        work.getCriteria().remove(versionField);
                    }
                } else if (OP_REMOVE_FILE_VERSION.equals(operationType)) {
                    if (existingFile == null) {
                        success = new DSResponse(this);
                        success.setSuccess();
                        return success;
                    }
                    work = new DSRequest(this.getName(), OP_REMOVE);
                    work.setCriteria(existingFile);
                }
            }
            if (work == null) {
                throw new OperationNotSupportedException("operationType: '" + operationType + "' is not supported by executeFileSource() for dataSource: '" + this.getName() + "'");
            }
            if (this.shouldRemoveFileContentsOutput(operationType, work.getOperationType(), req.getOutputs())) {
                List<String> fieldNames = this.getFieldNames();
                ArrayList<String> outputs = new ArrayList<String>(fieldNames);
                outputs.remove(this.getFileContentsField());
                work.setOutputs(outputs);
            }
            work.setOperationId(operationId);
            work.inheritClientContext(req);
            if (!work.isAllowMultiUpdateExplicitlySet()) {
                work.setAllowMultiUpdate(req.getAllowMultiUpdate());
            }
            if (!work.getOperationType().equals(OP_ADD) && (OP_ID_ALL_OWNERS.equals(req.getOperationId()) || OP_ID_ALL_OWNERS_XML_TO_JS.equals(req.getOperationId()))) {
                work.setAttribute("skipAuthentication", true);
            }
            if (req.getSortBy() != null && work.getSortBy() == null) {
                work.setSortBy(req.getSortBy());
            }
            try {
                response = work.execute();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message != null && message.toLowerCase().indexOf("incorrect string value") != -1) {
                    throw new Exception("Data encoding error - please ensure your file is in UTF-8 format");
                }
                throw e;
            }
            if (!work.getOperationType().equals(OP_FETCH)) {
                response.setInvalidateCache(true);
            }
            try {
                response.setData(DataTools.remapObject(response.getDataList(), this.getFileSourceFieldMapFromNative()));
            }
            catch (Exception ex) {
                log.warn((Object)"Caught exception attempting to remap response data; data will not be remapped", ex);
            }
            defaultType = null;
            defaultFormat = null;
            defaultTenantId = null;
            if (values != null) {
                if (this.getFileTypeField() == null) {
                    defaultType = values.get(FS_FILE_TYPE);
                }
                if (this.getFileFormatField() == null) {
                    defaultFormat = values.get(FS_FILE_FORMAT);
                }
                if (this.getFileTenantIdField() == null) {
                    defaultTenantId = values.get(FS_FILE_TENANT_ID);
                }
            }
            if (defaultType != null || defaultFormat != null || defaultTenantId != null) {
                data = response.getDataList();
                for (Map record : data) {
                    if (defaultType != null) {
                        record.put(FS_FILE_TYPE, defaultType);
                    }
                    if (defaultFormat != null) {
                        record.put(FS_FILE_FORMAT, defaultFormat);
                    }
                    if (defaultTenantId == null) continue;
                    record.put(FS_FILE_TENANT_ID, defaultTenantId);
                }
                response.setData(data);
            }
            if ((OP_REMOVE_FILE.equals(operationType) || OP_SAVE_FILE.equals(operationType)) && config.getList("project.datasources", new ArrayList()).contains("ds://" + this.getName())) {
                DataSourceManager.clearAllDataSourceCaches();
            }
            if (OP_REMOVE_FILE.equals(operationType) || OP_SAVE_FILE.equals(operationType) || OP_RENAME_FILE.equals(operationType) || OP_REMOVE_FILE_VERSION.equals(operationType)) {
                log.debug("'" + operationType + "' operation performed on FileSource file '" + fullFilename + "'; removing any entries from the FileSourceCaches");
                FileSourceCaches.removeFromCache(this, fullFilename);
                FileSourceCaches.removeFromNegativeCache(this, fullFilename);
            }
            if (OP_GET_FILE.equals(operationType) || OP_HAS_FILE.equals(operationType)) {
                data = response.getDataList();
                if (data.size() == 0) {
                    if (FileSourceCaches.useNegativeCache) {
                        log.debug("FileSource file '" + fullFilename + "' not found. Adding to the negative cache");
                    }
                    FileSourceCaches.addToNegativeCache(this, fullFilename);
                } else if (OP_GET_FILE.equals(operationType) || FileSourceCaches.useCache && FileSourceCaches.hasFileReturnsContents) {
                    Map firstRecord;
                    if (FileSourceCaches.useCache) {
                        log.debug("FileSource file '" + fullFilename + "' found. Adding to the cache");
                    }
                    if (this.cacheFileRecordNormally(fullFilename, values, firstRecord = (Map)data.get(0))) {
                        FileSourceCaches.addToCache(this, fullFilename, firstRecord);
                    }
                }
            }
            this.convertXmlToJsIfRequested(req, response);
            return response;
        }
    }

    private boolean cacheFileRecordNormally(String fullFilename, Map values, Map firstRecord) {
        if (!values.containsKey(FS_FILE_TENANT_ID)) {
            return true;
        }
        Object tenantId = values.get(FS_FILE_TENANT_ID);
        if (!(tenantId instanceof List)) {
            return true;
        }
        String tenantIdField = this.getFileTenantIdField();
        if (firstRecord.get(tenantIdField) != null) {
            return true;
        }
        String nullFilename = this.getFileSourceCacheKey(values, false);
        Map nullFile = FileSourceCaches.getFromCache(this, nullFilename);
        if (nullFile != null) {
            FileSourceCaches.addToCache(this, fullFilename, nullFile);
            return false;
        }
        FileSourceCaches.addToCache(this, nullFilename, firstRecord);
        return true;
    }

    public long getNextUniqueNameIndex(final String fieldName, AdvancedCriteria allNamesCrit, String firstIdValue, String baseIdValue, String indexPrefix, String indexSuffix, boolean ignoreGaps, Long indexSeed, RPCManager rpc) throws Exception {
        long index;
        if (!(indexSeed == null || StringUtils.isEmpty((String)indexSuffix) && StringUtils.isEmpty((String)indexPrefix) && StringUtils.isEmpty((String)firstIdValue))) {
            log.warning("getNextUniqueNameIndex(): using an indexSeed requires that indexPrefix, indexSuffix, and firstIdValue all be empty; ignoring indexSeed");
            indexSeed = null;
        }
        if (allNamesCrit == null) {
            allNamesCrit = new AdvancedCriteria(null);
        }
        Object regexp2 = DataSource.escapeForRegExp(firstIdValue != null ? firstIdValue : baseIdValue);
        regexp2 = (String)regexp2 + "|" + DataSource.escapeForRegExp(baseIdValue + indexPrefix, "[1-9][0-9]*", indexSuffix);
        allNamesCrit.addCriteria(fieldName, DefaultOperators.Regexp, "^(" + (String)regexp2 + ")$");
        DSRequest work = new DSRequest(this.getName(), OP_FETCH, rpc);
        work.setAdvancedCriteria(allNamesCrit);
        if (ignoreGaps) {
            work.setSortBy(new ArrayList(){
                {
                    this.add("-" + fieldName + "Length");
                    this.add("-" + fieldName);
                }
            });
            work.setStartRow(0L);
            work.setEndRow(2L);
        }
        DSResponse response = work.execute();
        long rowCount = response.getRowCount();
        long l = index = indexSeed != null ? indexSeed : 1L;
        if (rowCount == 0L) {
            return index;
        }
        List records = response.getDataList();
        if (ignoreGaps) {
            long topSuffix;
            if (index == 1L) {
                ++index;
            }
            String topMangling = (String)((Map)records.get(0)).get(fieldName);
            if (firstIdValue != null && firstIdValue.equals(topMangling) && records.size() > 1) {
                topMangling = (String)((Map)records.get(1)).get(fieldName);
            }
            if (topMangling != null && (topSuffix = DataSource.getLongSuffixFromMangling(topMangling, baseIdValue, indexPrefix, indexSuffix)) >= index) {
                index = topSuffix + 1L;
            }
        } else {
            HashSet<Long> suffixes = new HashSet<Long>();
            for (Map record : records) {
                suffixes.add(DataSource.getLongSuffixFromMangling((String)record.get(fieldName), baseIdValue, indexPrefix, indexSuffix));
            }
            while (suffixes.contains(index)) {
                ++index;
            }
        }
        return index;
    }

    private static String escapeForRegExp(String value) {
        return value.replaceAll("([^a-zA-Z0-9'\\s])", "\\\\$1");
    }

    private static String escapeForRegExp(String prefix, String regexp2, String suffix) {
        return DataSource.escapeForRegExp(prefix) + regexp2 + DataSource.escapeForRegExp(suffix);
    }

    private static long getLongSuffixFromMangling(String mangling, String baseIdValue, String indexPrefix, String indexSuffix) {
        int startIndex = baseIdValue.length();
        if (indexPrefix != null) {
            startIndex += indexPrefix.length();
        }
        int endIndex = mangling.length();
        if (indexSuffix != null) {
            endIndex -= indexSuffix.length();
        }
        if (startIndex < endIndex) {
            return Long.parseLong(mangling.substring(startIndex, endIndex));
        }
        return 1L;
    }

    private boolean shouldRemoveFileContentsOutput(String fileSrcOpType, String innerOpType, List<String> clientOutputs) {
        if (OP_GET_FILE.equals(fileSrcOpType) || OP_GET_FILE_VERSION.equals(fileSrcOpType)) {
            return false;
        }
        if (OP_HAS_FILE.equals(fileSrcOpType) && FileSourceCaches.useCache && FileSourceCaches.hasFileReturnsContents) {
            return false;
        }
        DSField fileContentsField = this.getField(this.getFileContentsField());
        if (fileContentsField == null || "change".equals(fileContentsField.get("audit")) && (OP_ADD.equals(innerOpType) || OP_UPDATE.equals(innerOpType))) {
            return false;
        }
        return clientOutputs == null || !clientOutputs.contains(FS_FILE_CONTENTS);
    }

    protected void convertXmlToJsIfRequested(DSRequest req, DSResponse response) {
        if (response.statusIsError()) {
            return;
        }
        if (OP_ID_XML_TO_JS.equals(req.getOperationId()) || OP_ID_ALL_OWNERS_XML_TO_JS.equals(req.getOperationId())) {
            List data = response.getDataList();
            for (Map record : data) {
                Object contents = record.get(FS_FILE_CONTENTS);
                if (contents == null || !(contents instanceof String)) continue;
                String xmlString = (String)contents;
                try {
                    boolean missingDSIsNotFatal = "true".equals(req.getHttpServletRequest().getParameter("missingDSIsNotFatal"));
                    String jsString = BuiltinRPC.xmlToJsString(xmlString, missingDSIsNotFatal, req);
                    record.put(FS_FILE_CONTENTS_AS_JS, jsString);
                }
                catch (Exception ex) {
                    log.warn("Error running xmlToJs on\n" + xmlString + "\nMessage: " + ex.getMessage());
                }
            }
            response.setData(data);
        }
    }

    protected DSResponse requireFileSourceField(Map<String, Object> values, String errorMessage, List<String> fieldNames) {
        LinkedList<String> missingFields = new LinkedList<String>();
        Map<String, String> fileSourceFieldMap = this.getFileSourceFieldMapToNative();
        for (String fieldName : fieldNames) {
            if (fileSourceFieldMap.get(fieldName) == null || values.containsKey(fieldName)) continue;
            missingFields.add(fieldName);
        }
        if (missingFields.size() > 0) {
            DSResponse response = new DSResponse(this);
            for (String fieldName : missingFields) {
                response.addError(fieldName, errorMessage);
            }
            return response;
        }
        return null;
    }

    private List getCustomFileSourceFieldNames(List<String> fieldNames) {
        ArrayList<String> custom = new ArrayList<String>();
        Map<String, String> fileSourceFieldMap = this.getFileSourceFieldMapToNative();
        for (String fieldName : fieldNames) {
            custom.add(fileSourceFieldMap.get(fieldName));
        }
        return custom;
    }

    protected void warnFileSourceField(Map<String, Object> values, String message, String ... fieldNames) {
        Map<String, String> fileSourceFieldMap = this.getFileSourceFieldMapToNative();
        for (String fieldName : fieldNames) {
            if (fileSourceFieldMap.get(fieldName) == null || values.containsKey(fieldName)) continue;
            log.warn("field '" + fieldName + "': " + message);
        }
    }

    protected Map<String, Object> getFileSourceNativeValues(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        return DataTools.remapRow(values, this.getFileSourceFieldMapToNative(), false);
    }

    protected List<String> getFileSourceNativeKeys(List keys) {
        return DataTools.remapKeys(keys, this.getFileSourceFieldMapToNative(), false);
    }

    protected Map<String, Object> getFileSourceNonNativeValues(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        return DataTools.remapRow(values, this.getFileSourceFieldMapFromNative(), false);
    }

    protected Map<String, Object> getFileSourceNativePrimaryKeys(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        Map primaryKeys = DataTools.subsetMap(values, FS_PRIMARY_KEYS);
        return this.getFileSourceNativeValues(primaryKeys);
    }

    protected Map<String, Object> getFileSourceNonNativePrimaryKeys(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> nonNativeValues = this.getFileSourceNonNativeValues(values);
        Map primaryKeys = DataTools.subsetMap(nonNativeValues, FS_PRIMARY_KEYS);
        return primaryKeys;
    }

    protected String getFileSourcePrimaryKeyMonitor(Map values) {
        String monitor = "fileSourceMonitor_" + this.getName();
        Map<String, Object> fileSourcePrimaryKeys = this.getFileSourceNativePrimaryKeys(values);
        for (String pkFragment : fileSourcePrimaryKeys.keySet()) {
            Object pkFragmentValue;
            if (FS_FILE_NAME.equals(pkFragment) || (pkFragmentValue = fileSourcePrimaryKeys.get(pkFragment)) == null) continue;
            monitor = monitor + "_" + pkFragmentValue.toString();
        }
        try {
            String prevailingSandbox = this.getPrevailingSandboxOrDbName();
            if (prevailingSandbox != null) {
                monitor = monitor + "_" + prevailingSandbox;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return monitor.intern();
    }

    protected String getPrevailingSandboxOrDbName() throws Exception {
        String dbName = this.getConfig().getString("dbName");
        if (dbName == null) {
            return null;
        }
        String prevailingSandbox = (String)Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "getPrevailingSandboxName", dbName);
        return prevailingSandbox == null ? dbName : prevailingSandbox;
    }

    protected Map<String, String> getFileSourceFieldMapToNative() {
        if (!this.fileSourceFieldMapInitialized) {
            this.setFileNameField(this.getFileNameField());
            this.setFileTypeField(this.getFileTypeField());
            this.setFileFormatField(this.getFileFormatField());
            this.setFileSizeField(this.getFileSizeField());
            this.setFileLastModifiedField(this.getFileLastModifiedField());
            this.setFileContentsField(this.getFileContentsField());
            this.setFileTenantIdField(this.getFileTenantIdField());
            this.fileSourceFieldMapInitialized = true;
        }
        return this.fileSourceFieldMapToNative;
    }

    protected Map<String, String> getFileSourceFieldMapFromNative() {
        this.getFileSourceFieldMapToNative();
        return this.fileSourceFieldMapFromNative;
    }

    protected final void setFileSourceField(String fsName, String nativeName) {
        String oldNativeName = this.fileSourceFieldMapToNative.put(fsName, nativeName);
        if (oldNativeName != null) {
            this.fileSourceFieldMapFromNative.remove(oldNativeName);
        }
        if (nativeName != null) {
            this.fileSourceFieldMapFromNative.put(nativeName, fsName);
        }
    }

    public final void setFileNameField(String fieldName) {
        this.setFileSourceField(FS_FILE_NAME, fieldName);
    }

    public final void setFileTypeField(String fieldName) {
        this.setFileSourceField(FS_FILE_TYPE, fieldName);
    }

    public final void setFileFormatField(String fieldName) {
        this.setFileSourceField(FS_FILE_FORMAT, fieldName);
    }

    public final void setFileContentsField(String fieldName) {
        this.setFileSourceField(FS_FILE_CONTENTS, fieldName);
    }

    public final void setFileSizeField(String fieldName) {
        this.setFileSourceField(FS_FILE_SIZE, fieldName);
    }

    public final void setFileLastModifiedField(String fieldName) {
        this.setFileSourceField(FS_FILE_LAST_MODIFIED, fieldName);
    }

    public final void setFileTenantIdField(String fieldName) {
        this.setFileSourceField(FS_FILE_TENANT_ID, fieldName);
    }

    public String getFileNameField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_NAME)) {
            this.setFileNameField(this.getFileNameFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_NAME);
    }

    protected String getFileNameFieldWithoutCache() {
        DSField pk;
        String binaryFileNameField;
        String fileContentsFieldName;
        DSField fileContentsField;
        String fileNameField = this.dsConfig.getString("fileNameField");
        if (fileNameField != null) {
            return fileNameField;
        }
        if (!this.preventFileContentsRecursion && (fileContentsField = this.getField(fileContentsFieldName = this.getFileContentsField())) != null && fileContentsField.isBinary() && (binaryFileNameField = this.getFilenameField(fileContentsField)) != null) {
            return binaryFileNameField;
        }
        if (this.getField(FS_FILE_NAME) != null) {
            return FS_FILE_NAME;
        }
        if (this.getField("name") != null) {
            return "name";
        }
        if (this.getField("title") != null) {
            return "title";
        }
        List<String> pks = this.getPrimaryKeys();
        if (pks != null && pks.size() == 1 && "text".equals((pk = this.getField(pks.get(0).toString())).getType())) {
            return pk.getName();
        }
        log.error("DataSource.getFileNameField: No suitable field found for '" + this.getName() + "'");
        return FS_FILE_NAME;
    }

    public String getFileContentsField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_CONTENTS)) {
            this.setFileContentsField(this.getFileContentsFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_CONTENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileContentsFieldWithoutCache() {
        String fileContentsField = this.dsConfig.getString("fileContentsField");
        if (fileContentsField != null) {
            return fileContentsField;
        }
        if (this.getField(FS_FILE_CONTENTS) != null) {
            return FS_FILE_CONTENTS;
        }
        if (this.getField("contents") != null) {
            return "contents";
        }
        for (DSField field : this.getFields()) {
            if (!field.isBinary()) continue;
            return field.getName();
        }
        this.preventFileContentsRecursion = true;
        String fileNameField = null;
        String fileTypeField = null;
        String fileFormatField = null;
        String fileTenantIdField = null;
        try {
            fileNameField = this.getFileNameField();
            fileTypeField = this.getFileTypeField();
            fileFormatField = this.getFileFormatField();
            fileTenantIdField = this.getFileTenantIdField();
        }
        finally {
            this.preventFileContentsRecursion = false;
        }
        long bestLength = 0L;
        String bestFieldName = null;
        for (DSField field : this.getFields()) {
            long length;
            String fieldName;
            if (!"text".equals(field.getType()) || (fieldName = field.getName()).equals(fileNameField) || fieldName.equals(fileTypeField) || fieldName.equals(fileFormatField) || fieldName.equals(fileTenantIdField) || (length = field.getLength().longValue()) <= bestLength) continue;
            bestLength = length;
            bestFieldName = fieldName;
        }
        if (bestFieldName != null) {
            return bestFieldName;
        }
        log.error("DataSource::getFileContentsField() : no suitable field found for '" + this.getName() + "'");
        return FS_FILE_CONTENTS;
    }

    public String getFileTypeField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_TYPE)) {
            this.setFileTypeField(this.getFileTypeFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_TYPE);
    }

    protected String getFileTypeFieldWithoutCache() {
        String fileTypeField = this.dsConfig.getString("fileTypeField");
        if (fileTypeField != null) {
            return fileTypeField;
        }
        if (this.getField(FS_FILE_TYPE) != null) {
            return FS_FILE_TYPE;
        }
        return null;
    }

    public String getFileFormatField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_FORMAT)) {
            this.setFileFormatField(this.getFileFormatFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_FORMAT);
    }

    protected String getFileFormatFieldWithoutCache() {
        String fileFormatField = this.dsConfig.getString("fileFormatField");
        if (fileFormatField != null) {
            return fileFormatField;
        }
        if (this.getField(FS_FILE_FORMAT) != null) {
            return FS_FILE_FORMAT;
        }
        return null;
    }

    public String getFileSizeField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_SIZE)) {
            this.setFileSizeField(this.getFileSizeFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_SIZE);
    }

    protected String getFileSizeFieldWithoutCache() {
        String fileSizeField = this.dsConfig.getString("fileSizeField");
        if (fileSizeField != null) {
            return fileSizeField;
        }
        if (this.getField(FS_FILE_SIZE) != null) {
            return FS_FILE_SIZE;
        }
        return null;
    }

    public String getFileLastModifiedField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_LAST_MODIFIED)) {
            this.setFileLastModifiedField(this.getFileLastModifiedFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_LAST_MODIFIED);
    }

    protected String getFileLastModifiedFieldWithoutCache() {
        String fileLastModifiedField = this.dsConfig.getString("fileLastModifiedField");
        if (fileLastModifiedField != null) {
            return fileLastModifiedField;
        }
        if (this.getField(FS_FILE_LAST_MODIFIED) != null) {
            return FS_FILE_LAST_MODIFIED;
        }
        for (DSField field : this.getFields()) {
            if (!"modifierTimestamp".equals(field.getType())) continue;
            return field.getName();
        }
        return null;
    }

    public String getFileTenantIdField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_TENANT_ID)) {
            this.setFileTenantIdField(this.getFileTenantIdFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_TENANT_ID);
    }

    protected String getFileTenantIdFieldWithoutCache() {
        String fileTenantIdField = this.dsConfig.getString("tenantIdField");
        if (fileTenantIdField != null) {
            return fileTenantIdField;
        }
        if (this.getField(FS_FILE_TENANT_ID) != null) {
            return FS_FILE_TENANT_ID;
        }
        return null;
    }

    public String getFileVersionField() {
        String fileVersionField = this.dsConfig.getString("fileVersionField");
        return fileVersionField != null ? fileVersionField : null;
    }

    public List<String> getFileExtensionFields() {
        String extensionConfig;
        ArrayList<String> fields = new ArrayList<String>();
        if (this.dsConfig.containsKey(FS_EXT_FIELDS) && (extensionConfig = this.dsConfig.getString(FS_EXT_FIELDS)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionConfig, " |:;,");
            while (tokenizer.hasMoreTokens()) {
                String fieldName = tokenizer.nextToken();
                if (this.getField(fieldName) == null) {
                    log.warn("DataSource " + this.getName() + " includes the invalid field '" + fieldName + "' in its declaration of the config property 'fileSourceExtensionFields' - ignoring that field");
                    continue;
                }
                fields.add(fieldName);
            }
        }
        return fields;
    }

    public String getFullFilename(Map values) {
        return this.getFileSourceCacheKey(values, true);
    }

    private String getFileSourceCacheKey(Map values, boolean includeTenantId) {
        StringBuffer filenameBuffer = new StringBuffer();
        String filenameField = this.getFileNameField();
        String fileTypeField = this.getFileTypeField();
        String fileFmtField = this.getFileFormatField();
        String fileMTIdField = this.getFileTenantIdField();
        if (fileMTIdField != null && includeTenantId) {
            Object tenantId = values.get(fileMTIdField);
            if (tenantId instanceof List) {
                tenantId = ((List)tenantId).get(0);
            }
            filenameBuffer.append("mt_");
            filenameBuffer.append(tenantId);
            filenameBuffer.append("_");
        }
        filenameBuffer.append(values.get(filenameField));
        if (fileTypeField != null) {
            filenameBuffer.append("_");
            filenameBuffer.append(values.get(fileTypeField));
        }
        if (fileFmtField != null) {
            filenameBuffer.append("_");
            filenameBuffer.append(values.get(fileFmtField));
        }
        return filenameBuffer.toString();
    }

    public Reader getFile(DSFileSpec fileSpec) throws Exception {
        DSResponse response;
        String textMatchStyle;
        DSRequest fileSpecRequestContext;
        DSRequest req = new DSRequest(this.getName(), OP_GET_FILE);
        req.setValues(fileSpec.getPrimaryKeys(true));
        Object sortBy = fileSpec.getSortBy();
        if (sortBy != null) {
            req.setSortBy(sortBy);
        }
        if ((fileSpecRequestContext = fileSpec.getRequestContext()) != null) {
            req.inheritClientContext(fileSpecRequestContext);
            String userId = fileSpecRequestContext.getUserId();
            if (userId != null) {
                req.setUserId(userId);
            }
        }
        if ((textMatchStyle = fileSpec.getTextMatchStyle()) != null) {
            req.setTextMatchStyle(textMatchStyle);
        }
        if ((response = req.execute()).statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        Map record = response.getDataMap();
        if (record == null) {
            return null;
        }
        Object fileContents = record.get(FS_FILE_CONTENTS);
        if (fileContents == null) {
            return null;
        }
        if (this.getFileTenantIdField() != null && fileSpec.hasFileTenantId() && record.get(FS_FILE_TENANT_ID) == null && "xml".equalsIgnoreCase((String)record.get(FS_FILE_FORMAT)) && fileContents instanceof String) {
            fileContents = "<FileContents _fallbackTenantId=\"true\">" + String.valueOf(fileContents) + "</FileContents>";
        }
        return IOUtil.makeReader(fileContents);
    }

    public String getFileAsString(DSFileSpec fileSpec) throws Exception {
        Reader reader = this.getFile(fileSpec);
        if (reader == null) {
            return null;
        }
        return IOUtil.readerToString(reader);
    }

    public InputStream getFileAsInputStream(DSFileSpec fileSpec) throws Exception {
        String contents = this.getFileAsString(fileSpec);
        if (contents == null) {
            return null;
        }
        return new ByteArrayInputStream(contents.getBytes(Charset.forName("UTF-8")));
    }

    public long getFileSize(DSFileSpec fileSpec) throws Exception {
        String contents = this.getFileAsString(fileSpec);
        if (contents == null) {
            return -1L;
        }
        return contents.length();
    }

    public long getFileLastModified(DSFileSpec fileSpec) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_HAS_FILE);
        req.setValues(fileSpec.getPrimaryKeys());
        req.inheritClientContext(fileSpec.getRequestContext());
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        Map data = response.getDataMap();
        if (data == null) {
            return 0L;
        }
        Object lastModified = data.get(FS_FILE_LAST_MODIFIED);
        if (lastModified == null) {
            return -1L;
        }
        if (lastModified instanceof Date) {
            return ((Date)lastModified).getTime();
        }
        log.error("fileLastModified value was of type: " + lastModified.getClass().getName() + " -- expected java.util.Date");
        return -1L;
    }

    public boolean setFileLastModified(DSFileSpec fileSpec, long lastModified) throws Exception {
        return false;
    }

    public boolean hasFile(DSFileSpec fileSpec) throws Exception {
        DSResponse response;
        String textMatchStyle;
        DSRequest req = new DSRequest(this.getName(), OP_HAS_FILE);
        req.setValues(fileSpec.getPrimaryKeys(true));
        DSRequest fileSpecRequestContext = fileSpec.getRequestContext();
        if (fileSpecRequestContext != null) {
            req.inheritClientContext(fileSpecRequestContext);
            String userId = fileSpecRequestContext.getUserId();
            if (userId != null) {
                req.setUserId(userId);
            }
        }
        if ((textMatchStyle = fileSpec.getTextMatchStyle()) != null) {
            req.setTextMatchStyle(textMatchStyle);
        }
        if ((response = req.execute()).statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        List data = response.getDataList();
        return data != null && !data.isEmpty();
    }

    public Map<String, Object> saveFile(DSFileSpec fileSpec, Object contents) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_SAVE_FILE);
        DSRequest context = fileSpec.getRequestContext();
        if (context != null) {
            req.inheritClientContext(context);
            req.setAllowMultiUpdate(context.getAllowMultiUpdate());
        }
        Map<String, Object> values = fileSpec.getPrimaryKeys();
        values.put(FS_FILE_CONTENTS, contents);
        req.setValues(values);
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        return response.getDataMap();
    }

    public List<Map<String, Object>> listFiles(Object criteria, DSRequest context) throws Exception {
        return this.listFiles(criteria, null, context);
    }

    public List<Map<String, Object>> listFiles(Object criteria, Map requestProperties, DSRequest context) throws Exception {
        DSResponse response;
        DSRequest req = new DSRequest(this.getName(), OP_LIST_FILES);
        if (context != null) {
            req.inheritClientContext(context);
        }
        if (criteria != null) {
            req.setCriteria(criteria);
        }
        if (requestProperties != null) {
            DataTools.setProperties(requestProperties, (Object)req, DataTools.buildMap("invokeNonConformingSetters", "true"));
        }
        if ((response = req.execute()).statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        return response.getDataList();
    }

    public List<Map<String, Object>> listFiles(Object criteria) throws Exception {
        return this.listFiles(criteria, (DSRequest)null);
    }

    public List<Map<String, Object>> listFiles(Object criteria, Map requestProperties) throws Exception {
        return this.listFiles(criteria, requestProperties, (DSRequest)null);
    }

    public List<Map<String, Object>> listFiles(String type, String format, DSRequest context) throws Exception {
        return this.listFiles(type, format, null, context);
    }

    public List<Map<String, Object>> listFiles(String type, String format, String tenantId, DSRequest context) throws Exception {
        HashMap<String, String> criteria = new HashMap<String, String>();
        if (type != null) {
            criteria.put(FS_FILE_TYPE, type);
        }
        if (format != null) {
            criteria.put(FS_FILE_FORMAT, format);
        }
        if (format != null) {
            criteria.put(FS_FILE_FORMAT, format);
        }
        return this.listFiles(criteria, context);
    }

    public List<Map<String, Object>> listFiles(String type, String format) throws Exception {
        return this.listFiles(type, format, (DSRequest)null);
    }

    public List<Map<String, Object>> listFiles(String type, String format, String tenantId) throws Exception {
        return this.listFiles(type, format, tenantId, null);
    }

    public List<Map<String, Object>> listFiles() throws Exception {
        return this.listFiles(null, (DSRequest)null);
    }

    public List<Map<String, Object>> renameFile(DSFileSpec oldSpec, DSFileSpec newSpec) throws Exception {
        String oldTenantId;
        String oldFormat;
        String oldType;
        DSRequest req = new DSRequest(this.getName(), OP_RENAME_FILE);
        req.inheritClientContext(oldSpec.getRequestContext());
        Map<String, Object> values = newSpec.getPrimaryKeys();
        if (!values.containsKey(FS_FILE_TYPE) && (oldType = oldSpec.getFileType()) != null) {
            values.put(FS_FILE_TYPE, oldType);
        }
        if (!values.containsKey(FS_FILE_FORMAT) && (oldFormat = oldSpec.getFileFormat()) != null) {
            values.put(FS_FILE_FORMAT, oldFormat);
        }
        if (!values.containsKey(FS_FILE_TENANT_ID) && (oldTenantId = oldSpec.getFileTenantId()) != null) {
            values.put(FS_FILE_TENANT_ID, oldTenantId);
        }
        req.setValues(values);
        Map<String, Object> oldValues = oldSpec.getPrimaryKeys();
        req.setOldValues(oldValues);
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        DSRequest refetchRequest = new DSRequest(this.getName(), OP_LIST_FILES);
        refetchRequest.inheritClientContext(newSpec.getRequestContext());
        refetchRequest.setCriteria(newSpec.getPrimaryKeys());
        DSResponse refetchResponse = refetchRequest.execute();
        return refetchResponse.getDataList();
    }

    public List<Map<String, Object>> removeFile(DSFileSpec fileSpec) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_REMOVE_FILE);
        DSRequest context = fileSpec.getRequestContext();
        if (context != null) {
            req.inheritClientContext(context);
            req.setAllowMultiUpdate(context.getAllowMultiUpdate());
        }
        req.setValues(fileSpec.getPrimaryKeys());
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        return response.getDataList();
    }

    public Object getLastRow() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ")");
    }

    protected boolean stateCleared() {
        return this._stateCleared;
    }

    protected void setStateCleared(boolean newValue) {
        this._stateCleared = newValue;
    }

    public void clearState() {
        if (this.stateCleared()) {
            return;
        }
        if (this.auditDS != null) {
            if (this.auditDS._isAutoGeneratedAuditDS) {
                this.auditDS.clearState();
            } else {
                DataSource auditDS = this.auditDS;
                this.auditDS = null;
                DataSourceManager.free(auditDS);
            }
        }
        this.clearAnnotatedConfig();
        this.globalServerConfig = null;
        this.serverConfigByOperationId = new DataTypeMap();
        this.setStateCleared(true);
    }

    public List fetch(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        return req.execute().getDataList();
    }

    public List fetch(String key, Object value) throws Exception {
        return this.fetch((Object)DataTools.buildMap(key, value));
    }

    public List filter(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "filter");
        req.setCriteria(criteria);
        return req.execute().getDataList();
    }

    public List filter(String key, Object value) throws Exception {
        return this.filter((Object)DataTools.buildMap(key, value));
    }

    public long add(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_ADD);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long add(Object values, RPCManager rpc) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_ADD, rpc);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long replace(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "replace");
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long update(Object criteria, Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_UPDATE);
        req.setCriteria(criteria);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long update(Object criteria, Object values, RPCManager rpc) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_UPDATE, rpc);
        req.setCriteria(criteria);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long remove(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_REMOVE);
        req.setCriteria(criteria);
        return req.execute().getAffectedRows();
    }

    public long insert(Object values) throws Exception {
        return this.add(values);
    }

    public long delete(Object criteria) throws Exception {
        return this.remove(criteria);
    }

    public List select(Object criteria) throws Exception {
        return this.fetch(criteria);
    }

    public List select(String key, Object value) throws Exception {
        return this.fetch(key, value);
    }

    public Map selectSingle(Object criteria) throws Exception {
        return this.fetchSingle(criteria);
    }

    public Map selectSingle(String key, Object value) throws Exception {
        return this.fetchSingle(key, value);
    }

    public Map selectUnique(Map criteria) throws Exception {
        throw new Exception("not supported by this class");
    }

    public Map fetchSingle(String key, Object value) throws Exception {
        return this.forceSingle(this.fetch(key, value));
    }

    public Map fetchSingle(Object criteria) throws Exception {
        return this.forceSingle(this.fetch(criteria));
    }

    public String getTransactionObjectKey(boolean longForm) throws Exception {
        return this.TRANSACTION_OBJECT_KEY;
    }

    public Object getTransactionObject(DSRequest req) throws Exception {
        return DataSource.getTransactionObject(req, this.getTransactionObjectKey(true), this.getTransactionObjectKey(false));
    }

    public static Object getTransactionObject(DSRequest req, String transactionObjectKey, String shortTransactionObjectKey) throws Exception {
        if (req == null) {
            throw new Exception("DSRequest must not be null");
        }
        DSTransaction dsTransaction = req.getDsTransaction();
        if (dsTransaction == null) {
            return null;
        }
        return dsTransaction.getAttribute(transactionObjectKey);
    }

    public static boolean usesSpringTransaction(DSRequest req, String transactionObjectKey) throws Exception {
        if (req == null) {
            return false;
        }
        DataSource ds = req.getDataSource();
        if (ds == null) {
            return false;
        }
        Boolean useSpring = null;
        DataTypeMap opConfig = ds.getOperationBinding(req);
        if (opConfig != null) {
            useSpring = (Boolean)opConfig.get(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null && req.getPrimaryDSRequest() != null && (opConfig = ds.getOperationBinding(req.getPrimaryDSRequest())) != null) {
            useSpring = (Boolean)opConfig.get(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = (Boolean)ds.dsConfig.get(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = config.getBoolean(transactionObjectKey + ".useSpringTransaction");
        }
        if (useSpring == null) {
            useSpring = config.getBoolean(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = false;
        }
        return useSpring;
    }

    public static Object getSpringTransaction(DSRequest req, String transactionObjectKey) throws Exception {
        if (!DataSource.usesSpringTransaction(req, transactionObjectKey)) {
            return null;
        }
        ISpringTransactionObjectProvider provider = (ISpringTransactionObjectProvider)InterfaceProvider.load("ISpringTransactionObjectProvider");
        return provider.getSpringTransactionObject(transactionObjectKey);
    }

    protected Map forceSingle(List result) throws Exception {
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return (Map)result.get(0);
    }

    protected Object forceSingleObject(List result) throws Exception {
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return result.get(0);
    }

    public String toXML() {
        return this.toXML((Map)((Object)this.dsConfig));
    }

    public String toXML(Map dsConfig) {
        return this.toXML(dsConfig, "DataSource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML(Map dsConfig, String tagName) {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + tagName + " \n");
        ArrayList complexValueKeys = new ArrayList();
        for (Object key : dsConfig.keySet()) {
            Object value = dsConfig.get(key);
            if (value instanceof List || value instanceof Map) {
                if ("fields".equals(key.toString())) continue;
                complexValueKeys.add(key);
                continue;
            }
            buf.append("\t" + String.valueOf(key) + "=\"" + String.valueOf(value) + "\"\n");
        }
        buf.append(">\n");
        buf.append("\n\t<fields>\n");
        Object fieldList = dsConfig.get("fields");
        StringWriter fw = new StringWriter();
        Iterator<Object> fields = null;
        if (fieldList instanceof Map) {
            fields = ((Map)fieldList).values().iterator();
        }
        if (fieldList instanceof List) {
            fields = ((List)fieldList).iterator();
        }
        if (fields != null) {
            DataSource fieldSchema = null;
            try {
                fieldSchema = DataSourceManager.get("DataSourceField");
                while (fields.hasNext()) {
                    fw.write("\t\t");
                    try {
                        XML.recordToXML("field", (Map)fields.next(), fw, true, false, fieldSchema, null);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                log.warn("Couldn't resolve DataSourceField schema.  Field XML may be wrong.");
            }
            finally {
                DataSourceManager.free(fieldSchema);
            }
        }
        buf.append(fw.toString());
        buf.append("\t</fields>\n");
        for (Object key : complexValueKeys) {
            Object value = dsConfig.get(key);
            StringWriter sw = new StringWriter();
            try {
                if (value instanceof List) {
                    buf.append("\t<" + key.toString() + ">\n");
                    for (Object object : (List)value) {
                        if (object instanceof Map) {
                            XML.recordToXML(key.toString().substring(0, key.toString().length() - 1), (Map)object, sw, true, null);
                            continue;
                        }
                        sw.append(ObjectUtils.toString(object));
                    }
                    buf.append("\t\t" + sw.toString());
                    buf.append("\t</" + key.toString() + ">\n");
                    continue;
                }
                if (!(value instanceof Map)) continue;
                XML.recordToXML(key.toString(), (Map)value, sw, true, null);
                buf.append(sw.toString());
            }
            catch (Exception e) {
                log.warn("Unable to XMLSerialize value for key: " + key.toString());
            }
        }
        buf.append("</" + tagName + ">\n");
        return buf.toString();
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS(this.getClientSafeConfig(), out);
    }

    protected Map<String, Object> getClientSafeConfig() {
        Object dsConfig = this.getAnnotatedConfig();
        if (dsConfig == null) {
            dsConfig = this.getConfig();
        }
        HashMap<String, Object> maskedConfig = new HashMap<String, Object>((Map<String, Object>)dsConfig);
        String tableName = (String)maskedConfig.remove("tableName");
        maskedConfig.remove("quoteTableName");
        maskedConfig.remove("dbName");
        maskedConfig.remove("schema");
        maskedConfig.remove("serverConfig");
        maskedConfig.remove("serverObject");
        maskedConfig.remove("serverConstructor");
        maskedConfig.remove("schemaBean");
        maskedConfig.remove("beanClassName");
        maskedConfig.remove("configBean");
        if (!this.isClientOnly()) {
            maskedConfig.remove("requires");
            maskedConfig.remove("requiresAuthentication");
            maskedConfig.remove("requiresRole");
        }
        maskedConfig.remove("creatorOverrides");
        maskedConfig.remove("ownerIdField");
        maskedConfig.remove("guestUserId");
        maskedConfig.remove("projectFileKey");
        maskedConfig.remove("projectFileLocations");
        maskedConfig.remove("lookAhead");
        maskedConfig.remove("endGap");
        maskedConfig.remove("progressiveLoadingThreshold");
        maskedConfig.remove("qualifyColumnNames");
        maskedConfig.remove("quoteColumnNames");
        maskedConfig.remove("sqlPaging");
        maskedConfig.remove("logSlowSQL");
        maskedConfig.remove("logSlowFetch");
        maskedConfig.remove("logSlowAdd");
        maskedConfig.remove("logSlowUpdate");
        maskedConfig.remove("logSlowRemove");
        maskedConfig.remove("logSlowCustom");
        maskedConfig.remove("scriptImport");
        maskedConfig.remove("script");
        maskedConfig.remove("serverOnly");
        maskedConfig.remove("cacheType");
        if (!this.isClientOnly()) {
            maskedConfig.remove("cacheData");
        }
        maskedConfig.remove("fmt");
        maskedConfig.remove("fmt:bundle");
        maskedConfig.remove("auth");
        List operationBindings = (List)maskedConfig.get("operationBindings");
        if (operationBindings != null) {
            ArrayList newBindings = new ArrayList();
            maskedConfig.put("operationBindings", newBindings);
            for (int i = 0; i < operationBindings.size(); ++i) {
                HashMap newBinding = new HashMap((Map)operationBindings.get(i));
                newBinding.remove("serverConfig");
                newBinding.remove("serverObject");
                newBinding.remove("customSQL");
                newBinding.remove("customHQL");
                newBinding.remove("selectClause");
                newBinding.remove("tableClause");
                newBinding.remove("whereClause");
                newBinding.remove("valuesClause");
                newBinding.remove("orderClause");
                newBinding.remove("groupClause");
                newBinding.remove("ansiJoinClause");
                newBinding.remove("groupWhereClause");
                newBinding.remove("language");
                if (!this.isClientOnly()) {
                    newBinding.remove("requires");
                    newBinding.remove("requiresAuthentication");
                    newBinding.remove("requiresRole");
                }
                newBinding.remove("creatorOverrides");
                newBinding.remove("ownerIdField");
                newBinding.remove("guestUserId");
                newBinding.remove("allowMultiUpdate");
                newBinding.remove("customCriteriaFields");
                newBinding.remove("customFields");
                newBinding.remove("customValueFields");
                newBinding.remove("excludeCriteriaFields");
                newBinding.remove("methodArguments");
                newBinding.remove("qualifyColumnNames");
                newBinding.remove("serverMethod");
                newBinding.remove("skipRowCount");
                newBinding.remove("sqlPaging");
                newBinding.remove("sqlType");
                newBinding.remove("scriptImport");
                newBinding.remove("script");
                newBinding.remove("criteria");
                newBinding.remove("values");
                newBinding.remove("mail");
                newBinding.remove("logSlowSQL");
                newBindings.add(newBinding);
            }
        }
        if (this instanceof BasicDataSource && ((BasicDataSource)this).autoDeriveDS != null) {
            DataSource inheritsFrom = ((BasicDataSource)this).autoDeriveDS;
            maskedConfig.put("inheritsFrom", inheritsFrom);
        }
        boolean autoLinkFKs = !Boolean.FALSE.equals(config.getBoolean("datasource.autoLinkFKs"));
        Map fields = (Map)maskedConfig.get("fields");
        if (this instanceof ProvidesAdditionalFields) {
            fields.putAll(((ProvidesAdditionalFields)((Object)this)).getAdditionalFields());
        }
        BasicDataSource superDS = ((BasicDataSource)this).getSuper();
        HashSet<String> suppressedFilenames = new HashSet<String>();
        if (fields != null) {
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (String fieldName : fields.keySet()) {
                String displayFieldName;
                Object fieldObj = fields.get(fieldName);
                boolean bl = false;
                if (!(fieldObj instanceof Map)) {
                    fieldList.add(fieldObj);
                    continue;
                }
                HashMap<String, Object> fieldMap = new HashMap<String, Object>((Map)fieldObj);
                if (!fieldMap.containsKey("name")) {
                    if (!bl) {
                        fieldMap = new LinkedHashMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("name", fieldName);
                }
                if (DataTools.getBoolean(fieldMap, "ignore")) {
                    if (fieldName.toLowerCase().endsWith("_filename")) {
                        suppressedFilenames.add(fieldName.substring(0, fieldName.length() - "_filename".length()));
                    }
                    DSField superField = null;
                    if (superDS != null) {
                        superField = ((DataSource)superDS).getField((String)fieldMap.get("name"));
                    }
                    if (superField == null) continue;
                    if (!bl) {
                        fieldMap = new LinkedHashMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("hidden", true);
                }
                if (fieldMap.get("tableName") != null && fieldMap.get("canEdit") == null) {
                    if (!bl) {
                        fieldMap = new LinkedHashMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("canEdit", Boolean.FALSE);
                }
                if ((displayFieldName = (String)fieldMap.get("displayField")) != null) {
                    HashMap displayFieldMap;
                    String includeFrom;
                    Object explicitUseLocalDisplayFieldValue = fieldMap.get("useLocalDisplayFieldValue");
                    Object explicitForeignDisplayFieldValue = fieldMap.get("foreignDisplayField");
                    Object displayFieldObj = fields.get(displayFieldName);
                    if (displayFieldObj != null && (includeFrom = (String)(displayFieldMap = new HashMap((Map)displayFieldObj)).get("includeFrom")) != null) {
                        if (explicitUseLocalDisplayFieldValue == null) {
                            fieldMap.put("useLocalDisplayFieldValue", true);
                        }
                        if (explicitForeignDisplayFieldValue == null) {
                            String[] path = includeFrom.split("\\.");
                            fieldMap.put("foreignDisplayField", path[path.length - 1]);
                        }
                    }
                }
                try {
                    String typeName = (String)fieldMap.get("type");
                    BasicDataSource cfr_ignored_0 = (BasicDataSource)this;
                    Map typeDef = BasicDataSource.getBuiltinType(typeName);
                    if (typeDef != null) {
                        if (fieldMap.get("hidden") == null && typeDef.get("hidden") != null) {
                            fieldMap.put("hidden", Boolean.valueOf(typeDef.get("hidden").toString()));
                        }
                        if (fieldMap.get("canView") == null && typeDef.get("canView") != null) {
                            fieldMap.put("canView", Boolean.valueOf(typeDef.get("canView").toString()));
                        }
                        if (fieldMap.get("canEdit") == null && typeDef.get("canEdit") != null) {
                            fieldMap.put("canEdit", Boolean.valueOf(typeDef.get("canEdit").toString()));
                        }
                        if (fieldMap.get("canSave") == null && typeDef.get("canSave") != null) {
                            fieldMap.put("canSave", Boolean.valueOf(typeDef.get("canSave").toString()));
                        }
                    }
                }
                catch (Exception e) {
                    log.warn(e);
                }
                String columnName = (String)fieldMap.get("nativeName");
                if (!DataTools.getBoolean(fieldMap, "canView", true) && !this.isClientOnly()) {
                    Iterator keys = fieldMap.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if ("name".equals(key) || "canView".equals(key)) continue;
                        keys.remove();
                    }
                } else {
                    fieldMap.remove("hashCipher");
                    fieldMap.remove("creatorOverrides");
                    fieldMap.remove("autoQuoteCustomExpressions");
                    fieldMap.remove("customCriteriaExpression");
                    fieldMap.remove("customInsertExpression");
                    fieldMap.remove("customSelectExpression");
                    fieldMap.remove("customSQL");
                    fieldMap.remove("customUpdateExpression");
                    fieldMap.remove("serverFormula");
                    if (!this.isClientOnly()) {
                        fieldMap.remove("includeFrom");
                        fieldMap.remove("viewRequires");
                        fieldMap.remove("viewRequiresAuthentication");
                        fieldMap.remove("viewRequiresRole");
                        fieldMap.remove("editRequires");
                        fieldMap.remove("editRequiresAuthentication");
                        fieldMap.remove("editRequiresRole");
                        fieldMap.remove("initRequires");
                        fieldMap.remove("initRequiresAuthentication");
                        fieldMap.remove("initRequiresRole");
                        fieldMap.remove("updateRequires");
                        fieldMap.remove("updateRequiresAuthentication");
                        fieldMap.remove("updateRequiresRole");
                    }
                    fieldMap.remove("javaClass");
                    fieldMap.remove("javaCollectionClass");
                    fieldMap.remove("javaKeyClass");
                    fieldMap.remove("sequenceName");
                    fieldMap.remove("sqlDateFormat");
                    fieldMap.remove("sqlFalseValue");
                    fieldMap.remove("sqlStorageStrategy");
                    fieldMap.remove("sqlTrueValue");
                    fieldMap.remove("tableName");
                    fieldMap.remove("implicitSequence");
                    fieldMap.remove("typeInherited");
                    fieldMap.remove("typeExplicitlyDeclared");
                    fieldMap.remove("__cachedType");
                    fieldMap.remove("isBinary");
                    fieldMap.remove("isJSON");
                    List allValidators = (List)fieldMap.get("validators");
                    ArrayList<Map> publicValidators = new ArrayList<Map>();
                    if (allValidators != null) {
                        for (int j = 0; j < allValidators.size(); ++j) {
                            Map privateMap = (Map)allValidators.get(j);
                            Object[] exclusions = new String[]{"serverObject", "serverCondition"};
                            List inclusions = DataTools.setDisjunction(privateMap.keySet(), DataTools.arrayToList(exclusions));
                            if (inclusions.isEmpty()) continue;
                            publicValidators.add(DataTools.subsetMap(privateMap, inclusions));
                        }
                    }
                    fieldMap.put("validators", publicValidators);
                }
                String nativeFKs = (String)fieldMap.remove("nativeFK");
                if ("sql".equals(this.getType()) && autoLinkFKs) {
                    if (nativeFKs != null) {
                        String[] parts = nativeFKs.split("\\.");
                        try {
                            String tableCode = DataTools.hashValue(parts[0].toLowerCase());
                            String columnCode = DataTools.hashValue(parts[1].toLowerCase());
                            fieldMap.put("fkTableCode", tableCode);
                            fieldMap.put("fkColumnCode", columnCode);
                        }
                        catch (Exception e) {
                            log.error((Object)"Can't hash foreign key", e);
                        }
                    }
                    if (columnName == null && (columnName = (String)fieldMap.get("nativeName")) == null) {
                        columnName = (String)fieldMap.get("name");
                    }
                    try {
                        String columnCode = DataTools.hashValue(columnName.toLowerCase());
                        fieldMap.put("columnCode", columnCode);
                    }
                    catch (Exception e) {
                        log.error((Object)"Can't hash columnName", e);
                    }
                }
                fieldMap.remove("nativeName");
                fieldList.add(fieldMap);
            }
            block12: for (String fieldName : suppressedFilenames) {
                if (fieldName == null) continue;
                for (Map map : fieldList) {
                    String nameInList = (String)map.get("name");
                    if (nameInList == null || !fieldName.toLowerCase().equals(nameInList.toLowerCase())) continue;
                    map.put("filenameSuppressed", true);
                    continue block12;
                }
            }
            maskedConfig.put("fields", fieldList);
        }
        if (useAxisForSQLDS && "sql".equals(this.getType())) {
            dsConfig.put((String)"__autoConstruct", (Object)"WSDataSource");
        }
        if ("sql".equals(this.getType()) && autoLinkFKs) {
            try {
                if (tableName == null) {
                    tableName = (String)maskedConfig.get("ID");
                }
                String tableCode = DataTools.hashValue(tableName.toLowerCase());
                maskedConfig.put("tableCode", tableCode);
            }
            catch (Exception e) {
                log.error((Object)"Can't hash tableName", e);
            }
        }
        return maskedConfig;
    }

    public String getFieldXML() throws Exception {
        return DataSource.getFieldXML(this.fieldList);
    }

    public static String getFieldXML(List fields) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<fields>\n");
        for (Object map : fields) {
            if (!(map instanceof Map)) {
                log.warn("Found object of type " + String.valueOf(map.getClass()) + " in list passed to getFieldXML - was expecting Map");
                continue;
            }
            StringWriter out = new StringWriter();
            XML.recordToXML("field", (Map)map, out);
            xml.append("\t");
            xml.append(out.toString());
        }
        xml.append("</fields>\n");
        return xml.toString();
    }

    public String escapeValueForWhereClause(Object value, Object key) throws Exception {
        return value == null ? null : value.toString();
    }

    public boolean hasRecord(String columnName, Object value) throws Exception {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(columnName, value);
        return this.hasRecord(criteria);
    }

    public boolean hasRecord(Map criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        req.context = req.context;
        DSResponse resp = req.execute();
        return resp.getRowCount() != 0L;
    }

    public Map<String, Object> fetchById(Object id) throws Exception {
        return this.fetchById(id, null);
    }

    public Map<String, Object> fetchById(Object id, RPCManager rpc) throws Exception {
        return this.fetchById(id, rpc, null);
    }

    public Map<String, Object> fetchById(Object id, RPCManager rpc, List<String> outputs) throws Exception {
        return this.fetchById(id, rpc, outputs, false);
    }

    protected Map<String, Object> fetchById(Object id, RPCManager rpc, List<String> outputs, boolean calledFromAudit) throws Exception {
        List<String> pks = this.getPrimaryKeys();
        if (pks.size() == 0) {
            throw new Exception("Cannot fetch by ID - DataSource has no primary key field");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        if (id instanceof Map) {
            for (String fieldName : pks) {
                if (!((Map)id).containsKey(fieldName)) continue;
                criteria.put(fieldName, ((Map)id).get(fieldName));
            }
        } else {
            criteria = new HashMap();
            criteria.put(this.getPrimaryKey(), id);
        }
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        req.context = req.context;
        if (rpc != null) {
            req.setRPCManager(rpc);
        }
        if (outputs != null) {
            req.setOutputs(outputs);
        }
        if (calledFromAudit) {
            req.setIsAuditRequest(true);
        }
        DSResponse resp = req.execute();
        return resp.getRecord();
    }

    public String getEnumTranslateStrategy() {
        String value = (String)this.dsConfig.get("enumTranslateStrategy");
        if (value == null) {
            boolean autoDerive = DataTools.getBoolean(this.dsConfig, "autoDeriveSchema", false);
            value = autoDerive ? "name" : "string";
        }
        return value;
    }

    public void setEnumTranslateStrategy(String newValue) {
        this.dsConfig.put("enumTranslateStrategy", newValue);
    }

    public String getEnumOrdinalProperty() {
        String value = (String)this.dsConfig.get("enumOrdinalProperty");
        if (value == null) {
            value = "_ordinal";
        }
        return value;
    }

    public String getEnumConstantProperty() {
        String value = (String)this.dsConfig.get("enumConstantProperty");
        if (value == null) {
            value = "_constant";
        }
        return value;
    }

    public void setEnumOrdinalProperty(String newValue) {
        this.dsConfig.put("enumOrdinalProperty", newValue);
    }

    public void setEnumConstantProperty(String newValue) {
        this.dsConfig.put("enumConstantProperty", newValue);
    }

    public Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator();
        }
        return this.evaluator;
    }

    public void addSearchOperator(Operator op) {
        this.getEvaluator().addSearchOperator(op);
    }

    public boolean matchesCriteria(Map values, AdvancedCriteria criteria) throws Exception {
        return this.getEvaluator().valuesMatchCriteria(values, criteria);
    }

    public boolean matchesCriteria(Map values, Map rawCriteria) throws Exception {
        AdvancedCriteria criteria = Evaluator.parseAdvancedCriteria(rawCriteria);
        return this.getEvaluator().valuesMatchCriteria(values, criteria);
    }

    @Override
    public void freeResources(DSRequest req) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeQueueResources(DSRequest req) {
        try {
            Map<String, DataSource> includes = req.getCachedDataSourceInstances();
            if (includes != null) {
                Iterator<String> i = includes.keySet().iterator();
                while (i.hasNext()) {
                    DataSource ds = includes.get(i.next());
                    if (ds == this || !req.isDataSourceNull() && ds == req.getDataSource()) continue;
                    DataSourceManager.free(ds);
                }
                includes.clear();
            }
            if (!req.isDataSourceNull() && req.getDataSource() != this) {
                DataSourceManager.free(this);
            }
            if (config.getBoolean((Object)"clear.inInitState.at.queue.end", false)) {
                DataSource.clearInInitState();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception freeing QueueResources", e);
        }
        finally {
            if (!req.isDataSourceNull()) {
                req.clearDataSource();
            }
        }
    }

    public boolean hasRelation(DataSource relatedDS) throws Exception {
        return this.getRelation(relatedDS) != null;
    }

    public boolean isRelatedThroughPrimaryKey(DataSource relatedDS) throws Exception {
        Relation rel = this.getRelation(relatedDS);
        if (rel == null) {
            return false;
        }
        List<DSField> keys = rel.getToFields();
        if (keys == null || keys.size() == 0) {
            return false;
        }
        boolean allPKs = true;
        Iterator<DSField> i = keys.iterator();
        while (i.hasNext()) {
            if (i.next().isPrimaryKey()) continue;
            allPKs = false;
            break;
        }
        return allPKs;
    }

    protected void addCachedRelationInfo(String key, RelationInfo relationInfo) {
        this.cachedRelations.put(key, relationInfo);
    }

    protected void removeCachedRelation(String key) {
        this.cachedRelations.remove(key);
    }

    protected RelationInfo getCachedRelationInfo(String key) {
        return this.cachedRelations.get(key);
    }

    public void clearCachedRelations() {
        this.cachedRelations.clear();
    }

    public Relation getRelation(DataSource relatedDS, String includeVia) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, includeVia, true, null);
    }

    public Relation getRelation(DataSource relatedDS) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, true, null);
    }

    public Relation getRelation(DataSource relatedDS, boolean logProblems) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, logProblems, null);
    }

    public Relation getRelation(DataSource relatedDS, DSRequest dsRequest) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, true, dsRequest);
    }

    public Relation getRelation(DataSource relatedDS, boolean logProblems, DSRequest dsRequest) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, logProblems, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDS, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDS, null, true, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDS, String includeVia, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDS, includeVia, true, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDSArray, boolean logProblems, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDSArray, null, logProblems, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDSArray, String includeVia, boolean logProblems, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDSArray, includeVia, null, logProblems, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDSArray, String includeVia, String queryFK, boolean logProblems, DSRequest dsRequest) throws Exception {
        Relation last;
        Relation r;
        Relation r2;
        DataSource relatedDS;
        Object baseDS;
        ArrayList<Relation> relations;
        RelationContext ctx;
        Object includePath = "";
        for (DataSource ds : relatedDSArray) {
            if (!"".equals(includePath)) {
                includePath = (String)includePath + ".";
            }
            includePath = (String)includePath + ds.getBaseName();
        }
        String cachedRelationKey = (String)includePath + (String)(includeVia != null ? "*iv*" + includeVia : "") + (String)(queryFK != null ? "*qfk*" + queryFK : "");
        String[] includeViaArray = new String[]{includeVia};
        if (includeVia != null && includeVia.contains(".")) {
            includeViaArray = includeVia.split("\\.");
        }
        HashMap<String, DataSource> inInitState = DataSource.getInInitState();
        Map<String, DataSource> dsObjectsMap = dsRequest != null ? dsRequest.getCachedDataSourceInstances() : inInitState;
        dsObjectsMap.putAll(inInitState);
        if (this.getCachedRelationInfo(cachedRelationKey) != null && dsObjectsMap != null) {
            log.debug("Returning cached relation for " + this.getName() + " -> " + (String)includePath + " (the relation is not necessarily direct)");
            return Relation.create(this.getCachedRelationInfo(cachedRelationKey), dsObjectsMap, dsRequest);
        }
        Relation relation = null;
        RelationContext relationContext = ctx = includeVia != null && !includeVia.trim().isEmpty() ? RelationContext.instance(includeVia, false) : RelationContext.instance(queryFK, true);
        if (relatedDSArray.length == 1) {
            relation = DataSource._getRelation(this, relatedDSArray[0], logProblems, dsObjectsMap, null, false, ctx);
        } else {
            relations = new ArrayList<Relation>();
            for (int i = -1; i < relatedDSArray.length - 1; ++i) {
                baseDS = i >= 0 ? relatedDSArray[i] : this;
                r2 = DataSource._getRelation((DataSource)baseDS, relatedDS = relatedDSArray[i + 1], logProblems, dsObjectsMap, null, false, ctx);
                if (r2 == null || !r2.isValid()) {
                    relations.clear();
                    break;
                }
                relations.add(r2);
            }
            r = null;
            for (Relation x : relations) {
                if (relation == null) {
                    relation = x;
                } else {
                    last = r;
                    while (last.getNextRelation() != null) {
                        last = last.getNextRelation();
                    }
                    last.setNextRelation(x);
                }
                r = x;
            }
        }
        if (relation == null || !relation.isValid() || ctx != null && !ctx.finished()) {
            relation = null;
            RelationContext relationContext2 = ctx = includeVia != null && !includeVia.trim().isEmpty() ? RelationContext.instance(includeVia, true) : RelationContext.instance(queryFK, false);
            if (relatedDSArray.length == 1) {
                relation = DataSource._getRelation(relatedDSArray[0], this, logProblems, dsObjectsMap, null, false, ctx);
            } else {
                relations = new ArrayList();
                for (int i = relatedDSArray.length - 1; i >= 0; --i) {
                    baseDS = relatedDSArray[i];
                    relatedDS = i > 0 ? relatedDSArray[i - 1] : this;
                    r2 = DataSource._getRelation(baseDS, relatedDS, logProblems, dsObjectsMap, null, false, ctx);
                    if (r2 == null || !r2.isValid()) {
                        relations.clear();
                        break;
                    }
                    relations.add(r2);
                }
                r = null;
                for (Relation x : relations) {
                    if (relation == null) {
                        relation = x;
                    } else {
                        last = r;
                        while (last.getNextRelation() != null) {
                            last = last.getNextRelation();
                        }
                        last.setNextRelation(x);
                    }
                    r = x;
                }
            }
            if (relation != null) {
                relation.setInverse();
            }
        }
        String nextDS = "";
        if (relation != null && relation.isValid() && (ctx == null || ctx.finished())) {
            relation = DataSource.inverseRelation(relation);
            String msg = "Path selected from " + this.getName() + " to " + (String)includePath + ": ";
            for (Relation r3 = relation; r3 != null; r3 = r3.getNextRelation()) {
                msg = msg + " -> " + r3.getFromDataSource().getName();
                nextDS = r3.getToDataSource().getName();
            }
            msg = msg + " -> " + nextDS;
            log.debug(msg);
            this.addCachedRelationInfo(cachedRelationKey, RelationInfo.create(relation));
            return relation;
        }
        String message = "DataSource " + this.getName() + " includes fields from DataSource " + (String)includePath + " but we cannot establish a direct or indirect relation between those DataSources.  You must specify foreignKey field(s) on the including DataSource (" + this.getName() + ") that either express a direct relationship to " + (String)includePath + ", or express an indirect relationship via one or more intervening tables";
        if (logProblems) {
            log.warn(message);
        }
        return null;
    }

    public static Relation inverseRelation(Relation relation) {
        Relation r;
        if (!relation.getInverse()) {
            return relation;
        }
        ArrayList<Relation> listFrom = new ArrayList<Relation>();
        for (r = relation; r != null; r = r.getNextRelation()) {
            listFrom.add(r);
        }
        Relation result = new Relation();
        Relation work = null;
        for (int i = listFrom.size() - 1; i >= 0; --i) {
            if (work == null) {
                work = result;
            } else {
                Relation previous = work;
                work = new Relation();
                previous.setNextRelation(work);
            }
            r = (Relation)listFrom.get(i);
            work.setFromDataSource(r.getToDataSource());
            work.setFromAlias(r.getToAlias());
            work.setFromFields(r.getToFields());
            work.setToDataSource(r.getFromDataSource());
            work.setToAlias(r.getFromAlias());
            work.setToFields(r.getFromFields());
            work.setJoinType(r.getJoinType());
            work.setOtherFK(!r.getOtherFK());
        }
        return result;
    }

    public static Relation _getRelation(DataSource baseDS, DataSource relatedDS, boolean logProblems, Map<String, DataSource> dsObjectsMap, Map seenBefore, boolean directOnly, RelationContext ctx) throws Exception {
        String[] parsed;
        List<String> allFKs;
        List<String> ctxFields;
        boolean checkDSFields;
        Relation relation = new Relation();
        relation.setFromDataSource(baseDS);
        relation.setToDataSource(relatedDS);
        boolean foundLink = false;
        HashMap<String, List<DSField>> fkSets = new HashMap<String, List<DSField>>();
        boolean checkCtxFields = ctx != null && !ctx.empty() && !ctx.finished();
        boolean bl = checkDSFields = ctx == null || !ctx.inUse() || ctx.finished();
        while (checkCtxFields || checkDSFields) {
            List<DSField> baseFields = null;
            if (checkCtxFields && (ctx.ds() == null || baseDS.getBaseName().equals(ctx.ds())) && (ctxFields = ctx.fields()) != null && !ctxFields.isEmpty()) {
                for (DSField f : baseDS.getFields()) {
                    if (!ctxFields.contains(f.getName())) continue;
                    if (baseFields == null) {
                        baseFields = new ArrayList<DSField>();
                    }
                    baseFields.add(f);
                }
                if (baseFields == null || ctxFields == null || baseFields.size() != ctxFields.size()) {
                    baseFields = null;
                }
            }
            if (baseFields == null) {
                if (!checkDSFields) break;
                checkCtxFields = false;
                baseFields = baseDS.getFields();
            }
            for (DSField dSField : baseFields) {
                allFKs = dSField.getAllFKs(false, true);
                if (allFKs.isEmpty()) continue;
                boolean otherFK = false;
                for (String fk : allFKs) {
                    List<DSField> fks;
                    String[] parsed2 = fk.split("\\.");
                    String dsName = null;
                    if (parsed2.length == 1) {
                        dsName = baseDS.getBaseName();
                        if (baseDS.getName().equals(relatedDS.getName()) && (ctx == null || ctx.validateField(dsName, dSField.getName()))) {
                            relation.addFromField(dSField);
                            relation.addToField(baseDS.getField(parsed2[0]));
                            relation.setJoinType(dSField.getJoinType());
                            relation.setOtherFK(otherFK);
                            foundLink = true;
                        }
                    } else {
                        dsName = parsed2[0];
                        if (!(parsed2.length != 2 || !relatedDS.getBaseName().equals(parsed2[0]) || relation.getToFields() != null && relation.getToFields().contains(relatedDS.getField(parsed2[1])) || relation.getFromFields() != null && relation.getFromFields().contains(baseDS.getField(parsed2[1])) || ctx != null && !ctx.validateField(baseDS.getBaseName(), dSField.getName()))) {
                            relation.addFromField(dSField);
                            relation.addToField(relatedDS.getField(parsed2[1]));
                            relation.setJoinType(dSField.getJoinType());
                            relation.setOtherFK(otherFK);
                            foundLink = true;
                        }
                    }
                    if (fkSets.containsKey(dsName)) {
                        fks = (List)fkSets.get(dsName);
                    } else {
                        fks = new ArrayList();
                        fkSets.put(dsName, fks);
                    }
                    fks.add(dSField);
                    otherFK = true;
                }
                if (ctx == null || ctx.finished() || !ctx.drafted()) continue;
                if (foundLink) {
                    ctx.confirmField(dSField.getName());
                    continue;
                }
                ctx.cancelField(dSField.getName());
            }
            if (ctx != null && !ctx.empty() && !ctx.finished() && ctx.drafted()) {
                if (ctx.validDraft()) {
                    ctx.next();
                    break;
                }
                ctx.cancel();
            }
            if (!checkCtxFields && checkDSFields) break;
            checkCtxFields = false;
        }
        if (!foundLink) {
            checkCtxFields = ctx != null && !ctx.empty() && !ctx.finished();
            boolean bl2 = checkDSFields = ctx == null || !ctx.inUse() || ctx.finished();
            while (checkCtxFields || checkDSFields) {
                List<DSField> relatedFields = null;
                if (checkCtxFields && (ctx.ds() == null || relatedDS.getBaseName().equals(ctx.ds())) && (ctxFields = ctx.fields()) != null && !ctxFields.isEmpty()) {
                    for (DSField f : relatedDS.getFields()) {
                        if (!ctxFields.contains(f.getName())) continue;
                        if (relatedFields == null) {
                            relatedFields = new ArrayList<DSField>();
                        }
                        relatedFields.add(f);
                    }
                    if (relatedFields != null && ctxFields != null && relatedFields.size() != ctxFields.size()) {
                        relatedFields = null;
                    }
                }
                if (relatedFields == null) {
                    if (!checkDSFields) break;
                    checkCtxFields = false;
                    relatedFields = relatedDS.getFields();
                }
                for (DSField dSField : relatedFields) {
                    allFKs = dSField.getAllFKs(false, true);
                    if (allFKs.isEmpty()) continue;
                    for (String fk : allFKs) {
                        parsed = fk.split("\\.");
                        if (parsed.length == 1) {
                            if (!relatedDS.getBaseName().equals(baseDS.getBaseName()) || ctx != null && !ctx.validateField(relatedDS.getBaseName(), dSField.getName())) continue;
                            relation.addFromField(dSField);
                            relation.addToField(baseDS.getField(parsed[0]));
                            relation.setJoinType(dSField.getJoinType());
                            relation.setOtherFK(true);
                            foundLink = true;
                            continue;
                        }
                        if (parsed.length != 2 || !baseDS.getBaseName().equals(parsed[0]) || relation.getToFields() != null && relation.getToFields().contains(relatedDS.getField(parsed[1])) || relation.getFromFields() != null && relation.getFromFields().contains(baseDS.getField(parsed[1])) || ctx != null && !ctx.validateField(relatedDS.getBaseName(), dSField.getName())) continue;
                        relation.addFromField(baseDS.getField(parsed[1]));
                        relation.addToField(dSField);
                        int joinType = dSField.getJoinType(false);
                        relation.setJoinType(joinType == -1 ? 1 : joinType);
                        relation.setOtherFK(true);
                        foundLink = true;
                    }
                    if (ctx == null || ctx.finished() || !ctx.drafted()) continue;
                    if (foundLink) {
                        ctx.confirmField(dSField.getName());
                        continue;
                    }
                    ctx.cancelField(dSField.getName());
                }
                if (ctx != null && !ctx.empty() && !ctx.finished() && ctx.drafted()) {
                    if (ctx.validDraft()) {
                        ctx.next();
                        break;
                    }
                    ctx.cancel();
                }
                if (!checkCtxFields && checkDSFields) break;
                checkCtxFields = false;
            }
        }
        if (directOnly) {
            return relation;
        }
        if (!foundLink && dsObjectsMap != null) {
            foundLink = DataSource._findIndirectRelation(relation, baseDS, relatedDS, fkSets, dsObjectsMap, logProblems, seenBefore, ctx);
        }
        if (!foundLink && dsObjectsMap != null) {
            for (DSField field : baseDS.getFields()) {
                List<String> list = field.getAllFKs(true, false);
                if (list.isEmpty()) continue;
                boolean otherFK = false;
                for (String fk : list) {
                    parsed = fk.split("\\.");
                    String dsName = null;
                    if (parsed.length != 3) continue;
                    dsName = parsed[1];
                    if (!relatedDS.getBaseName().equals(dsName)) continue;
                    String joinDSName = parsed[0];
                    DataSource joinDS = DataSourceManager.get(joinDSName);
                    if (joinDS == null) {
                        log.warn("Looking for relation " + fk + " declared for field " + field.getName() + " in DataSource " + baseDS.getName() + ", the join dataSource (" + joinDSName + ") does not exist");
                        continue;
                    }
                    for (DSField joinField : joinDS.getFields()) {
                        String[] joinParsed;
                        String joinFK = joinField.getForeignKey();
                        if (joinFK == null || joinFK.isEmpty() || (joinParsed = joinFK.split("\\.")).length != 2 || !baseDS.getBaseName().equals(joinParsed[0]) || !joinParsed[1].equals(baseDS.getPrimaryKey())) continue;
                        relation.setToDataSource(joinDS);
                        relation.addFromField(baseDS.getField(baseDS.getPrimaryKey()));
                        relation.addToField(joinField);
                        int joinType = field.getJoinType(false);
                        relation.setJoinType(joinType == -1 ? 1 : joinType);
                        relation.setOtherFK(false);
                        Relation nextRelation = DataSource._getRelation(joinDS, relatedDS, logProblems, dsObjectsMap, seenBefore, false, ctx);
                        if (nextRelation == null) {
                            log.warn("Looking for relation " + fk + " declared for field " + field.getName() + " in DataSource " + baseDS.getName() + ", join DataSource '" + joinDSName + "' is not related to the target DataSource '" + relatedDS.getName() + "'");
                            continue;
                        }
                        joinType = nextRelation.getFromFields().get(0).getJoinType(false);
                        nextRelation.setJoinType(joinType == -1 ? 1 : joinType);
                        relation.setNextRelation(nextRelation);
                        foundLink = true;
                        break;
                    }
                    if (foundLink) continue;
                    log.warn("Unable to discover relation " + fk + " declared for field " + field.getName() + " in DataSource " + baseDS.getName() + " after looking for a many-many link using a join dataSource");
                }
            }
        }
        return relation;
    }

    private static boolean _findIndirectRelation(Relation relation, DataSource baseDS, DataSource relatedDS, Map<String, List<DSField>> fkSets, Map<String, DataSource> dsObjectsMap, boolean logProblems, Map seenBefore, RelationContext ctx) throws Exception {
        List fks;
        boolean topLevelLookup = seenBefore == null;
        ArrayList candidates = new ArrayList();
        for (String dsName : fkSets.keySet()) {
            if (topLevelLookup) {
                seenBefore = new HashMap<String, DataSource>();
            }
            if (seenBefore.containsKey(dsName)) continue;
            DataSource ds = dsObjectsMap.get(dsName);
            if (ds == null) {
                ds = DataSourceManager.get(dsName, null);
                if (ds == null) {
                    throw new Exception("DataSource '" + baseDS.getName() + "' declares a foreignKey relation to DataSource '" + dsName + "', which does not exist.");
                }
                dsObjectsMap.put(dsName, ds);
            }
            seenBefore.put(dsName, ds);
            fks = fkSets.get(dsName);
            boolean compositeFK = true;
            ArrayList<String> seenFKValues = new ArrayList<String>();
            for (DSField fk : fks) {
                if (seenFKValues.contains(fk.getForeignKey())) {
                    compositeFK = false;
                    break;
                }
                seenFKValues.add(fk.getForeignKey());
            }
            if (compositeFK && fks.size() > 1) {
                Relation candidate;
                RelationContext localCtx = RelationContext.instance(ctx);
                Relation rootRelation = null;
                if (localCtx != null && ((rootRelation = DataSource._getRelation(baseDS, ds, logProblems, dsObjectsMap, seenBefore, true, localCtx)) == null || !rootRelation.isValid()) || (candidate = DataSource._getRelation(ds, relatedDS, logProblems, dsObjectsMap, seenBefore, false, localCtx)) == null || !candidate.isValid()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("rootRelation", rootRelation);
                map.put("relation", candidate);
                map.put("ds", ds);
                map.put("fks", fks);
                map.put("ctx", localCtx);
                candidates.add(map);
                continue;
            }
            for (final DSField fkField : fks) {
                Relation candidate;
                RelationContext localCtx = RelationContext.instance(ctx);
                Relation rootRelation = null;
                if (localCtx != null && ((rootRelation = DataSource._getRelation(baseDS, ds, logProblems, dsObjectsMap, seenBefore, true, localCtx)) == null || !rootRelation.isValid()) || (candidate = DataSource._getRelation(ds, relatedDS, logProblems, dsObjectsMap, seenBefore, false, localCtx)) == null || !candidate.isValid()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("rootRelation", rootRelation);
                map.put("relation", candidate);
                map.put("ds", ds);
                map.put("ctx", localCtx);
                map.put("fks", new ArrayList(){
                    {
                        this.add(fkField);
                    }
                });
                candidates.add(map);
            }
        }
        int shortest = Integer.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < candidates.size(); ++i) {
            Relation r = (Relation)((Map)candidates.get(i)).get("relation");
            int length = 1;
            while (r.getNextRelation() != null) {
                r = r.getNextRelation();
                ++length;
            }
            if (length < shortest) {
                shortest = length;
                index = i;
                String msg = "Found new shortest path from " + baseDS.getName() + " to " + relatedDS.getName() + ".  Path is: " + baseDS.getName();
                String nextDS = "";
                for (r = (Relation)((Map)candidates.get(i)).get("relation"); r != null; r = r.getNextRelation()) {
                    msg = msg + " -> " + r.getFromDataSource().getName();
                    nextDS = r.getToDataSource().getName();
                }
                msg = msg + " -> " + nextDS;
                log.debug(msg);
                continue;
            }
            String nextDS = "";
            String msg = "Ignoring a path from " + baseDS.getName() + " to " + relatedDS.getName() + " - we already know of one at least as as short.  The ignored path is: " + baseDS.getName();
            for (r = (Relation)((Map)candidates.get(i)).get("relation"); r != null; r = r.getNextRelation()) {
                msg = msg + " -> " + r.getFromDataSource().getName();
                nextDS = r.getToDataSource().getName();
            }
            msg = msg + " -> " + nextDS;
            log.debug(msg);
        }
        if (index != -1) {
            Relation root;
            DataSource ds = (DataSource)((Map)candidates.get(index)).get("ds");
            fks = (List)((Map)candidates.get(index)).get("fks");
            Relation selected = (Relation)((Map)candidates.get(index)).get("relation");
            relation.setToDataSource(ds);
            RelationContext localCtx = (RelationContext)((Map)candidates.get(index)).get("ctx");
            if (localCtx != null) {
                ctx.setState(localCtx);
            }
            if ((root = (Relation)((Map)candidates.get(index)).get("rootRelation")) != null) {
                relation.setFromFields(root.getFromFields());
                relation.setToFields(root.getToFields());
                relation.setJoinType(root.getJoinType());
            } else {
                for (DSField field : fks) {
                    String[] parsed = field.getForeignKey().split("\\.");
                    if (parsed.length == 1) {
                        if (!ds.getName().equals(ds.getName())) continue;
                        relation.addToField(field);
                        relation.setJoinType(field.getJoinType());
                        continue;
                    }
                    if (parsed.length != 2 || !ds.getName().equals(parsed[0]) || relation.getToFields() != null && relation.getToFields().contains(ds.getField(parsed[1])) || relation.getFromFields() != null && relation.getFromFields().contains(field)) continue;
                    relation.addFromField(field);
                    relation.addToField(ds.getField(parsed[1]));
                    relation.setJoinType(field.getJoinType());
                }
            }
            relation.setNextRelation(selected);
        }
        return index != -1;
    }

    public String getProperty(String key) {
        return this.dsConfig.getString(key, null);
    }

    public Object getObjectProperty(String key) {
        return this.dsConfig.get(key);
    }

    public List getListProperty(String key) {
        return (List)this.dsConfig.get(key);
    }

    public DataTypeMap getMapProperty(String key) {
        return this.dsConfig.getMap(key);
    }

    public boolean canJoinIncludedFields() {
        return false;
    }

    public boolean inheritsParent() {
        return false;
    }

    public List getLocalFieldNames() {
        Map fields = this.getRawFields();
        if (fields == null) {
            return new ArrayList();
        }
        return new ArrayList(fields.keySet());
    }

    public List getLocalFields() {
        List fieldNames = this.getLocalFieldNames();
        ArrayList<DSField> fields = new ArrayList<DSField>();
        if (fieldNames != null) {
            Iterator i = fieldNames.iterator();
            while (i.hasNext()) {
                fields.add(this.getField((String)i.next()));
            }
        }
        return fields;
    }

    public boolean isInherited(DSField field) {
        String name = field.getName();
        for (DataSource ds = this.getSuper(); ds != null; ds = ds.getSuper()) {
            List locals = ds.getLocalFieldNames();
            if (locals.contains(name)) {
                return true;
            }
            if (ds == ds.getSuper()) break;
        }
        return false;
    }

    public boolean isPureInherited(DSField field) {
        String name;
        List locals = this.getLocalFieldNames();
        if (locals.contains(name = field.getName())) {
            return false;
        }
        return this.isInherited(field);
    }

    public boolean isAutoDerived(DSField field) {
        DataSource autoDerive = this.getAutoDeriveDS();
        if (autoDerive == null) {
            return false;
        }
        List fields = autoDerive.getLocalFieldNames();
        String name = field.getName();
        return fields.contains(name);
    }

    public boolean isPureAutoDerived(DSField field) {
        String name;
        List locals = this.getLocalFieldNames();
        if (locals.contains(name = field.getName())) {
            return false;
        }
        return this.isAutoDerived(field);
    }

    protected DataSource getSuper() {
        return null;
    }

    protected DataSource getSuper(ValidationContext context) {
        return null;
    }

    public DataSource getAutoDeriveDS() {
        return null;
    }

    public boolean isBinaryMetadata(DSField field) {
        if (field == null) {
            return false;
        }
        String name = field.getName();
        List<String> fields = this.getFieldNames();
        String[] sfx = new String[]{"_filename", "_filesize", "_date_created"};
        for (int i = 0; i < sfx.length; ++i) {
            if (!name.endsWith(sfx[i]) || !fields.contains(name.substring(0, name.length() - sfx[i].length()))) continue;
            return true;
        }
        return false;
    }

    public String getFilenameField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getFilenameField(baseField.getName());
    }

    public String getFilenameField(String baseFieldName) {
        if (this.filenameField.containsKey(baseFieldName)) {
            return this.filenameField.get(baseFieldName);
        }
        this.filenameField.put(baseFieldName, this.getMetadataField(baseFieldName, "_filename"));
        return this.filenameField.get(baseFieldName);
    }

    public String getFilesizeField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getFilesizeField(baseField.getName());
    }

    public String getFilesizeField(String baseFieldName) {
        if (this.filesizeField.containsKey(baseFieldName)) {
            return this.filesizeField.get(baseFieldName);
        }
        this.filesizeField.put(baseFieldName, this.getMetadataField(baseFieldName, "_filesize"));
        return this.filesizeField.get(baseFieldName);
    }

    public String getDateCreatedField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getDateCreatedField(baseField.getName());
    }

    public String getDateCreatedField(String baseFieldName) {
        if (this.dateCreatedField.containsKey(baseFieldName)) {
            return this.dateCreatedField.get(baseFieldName);
        }
        this.dateCreatedField.put(baseFieldName, this.getMetadataField(baseFieldName, "_date_created"));
        return this.dateCreatedField.get(baseFieldName);
    }

    protected String getMetadataField(String baseFieldName, String suffix) {
        String fld = baseFieldName + suffix;
        List<String> fields = this.getFieldNames();
        for (int i = 0; i < fields.size(); ++i) {
            if (!fld.equalsIgnoreCase(fields.get(i))) continue;
            return fields.get(i);
        }
        return fld;
    }

    public static AdvancedCriteria parseAdvancedCriteria(Map rawCriteria) {
        return Evaluator.parseAdvancedCriteria(rawCriteria);
    }

    public boolean handlesRelations() {
        return false;
    }

    public boolean embedsRelatedObjects() {
        return false;
    }

    public boolean handlesNto1Relations() {
        return false;
    }

    protected Object getRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, List recursedList, ValidationContext vc) throws Exception {
        return DataTools.getProperties(obj, DataTools.buildList(relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
    }

    protected void setRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, Object value) throws Exception {
        DataTools.setProperties((Map)((Object)DataTools.buildMap(relationFieldInfo.getFieldName(), value)), obj, this);
    }

    protected void markIncFromAsAmbiguous(String newField, String existingField, String incFromKey) {
        if (this.ambiguousIncFrom == null) {
            this.ambiguousIncFrom = new LinkedHashMap<String, String>();
        }
        if (!this.ambiguousIncFrom.containsKey(newField)) {
            this.ambiguousIncFrom.put(newField, existingField);
        }
    }

    protected void reportAmbiguousIncFrom() {
        if (this.ambiguousIncFrom != null) {
            for (Map.Entry<String, String> report : this.ambiguousIncFrom.entrySet()) {
                String reportedField = report.getKey();
                String existingField = report.getValue();
                log.warn("Field definition '" + reportedField + "' of the '" + this.getName() + "' DataSource includes the same field from the same related DataSource as does the '" + existingField + "' field. This is not allowed, for more details see the 'Ambiguous includeFrom definitions and logging' section of includeVia docs in Smartclient reference.");
            }
        }
    }

    protected boolean isIncFromAmbiguous(IncludeFromDefinition def) {
        if (this.includeFromFields != null && def != null) {
            String incFromKey = DataSource.buildIncFromKey(def);
            for (Map.Entry<String, IncludeFromInfo> report : this.includeFromFields.entrySet()) {
                if (!incFromKey.equals(report.getValue().getKey()) || def.getThisFieldName().equals(report.getValue().getThisFieldName())) continue;
                if (def.isDynamic()) {
                    log.warn("Dynamic field '" + def.getThisFieldName() + "' includes the same field from the same related DataSource as does the '" + report.getValue().getThisFieldName() + "' field. This is not allowed, for more details see the 'Ambiguous includeFrom definitions and logging' section of includeVia docs in Smartclient reference.");
                }
                return true;
            }
        }
        return false;
    }

    static String buildIncFromKey(IncludeFromDefinition def) {
        return DataSource.buildIncFromKey(def.getThisDataSource().getBaseName(), def.getIncludePath() + "." + def.getIncludedFieldName(), def.getIncludeVia(), def.getThisField() != null ? def.getThisField().getString("includeSummaryFunction") : null, def.getThisField() != null ? def.getThisField().getString("valueOperation") : null, def.isCriteria(), def.isSortBy());
    }

    static String buildIncFromKey(String ds, String includeFrom, String includeVia, String function, String valueOperation, boolean isCriteria, boolean isSortBy) {
        return new StringBuffer().append(ds).append("___").append(includeFrom).append("___").append(includeVia).append("___").append(function).append("___").append(valueOperation).append("___").append(isCriteria).append("___").append(isSortBy).toString();
    }

    protected IncludeFromInfo getIncludeFromInfo(DSField field, DSRequest dsRequest) throws Exception {
        String incFromKey;
        Map includeFromsAlreadySeen;
        HashMap<String, DataSource> inInitState = DataSource.getInInitState();
        if (dsRequest == null) {
            dsRequest = new DSRequest();
        }
        if (this.includeFromFields != null && this.includeFromFields.get(field.getName()) != null) {
            return this.includeFromFields.get(field.getName());
        }
        String includePath = null;
        String includedFieldName = null;
        String operationId = null;
        String text = (String)field.get("includeFrom");
        if (text != null) {
            parsed = text.split("\\.");
            if (parsed.length < 2) {
                log.warn("Field " + field.getName() + " has invalid IncludeFromDefinition definition: '" + text + "'.  Should be of the form 'dataSourceName.fieldName'. You can also define multiple data sources to request certain  path to connect indirectly related data sources: 'dataSourceName1.dataSourceName2.fieldName'.");
                return null;
            }
            includePath = text.substring(0, text.lastIndexOf("."));
            includedFieldName = text.substring(text.lastIndexOf(".") + 1);
        } else {
            text = (String)field.get("valueOperation");
            if (text != null) {
                parsed = text.split("\\.");
                if (parsed.length < 2 || parsed.length > 3) {
                    log.warn("Field '" + field.getName() + "' has invalid valueOperation: '" + text + "'. Should be of the form 'dataSourceName.operationId.fieldName' or 'operationId.fieldName' if valueOperation targets same dataSource.");
                    return null;
                }
                includedFieldName = parsed[parsed.length - 1];
                operationId = parsed[parsed.length - 2];
                String string = includePath = parsed.length == 2 ? this.getBaseName() : parsed[0];
            }
        }
        if (dsRequest.getAttribute("_includeFromsAlreadySeen") == null) {
            dsRequest.setAttribute("_includeFromsAlreadySeen", new HashMap());
        }
        if ((includeFromsAlreadySeen = (Map)dsRequest.getAttribute("_includeFromsAlreadySeen")).containsKey(incFromKey = DataSource.buildIncFromKey(this.getBaseName(), text, field.getString("includeVia"), field.getString("includeSummaryFunction"), field.getString("valueOperation"), false, false))) {
            IncludeFromInfo cached = (IncludeFromInfo)includeFromsAlreadySeen.get(incFromKey);
            if (cached != null && incFromKey.equals(cached.getKey()) && !DataTools.equals(cached.getThisFieldName(), field.getName())) {
                this.markIncFromAsAmbiguous(field.getName(), cached.getThisFieldName(), incFromKey);
            } else {
                return cached;
            }
        }
        if (includePath != null) {
            DataSource includeFromDS;
            DSField includedField;
            IncludeFromInfo includeFromInfo = new IncludeFromInfo();
            String[] parsed = includePath.split("\\.");
            DataSource[] dataSources = new DataSource[parsed.length];
            String[] dataSourceNames = new String[parsed.length];
            for (int i = 0; i < parsed.length; ++i) {
                String dsName = parsed[i];
                DataSource ds = inInitState.get(dsName);
                if (ds == null && dsRequest != null) {
                    ds = dsRequest.getCachedDataSourceInstance(dsName);
                }
                if (ds == null && (ds = DataSourceManager.get(dsName, dsRequest)) != null && dsRequest != null) {
                    log.debug("Caching instance " + String.valueOf(ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of DS '" + dsName + "' from getIncludeFromInfo()");
                    dsRequest.cacheDataSourceInstance(dsName, ds);
                }
                if (ds == null) {
                    log.warn("includeFrom field named '" + field.getName() + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                    return null;
                }
                dataSources[i] = ds;
                dataSourceNames[i] = dsName;
            }
            includeFromInfo.setThisDataSourceName(this.getBaseName());
            includeFromInfo.setThisFieldName(field.getName());
            includeFromInfo.setIncludedFieldName(includedFieldName);
            includeFromInfo.setIncludePath(includePath);
            includeFromInfo.setDataSourceNames(dataSourceNames);
            includeFromInfo.setValueOperationId(operationId);
            String includeVia = field.getProperty("includeVia");
            Relation relationObject = this.getRelation(dataSources, includeVia, dsRequest);
            if (relationObject == null || !relationObject.isValid()) {
                log.warn("includeFrom field named '" + field.getName() + "' refers to a related DataSource ('" + dataSourceNames[dataSourceNames.length - 1] + "'). Failed to discover relation between data sources. Ignoring this field.");
                return null;
            }
            includeFromInfo.setRelation(RelationInfo.create(relationObject));
            if (includeVia != null && !"".equals(includeVia.trim())) {
                includeFromInfo.setIncludeVia(includeVia);
            }
            if ((includedField = (includeFromDS = dataSources[dataSources.length - 1]).getField(includedFieldName)) == null) {
                DSField addOutFld = dsRequest.getAdditionalOutputsField(includedFieldName);
                if (addOutFld != null) {
                    includedField = addOutFld;
                }
                if (includedField == null) {
                    log.warn("includeFrom field named '" + field.getName() + "' refers to a '" + includedFieldName + "' field that does not exist in '" + includeFromDS.getName() + "' data source. Ignoring this field.");
                    return null;
                }
            }
            if (this.getName().equals(includeFromDS.getName()) && includedField.equals(field)) {
                log.warn("includeFrom field named '" + field.getName() + "' of datasource '" + this.getName() + "' refers to itself. Ignoring this field.");
                return null;
            }
            includeFromsAlreadySeen.put(incFromKey, includeFromInfo);
            includeFromInfo.setTargetIncludeFrom(includeFromDS.getIncludeFromInfo(includedField, dsRequest));
            includeFromInfo.setTargetInspected(true);
            DataTypeMap configField = null;
            DataTypeMap configFieldsList = this.dsConfig.getMap("fields");
            if (configFieldsList != null) {
                configField = configFieldsList.getMap(field.getName());
            }
            if (!field.getBoolean("canEdit")) {
                field.put("canEdit", Boolean.FALSE);
                if (configField != null) {
                    configField.put("canEdit", Boolean.FALSE);
                }
            }
            for (Object propertyName : includedField.keySet()) {
                if (propertyName == null || "primaryKey".equals(propertyName) || "foreignKey".equals(propertyName) || "joinType".equals(propertyName) || "required".equals(propertyName) || "conditionallyRequired".equals(propertyName) || "validators".equals(propertyName) || "__cachedType".equals(propertyName) || propertyName.toString().startsWith("editRequires") || propertyName.toString().startsWith("updateRequires") || propertyName.toString().startsWith("initRequires") || "template".equals(propertyName) || "formula".equals(propertyName) || "valueOperation".equals(propertyName) || "includeVia".equals(propertyName) || field.getProperty("includeSummaryFunction") != null && "displayField".equals(propertyName)) continue;
                if ("type".equals(propertyName)) {
                    if ("sequence".equalsIgnoreCase(includedField.getString(propertyName))) {
                        field.put("type", "integer");
                    } else {
                        field.put(propertyName, includedField.get(propertyName));
                    }
                    if (configField == null) continue;
                    configField.put(propertyName, includedField.get(propertyName));
                    continue;
                }
                if (field.containsKey(propertyName)) continue;
                field.put(propertyName, includedField.get(propertyName));
                if (configField == null) continue;
                configField.put(propertyName, includedField.get(propertyName));
            }
            if (this.handlesRelations() && this.embedsRelatedObjects()) {
                Object propertyName;
                propertyName = null;
                for (RelationInfo r = includeFromInfo.getRelation(); r != null; r = r.getNextRelation()) {
                    propertyName = propertyName == null ? r.getFromFields().get(0) : propertyName + "/" + r.getFromFields().get(0);
                }
                propertyName = includeFromInfo.getTargetIncludeFrom() != null ? propertyName + "/" + includedField.getValueXPath() : propertyName + "/" + includedFieldName;
                field.setValueXPath((String)propertyName);
                if (configField != null) {
                    configField.put("valueXPath", propertyName);
                }
            }
            includeFromInfo.setPrepared(true);
            includeFromInfo.setKey(incFromKey);
            return includeFromInfo;
        }
        return null;
    }

    public boolean supportsSummaryFunction(String functionName) {
        return false;
    }

    public Class getPropertyJavaClass(String propertyName, DSField field, Object value) throws Exception {
        if (field == null) {
            return null;
        }
        String typeName = field.getProperty("javaClass");
        if (typeName != null) {
            return Reflection.classForName(typeName);
        }
        return null;
    }

    public Class getFieldJavaType(String fieldName) {
        return this.getFieldJavaType(this.getField(fieldName));
    }

    public Class getFieldJavaType(DSField field) {
        return null;
    }

    public void _clearConvertedProperties() {
        this.convertedProps.clear();
    }

    public Class _getPropertyJavaClass(String propertyName, DSField field, Object value) throws Exception {
        if (this.convertedProps.containsKey(field)) {
            return this.convertedProps.get(field);
        }
        Class c = this.getPropertyJavaClass(propertyName, field, value);
        this.convertedProps.put(field, c);
        return c;
    }

    public boolean hasNextRecord(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public Map streamNextRecord(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public Object streamNextRecordAsObject(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public int getProgressiveLoadingThreshold() {
        Object fromConfig = this.dsConfig.get("progressiveLoadingThreshold");
        if (fromConfig == null) {
            return 200000;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public int getLookAhead() {
        Object fromConfig = this.dsConfig.get("lookAhead");
        if (fromConfig == null) {
            return 1;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public int getEndGap() {
        Object fromConfig = this.dsConfig.get("endGap");
        if (fromConfig == null) {
            return 20;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public DSInheritanceMode getInheritanceMode() {
        return DSInheritanceMode.FULL;
    }

    @Override
    public void commit(DSTransaction dsTransaction) throws Exception {
    }

    @Override
    public void rollback(DSTransaction dsTransaction) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCreateTrace(List<Map> createTrace, String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        List<Map> list = createTrace;
        synchronized (list) {
            PrintStream out;
            if (filename == null) {
                out = System.out;
            } else {
                File file = new File(filename);
                file.createNewFile();
                out = new PrintStream(file);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            out.println("\nDumping Create Trace data for DataSource " + (String)(dsName == null ? "(all)" : dsName + "*"));
            for (Map map : createTrace) {
                String id = (String)map.get("ID");
                if (dsName != null && !id.startsWith(dsName)) continue;
                out.println(sdf.format(new Date((Long)map.get("time"))) + " ID: " + String.valueOf(map.get("ID")) + ", instanceId: " + String.valueOf(map.get("instanceId")));
                if (dumpConfig) {
                    out.println("Config: " + String.valueOf(map.get("config")));
                }
                if (!dumpStack) continue;
                out.println("Stacktrace: ");
                StackTraceElement[] ste = (StackTraceElement[])map.get("stack");
                for (int j = 0; j < ste.length; ++j) {
                    out.println(ste[j]);
                }
            }
            out.println("\nEnd of Create Trace data for DataSource " + (dsName == null ? "(all)" : dsName) + "\n");
        }
    }

    public static AdvancedCriteria convertRelativeDates(AdvancedCriteria advancedCriteria) {
        return DataSource.convertRelativeDates(advancedCriteria, null);
    }

    public static AdvancedCriteria convertRelativeDates(AdvancedCriteria advancedCriteria, Date baseDate) {
        advancedCriteria.convertRelativeDates(baseDate);
        return advancedCriteria;
    }

    public static Criterion convertRelativeDates(Criterion criterion) {
        return DataSource.convertRelativeDates(criterion, null, null);
    }

    public static Criterion convertRelativeDates(Criterion criterion, Date baseDate, DataSource ds) {
        return DataSource.convertRelativeDates(criterion, baseDate, ds, false);
    }

    public static Criterion convertRelativeDates(Criterion criterion, Date baseDate, DataSource ds, boolean useEmbeddedTZ) {
        LinkedList<Criterion> newCriterions;
        LogicalCriterion logicalCriterion;
        Date localBaseDate;
        if (criterion == null) {
            return null;
        }
        Date date = localBaseDate = baseDate != null ? baseDate : new Date();
        if (criterion instanceof LogicalCriterion) {
            logicalCriterion = (LogicalCriterion)criterion;
            newCriterions = new LinkedList<Criterion>();
            for (Criterion subCriterion : logicalCriterion.getCriteria()) {
                Criterion newCriterion;
                if (subCriterion == null) continue;
                if (subCriterion instanceof LogicalCriterion) {
                    newCriterion = DataSource.convertRelativeDates(subCriterion, localBaseDate, ds);
                    newCriterions.add(newCriterion);
                    continue;
                }
                newCriterion = DataSource.mapRelativeDate(subCriterion, localBaseDate, ds, useEmbeddedTZ);
                newCriterions.add(newCriterion);
            }
        } else {
            return DataSource.mapRelativeDate(criterion, localBaseDate, ds, useEmbeddedTZ);
        }
        logicalCriterion.setCriteria(newCriterions);
        return criterion;
    }

    public static Criterion mapRelativeDate(Criterion criterion, Date baseDate, DataSource ds, boolean useEmbeddedTZ) {
        Date localBaseDate = baseDate != null ? baseDate : new Date();
        String fieldName = criterion.getFieldName();
        boolean logicalDate = false;
        if (ds != null) {
            String type = ds.getField(fieldName).getType();
            try {
                logicalDate = "date".equals(ds.getSimpleBaseType(type));
            }
            catch (Exception e) {
                log.warn((Object)"Exception deriving field type", e);
            }
        }
        if (criterion instanceof SimpleCriterion && DateUtil.isRelativeDate(criterion.getValue())) {
            ISCGregorianCalendar absoluteDate;
            Map valueMap = (Map)criterion.getValue();
            RelativeDateRangePosition rangePosition = RelativeDateRangePosition.START;
            RelativeDate relativeDate = new RelativeDate((String)valueMap.get("value"), rangePosition);
            String embeddedTZ = (String)valueMap.get("browserTZ");
            if (useEmbeddedTZ && embeddedTZ != null && embeddedTZ.length() > 0) {
                TimeZone clientTZ = TimeZone.getTimeZone("GMT" + embeddedTZ);
                if (clientTZ == null) {
                    log.warn("Error: No valid Java TimeZone for embeddedTZ '" + embeddedTZ + "'.  Using server timezone instead");
                }
                GregorianCalendar work = relativeDate.getAbsoluteDate(localBaseDate, logicalDate, clientTZ);
                absoluteDate = new ISCGregorianCalendar(work);
            } else {
                absoluteDate = new ISCGregorianCalendar(relativeDate.getAbsoluteDate(localBaseDate, logicalDate, null));
            }
            RelativeDateShortcut shortcut = RelativeDateShortcut.parseShortcut((String)valueMap.get("value"));
            if (!logicalDate && shortcut != null && (shortcut.equals((Object)RelativeDateShortcut.YESTERDAY) || shortcut.equals((Object)RelativeDateShortcut.TODAY) || shortcut.equals((Object)RelativeDateShortcut.TOMORROW))) {
                Date startOfDay;
                if (criterion.getOperatorId().equals("equals")) {
                    startOfDay = DateUtil.getStartOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    Date endOfDay = DateUtil.getEndOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    return new DateRangeCriterion(fieldName, "betweenInclusive", startOfDay, endOfDay);
                }
                if (criterion.getOperatorId().equals("notEqual")) {
                    startOfDay = DateUtil.getStartOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    Date endOfDay = DateUtil.getEndOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    DateRangeCriterion dateRangeCriterion = new DateRangeCriterion(fieldName, "betweenInclusive", startOfDay, endOfDay);
                    return new NotCriterion(dateRangeCriterion);
                }
                if (criterion.getOperatorId().equals("lessThan") || criterion.getOperatorId().equals("greaterOrEqual")) {
                    startOfDay = DateUtil.getStartOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)startOfDay);
                }
                if (criterion.getOperatorId().equals("greaterThan") || criterion.getOperatorId().equals("lessOrEqual")) {
                    Date endOfDay = DateUtil.getEndOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)endOfDay);
                }
                return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)absoluteDate);
            }
            return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)absoluteDate);
        }
        if (criterion instanceof RelativeDateRangeCriterion) {
            RelativeDate end;
            RelativeDate start;
            Date endDate;
            RelativeDateRangeCriterion rangeCriterion = (RelativeDateRangeCriterion)criterion;
            Date startDate = rangeCriterion.getMin() instanceof Date ? (Date)rangeCriterion.getMin() : null;
            Date date = endDate = rangeCriterion.getMax() instanceof Date ? (Date)rangeCriterion.getMax() : null;
            if (startDate == null && (start = (RelativeDate)rangeCriterion.getMin()) != null) {
                startDate = start.getAbsoluteDate(localBaseDate, logicalDate).getTime();
            }
            if (endDate == null && (end = (RelativeDate)rangeCriterion.getMax()) != null) {
                endDate = end.getAbsoluteDate(localBaseDate, logicalDate).getTime();
            }
            return new DateRangeCriterion(fieldName, criterion.getOperatorId(), startDate, endDate);
        }
        return criterion;
    }

    public static Object convertRelativeDates(Map criteria, DSRequest request) {
        return DataSource.convertRelativeDates(criteria, null, null, false, request);
    }

    public static Object convertRelativeDates(Map criteria, Date baseDate, DataSource ds, boolean useEmbeddedTZ, DSRequest req) {
        if (criteria == null) {
            return null;
        }
        Date localBaseDate = baseDate != null ? baseDate : new Date();
        for (String fieldName : criteria.keySet()) {
            ISCGregorianCalendar absoluteDate;
            Object value = criteria.get(fieldName);
            if (!DateUtil.isRelativeDate(value)) continue;
            Map valueMap = (Map)value;
            boolean logicalDate = false;
            if (ds != null) {
                String type = ds.getField(fieldName).getType();
                try {
                    logicalDate = "date".equals(ds.getSimpleBaseType(type));
                }
                catch (Exception e) {
                    log.warn((Object)"Exception deriving field type", e);
                }
            }
            RelativeDateShortcut shortcut = RelativeDateShortcut.parseShortcut((String)valueMap.get("value"));
            if (!logicalDate && shortcut != null && (shortcut.equals((Object)RelativeDateShortcut.YESTERDAY) || shortcut.equals((Object)RelativeDateShortcut.TODAY) || shortcut.equals((Object)RelativeDateShortcut.TOMORROW))) {
                AdvancedCriteria ac = req.getAdvancedCriteria(criteria);
                return new AdvancedCriteria(DataSource.convertRelativeDates(ac.asCriterion(), baseDate, ds, useEmbeddedTZ));
            }
            RelativeDateRangePosition rangePosition = RelativeDateRangePosition.START;
            RelativeDate relativeDate = new RelativeDate((String)valueMap.get("value"), rangePosition);
            String embeddedTZ = (String)valueMap.get("browserTZ");
            if (useEmbeddedTZ && embeddedTZ != null && embeddedTZ.length() > 0) {
                TimeZone clientTZ = TimeZone.getTimeZone("GMT" + embeddedTZ);
                if (clientTZ == null) {
                    log.warn("Error: No valid Java TimeZone for embeddedTZ '" + embeddedTZ + "'.  Using server timezone instead");
                }
                GregorianCalendar work = relativeDate.getAbsoluteDate(localBaseDate, logicalDate, clientTZ);
                absoluteDate = new ISCGregorianCalendar(work);
            } else {
                absoluteDate = new ISCGregorianCalendar(relativeDate.getAbsoluteDate(localBaseDate, logicalDate, null));
            }
            criteria.put(fieldName, absoluteDate);
        }
        return criteria;
    }

    public String toString() {
        return this.getID() + " DataSource with instanceId " + this.getInstanceId();
    }

    public void createStorage(boolean dropFirst) throws Exception {
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isCacheableAcrossSandboxes() {
        if (this._isCacheable == null) {
            String parentDatasourceId;
            this._isCacheable = this.dsConfig.getBoolean((Object)"immutableAcrossSandboxes", false) ? Boolean.TRUE : (DataSource.isSandboxEligible(this) ? Boolean.FALSE : (DataSource.isSandboxEligible(parentDatasourceId = this.getSourceDataSourceID()) ? Boolean.FALSE : Boolean.TRUE));
        }
        log.debug(this.getID() + " isCacheable?: " + this._isCacheable.toString());
        return this._isCacheable;
    }

    public void setIsCacheable(boolean value) {
        this._isCacheable = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSandboxEligible(String ID) {
        if (ID == null) {
            return false;
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(ID);
            boolean bl = DataSource.isSandboxEligible(ds);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public static boolean isSandboxEligible(DataSource ds) {
        if (ds == null) {
            return false;
        }
        String ID = ds.getID();
        Boolean result = sandboxEligibleCache.get(ID);
        if (result == null) {
            result = Boolean.FALSE;
            try {
                String dbName = ds.getConfig().getString("dbName");
                if (dbName != null) {
                    Boolean sandboxingEnabled = (Boolean)Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "isEnabled", dbName);
                    if (sandboxingEnabled.booleanValue()) {
                        result = Boolean.TRUE;
                    }
                } else if (ds.isMock() || ds.getConfig().getBoolean((Object)"fromServer", false)) {
                    result = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                log.warn((Object)("Caught exception when checking if DataSource " + ds.getName() + " iseligible for sandboxing"), e);
            }
            sandboxEligibleCache.put(ID, result);
        }
        log.debug(ID + "isSandboxEligible?: " + result);
        return result;
    }

    public DataSource() {
        this.TRANSACTION_OBJECT_KEY = null;
        this.checkIsValidSubclass();
    }

    private void checkIsValidSubclass() {
        Class<?> c = this.getClass();
        Class<DataSource> dsc = DataSource.class;
        Class<BasicDataSource> bdsc = BasicDataSource.class;
        if (c != dsc && c != bdsc && !this.isValidSubclass()) {
            log.warn(String.valueOf(c) + ": Direct subclassing of DataSource is not allowed. Subclass BasicDataSource instead. If you are sure you need to subclass DataSource directly, implement isValidSubclass() returning true.");
        }
    }

    protected boolean isValidSubclass() {
        return false;
    }

    public boolean canQueryTable() throws Exception {
        log.warn("canQueryTable() method called on unsupported DataSource type - returning false");
        return false;
    }

    public void setComponentSchema(boolean componentSchema) {
        this.dsConfig.put("componentSchema", componentSchema);
    }

    public boolean getComponentSchema() {
        Boolean ret = (Boolean)this.dsConfig.get("componentSchema");
        return ret != null && ret != false;
    }

    public List getSortByFields(List sortByFields) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        if (sortByFields == null) {
            return result;
        }
        for (String fieldName : sortByFields) {
            String sortByField;
            DSField field;
            boolean ascending = true;
            if (fieldName.startsWith("-")) {
                fieldName = fieldName.substring(1);
                ascending = false;
            }
            if ((field = this.getField(fieldName)) != null && (sortByField = field.getProperty("sortByField")) != null && !"".equals(sortByField.trim())) {
                fieldName = sortByField;
            }
            result.add((CallSite)((Object)((ascending ? "" : "-") + fieldName)));
        }
        return result;
    }

    @Deprecated
    public Map getRelatedDisplayRecord(String fieldName, Object displayValue) throws Exception {
        return this.getRelatedDisplayRecord(fieldName, displayValue, null);
    }

    public Map getRelatedDisplayRecord(String fieldName, Object displayValue, DSRequest dsRequest) throws Exception {
        DisplayFieldProperties props = this.getIncludedDisplayFieldProperties(fieldName);
        if (props == null) {
            return null;
        }
        DSRequest fetch = new DSRequest(props.fkDataSourceName, OP_FETCH);
        fetch.inheritClientContext(dsRequest);
        if (props.batchUploadCaseSensitive) {
            fetch.setTextMatchStyle("exactCase");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(props.foreignDisplayFieldName, displayValue);
        fetch.setCriteria(criteria);
        fetch.setOperationId(props.batchUploadOperationId);
        return fetch.execute().getDataMap();
    }

    public DisplayFieldProperties getIncludedDisplayFieldProperties(String fieldName) {
        DisplayFieldProperties props = new DisplayFieldProperties();
        props.fieldName = fieldName;
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        String fk = field.getForeignKey();
        if (fk == null || field.get("displayField") == null) {
            return null;
        }
        DSField displayField = this.getField((String)field.get("displayField"));
        if (displayField == null) {
            return null;
        }
        String dfTarget = displayField.getIncludeFrom();
        if (dfTarget == null) {
            return null;
        }
        props.displayFieldName = displayField.getName();
        String[] fkElements = fk.split("\\.");
        String[] dfElements = dfTarget.split("\\.");
        if (fkElements.length == 1) {
            props.fkDataSourceName = this.getName();
            props.fkFieldName = fkElements[0];
        } else {
            props.fkDataSourceName = fkElements[0];
            props.fkFieldName = fkElements[1];
        }
        if (dfElements.length == 1) {
            props.foreignDisplayFieldDataSourceName = this.getName();
            props.foreignDisplayFieldName = dfElements[0];
        } else {
            props.foreignDisplayFieldDataSourceName = dfElements[0];
            props.foreignDisplayFieldName = dfElements[1];
        }
        if (!props.fkDataSourceName.equals(props.foreignDisplayFieldDataSourceName)) {
            log.info("Field " + fieldName + " on DataSource " + this.getName() + " declares a foreignKey and a displayFIeld that target different dataSource. This is rarely correct.");
            return null;
        }
        props.batchUploadOperationId = (String)field.get("batchUploadOperationId");
        if (field.get("batchUploadCaseSensitive") != null && Boolean.parseBoolean(field.get("batchUploadCaseSensitive").toString())) {
            props.batchUploadCaseSensitive = true;
        }
        return props;
    }

    @Deprecated
    public Object transformImportValue(String fieldName, Object rawValue, String defaultStrategy) throws Exception {
        return this.transformImportValue(fieldName, rawValue, defaultStrategy, null);
    }

    public Object transformImportValue(String fieldName, Object rawValue, String defaultStrategy, DSRequest dsRequest) throws Exception {
        DisplayFieldProperties props = this.getIncludedDisplayFieldProperties(fieldName);
        Object transformed = null;
        if (props != null) {
            String importStrategy;
            DSField field = this.getField(fieldName);
            String string = importStrategy = field == null ? null : (String)field.get("importStrategy");
            if (importStrategy == null || "auto".equals(importStrategy)) {
                importStrategy = defaultStrategy;
            }
            if ("display".equals(importStrategy) || "displayRequired".equals(importStrategy)) {
                Map record = this.getRelatedDisplayRecord(fieldName, rawValue, dsRequest);
                if (record == null) {
                    transformed = "displayRequired".equals(importStrategy) ? null : rawValue;
                } else {
                    String fk = field.getForeignKey();
                    String[] fkElements = fk.split("\\.");
                    String fkname = fkElements.length == 1 ? fkElements[0] : fkElements[1];
                    transformed = record.get(fkname);
                }
            }
        }
        return transformed;
    }

    public boolean isServerOnly() {
        return this.dsConfig.getBoolean((Object)"serverOnly", false);
    }

    public boolean isClientOnly() {
        DataTypeMap config = this.dsConfig;
        Map<String, Object> annotatedConfig = this.getAnnotatedConfig();
        if (annotatedConfig instanceof DataTypeMap) {
            config = (DataTypeMap)((Object)annotatedConfig);
        }
        return config.getBoolean((Object)"clientOnly", false) || config.getBoolean((Object)"mockMode", false) || this.isMock();
    }

    public boolean enforceSecurityOnClient() {
        DataTypeMap<String, Object> config = this.dsConfig;
        return config.getBoolean((Object)"enforceSecurityOnClient", this.isClientOnly());
    }

    public boolean isAuditDataSource() {
        return this.dsConfig.containsKey("auditedDataSourceID");
    }

    public boolean isMock() {
        return false;
    }

    public void applyTransformRequestScript(DSRequest dsRequest, Map<String, Object> transformContext) throws Exception {
        if (this.getTransformRequestScript(dsRequest, false) != null) {
            for (String varName : transformContext.keySet()) {
                dsRequest.addToScriptContext(varName, transformContext.get(varName));
            }
            log.debug("Request criteria prior to DS-level transform: " + String.valueOf(dsRequest.getCriteria(false)));
            log.debug("Request values prior to DS-level transform: " + String.valueOf(dsRequest.getValues(false)));
            Object data = DataSourceDMI.evalInlineScript(dsRequest, dsRequest.getRPCManager(), dsRequest.getContext(), null, "transformRequestScript");
            if (data != null) {
                String msg = "The DS-level transformRequest script returned a value.  Applying it to ";
                if (DataSource.isFetch(dsRequest.getOperationType()) || DataSource.isRemove(dsRequest.getOperationType())) {
                    log.debug(msg + "criteria");
                    dsRequest.setCriteria(data);
                } else {
                    log.debug(msg + "values");
                    dsRequest.setValues(data);
                }
            }
            log.debug("Request criteria after DS-level transform: " + String.valueOf(dsRequest.getCriteria(false)));
            log.debug("Request values after DS-level transform: " + String.valueOf(dsRequest.getValues(false)));
        }
        if (this.getTransformRequestScript(dsRequest, true) != null) {
            DataTypeMap opBinding = this.getOperationBinding(dsRequest);
            log.debug("Request criteria prior to op-level transform: " + String.valueOf(dsRequest.getCriteria(false)));
            log.debug("Request values prior to op-level transform: " + String.valueOf(dsRequest.getValues(false)));
            Object data = DataSourceDMI.evalInlineScript(dsRequest, dsRequest.getRPCManager(), dsRequest.getContext(), (Map)((Object)opBinding), "transformRequestScript");
            if (data != null) {
                String msg = "The op-level transformRequest script returned a value.  Applying it to ";
                if (DataSource.isFetch(dsRequest.getOperationType()) || DataSource.isRemove(dsRequest.getOperationType())) {
                    log.debug(msg + "criteria");
                    dsRequest.setCriteria(data);
                } else {
                    log.debug(msg + "values");
                    dsRequest.setValues(data);
                }
            }
            log.debug("Request criteria after op-level transform: " + String.valueOf(dsRequest.getCriteria(false)));
            log.debug("Request values after op-level transform: " + String.valueOf(dsRequest.getValues(false)));
        }
    }

    public void transformResponse(List untransformed, DSRequest ctxReq, DSResponse ctxResp) throws Exception {
    }

    public void applyTransformResponseScript(DSRequest dsRequest, DSResponse dsResponse, Map<String, Object> transformContext) throws Exception {
        Object data;
        if (Boolean.TRUE.equals(dsRequest.getAttribute("transformResponseScriptApplied"))) {
            return;
        }
        dsRequest.setAttribute("transformResponseScriptApplied", true);
        boolean transforming = false;
        if (this.transformResponseScriptExists(dsRequest)) {
            transforming = true;
            dsRequest.addToScriptContext("dsResponse", dsResponse);
            if (dsResponse.getData() instanceof List) {
                dsRequest.addToScriptContext("responseObjects", dsResponse.getData());
                if (((List)dsResponse.getData()).size() > 0) {
                    dsRequest.addToScriptContext("responseObject", ((List)dsResponse.getData()).get(0));
                } else {
                    dsRequest.addToScriptContext("responseObject", null);
                }
                if (!dsRequest.getScriptContext().containsKey("responseRecords")) {
                    dsRequest.addToScriptContext("responseRecords", dsResponse.getData());
                    if (((List)dsResponse.getData()).size() > 0) {
                        dsRequest.addToScriptContext("responseObject", ((List)dsResponse.getData()).get(0));
                    } else {
                        dsRequest.addToScriptContext("responseObject", null);
                    }
                }
            } else {
                dsRequest.addToScriptContext("responseObject", dsResponse.getData());
                ArrayList<Object> work = new ArrayList<Object>();
                work.add(dsResponse.getData());
                dsRequest.addToScriptContext("responseObjects", work);
                if (!dsRequest.getScriptContext().containsKey("responseRecords")) {
                    dsRequest.addToScriptContext("responseRecord", dsResponse.getData());
                    dsRequest.addToScriptContext("responseRecords", work);
                }
            }
            if (transformContext != null) {
                for (String varName : transformContext.keySet()) {
                    dsRequest.addToScriptContext(varName, transformContext.get(varName));
                }
            }
        }
        if (this.getTransformResponseScript(dsRequest, false) != null && (data = DataSourceDMI.evalInlineScript(dsRequest, dsRequest.getRPCManager(), dsRequest.getContext(), null, "transformResponseScript")) != null) {
            dsResponse.setData(data);
        }
        if (this.getTransformResponseScript(dsRequest, true) != null) {
            DataTypeMap opBinding = this.getOperationBinding(dsRequest);
            Object data2 = DataSourceDMI.evalInlineScript(dsRequest, dsRequest.getRPCManager(), dsRequest.getContext(), (Map)((Object)opBinding), "transformResponseScript");
            if (data2 != null) {
                dsResponse.setData(data2);
            }
        }
        if (transforming) {
            log.debug("Response data after transformResponseScript processing: " + DataTools.prettyPrint(dsResponse.getData()));
        }
    }

    public void applyFieldValueScripts(DSRequest dsRequest, DSResponse dsResponse) throws Exception {
        if (Boolean.TRUE.equals(dsRequest.getAttribute("fieldValueScriptsApplied"))) {
            return;
        }
        long start = System.currentTimeMillis();
        int calls = 0;
        long totalScriptTime = 0L;
        HashMap context = new HashMap();
        Map<String, DataTranslator> translators = this.getConfiguredTranslators();
        Map<Object, Object> defaultTranslators = new HashMap();
        if (this.shouldApplyDefaultTranslators(dsRequest)) {
            defaultTranslators = this.getDefaultTranslators(dsRequest);
        }
        dsRequest.setAttribute("fieldValueScriptsApplied", true);
        dsRequest.addToScriptContext("dataSource", this);
        Object data = dsResponse.getData();
        ArrayList<Object> dataList = null;
        if (data instanceof List) {
            dataList = (ArrayList<Object>)data;
        } else {
            dataList = new ArrayList<Object>();
            dataList.add(data);
        }
        List<String> fieldNames = dsRequest.getConsolidatedOutputs();
        if (fieldNames == null || fieldNames.size() == 0) {
            fieldNames = this.getFieldNames();
        }
        ValidationContext vc = new ValidationContext();
        vc.setSkipNonTypeValidations(true);
        for (String fieldName : fieldNames) {
            DSField field = this.getField(fieldName);
            if (field == null) continue;
            DataTranslator translator = translators.get(fieldName);
            if (translator == null && this.shouldApplyDefaultTranslators(dsRequest)) {
                translator = (DataTranslator)defaultTranslators.get(fieldName);
            }
            if (field.getFieldValueScript() == null && translator == null) continue;
            String name = field.getName();
            for (Object e : dataList) {
                Object value = null;
                String declaredType = field.getType();
                dsRequest.removeFromScriptContext("valueString");
                dsRequest.removeFromScriptContext("valueInteger");
                dsRequest.removeFromScriptContext("valueFloat");
                dsRequest.removeFromScriptContext("valueBoolean");
                dsRequest.removeFromScriptContext("valueDate");
                dsRequest.removeFromScriptContext("valueDatetime");
                dsRequest.removeFromScriptContext("valueTime");
                dsRequest.removeFromScriptContext("value");
                if (e instanceof Map) {
                    value = ((Map)e).get(name);
                    if (translator != null) {
                        if (translator instanceof FieldDataTranslator) {
                            String raw = value == null ? null : value.toString();
                            Object coerced = null;
                            coerced = Boolean.TRUE.equals(dsRequest.getAttribute("responseDataIsTypeValidated")) ? value : (!DataTools.getBoolean((Map)((Object)field), "skipTypeCoercion") ? ((BasicDataSource)this).validateFieldValue((Map)e, field, value, vc) : null);
                            value = ((FieldDataTranslator)translator).translate(raw, coerced);
                        } else {
                            value = translator.translate(value);
                        }
                    } else if (this instanceof BasicDataSource && !Boolean.TRUE.equals(dsRequest.getAttribute("responseDataIsTypeValidated")) && !DataTools.getBoolean((Map)((Object)field), "skipTypeCoercion")) {
                        value = ((BasicDataSource)this).validateFieldValue((Map)e, field, value, vc);
                    }
                    dsRequest.addToScriptContext("value", value);
                    if ("text".equals(declaredType)) {
                        dsRequest.addToScriptContext("valueString", value == null ? null : value.toString());
                    } else if ("integer".equals(declaredType) && value instanceof Number) {
                        dsRequest.addToScriptContext("valueInteger", value == null ? null : Long.valueOf(((Number)value).longValue()));
                    } else if ("float".equals(declaredType) && value instanceof Number) {
                        dsRequest.addToScriptContext("valueFloat", value == null ? null : Double.valueOf(((Number)value).doubleValue()));
                    } else if ("boolean".equals(declaredType)) {
                        boolean boolValue = Boolean.TRUE.equals(value) || "true".equals(value.toString()) || value instanceof Number && ((Number)value).intValue() == 1;
                        dsRequest.addToScriptContext("valueBoolean", boolValue);
                    } else if ("date".equals(declaredType)) {
                        if (value == null) {
                            dsRequest.addToScriptContext("valueDate", null);
                        } else {
                            date = null;
                            if (value instanceof Date) {
                                date = (Date)value;
                            } else {
                                try {
                                    date = dateFmt.parse(value.toString());
                                }
                                catch (ParseException pe) {
                                    log.warn((Object)("Field '" + field.getName() + "' is declared to be type 'date', but we could not parse value '" + String.valueOf(value) + "' as a date"), pe);
                                }
                            }
                            dsRequest.addToScriptContext("valueDate", date);
                        }
                    } else if ("datetime".equals(declaredType)) {
                        if (value == null) {
                            dsRequest.addToScriptContext("valueDatetime", null);
                        } else {
                            date = null;
                            if (value instanceof Date) {
                                date = (Date)value;
                            } else {
                                try {
                                    date = dateTimeFmt.parse(value.toString());
                                }
                                catch (ParseException pe) {
                                    log.warn((Object)("Field '" + field.getName() + "' is declared to be type 'datetime', but we could not parse value '" + String.valueOf(value) + "' as a datetime"), pe);
                                }
                            }
                            dsRequest.addToScriptContext("valueDatetime", date);
                        }
                    } else if ("time".equals(declaredType)) {
                        if (value == null) {
                            dsRequest.addToScriptContext("valueTime", null);
                        } else {
                            Date time = null;
                            if (value instanceof Date) {
                                time = (Date)value;
                            } else {
                                try {
                                    time = timeFmt.parse(value.toString());
                                }
                                catch (ParseException pe) {
                                    log.warn((Object)("Field '" + field.getName() + "' is declared to be type 'time', but we could not parse value '" + String.valueOf(value) + "' as a time"), pe);
                                }
                            }
                            dsRequest.addToScriptContext("valueTime", time);
                        }
                    }
                }
                Object transformed = value;
                if (field.getFieldValueScript() != null) {
                    transformed = this.evaluateFieldValueScript(dsRequest, field, value, e, context);
                }
                ++calls;
                Object elapsedObj = context.get("elapsed");
                long elapsed = elapsedObj == null || !(elapsedObj instanceof Long) ? 0L : (Long)elapsedObj;
                totalScriptTime += elapsed;
                if (e instanceof Map && transformed != null) {
                    ((Map)e).put(field.getName(), transformed);
                }
                if (!log.isDebugEnabled()) continue;
                Object newValue = transformed;
                if (newValue == null && e instanceof Map) {
                    ((Map)e).get(field.getName());
                }
                if (value == null && newValue == null || value.equals(newValue)) {
                    log.debug("applyFieldValueScript ran for field '" + field.getName() + "' but the value [" + String.valueOf(value) + "] was not changed");
                    continue;
                }
                log.debug("applyFieldValueScript transformed the value of field '" + field.getName() + "' from [" + String.valueOf(value) + "] to [" + String.valueOf(newValue) + "]");
            }
        }
    }

    protected boolean fieldhasTranslatorsOrFieldValueScript(String fieldName, DSRequest dsRequest) throws Exception {
        DSField field;
        Map<String, DataTranslator> translators = this.getConfiguredTranslators();
        Map<Object, Object> defaultTranslators = new HashMap();
        if (this.shouldApplyDefaultTranslators(dsRequest)) {
            defaultTranslators = this.getDefaultTranslators(dsRequest);
        }
        if ((field = this.getField(fieldName)) == null) {
            return false;
        }
        DataTranslator translator = translators.get(fieldName);
        if (translator == null && this.shouldApplyDefaultTranslators(dsRequest)) {
            translator = (DataTranslator)defaultTranslators.get(fieldName);
        }
        return field.getFieldValueScript() != null || translator != null;
    }

    protected Map<String, DataTranslator> getDefaultTranslators(DSRequest dsRequest) throws Exception {
        String dataImportFQCN = "com.isomorphic.tools.DataImport";
        Object dataImport = Reflection.instantiateClass(dataImportFQCN);
        Method method = Reflection.findMethod(dataImport.getClass(), "getTranslators", Map.class, DataSource.class);
        Map translators = (Map)Reflection._invokeMethod(method, dataImport, this.native2DSFieldMap(), this);
        HashMap<String, DataTranslator> instantiatedTranslators = new HashMap<String, DataTranslator>();
        for (String fieldName : translators.keySet()) {
            Object translator;
            Object className = (String)translators.get(fieldName);
            if (className == null) continue;
            if (((String)className).startsWith(dataImportFQCN)) {
                int lastDot = ((String)className).lastIndexOf(46);
                className = ((String)className).substring(0, lastDot) + "$" + ((String)className).substring(lastDot + 1);
            }
            if (!((translator = Reflection.instantiateInnerClass((String)className, dataImport, null, null)) instanceof DataTranslator)) {
                log.warn("ERROR: DataSource " + this.getName() + " is trying to derive a default translator with class name " + (String)className + ", but this class is not an instance of com.isomorphic.datasource.DataTranslator.  No default translation will take place for field '" + fieldName + "'");
                continue;
            }
            instantiatedTranslators.put(fieldName, (DataTranslator)translator);
            DSField field = dsRequest.getDataSource().getField(fieldName);
            if (field == null || field.getNativeName() == null) continue;
            instantiatedTranslators.put(field.getNativeName(), (DataTranslator)translator);
        }
        return instantiatedTranslators;
    }

    protected boolean shouldApplyDefaultTranslators(DSRequest dsRequest) {
        return false;
    }

    public Object evaluateFieldValueScript(DSRequest dsRequest, DSField field, Object value, Object record, Map context) throws Exception {
        String expression = field.getFieldValueScript();
        String language = field.getLanguage();
        Object imports = field.getScriptImports();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        HashMap<String, String> bindingsClassName = new HashMap<String, String>();
        bindings.put("dsRequest", dsRequest);
        bindingsClassName.put("dsRequest", dsRequest.getClass().getName());
        bindings.put("field", field);
        bindingsClassName.put("dsRequest", field.getClass().getName());
        bindings.put("record", record);
        bindingsClassName.put("record", record.getClass().getName());
        for (String varName : dsRequest.getScriptContext().keySet()) {
            if (bindings.containsKey(varName)) {
                log.warn((Object)("scriptContext contained a reference with name '" + varName + "'. This collides with a built-in context variable of the same name. Ignoring this custom scriptContext variable - please choose a different name for it"), new Exception());
                continue;
            }
            Object obj = dsRequest.getScriptContext().get(varName);
            if (obj != null) {
                bindingsClassName.put(varName, obj.getClass().getName());
            } else {
                bindingsClassName.put(varName, "Object");
            }
            bindings.put(varName, obj);
        }
        DataTypeMap<String, Object> params = new DataTypeMap<String, Object>();
        params.put("engineName", language);
        params.put("imports", imports);
        params.put("script", expression);
        params.put("bindings", bindings);
        params.put("bindingsClassName", bindingsClassName);
        Map result = null;
        try {
            long start = System.currentTimeMillis();
            IScript script = Scripting.getScript(language);
            result = script.eval(params);
            context.put("elapsed", System.currentTimeMillis() - start);
            if (result != null && result instanceof Map) {
                return result.get("evalResult");
            }
        }
        catch (Exception e) {
            log.warn("Failed to evaluate fieldValueScript for DataSource '" + this.getName() + "', field '" + field.getName() + "'. Processing will continue, expect errors in the value of this field.  Error message: " + e.getMessage());
        }
        return null;
    }

    protected Map<String, DataTranslator> getConfiguredTranslators() {
        HashMap<String, DataTranslator> instantiatedTranslators = new HashMap<String, DataTranslator>();
        String className = null;
        DSField field = null;
        Iterator<String> i = this.getFieldNames().iterator();
        while (i.hasNext()) {
            try {
                field = this.getField(i.next());
                if (field == null || (className = field.getDataTranslatorClassName()) == null) continue;
                Object translator = Reflection.instantiateClass(className);
                if (!(translator instanceof DataTranslator)) {
                    log.warn("ERROR: DataSource " + this.getName() + " specifies a translator with class name " + className + ", but this class is not an instance of com.isomorphic.datasource.DataTranslator.  The default translator will be used for field '" + field.getName() + "'");
                    continue;
                }
                instantiatedTranslators.put(field.getName(), (DataTranslator)translator);
                if (field.getNativeName() == null) continue;
                instantiatedTranslators.put(field.getNativeName(), (DataTranslator)translator);
            }
            catch (Exception e) {
                log.warn((Object)("ERROR: Caught exception when trying to instantiate data translator for DataSource " + this.getName() + ". We were trying to instantiate class " + className + " for field '" + field.getName() + "'"), e);
            }
        }
        return instantiatedTranslators;
    }

    public Map native2DSFieldMap() {
        return null;
    }

    public static Object getOperationProperty(DSRequest request, String propertyName, Object defaultValue) throws Exception {
        Object propertyValue = request.getOperationProperty(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        DataTypeMap operationBinding = request.getDataSource().getOperationBinding(request.getOperationType(), request.getOperationId());
        if (operationBinding != null && (propertyValue = operationBinding.get(propertyName)) != null) {
            return propertyValue;
        }
        return defaultValue;
    }

    public Map<String, Object> getRecord(Object data) {
        return this.getRecord(data, false, false);
    }

    public Map<String, Object> getRecord(Object data, boolean bypassDataFilter, boolean dropExtraFields) {
        return this.getRecord(data, bypassDataFilter, dropExtraFields, null);
    }

    public Map<String, Object> getRecord(Object data, boolean bypassDataFilter, boolean dropExtraFields, ValidationContext vc) {
        IBeanFilter filter = null;
        if (data instanceof JSONFilter) {
            filter = ((JSONFilter)data).getBeanFilter();
            data = ((JSONFilter)data).getObj();
        }
        if (data instanceof List) {
            data = ((List)data).size() > 0 ? ((List)data).get(0) : null;
        }
        Map record = null;
        if (bypassDataFilter) {
            if (data instanceof Map) {
                record = (Map)data;
            } else {
                try {
                    record = DataTools.getProperties(data);
                }
                catch (Exception ex) {
                    log.warn((Object)"Failed to apply getProperties on data for record", ex);
                }
            }
        } else {
            record = this.getProperties(data, dropExtraFields, true, vc);
        }
        if (filter != null) {
            try {
                record = filter.filter(record);
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to filter record:" + String.valueOf(filter)), ex);
            }
        }
        return record;
    }

    public String getDefaultCacheSyncStrategyName() {
        return config.getString("default.cache.sync.strategy");
    }

    public String getCacheSyncStrategyName() {
        return this.dsConfig.getString("cacheSyncStrategy");
    }

    public CacheSyncStrategy getCacheSyncStrategy(String name) {
        return this.registeredCacheSyncStrategies.get(name);
    }

    public void registerCacheSyncStrategy(String name, CacheSyncStrategy strategy) {
        this.registeredCacheSyncStrategies.put(name, strategy);
    }

    public String getDefaultCacheSyncTiming() {
        return config.getString("default.cache.sync.timing");
    }

    public String getCacheSyncTiming() {
        return this.dsConfig.getString("cacheSyncTiming");
    }

    public boolean hasGeneratedFieldValues(DSRequest dsReq) {
        List outputFields = dsReq.getConsolidatedOutputs();
        for (DSField field : this.getFields()) {
            if (outputFields != null && !outputFields.contains(field.getName()) || !field.getBoolean("customSQL") && !field.getBoolean("customSelectExpression") && !field.getBoolean("autoGenerated")) continue;
            if (DataSource.isAdd(dsReq.getOperationType())) {
                return true;
            }
            if (!DataSource.isUpdate(dsReq.getOperationType()) || (dsReq.getValues() == null || dsReq.getValues().get(field.getName()) == null) && (dsReq.getOldValues() == null || dsReq.getOldValues().get(field.getName()) != null)) continue;
            return true;
        }
        return false;
    }

    public boolean requestIsMissingRequiredValues(DSRequest dsReq) {
        List outputFields = dsReq.getConsolidatedOutputs();
        for (DSField field : this.getFields()) {
            if (outputFields != null && !outputFields.contains(field.getName()) || !field.isRequired() || dsReq.getValues() != null && dsReq.getValues().get(field.getName()) != null || dsReq.getOldValues() != null && dsReq.getOldValues().get(field.getName()) != null) continue;
            return true;
        }
        return false;
    }

    public boolean requestHasUsableOldValues(DSRequest dsReq) {
        List values = dsReq.getValueSets();
        List criteria = dsReq.getCriteriaSets();
        List oldValues = dsReq.getOldValueSets();
        if (values.size() != oldValues.size()) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            Map dropped;
            HashMap v = (HashMap)values.get(i);
            Map c = (Map)criteria.get(i);
            Map ov = (Map)oldValues.get(i);
            if (v == null || ov == null) {
                return false;
            }
            if (c != null) {
                v = new HashMap(v);
                v.putAll(c);
            }
            if ((dropped = dsReq.getDroppedFieldValues(i)) != null) {
                v = new HashMap(v);
                v.putAll(dropped);
            }
            boolean diff = false;
            int missingOVs = 0;
            for (String key : v.keySet()) {
                Object vObj = v.get(key);
                Object ovObj = ov.get(key);
                if (!ov.containsKey(key)) {
                    ++missingOVs;
                }
                if (vObj == null && ovObj == null) continue;
                if (vObj == null) {
                    diff = true;
                    break;
                }
                if (ovObj == null) {
                    diff = true;
                    break;
                }
                if (vObj.equals(ovObj) || vObj.toString().equals(ovObj.toString())) continue;
                diff = true;
                break;
            }
            if (!diff && v.keySet().size() + missingOVs < ov.keySet().size()) {
                diff = true;
            }
            if (diff) continue;
            return false;
        }
        return true;
    }

    public boolean responseValuesMissingRequiredValue(DSRequest dsReq, Map responseValues) {
        List outputFields = dsReq.getConsolidatedOutputs();
        for (DSField field : this.getFields()) {
            if (outputFields != null && !outputFields.contains(field.getName()) || !field.isRequired() || responseValues.get(field.getName()) != null) continue;
            return true;
        }
        return false;
    }

    public boolean shouldDeferCacheSync(DSRequest request) throws Exception {
        return true;
    }

    public boolean shouldAutoSwitchCacheSyncTiming() {
        return false;
    }

    public boolean requestRequiresChildUpdates(DSRequest req) throws Exception {
        return false;
    }

    public void applyEarlyResponseTransformations(DSRequest dsRequest, DSResponse dsResponse, Map transformContext) throws Exception {
    }

    public CompiledScript getCompiledScript(String cacheKey) {
        return this.compiledScripts.get(cacheKey);
    }

    public void cacheCompiledScript(String cacheKey, CompiledScript script) {
        this.compiledScripts.put(cacheKey, script);
    }

    public String getSchemaName() {
        return this.getSchemaName((Map)((Object)this.dsConfig));
    }

    public String getSchemaName(Map theConfig) {
        return null;
    }

    public Map getSequences() {
        return null;
    }

    public String getDefaultSubqueryOutputFieldName(DSRequest req) {
        if (req != null && req.getQueryOutput() != null) {
            return req.getQueryOutput();
        }
        return this.getDefaultSubqueryOutputFieldName();
    }

    public String getDefaultSubqueryOutputFieldName() {
        if (this.getPrimaryKey() != null) {
            return this.getPrimaryKey();
        }
        String firstField = null;
        for (String fieldName : this.getFieldNames()) {
            DSField field;
            String type;
            if (firstField == null) {
                firstField = fieldName;
            }
            if (!"integer".equals(type = this.getSimpleBaseType((field = this.getField(fieldName)).getType())) && !"float".equals(type)) continue;
            return fieldName;
        }
        return firstField;
    }

    public List convertToRecordFormat(Object data) {
        return this.convertToRecordFormat(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List convertToRecordFormat(Object data, ValidationContext vc) {
        boolean freeVC = false;
        if (vc == null) {
            vc = new ValidationContext();
            freeVC = true;
        }
        ArrayList<Map> target = new ArrayList<Map>();
        try {
            ArrayList<Object> source;
            IBeanFilter filter = null;
            if (data instanceof JSONFilter) {
                filter = ((JSONFilter)data).getBeanFilter();
                data = ((JSONFilter)data).getObj();
            }
            if (data instanceof List) {
                source = (ArrayList<Object>)data;
            } else {
                source = new ArrayList<Object>();
                if (data instanceof Collection) {
                    source.addAll((Collection)data);
                } else if (data != null) {
                    source.add(data);
                }
            }
            for (Object e : source) {
                Map properties = e instanceof Map ? (Map)e : this.getProperties(e, true, true, vc);
                if (filter != null) {
                    try {
                        if (filter instanceof IContextBeanFilter) {
                            target.add(((IContextBeanFilter)filter).filter(properties, vc));
                            continue;
                        }
                        target.add(filter.filter(properties));
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Failed to filter record:'" + String.valueOf(properties) + "'. Skipping."), ex);
                    }
                    continue;
                }
                target.add(properties);
            }
        }
        finally {
            if (freeVC) {
                vc.freeResources();
            }
        }
        return target;
    }

    public boolean supportsAggregationInherently() {
        return false;
    }

    public boolean shouldApplyManualAggregation() {
        if (this.supportsAggregationInherently()) {
            return false;
        }
        if (this.getConfig().getBoolean("suppressManualAggregation") != null) {
            return this.getConfig().getBoolean("applyManualAggregation") == false;
        }
        return !config.getBoolean((Object)"datasource.suppress.manual.aggregation", false);
    }

    public String getSQLPaging(DSRequest req, Map operationBinding) {
        return null;
    }

    protected boolean shouldForceSort(DSRequest req) {
        return false;
    }

    public String getDBType() throws Exception {
        return null;
    }

    public void dsRequestStarted(DSRequest dsRequest) {
    }

    public boolean is1ManyRelationField(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field != null) {
            return field.is1ManyRelation();
        }
        return false;
    }

    public boolean isManyManyRelationField(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field != null) {
            return field.isManyManyRelation();
        }
        return false;
    }

    public boolean isRelationField(String fieldName) {
        return this.is1ManyRelationField(fieldName) || this.isManyManyRelationField(fieldName);
    }

    public List<DSField> get1ManyRelationFields() {
        ArrayList<DSField> list = new ArrayList<DSField>();
        for (DSField field : this.getFields()) {
            if (!field.is1ManyRelation()) continue;
            list.add(field);
        }
        return list;
    }

    public List<DSField> getManyManyRelationFields() {
        ArrayList<DSField> list = new ArrayList<DSField>();
        for (DSField field : this.getFields()) {
            if (!field.isManyManyRelation()) continue;
            list.add(field);
        }
        return list;
    }

    public List<DSField> getRelationFields() {
        List<DSField> all = this.get1ManyRelationFields();
        all.addAll(this.getManyManyRelationFields());
        return all;
    }

    public boolean has1ManyRelationFields() {
        return this.get1ManyRelationFields().size() > 0;
    }

    public boolean hasManyManyRelationFields() {
        return this.getManyManyRelationFields().size() > 0;
    }

    public boolean hasRelationFields() {
        return this.getRelationFields().size() > 0;
    }

    public String getRelatedDSName(String fieldName) {
        return this.getRelatedDSName(this.getField(fieldName));
    }

    public String getRelatedDSName(DSField field) {
        String relatedDSName = null;
        if (field != null && field.isRelation()) {
            relatedDSName = field.getRelatedDSName();
        }
        return relatedDSName;
    }

    public String getJoinDSName(String fieldName) {
        return this.getJoinDSName(this.getField(fieldName));
    }

    public String getJoinDSName(DSField field) {
        String joinDSName = null;
        if (field != null && field.isManyManyRelation()) {
            joinDSName = field.getJoinDSName();
        }
        return joinDSName;
    }

    public boolean isSQLDataSource() {
        return false;
    }

    static {
        builtinTypesInitialized = false;
        builtinTypesInitializing = false;
        builtinTypesLock = new Object();
        count = 0;
        failCount = 0;
        nanosecs = 0L;
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new JXPathBeanPointerFactory());
        dynamicBeanMarkerName = config.getString("dynamicBeanMarker");
        try {
            dynamicBeanMarker = dynamicBeanMarkerName == null ? null : Class.forName(dynamicBeanMarkerName);
        }
        catch (Exception e) {
            log.warn((Object)("Error attempting to load dynamic bean marker class " + dynamicBeanMarkerName + ", dynamic beans will not be supported"), e);
            dynamicBeanMarker = null;
        }
        beanConversionLapse = 0L;
        subValuesLapse = 0L;
        subValDSMLapse = 0L;
        subValVCLapse = 0L;
        subValVCHit = 0L;
        subValVCMiss = 0L;
        inSubValueLapse = 0L;
        inSubValueLapse0 = 0L;
        inSubValueLapse1 = 0L;
        inSubValueLapse2 = 0L;
        subPropsLapse = 0L;
        useAxisForSQLDS = config.getBoolean((Object)"useAxisForSQLDS", false);
        sandboxEligibleCache = new ConcurrentHashMap();
        dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        dateTimeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        timeFmt = new SimpleDateFormat("HH:mm:ss");
    }

    static class DataSourcePropertiesMap
    extends LinkedHashMap {
        DataSourcePropertiesMap() {
        }
    }

    public static enum DSInheritanceMode {
        FULL,
        NONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class DisplayFieldProperties {
        public String fieldName;
        public String displayFieldName;
        public String fkDataSourceName;
        public String fkFieldName;
        public String foreignDisplayFieldDataSourceName;
        public String foreignDisplayFieldName;
        public String batchUploadOperationId;
        public boolean batchUploadCaseSensitive = false;
    }

    private static class ConfigLogger {
        private ConfigLogger() {
        }
    }
}

