/*

  SmartClient Ajax RIA system
  Version v14.0p_2025-11-05/LGPL Deployment (2025-11-05)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>	@class	MeasureItem
// FormItem intended for inputting measurement values like width and height where the value
// can be a fixed numeric number or a percent (%) or expand-to-fill (*).
//
// @inheritsFrom TextItem
// @visibility tools
//<
isc.ClassFactory.defineClass("MeasureItem", "TextItem");
isc.MeasureItem.addProperties({
    changeOnKeypress: false,
    redrawOnChange: true,
    canTabToIcons: false
});

isc.MeasureItem.addMethods({

    init : function() {
        this.Super("init", arguments);
        if (this.type == "measure") {
            // Only for "measure" fields are percent and * values accepted
            this.supportPercentAndExpand = true;
        }
        this.addMeasureValidator();
    },

    addMeasureValidator : function () {
        var measureValidator = this.getMeasureValidator();
        if (!measureValidator) return;

        
        if (this.validators == null) this.validators = [];
        else if (!isc.isAn.Array(this.validators)) this.validators = [this.validators];
            
        if (this.validators._typeValidators) {
            this.validators = this.validators.duplicate();
        }
        this.validators.addAt(measureValidator, 0);
    },

    getMeasureValidator : function () {
        var validator;
        if (this.type != "measure") {
            // For a non-measure field, reject a % or * value with an error message.
            // Other values entered that will convert to an integer are accepted (e.g. 10px)
            validator = {
                type: "custom",
                defaultErrorMessage: "A relative size is not supported for this property",
                condition : function (item, validator, value, record, additionalContext) {
                    if (value != null && isc.isA.String(value)) {
                        value = value.replaceAll("\"", "").trim();

                        if (value == "*" || value.endsWith("%")) {
                            return false;
                        }

                        var intValue = parseInt(value);
                        if (!isNaN(intValue)) {
                            value = intValue;
                        }
                        validator.resultingValue = value;
                    }
                    return true;
                }
            };
        }
        return validator;
    },

    drawing : function (itemVisibilityChanged) {
        this.setIcons();
        this.Super("drawing", arguments);
    },

    redrawing : function () {
        this.setIcons();
        this.Super("redrawing", arguments);
    },

    // Editable value should always be the user value - not the current, derived value
    mapValueToDisplay : function (value, recursed, includeValueIcons) {
        return (this.supportPercentAndExpand ? this.getUserValue(this.name) : (value || ""));
    },

    _$percent: "%",
    storeValue : function (value) {
        // Remove any entered quotation marks and convert to number if appropriate
        if (value != null && isc.isA.String(value)) {
            value = value.replaceAll("\"", "").trim();
            if (!this.supportPercentAndExpand && (value == "*" || isc.endsWith(value, this._$percent))) {
                // leave this value in place for the validator
            } else if (!this.supportPercentAndExpand || !isc.endsWith(value, this._$percent)) {
                var intValue = parseInt(value);
                if (!isNaN(intValue)) {
                    value = intValue;
                }
            }
            
        }
        return this.Super("storeValue", [value]);
    },

    setIcons : function () {
        if (this.supportPercentAndExpand) {
            var value = this.getUserValue(this.name),
                derivedValue = this.getDerivedValue(this.name)
            ;
            this.icons = this.getDerivedValueIcons(derivedValue, value);
            this._setUpIcons();
        }
    },

    getLiveComponent : function () {
        return (this.form && this.form.currentComponent ? this.form.currentComponent.liveObject : null);
    },

    getUserValue : function (name) {
        var component = this.getLiveComponent(),
            editNode = (component ? component.editNode : null),
            defaults = (editNode ? editNode.defaults : {}),
            userValue = defaults[name]
        ;
        return userValue || "";
    },

    getDerivedValue : function (name) {
        var component = this.getLiveComponent(),
            derivedValue = (component && component.getProperty ? component.getProperty(name) : this.getValue())
        ;
        if (derivedValue == "undefined") derivedValue = null;

        return derivedValue;
    },

    isPercent : function (value) {
        if (value != null && isc.isA.String(value)) value = value.replaceAll("\"", "");
        return (isc.isA.String(value) && value.length > 0 && "%" == value.substring(value.length-1,value.length));
    },

    isExpand : function (value) {
        if (value != null && isc.isA.String(value)) value = value.replaceAll("\"", "");
        return ("*" == value);
    },

    getDerivedValueIcons : function (derivedValue, value) {
        if (derivedValue == null || value == null) return null;
        var promptText = (value != "" ?
                            "Current value based on configured value of '" + value + "'" :
                            "[no specified value]");
        var icon = {
            name: "derivedValue",
            text: derivedValue,
            width: 32,
            inline: true,
            inlineIconAlign: "right",
            baseStyle: "measureItemCurrentValue",   // In visualBuilder.css
            neverDisable: true,
            showFocused: false,
            showOver: false,
            prompt: promptText
        };
        return [icon];
    }
});

//>	@class	FormFieldMeasureItem
// FormItem intended for inputting measurement values like width where the value
// can be a fixed numeric number or expand-to-fill (*). Percent (%) is not accepted.
//
// @inheritsFrom MeasureItem
// @visibility tools
//<
isc.ClassFactory.defineClass("FormFieldMeasureItem", "MeasureItem");
isc.FormFieldMeasureItem.addProperties({
    keyPressFilter: "[0-9\*]"
});
