/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * is published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.smartgwt.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.*;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.smartgwt.client.bean.BeanFactory;
import com.smartgwt.rebind.BeanClass;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.HashSet;

public class AnnotationMetaBeanFactoryGenerator extends Generator {
    @Override
    public String generate (TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        TypeOracle oracle = context.getTypeOracle();

        final String genPackageName = "com.smartgwt.client.bean";
        final String genClassName = "AnnotationMetaFactoryImpl";

        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(genPackageName, genClassName);
        composer.addImplementedInterface(BeanFactory.AnnotationMetaFactory.class.getCanonicalName());

        PrintWriter printWriter = context.tryCreate(logger, genPackageName, genClassName);
        if (printWriter != null) {
            SourceWriter sourceWriter = composer.createSourceWriter(context, printWriter);
            sourceWriter.println("// This class lovingly generated by " + this.getClass().getCanonicalName() + "\n");

            // Our constructor ... will be called by GWT.create()
            sourceWriter.println(genClassName + " () {");
            sourceWriter.indent();

            Set<JClassType> typesGenerated = new HashSet<JClassType>();

            // Collect the types ...
            for (JClassType classType : oracle.getTypes()) {
                BeanFactory.Generate annotation = classType.getAnnotation(BeanFactory.Generate.class);

                if (annotation != null) {
                    TreeLogger annotationLogger = logger.branch(TreeLogger.DEBUG, "Processing @BeanFactory.Generate annotation on " + classType.getQualifiedSourceName());
                    
                    Class[] value = annotation.value();
                    if (value.length == 0) {
                        // No value supplied, so we use the class the annotation was applied to
                        if (!typesGenerated.contains(classType)) {
                            typesGenerated.add(classType);
                            generateFactory(classType, annotationLogger, context, sourceWriter);
                        }
                    } else {
                        // Some values were supplied, so we use them, and not the class itself
                        for (Class klass : value) {
                            JClassType klassValue = oracle.findType(klass.getCanonicalName());
                            if (klassValue == null) {
                                annotationLogger.log(TreeLogger.ERROR, "Could not find " + klass.getName() + " in source classpath.");
                                throw new UnableToCompleteException();
                            } else {
                                if (!typesGenerated.contains(klassValue)) {
                                    typesGenerated.add(klassValue);
                                    generateFactory(klassValue, annotationLogger, context, sourceWriter);
                                }
                            }
                        }
                    }
                }
            }

            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.commit(logger);
        }

        return composer.getCreatedClassName();
    }

    public void generateFactory (JClassType classType, TreeLogger logger, GeneratorContext context, SourceWriter sourceWriter) throws UnableToCompleteException {
        BeanClass beanClass = new BeanClass(classType);
        beanClass.generateFactory(logger, context);

        // We have to instantiate the factory to register it in the BeanFactory static API
        sourceWriter.println(beanClass.getQualifiedFactoryName() + ".create(false);");
    }
}
