/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * Use the HTMLFlow component to display HTML content that should expand to its natural size without scrolling. <p> HTML
 * content can be specified directly via {@link com.smartgwt.client.widgets.HTMLFlow#getContents contents}, or loaded from
 * a  URL via the property {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL}.  This method of loading
 * is for simple HTML content only; Smart GWT components should be loaded via the {@link
 * com.smartgwt.client.widgets.ViewLoader} class. <P> HTMLFlows are typically used to render snippets of HTML directly in
 * the document rather than holding a complete HTML page, as the component can only size to fit HTML content it renders
 * directly into the DOM. If you are looking to display a complete HTML page, you will need to modify the default {@link
 * com.smartgwt.client.types.Overflow} and {@link com.smartgwt.client.widgets.HTMLFlow#getDefaultHeight defaultHeight}, or
 * use the {@link com.smartgwt.client.widgets.HTMLPane} class  <P> NOTE: Since the size of an HTMLFlow component is
 * determined by its HTML contents, this component will draw at varying sizes if given content of varying size.  When using
 * HTMLFlow components within a Layout, consider what will happen if the HTMLFlow renders at various sizes.  An HTMLFlow
 * which can expand should be placed in a container where other components can render smaller, where the container is
 * allowed to scroll, or where there is padding to expand into. <p> HTMLFlow is a {@link
 * com.smartgwt.client.widgets.DataBoundComponent} but only supports one method at this time, {@link
 * com.smartgwt.client.widgets.HTMLFlow#fetchRelatedData fetchRelatedData}.
 * @see com.smartgwt.client.docs.ContentLoading ContentLoading overview and related methods
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("HTMLFlow")
public class HTMLFlow extends Canvas implements com.smartgwt.client.widgets.events.HasContentLoadedHandlers {

    public static HTMLFlow getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new HTMLFlow(jsObj);
        } else {
            assert refInstance instanceof HTMLFlow;
            return (HTMLFlow)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(HTMLFlow.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.HTMLFlow.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(HTMLFlow.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.HTMLFlow.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public HTMLFlow(){
        scClassName = "HTMLFlow";
    }

    public HTMLFlow(JavaScriptObject jsObj){
        scClassName = "HTMLFlow";
        setJavaScriptObject(jsObj);
    }


    public HTMLFlow(String contents) {
        setContents(contents);
                scClassName = "HTMLFlow";
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * By default an HTMLFlow will explicitly prevent browser caching. <P> Set to true to allow browser caching <b>if the
     * browser would normally do so</b>, in other words, if the HTTP headers returned with the response indicate that the
     * response can be cached.
     *
     * @param allowCaching New allowCaching value. Default value is false
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public HTMLFlow setAllowCaching(Boolean allowCaching)  throws IllegalStateException {
        return (HTMLFlow)setAttribute("allowCaching", allowCaching, false);
    }

    /**
     * By default an HTMLFlow will explicitly prevent browser caching. <P> Set to true to allow browser caching <b>if the
     * browser would normally do so</b>, in other words, if the HTTP headers returned with the response indicate that the
     * response can be cached.
     *
     * @return Current allowCaching value. Default value is false
     */
    public Boolean getAllowCaching()  {
        Boolean result = getAttributeAsBoolean("allowCaching");
        return result == null ? false : result;
    }
    

    /**
     * If this component is passed a URL with a protocol that differs from the current page, should it be automatically changed
     * to match the page?
     *
     * @param autoChangeProtocol New autoChangeProtocol value. Default value is true
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setAutoChangeProtocol(Boolean autoChangeProtocol) {
        return (HTMLFlow)setAttribute("autoChangeProtocol", autoChangeProtocol, true);
    }

    /**
     * If this component is passed a URL with a protocol that differs from the current page, should it be automatically changed
     * to match the page?
     *
     * @return Current autoChangeProtocol value. Default value is true
     */
    public Boolean getAutoChangeProtocol()  {
        Boolean result = getAttributeAsBoolean("autoChangeProtocol");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.types.ContentsType} is not explicitly specified, should it be automatically derived? <P>
     * If set to true, this component will use {@link com.smartgwt.client.widgets.HTMLFlow#isPageHTML isPageHTML()} to
     * determine whether the contents are a standalone HTML page which should be rendered into an embedded IFRAME rather than
     * written directly into the component's handle in the DOM. <P> Note that this property will auto derive the appropriate
     * contents type for both  explicitly specified {@link com.smartgwt.client.widgets.HTMLFlow#getContents contents} and for
     * HTML loaded from the {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} <P> See {@link
     * com.smartgwt.client.types.ContentsType} for further information on displaying complete HTML pages in an IFRAME.
     *
     * @param autoDeriveContentsType New autoDeriveContentsType value. Default value is false
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setAutoDeriveContentsType(boolean autoDeriveContentsType) {
        return (HTMLFlow)setAttribute("autoDeriveContentsType", autoDeriveContentsType, true);
    }

    /**
     * If {@link com.smartgwt.client.types.ContentsType} is not explicitly specified, should it be automatically derived? <P>
     * If set to true, this component will use {@link com.smartgwt.client.widgets.HTMLFlow#isPageHTML isPageHTML()} to
     * determine whether the contents are a standalone HTML page which should be rendered into an embedded IFRAME rather than
     * written directly into the component's handle in the DOM. <P> Note that this property will auto derive the appropriate
     * contents type for both  explicitly specified {@link com.smartgwt.client.widgets.HTMLFlow#getContents contents} and for
     * HTML loaded from the {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} <P> See {@link
     * com.smartgwt.client.types.ContentsType} for further information on displaying complete HTML pages in an IFRAME.
     *
     * @return Current autoDeriveContentsType value. Default value is false
     */
    public boolean getAutoDeriveContentsType()  {
        Boolean result = getAttributeAsBoolean("autoDeriveContentsType");
        return result == null ? false : result;
    }
    

    /**
     * Text selection for copy and paste is enabled by default in the HTMLFlow class. Note that this setting has no impact if
     * {@link com.smartgwt.client.types.ContentsType} is set to  {@link com.smartgwt.client.types.ContentsType#PAGE}. In this
     * case contents is loaded from a target URL via an IFRAME element, and text selection behavior will be dictated by the
     * loaded HTML.
     *
     * @param canSelectText New canSelectText value. Default value is true
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public HTMLFlow setCanSelectText(Boolean canSelectText)  throws IllegalStateException {
        return (HTMLFlow)setAttribute("canSelectText", canSelectText, false);
    }

    /**
     * Text selection for copy and paste is enabled by default in the HTMLFlow class. Note that this setting has no impact if
     * {@link com.smartgwt.client.types.ContentsType} is set to  {@link com.smartgwt.client.types.ContentsType#PAGE}. In this
     * case contents is loaded from a target URL via an IFRAME element, and text selection behavior will be dictated by the
     * loaded HTML.
     *
     * @return Current canSelectText value. Default value is true
     */
    public Boolean getCanSelectText()  {
        Boolean result = getAttributeAsBoolean("canSelectText");
        return result == null ? true : result;
    }
    

    /**
     * If true, Smart GWT components created while executing the loaded HTML are captured for rendering inside the HTMLFlow.
     * <P> Only applies when contentsType is <b>not</b> "page".
     *
     * @param captureSCComponents New captureSCComponents value. Default value is true
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public HTMLFlow setCaptureSCComponents(Boolean captureSCComponents)  throws IllegalStateException {
        return (HTMLFlow)setAttribute("captureSCComponents", captureSCComponents, false);
    }

    /**
     * If true, Smart GWT components created while executing the loaded HTML are captured for rendering inside the HTMLFlow.
     * <P> Only applies when contentsType is <b>not</b> "page".
     *
     * @return Current captureSCComponents value. Default value is true
     */
    public Boolean getCaptureSCComponents()  {
        Boolean result = getAttributeAsBoolean("captureSCComponents");
        return result == null ? true : result;
    }
    

    /**
     * String of HTML contents for this component - may be a fragment of HTML to display or a complete HTML page. See {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage supportsContentsAsPage}. <P> To load HTML contents from a
     * URL, use {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} instead of this property. If
     * <code>contentsURL</code> is non-null, <code>contents</code> will be ignored.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes the contents of a widget to newContents, an HTML string.
     *
     * @param contents an HTML string to be set as the contents of this widget. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.HTMLFlow#setContentsURL
     * @see com.smartgwt.client.widgets.HTMLFlow#setDynamicContents
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public HTMLFlow setContents(String contents) {
        return (HTMLFlow)setAttribute("contents", contents, true);
    }

    /**
     * String of HTML contents for this component - may be a fragment of HTML to display or a complete HTML page. See {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage supportsContentsAsPage}. <P> To load HTML contents from a
     * URL, use {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} instead of this property. If
     * <code>contentsURL</code> is non-null, <code>contents</code> will be ignored.
     *
     * @return Current contents value. Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.HTMLFlow#getContentsURL
     * @see com.smartgwt.client.widgets.HTMLFlow#getDynamicContents
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getContents()  {
        return getAttributeAsString("contents");
    }
    

    /**
     * The <code>contentsType</code> attribute governs whether the contents  of this htmlFlow are a fragment of HTML to
     * inserted directly into the DOM,  or a complete HTML page to be displayed in an IFRAME. If not explicitly specified,
     * {@link com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType autoDeriveContentsType} may be set to
     * automatically determine the appropriate contents type by analyzing the contents of the component. If
     * <code>autoDeriveContentsType</code> is false and <code>contentsType</code> is not explicitly specified, contents will
     * always be assumed to be <code>"fragment"</code>. <P> HTMLFlow contents may be {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContents directly specified} or loaded from a  {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURL specified URL}. Note that if {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage supportsContentsAsPage} is  false and no {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} is specified, the contents string will always be
     * assumed to be a fragment, even if {@link com.smartgwt.client.types.ContentsType} is explicitly set to
     * <code>"page"</code>. <P> Note that an HTMLFlow with contentsType:"page" should not be used to  load and display a page
     * containing a set of Smart GWT components into the application. To dynamically load Smart GWT components, use {@link
     * com.smartgwt.client.widgets.ViewLoader}, <b>never</b> this mechanism (click {@link com.smartgwt.client.docs.NoFrames
     * here} for why). <P> <b>Scripting, CSS and scoping considerations for HTMLFlow contents</b><br> The following
     * considerations apply to HTMLFlow contents, whether directly specified or loaded from a contentsURL. <P> When
     * contentsType is <code>"page"</code>, the HTML content will be rendered as  a standalone document using an IFRAME. Use
     * {@link com.smartgwt.client.widgets.HTMLFlow#getIframeSandbox iframeSandbox} to specify  IFRAME restrictions using the
     * native <a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox' target='_blank'>sandbox
     * attribute</a>. Note that any script (if allowed) will be executed in the scope of the embedded IFRAME window, not the
     * main application window. Similarly, other features like css stylesheets loaded by the HTMLFlow will apply to the IFRAME
     * window only, and the IFRAME will not pick up css style from the main application by default. <P> When contentsType is
     * <code>"fragment"</code>, if script is encountered within the HTML  fragment it will be evaluated in the scope of the
     * main application if {@link com.smartgwt.client.widgets.HTMLFlow#getEvalScriptBlocks evalScriptBlocks} is enabled.
     * Developers should be aware that this evaluation occurs as part of the draw/redraw process, but unlike script embedded
     * directly in a static HTML page, it is not processed by the browser while the elements are being written into the DOM and
     * <code>document.write(...)</code> can not be used to modify the HTML as it is being rendered. In this mode, since the
     * contents is written directly into the DOM, standard css styling  for the page will be applied. <P> Note that if {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType autoDeriveContentsType} is enabled, the default set of
     * recognized {@link com.smartgwt.client.widgets.HTMLFlow#getStructuralHTMLTags structuralHTMLTags} include
     * <code>&lt;script&gt</code>, so HTML contents  including script will display as <code>contentsType:"page"</code>. The
     * list of <code>structuralHTMLTags</code> can be modified to exclude script tags if desired.
     *
     * @param contentsType New contentsType value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public HTMLFlow setContentsType(ContentsType contentsType)  throws IllegalStateException {
        return (HTMLFlow)setAttribute("contentsType", contentsType == null ? null : contentsType.getValue(), false);
    }

    /**
     * The <code>contentsType</code> attribute governs whether the contents  of this htmlFlow are a fragment of HTML to
     * inserted directly into the DOM,  or a complete HTML page to be displayed in an IFRAME. If not explicitly specified,
     * {@link com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType autoDeriveContentsType} may be set to
     * automatically determine the appropriate contents type by analyzing the contents of the component. If
     * <code>autoDeriveContentsType</code> is false and <code>contentsType</code> is not explicitly specified, contents will
     * always be assumed to be <code>"fragment"</code>. <P> HTMLFlow contents may be {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContents directly specified} or loaded from a  {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURL specified URL}. Note that if {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage supportsContentsAsPage} is  false and no {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} is specified, the contents string will always be
     * assumed to be a fragment, even if {@link com.smartgwt.client.types.ContentsType} is explicitly set to
     * <code>"page"</code>. <P> Note that an HTMLFlow with contentsType:"page" should not be used to  load and display a page
     * containing a set of Smart GWT components into the application. To dynamically load Smart GWT components, use {@link
     * com.smartgwt.client.widgets.ViewLoader}, <b>never</b> this mechanism (click {@link com.smartgwt.client.docs.NoFrames
     * here} for why). <P> <b>Scripting, CSS and scoping considerations for HTMLFlow contents</b><br> The following
     * considerations apply to HTMLFlow contents, whether directly specified or loaded from a contentsURL. <P> When
     * contentsType is <code>"page"</code>, the HTML content will be rendered as  a standalone document using an IFRAME. Use
     * {@link com.smartgwt.client.widgets.HTMLFlow#getIframeSandbox iframeSandbox} to specify  IFRAME restrictions using the
     * native <a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox' target='_blank'>sandbox
     * attribute</a>. Note that any script (if allowed) will be executed in the scope of the embedded IFRAME window, not the
     * main application window. Similarly, other features like css stylesheets loaded by the HTMLFlow will apply to the IFRAME
     * window only, and the IFRAME will not pick up css style from the main application by default. <P> When contentsType is
     * <code>"fragment"</code>, if script is encountered within the HTML  fragment it will be evaluated in the scope of the
     * main application if {@link com.smartgwt.client.widgets.HTMLFlow#getEvalScriptBlocks evalScriptBlocks} is enabled.
     * Developers should be aware that this evaluation occurs as part of the draw/redraw process, but unlike script embedded
     * directly in a static HTML page, it is not processed by the browser while the elements are being written into the DOM and
     * <code>document.write(...)</code> can not be used to modify the HTML as it is being rendered. In this mode, since the
     * contents is written directly into the DOM, standard css styling  for the page will be applied. <P> Note that if {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType autoDeriveContentsType} is enabled, the default set of
     * recognized {@link com.smartgwt.client.widgets.HTMLFlow#getStructuralHTMLTags structuralHTMLTags} include
     * <code>&lt;script&gt</code>, so HTML contents  including script will display as <code>contentsType:"page"</code>. The
     * list of <code>structuralHTMLTags</code> can be modified to exclude script tags if desired.
     *
     * @return Current contentsType value. Default value is null
     */
    public ContentsType getContentsType()  {
        return EnumUtil.getEnum(ContentsType.values(), getAttribute("contentsType"));
    }
    

    /**
     * If specified the HTMLFlow will load its contents from this URL instead of displaying {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContents this.contents}. May be combined with parameters if {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURLParams contentsURLParams} were specified. <P> The HTML retrieved from
     * the target URL may be a complete standalone page to be rendered into its own scope using an IFRAME, or a fragment of
     * HTML  to display within this component's handle. See {@link com.smartgwt.client.types.ContentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType autoDeriveContentsType} for more information. <P> Note
     * that the link{loadingMessage} and {@link com.smartgwt.client.widgets.HTMLFlow#getHttpMethod httpMethod} features only
     * apply if contentsURL was set and  contentsType was not explicitly set to  <code>"page"</code>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Change the URL this component loads content from.  Triggers a fetch for content from the new URL. <p> Can also be called with no arguments to reload content from the existing {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL}.
     *
     * @param contentsURL URL to retrieve contents from. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.URL URL 
     */
    public HTMLFlow setContentsURL(String contentsURL) {
        return (HTMLFlow)setAttribute("contentsURL", contentsURL, true);
    }

    /**
     * If specified the HTMLFlow will load its contents from this URL instead of displaying {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContents this.contents}. May be combined with parameters if {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURLParams contentsURLParams} were specified. <P> The HTML retrieved from
     * the target URL may be a complete standalone page to be rendered into its own scope using an IFRAME, or a fragment of
     * HTML  to display within this component's handle. See {@link com.smartgwt.client.types.ContentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType autoDeriveContentsType} for more information. <P> Note
     * that the link{loadingMessage} and {@link com.smartgwt.client.widgets.HTMLFlow#getHttpMethod httpMethod} features only
     * apply if contentsURL was set and  contentsType was not explicitly set to  <code>"page"</code>
     *
     * @return Current contentsURL value. Default value is null
     * @see com.smartgwt.client.docs.URL URL 
     */
    public String getContentsURL()  {
        return getAttributeAsString("contentsURL");
    }
    

    /**
     * Parameters to be sent to the contentsURL when fetching content.
     *
     * @param contentsURLParams New contentsURLParams value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setContentsURLParams(Map contentsURLParams) {
        return (HTMLFlow)setAttribute("contentsURLParams", contentsURLParams, true);
    }
    

    /**
     * HTMLFlow defaultHeight is set to <code>1</code> which, together with  {@link com.smartgwt.client.types.Overflow
     * overflow:"visible"} causes the HTMLFlow to size to its content HTML. <P> Note that if {@link
     * com.smartgwt.client.types.ContentsType} is <code>"page"</code>, <code>overflow:"visible"</code> is not supported - for
     * this usage an explicit larger height should be specified. You may  want to use the preconfigured {@link
     * com.smartgwt.client.widgets.HTMLPane} class instead of HTMLFlow for this usage.
     *
     * @param defaultHeight New defaultHeight value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setDefaultHeight(int defaultHeight) {
        return (HTMLFlow)setAttribute("defaultHeight", defaultHeight, true);
    }

    /**
     * HTMLFlow defaultHeight is set to <code>1</code> which, together with  {@link com.smartgwt.client.types.Overflow
     * overflow:"visible"} causes the HTMLFlow to size to its content HTML. <P> Note that if {@link
     * com.smartgwt.client.types.ContentsType} is <code>"page"</code>, <code>overflow:"visible"</code> is not supported - for
     * this usage an explicit larger height should be specified. You may  want to use the preconfigured {@link
     * com.smartgwt.client.widgets.HTMLPane} class instead of HTMLFlow for this usage.
     *
     * @return Current defaultHeight value. Default value is 1
     */
    public int getDefaultHeight()  {
        return getAttributeAsInt("defaultHeight");
    }
    

    /**
     * For custom components, establishes a default width for the component. <P> For a component that should potentially be
     * sized automatically by a Layout, set this property rather than {@link com.smartgwt.client.widgets.Canvas#getWidth width}
     * directly, because Layouts regard a width setting as an explicit size that shouldn't be changed.
     *
     * @param defaultWidth New defaultWidth value. Default value is 200
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public HTMLFlow setDefaultWidth(int defaultWidth) {
        return (HTMLFlow)setAttribute("defaultWidth", defaultWidth, true);
    }

    /**
     * For custom components, establishes a default width for the component. <P> For a component that should potentially be
     * sized automatically by a Layout, set this property rather than {@link com.smartgwt.client.widgets.Canvas#getWidth width}
     * directly, because Layouts regard a width setting as an explicit size that shouldn't be changed.
     *
     * @return Current defaultWidth value. Default value is 200
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public int getDefaultWidth()  {
        return getAttributeAsInt("defaultWidth");
    }
    

    /**
     * Dynamic string of HTML contents for this component. As with {@link com.smartgwt.client.widgets.HTMLFlow#getContents
     * contents}, this may be a fragment of HTML to display or a complete HTML page. See {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage supportsContentsAsPage}. <P> See {@link
     * com.smartgwt.client.widgets.Canvas#getDynamicContents Canvas.dynamicContents} for details on how dynamicContents are
     * resolved to a final string value.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dynamicContents New dynamicContents value. Default value is false
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setDynamicContents(Boolean dynamicContents) {
        return (HTMLFlow)setAttribute("dynamicContents", dynamicContents, true);
    }

    /**
     * Dynamic string of HTML contents for this component. As with {@link com.smartgwt.client.widgets.HTMLFlow#getContents
     * contents}, this may be a fragment of HTML to display or a complete HTML page. See {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage supportsContentsAsPage}. <P> See {@link
     * com.smartgwt.client.widgets.Canvas#getDynamicContents Canvas.dynamicContents} for details on how dynamicContents are
     * resolved to a final string value.
     *
     * @return Current dynamicContents value. Default value is false
     */
    public Boolean getDynamicContents()  {
        Boolean result = getAttributeAsBoolean("dynamicContents");
        return result == null ? false : result;
    }
    

    /**
     * If <code>evalScriptBlocks</code> is true, HTMLFlow will pre-process the loaded HTML in order to mimic how the HTML would
     * execute if it were loaded as an independent page or loaded via an IFRAME.   <P> This feature is intended to assist with
     * migrating existing applications to Smart GWT. <P> <code>evalScriptBlocks</code> is enabled by default when loading
     * remote content (via {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL}) and disabled by default for
     * content supplied via {@link com.smartgwt.client.widgets.HTMLFlow#setContents setContents()}. <P> Note that, if
     * evalScriptBlocks is false, &lt;SCRIPT&gt; blocks will still be detected and disabled to avoid the inconsistent results
     * across different browsers. <P> Only applies when contentsType is <b>not</b> "page".
     *
     * @param evalScriptBlocks New evalScriptBlocks value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public HTMLFlow setEvalScriptBlocks(Boolean evalScriptBlocks)  throws IllegalStateException {
        return (HTMLFlow)setAttribute("evalScriptBlocks", evalScriptBlocks, false);
    }

    /**
     * If <code>evalScriptBlocks</code> is true, HTMLFlow will pre-process the loaded HTML in order to mimic how the HTML would
     * execute if it were loaded as an independent page or loaded via an IFRAME.   <P> This feature is intended to assist with
     * migrating existing applications to Smart GWT. <P> <code>evalScriptBlocks</code> is enabled by default when loading
     * remote content (via {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL}) and disabled by default for
     * content supplied via {@link com.smartgwt.client.widgets.HTMLFlow#setContents setContents()}. <P> Note that, if
     * evalScriptBlocks is false, &lt;SCRIPT&gt; blocks will still be detected and disabled to avoid the inconsistent results
     * across different browsers. <P> Only applies when contentsType is <b>not</b> "page".
     *
     * @return Current evalScriptBlocks value. Default value is null
     */
    public Boolean getEvalScriptBlocks()  {
        return getAttributeAsBoolean("evalScriptBlocks");
    }
    

    /**
     * Selects the HTTP method that will be used when fetching content.  Valid values are "POST" and "GET".
     *
     * @param httpMethod New httpMethod value. Default value is "GET"
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setHttpMethod(SendMethod httpMethod) {
        return (HTMLFlow)setAttribute("httpMethod", httpMethod == null ? null : httpMethod.getValue(), true);
    }

    /**
     * Selects the HTTP method that will be used when fetching content.  Valid values are "POST" and "GET".
     *
     * @return Current httpMethod value. Default value is "GET"
     */
    public SendMethod getHttpMethod()  {
        return EnumUtil.getEnum(SendMethod.values(), getAttribute("httpMethod"));
    }
    

    /**
     * When using {@link com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType}  {@link
     * com.smartgwt.client.types.ContentsType#PAGE},  sets the &lt;iframe&gt; <code>sandbox</code> attribute to the provided
     * value. <p> Use the value "*ALL*" to cause the "sandbox" attribute to be output with no value (which causes full
     * sandboxing). <p> See any HTML reference for other legal values of the "sandbox" attribute, which allow you to remove
     * individual restrictions on the loaded content. <p> Note that Smart GWT simply applies the provided value to the
     * generated &lt;iframe&gt; element and cannot fix bugs or differences in sandbox behavior across different browsers.
     *
     * @param iframeSandbox New iframeSandbox value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public HTMLFlow setIframeSandbox(String iframeSandbox)  throws IllegalStateException {
        return (HTMLFlow)setAttribute("iframeSandbox", iframeSandbox, false);
    }

    /**
     * When using {@link com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType}  {@link
     * com.smartgwt.client.types.ContentsType#PAGE},  sets the &lt;iframe&gt; <code>sandbox</code> attribute to the provided
     * value. <p> Use the value "*ALL*" to cause the "sandbox" attribute to be output with no value (which causes full
     * sandboxing). <p> See any HTML reference for other legal values of the "sandbox" attribute, which allow you to remove
     * individual restrictions on the loaded content. <p> Note that Smart GWT simply applies the provided value to the
     * generated &lt;iframe&gt; element and cannot fix bugs or differences in sandbox behavior across different browsers.
     *
     * @return Current iframeSandbox value. Default value is null
     */
    public String getIframeSandbox()  {
        return getAttributeAsString("iframeSandbox");
    }
    

    /**
     * HTML to show while content is being fetched, active only if the <code>contentsURL</code> property has been set. Use
     * <code>"&#36;{loadingImage}"</code> to include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading
     * image}. <P> The loading message will show both during the initial load of content, and during reload if the contents are
     * reloaded or the contentsURL changed.  For a first-time only loading message, initialize the <code>contents</code>
     * property instead. <P> Note: the <code>loadingMessage</code> is never displayed when {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} was explicitly specified as <code>"page"</code>.
     *
     * @param loadingMessage New loadingMessage value. Default value is "&amp;nbsp;${loadingImage}"
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public HTMLFlow setLoadingMessage(String loadingMessage) {
        return (HTMLFlow)setAttribute("loadingMessage", loadingMessage, true);
    }

    /**
     * HTML to show while content is being fetched, active only if the <code>contentsURL</code> property has been set. Use
     * <code>"&#36;{loadingImage}"</code> to include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading
     * image}. <P> The loading message will show both during the initial load of content, and during reload if the contents are
     * reloaded or the contentsURL changed.  For a first-time only loading message, initialize the <code>contents</code>
     * property instead. <P> Note: the <code>loadingMessage</code> is never displayed when {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} was explicitly specified as <code>"page"</code>.
     *
     * @return Current loadingMessage value. Default value is "&amp;nbsp;${loadingImage}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getLoadingMessage()  {
        return getAttributeAsString("loadingMessage");
    }
    

    /**
     * HTMLFlows are <code>overflow:"visible"</code> by default, allowing them to fit their HTML content. <P> Note that if
     * {@link com.smartgwt.client.types.ContentsType} is <code>"page"</code>, <code>overflow:"visible"</code> is not supported
     * and the overflow will default to <code>"auto"</code> instead
     *
     * @param overflow New overflow value. Default value is Canvas.VISIBLE
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setOverflow(Overflow overflow) {
        return (HTMLFlow)setAttribute("overflow", overflow == null ? null : overflow.getValue(), true);
    }

    /**
     * HTMLFlows are <code>overflow:"visible"</code> by default, allowing them to fit their HTML content. <P> Note that if
     * {@link com.smartgwt.client.types.ContentsType} is <code>"page"</code>, <code>overflow:"visible"</code> is not supported
     * and the overflow will default to <code>"auto"</code> instead
     *
     * @return Current overflow value. Default value is Canvas.VISIBLE
     */
    public Overflow getOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("overflow"));
    }
    

    /**
     * When this <code>HTMLFlow</code> is focused, causes Ctrl-A / Command-A keypresses to select just the content, as opposed
     * to all content on the screen becoming selected. This <code>HTMLFlow</code> must be {@link
     * com.smartgwt.client.widgets.Canvas#getCanFocus focusable} in order for this setting to have an effect. <p> Not valid
     * with {@link com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType}  {@link
     * com.smartgwt.client.types.ContentsType#PAGE}.
     *
     * @param selectContentOnSelectAll New selectContentOnSelectAll value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#basics_html_pane" target="examples">HTMLPane Example</a>
     */
    public HTMLFlow setSelectContentOnSelectAll(Boolean selectContentOnSelectAll) {
        return (HTMLFlow)setAttribute("selectContentOnSelectAll", selectContentOnSelectAll, true);
    }

    /**
     * When this <code>HTMLFlow</code> is focused, causes Ctrl-A / Command-A keypresses to select just the content, as opposed
     * to all content on the screen becoming selected. This <code>HTMLFlow</code> must be {@link
     * com.smartgwt.client.widgets.Canvas#getCanFocus focusable} in order for this setting to have an effect. <p> Not valid
     * with {@link com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType}  {@link
     * com.smartgwt.client.types.ContentsType#PAGE}.
     *
     * @return Current selectContentOnSelectAll value. Default value is null
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#basics_html_pane" target="examples">HTMLPane Example</a>
     */
    public Boolean getSelectContentOnSelectAll()  {
        return getAttributeAsBoolean("selectContentOnSelectAll");
    }
    

    /**
     * List of tags used to determine whether the HTML contents of an HTMLFlow should be rendered with {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType contentsType:"page"}. <P> If an HTML string contains any
     * of these tags not enclosed in either <code>&lt;pre&gt; ... &lt;/pre&gt;</code> tags or comments (<code>&lt;!-- ...
     * --&gt;</code>), {@link com.smartgwt.client.widgets.HTMLFlow#isPageHTML isPageHTML()} will return true. <P> The default
     * list of tags are as follows: <ul><li>"!doctype"</li>  <li>"html"</li>  <li>"head"</li>  <li>"body"</li> 
     * <li>"style"</li>  <li>"link"</li>  <li>"script"</li> </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param structuralHTMLTags New structuralHTMLTags value. Default value is ["!doctype","html","head","body","style","link","script"]
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setStructuralHTMLTags(String... structuralHTMLTags) {
        return (HTMLFlow)setAttribute("structuralHTMLTags", structuralHTMLTags, true);
    }

    /**
     * List of tags used to determine whether the HTML contents of an HTMLFlow should be rendered with {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType contentsType:"page"}. <P> If an HTML string contains any
     * of these tags not enclosed in either <code>&lt;pre&gt; ... &lt;/pre&gt;</code> tags or comments (<code>&lt;!-- ...
     * --&gt;</code>), {@link com.smartgwt.client.widgets.HTMLFlow#isPageHTML isPageHTML()} will return true. <P> The default
     * list of tags are as follows: <ul><li>"!doctype"</li>  <li>"html"</li>  <li>"head"</li>  <li>"body"</li> 
     * <li>"style"</li>  <li>"link"</li>  <li>"script"</li> </ul>
     *
     * @return Current structuralHTMLTags value. Default value is ["!doctype","html","head","body","style","link","script"]
     */
    public String[] getStructuralHTMLTags()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("structuralHTMLTags"));
    }
    

    /**
     * Can this component have its {@link com.smartgwt.client.widgets.HTMLFlow#getContents contents} specified as a complete
     * standalone HTML page to be rendered into an embedded IFRAME? <P> If true, if {@link
     * com.smartgwt.client.types.ContentsType} is specified as, or {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType derived to be} "page", the contents will be rendered into
     * an embedded IFRAME using the <code>srcdoc</code> attribute rather than written directly into the component handle. <P>
     * If false, contentsType has no effect unless contents are being loaded from an explicitly specified {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL}
     *
     * @param supportsContentsAsPage New supportsContentsAsPage value. Default value is true
     * @return {@link com.smartgwt.client.widgets.HTMLFlow HTMLFlow} instance, for chaining setter calls
     */
    public HTMLFlow setSupportsContentsAsPage(boolean supportsContentsAsPage) {
        return (HTMLFlow)setAttribute("supportsContentsAsPage", supportsContentsAsPage, true);
    }

    /**
     * Can this component have its {@link com.smartgwt.client.widgets.HTMLFlow#getContents contents} specified as a complete
     * standalone HTML page to be rendered into an embedded IFRAME? <P> If true, if {@link
     * com.smartgwt.client.types.ContentsType} is specified as, or {@link
     * com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType derived to be} "page", the contents will be rendered into
     * an embedded IFRAME using the <code>srcdoc</code> attribute rather than written directly into the component handle. <P>
     * If false, contentsType has no effect unless contents are being loaded from an explicitly specified {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL}
     *
     * @return Current supportsContentsAsPage value. Default value is true
     */
    public boolean getSupportsContentsAsPage()  {
        Boolean result = getAttributeAsBoolean("supportsContentsAsPage");
        return result == null ? true : result;
    }
    

    // ********************* Methods ***********************
    /**
     * Add a contentLoaded handler.
     * <p>
     * StringMethod fired when content is completely loaded in this htmlFlow. Has no default  implementation. Add a
     * notification to fire custom logic when loading completes. <P> Notes: <ul><li>A call to {@link
     * com.smartgwt.client.widgets.Canvas#setContents this.setContents()}   will cause this notification to be fired when  the
     * contents have been set. If {@link com.smartgwt.client.widgets.HTMLFlow#getEvalScriptBlocks HTMLFlow.evalScriptBlocks} is
     * true, and the HTML passed  into <code>setContents()</code> contains any <code>&lt;script src=... &gt;</code>  tags, this
     * callback will be fired asynchronously once the scripts have been loaded  from the server and executed, as well as having
     * the widget content updated</li> <li>When using {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL
     * HTMLFlow.contentsURL}, this does not apply to htmlFlows with  {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} set to <code>"page"</code></li></ul>
     *
     * @param handler the contentLoaded handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addContentLoadedHandler(com.smartgwt.client.widgets.events.ContentLoadedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.events.ContentLoadedEvent.getType()) == 0) setupContentLoadedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.events.ContentLoadedEvent.getType());
    }

    private native void setupContentLoadedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var contentLoaded = $entry(function(){
            var param = {"_this": this};
            var event = @com.smartgwt.client.widgets.events.ContentLoadedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.HTMLFlow::handleTearDownContentLoadedEvent()();
            if (hasDefaultHandler) this.Super("contentLoaded", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("contentLoaded"));
            obj.addProperties({contentLoaded:  contentLoaded              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("contentLoaded"));
            obj.contentLoaded =  contentLoaded             ;
        }
    }-*/;

    private void handleTearDownContentLoadedEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.events.ContentLoadedEvent.getType()) == 0) tearDownContentLoadedEvent();
    }

    private native void tearDownContentLoadedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("contentLoaded")) delete obj.contentLoaded;
    }-*/;

	/**
     * Based on the relationship between the DataSource this component is bound to and the DataSource specified as the "schema"
     * argument, call fetchData() to retrieve records in this data set that are related to the passed-in record. <P>
     * Relationships between DataSources are declared via {@link com.smartgwt.client.data.DataSourceField#getForeignKey
     * DataSourceField.foreignKey}. <P> For example, given two related DataSources "orders" and "orderItems", where we want to
     * fetch the "orderItems" that belong to a given "order".  "orderItems" should declare a field that is a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} to the "orders" table (for example, it might be named
     * "orderId" with foreignKey="orders.id").  Then, to load the records related to a given "order", call fetchRelatedData()
     * on the component bound to "orderItems", pass the "orders" DataSource as the "schema" and pass a record from the "orders"
     * DataSource as the "record" argument. <p> <b>Note:</b> When you expect a large number of records to be returned it is not
     * recommended to display these in the DetailViewer as it doesn't have the same level of support for large datasets as the
     * {@link com.smartgwt.client.widgets.grid.ListGrid}.
     * @param record DataSource record
     * @param schema schema of the DataSource record, or                            DataBoundComponent already bound to that schema
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBound Component Methods
     */
    public native void fetchRelatedData(ListGridRecord record, Canvas schema) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fetchRelatedData", "ListGridRecord,Canvas");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fetchRelatedData(record.@com.smartgwt.client.core.DataClass::getJsObj()(), schema == null ? null : schema.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
    }-*/;

    /**
     * @see HTMLFlow#fetchRelatedData
     */
    public void fetchRelatedData(ListGridRecord record, Canvas schema, DSCallback callback){
        fetchRelatedData(record, schema, callback, null);
    }

	/**
     * Based on the relationship between the DataSource this component is bound to and the DataSource specified as the "schema"
     * argument, call fetchData() to retrieve records in this data set that are related to the passed-in record. <P>
     * Relationships between DataSources are declared via {@link com.smartgwt.client.data.DataSourceField#getForeignKey
     * DataSourceField.foreignKey}. <P> For example, given two related DataSources "orders" and "orderItems", where we want to
     * fetch the "orderItems" that belong to a given "order".  "orderItems" should declare a field that is a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} to the "orders" table (for example, it might be named
     * "orderId" with foreignKey="orders.id").  Then, to load the records related to a given "order", call fetchRelatedData()
     * on the component bound to "orderItems", pass the "orders" DataSource as the "schema" and pass a record from the "orders"
     * DataSource as the "record" argument. <p> <b>Note:</b> When you expect a large number of records to be returned it is not
     * recommended to display these in the DetailViewer as it doesn't have the same level of support for large datasets as the
     * {@link com.smartgwt.client.widgets.grid.ListGrid}.
     * @param record DataSource record
     * @param schema schema of the DataSource record, or                            DataBoundComponent already bound to that schema
     * @param callback callback to invoke on completion
     * @param requestProperties additional properties to set on the DSRequest                                            that will be issued
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBound Component Methods
     */
    public native void fetchRelatedData(ListGridRecord record, Canvas schema, DSCallback callback, DSRequest requestProperties) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fetchRelatedData", "ListGridRecord,Canvas,DSCallback,DSRequest");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fetchRelatedData(record.@com.smartgwt.client.core.DataClass::getJsObj()(), schema == null ? null : schema.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), 
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Determines whether the html string passed in is source for a standalone HTML page as opposed to an HTML fragment to be
     * added to the DOM. <P> Returns true if any {@link com.smartgwt.client.widgets.HTMLFlow#getStructuralHTMLTags
     * structuralHTMLTags} are found in the HTML string, outside of HTML comment or <code>&lt;pre&gt; ... &lt;/pre&gt;</code>
     * blocks. <P> This method is used by {@link com.smartgwt.client.widgets.HTMLFlow#getAutoDeriveContentsType
     * autoDeriveContentsType} to determine whether the widget contents should be rendered inside an embedded IFRAME.
     * @param html HTML string to test
     *
     * @return true if the HTML string contains any structural HTML page elements.
     */
    public native boolean isPageHTML(String html) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "isPageHTML", "String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isPageHTML(html);
        return ret == null ? false : ret;
    }-*/;

	/**
     * Returns true if this htmlFlow is currently loading content from the server.<br> Note: Does not apply to htmlFlows with
     * {@link com.smartgwt.client.widgets.HTMLFlow#getContentsType contentsType} set to  <code>"page"</code>
     *
     * @return whether content is currently being loaded
     * @see com.smartgwt.client.widgets.events.ContentLoadedEvent
     */
    public native Boolean loadingContent() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "loadingContent", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.loadingContent();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Override to modify the loaded HTML before it is rendered.
     * @param html the html as loaded from the server return (HTML) html to be rendered.
     * See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     * @see com.smartgwt.client.docs.HTMLString HTMLString
     */
    public native void transformHTML(String html) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "transformHTML", "String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.transformHTML(html);
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param hTMLFlowProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(HTMLFlow hTMLFlowProperties) /*-{
        if (hTMLFlowProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(HTMLFlow.@java.lang.Object::getClass()(), "setDefaultProperties", hTMLFlowProperties.@java.lang.Object::getClass()());
        }
        hTMLFlowProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = hTMLFlowProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.HTMLFlow.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(HTMLFlowLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.allowCaching = getAttributeAsString("allowCaching");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.allowCaching:" + t.getMessage() + "\n";
        }
        try {
            s.autoChangeProtocol = getAttributeAsString("autoChangeProtocol");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.autoChangeProtocol:" + t.getMessage() + "\n";
        }
        try {
            s.autoDeriveContentsType = getAttributeAsString("autoDeriveContentsType");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.autoDeriveContentsType:" + t.getMessage() + "\n";
        }
        try {
            s.canSelectText = getAttributeAsString("canSelectText");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.canSelectText:" + t.getMessage() + "\n";
        }
        try {
            s.captureSCComponents = getAttributeAsString("captureSCComponents");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.captureSCComponents:" + t.getMessage() + "\n";
        }
        try {
            s.contents = getAttributeAsString("contents");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.contents:" + t.getMessage() + "\n";
        }
        try {
            s.contentsType = getAttributeAsString("contentsType");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.contentsType:" + t.getMessage() + "\n";
        }
        try {
            s.contentsURL = getAttributeAsString("contentsURL");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.contentsURL:" + t.getMessage() + "\n";
        }
        try {
            s.defaultHeight = getAttributeAsString("defaultHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.defaultHeight:" + t.getMessage() + "\n";
        }
        try {
            s.defaultWidth = getAttributeAsString("defaultWidth");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.defaultWidth:" + t.getMessage() + "\n";
        }
        try {
            s.dynamicContents = getAttributeAsString("dynamicContents");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.dynamicContents:" + t.getMessage() + "\n";
        }
        try {
            s.evalScriptBlocks = getAttributeAsString("evalScriptBlocks");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.evalScriptBlocks:" + t.getMessage() + "\n";
        }
        try {
            s.httpMethod = getAttributeAsString("httpMethod");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.httpMethod:" + t.getMessage() + "\n";
        }
        try {
            s.iframeSandbox = getAttributeAsString("iframeSandbox");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.iframeSandbox:" + t.getMessage() + "\n";
        }
        try {
            s.loadingMessage = getAttributeAsString("loadingMessage");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.loadingMessage:" + t.getMessage() + "\n";
        }
        try {
            s.overflow = getAttributeAsString("overflow");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.overflow:" + t.getMessage() + "\n";
        }
        try {
            s.selectContentOnSelectAll = getAttributeAsString("selectContentOnSelectAll");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.selectContentOnSelectAll:" + t.getMessage() + "\n";
        }
        try {
            s.structuralHTMLTags = getAttributeAsStringArray("structuralHTMLTags");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.structuralHTMLTagsArray:" + t.getMessage() + "\n";
        }
        try {
            s.supportsContentsAsPage = getAttributeAsString("supportsContentsAsPage");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLFlow.supportsContentsAsPage:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        HTMLFlowLogicalStructure s = new HTMLFlowLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
