package com.smartgwt.sample.showcase.client.reifyIntegration;

import java.util.HashMap;

import com.google.gwt.core.client.EntryPoint;
import com.smartgwt.client.callbacks.LoadProjectCallback;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.rpc.CreateScreenSettings;
import com.smartgwt.client.rpc.LoadProjectSettings;
import com.smartgwt.client.rpc.Project;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.tools.Reify;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.CheckboxItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.events.RecordClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.SourceEntity;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class GridSubstitutionReifySample extends ShowcasePanel {
    private static final String DESCRIPTION = "Classes used in a Reify screen can be substituted for other classes when the screen is loaded.\r" +
        "<P>\r" +
        "In this scenario, the project has a ListGrid subclass with various changes:\r" +
        "<ul><li>It shows a different set of fields</li>\r" +
        "    <li>It shows the full record when hovering over the icon field</li>\r" +
        "    <li>It turns off canRemoveRecords</li></ul>\r" +
        "The designers have decided that this feature should be present \r" +
        "in any grid that shows data records.\r" +
        "<P>\r" +
        "Below the unmodified Reify project is shown. Click any grid record to edit in the form, and \r" +
        "click the \"Save\" button to save changes.\r" +
        "<P>\r" +
        "Note how there is no icon field present, then click the \"Substitute Grid Class\" checkbox and \r" +
        "see how the project looks with the substitute grid.\r" +
        "<P>\r" +
        "Note the following:\r" +
        "<P>\r" +
        "<ul>\r" +
        "<li> the Reify-created functionality of populating the form from click on rows still works - \r" +
        "because the substitute grid is still a ListGrid and still supports Reify Actions.</li>\r" +
        "<li> an iconField with a hover as shown could actually have been created solely in Reify, \r" +
        "however, done this way, Reify designs do not have to rebuild this feature for every grid.</li>\r" +
        "<li> Reify supports adding custom classes to the Reify design environment, however, this \r" +
        "particular feature doesn't impact the design process very much, so in this case, runtime \r" +
        "substitution is used. Both are valid approaches.</li>\r" +
        "</ul>";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            GridSubstitutionReifySample panel = new GridSubstitutionReifySample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    public Canvas getViewPanel() {

        final VLayout container = new VLayout();
        container.setHeight100();
        container.setWidth100();
        container.setMembersMargin(10);
        
        LoadProjectSettings settings = new LoadProjectSettings();    
        settings.setUserName("reifySample");    
        settings.setPassword("tryReify");    
        settings.setServerURL("https://create.reify.com");   
        Reify.loadProject("Simple Grid", new LoadProjectCallback() {    
            @Override    
            public void execute(Project loadedProject, Project[] projects, RPCResponse rpcResponse) {  
                String message = RPCManager.getLoadProjectErrorMessage(rpcResponse);    
                if (message != null) {    
                    SC.warn(message);    
                    return;    
                }    
                if (rpcResponse.getStatus() == 0) { 
                    final DynamicForm form = new DynamicForm();
                    form.setDataSource(DataSource.get("supplyItem"));

                    // original listGrid
                    CreateScreenSettings initialSettings = new CreateScreenSettings();
                    initialSettings.setSuppressAutoDraw(true);

                    final Canvas initialScreen = loadedProject.createScreen("Simple Grid Screen", initialSettings);
                    final ListGrid initialListGrid = (ListGrid)initialScreen.getByLocalId("simpleGrid");
                    initialListGrid.setHeight(350);
                        initialListGrid.addRecordClickHandler(new RecordClickHandler() {
                        @Override
                        public void onRecordClick(RecordClickEvent event) {
                            form.editSelectedData(initialListGrid);
                        }
                    });

                    // substitute listGrid
                    CreateScreenSettings customSettings = new CreateScreenSettings();
                    customSettings.setComponentSubstitutions(new HashMap() {{ put("simpleGrid", MyCustomListGrid.class.getName()); }});
                    customSettings.setSuppressAutoDraw(true);

                    final Canvas newScreen = loadedProject.createScreen("Simple Grid Screen", customSettings);

                    IButton saveButton = new IButton();
                    saveButton.setTitle("Save");
                    saveButton.setWidth(100);
                    saveButton.addClickHandler(new ClickHandler() {
                        @Override
                        public void onClick(ClickEvent event) {
                            form.saveData();
                        }                    	 
                    });
                     
                    final DynamicForm mainForm = new DynamicForm();  
                    CheckboxItem cbItem = new CheckboxItem();  
                    cbItem.setTitle("Substitute Grid Class");  
                    cbItem.addChangedHandler(new ChangedHandler() {  
                        @Override  
                        public void onChanged(ChangedEvent event) {  
                            boolean value = (Boolean)event.getValue();
                            form.clearValues();
                            if (!value) {  
                                final ListGrid unmodifiedListGrid = (ListGrid)initialScreen.getByLocalId("simpleGrid");
                                unmodifiedListGrid.setHeight(350);
                                unmodifiedListGrid.addRecordClickHandler(new RecordClickHandler() {
                                    @Override
                                    public void onRecordClick(RecordClickEvent event) {
                                        form.editSelectedData(unmodifiedListGrid);
                                    }
                                });
                                container.replaceMember(container.getMember(1), unmodifiedListGrid);
                                 
                            } else {  
                                final ListGrid customListGrid = (ListGrid)newScreen.getByLocalId("simpleGrid");
                                customListGrid.setHeight(350);
                                customListGrid.addRecordClickHandler(new RecordClickHandler() {
                                    @Override
                                    public void onRecordClick(RecordClickEvent event) {
                                         form.editSelectedData(customListGrid);
                                    }
                                });
                                container.replaceMember(container.getMember(1), customListGrid);
                                    
                            }  
                        }  
                    });  
                    mainForm.setFields(cbItem);
                     
                    container.addMember(mainForm);
                    container.addMember(initialListGrid);
                    container.addMember(form);
                    container.addMember(saveButton);

                }    
            }    
        }, settings); 
                              
        return container;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

    @Override  
    protected boolean isTopIntro() {  
        return true;  
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("MyCustomListGrid.java", JAVA, "source/reifyIntegration/MyCustomListGrid.java.html", false)
        };
    }
}
