package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.SummaryFunctionType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.HeaderSpan;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class CustomAggregationSample extends ShowcasePanel {

    private static final String DESCRIPTION =
		"The Server Summaries feature allows you to implement your own custom aggregation functions\r" +
		"in addition to the built-in ones.\r" +
		"<p>\r" +
		"This sample demonstrates as fetch against the <code>orderItem</code> DataSource, grouped by customer.<br>\r" +
		"The <code>Count</code> field uses the standard <code>\"count\"</code> summary function to show how many\r" +
		"items exist that match the criteria for the specified customer.<br>\r" +
		"The <code>Items Description</code> field performs a custom aggregation to display a  \r" +
		"concatenation of <b>unique</b> items.<br>\r" +
		"<i>Note that <code>Count</code> does not match the number of items listed in the \"Items Description\" field\r" +
		"since duplicates were ignored in concatenation.</i>\r" +
		"<p>\r" +
		"Click \"View Source\" to see the source code for this sample.<br>" +
		"The <code>Source</code> tab shows client-side Java code. The request it sends to the\r" +
		"server includes settings for <code>dsRequest.groupBy</code> and <code>dsRequest.summaryFunctions</code> " +
		"(via a call to <code>dsProperties.setRawSummaryFunctions(...)</code>).\r" +
		"The <code>summaryFunctions</code> include the standard \"<code>count</code>\" function for the <code>pk</code>\r" +
		"field, as well a new summnary function name \"<code>concatDistinct</code>\" for <code>itemDescription</code>.\r" +
		"This summaryFunction is implemented in a server-side DMI. \r" +
		"See <code>operationBindings</code> in <code>aggregationCustom_orderItem</code>\r" +
		"DataSource and code in <code>OrderItemDMI.java</code>.";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	CustomAggregationSample panel = new CustomAggregationSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	final ListGrid orderItemList = new ListGrid();
    	orderItemList.setDataSource(DataSource.get("aggregationCustom_orderItem"));
    	orderItemList.setWidth(700);
    	orderItemList.setHeight(300);
    	orderItemList.setShowFilterEditor(true);
    	orderItemList.setAutoFetchData(false);
    	orderItemList.setCanEdit(false);
    	orderItemList.setCanRemoveRecords(false);
    	orderItemList.setWrapHeaderTitles(true);
    	orderItemList.setWrapCells(true);
    	orderItemList.setCellHeight(40);
    	orderItemList.setHeaderHeight(65);
    	orderItemList.setSortField(0);
    	
    	ListGridField orderCustomerName = new ListGridField("orderCustomerName");
    	orderCustomerName.setWidth(180);
    	orderCustomerName.setTitle("Customer Name");
    	ListGridField pk = new ListGridField("pk");
    	pk.setType(ListGridFieldType.INTEGER);
    	pk.setTitle("Count");
    	pk.setAlign(Alignment.CENTER);
    	pk.setWidth(100);
    	ListGridField itemDescription = new ListGridField("itemDescription");
    	itemDescription.setWidth(420);
    	itemDescription.setTitle("Items Description");
    	
    	orderItemList.setFields(orderCustomerName,pk,itemDescription);    	
    	
    	orderItemList.setHeaderSpans(new HeaderSpan[] {
    			new HeaderSpan("Aggregated items data", new String[] {"pk", "itemDescription"})
        });
    	
    	DSRequest dsProperties = new DSRequest();
    	dsProperties.setOperationId("customAggregation");
    	dsProperties.setGroupBy("orderCustomerName");
		Map<String,String> summaryFunctions = new HashMap<String,String>();
		summaryFunctions.put("pk", "count");
		summaryFunctions.put("itemDescription", "concatDistinct");
		dsProperties.setRawSummaryFunctions(summaryFunctions);
		orderItemList.fetchData(null, null, dsProperties);
    	
        return orderItemList;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

	public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
			new SourceEntity("aggregationCustom_order.ds.xml", XML, "source/aggregationCustom_order.ds.xml.html", true),
            new SourceEntity("server/OrderItemDMI.java", JAVA, "source/ds/aggregationCustom/OrderItemDMI.java.html", true)
        };
    }
}
