/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractSingleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.StringLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;

public class TrimExpressionStateObject
extends AbstractSingleEncapsulatedExpressionStateObject {
    private TrimExpression.Specification specification;
    private StateObject trimCharacter;
    public static final String HAS_FROM_PROPERTY = "hasFrom";
    public static final String SPECIFICATION_PROPERTY = "specification";
    public static final String TRIM_CHARACTER_PROPERTY = "trimCharacterStateObject";

    public TrimExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public TrimExpressionStateObject(StateObject parent, TrimExpression.Specification specification, StateObject stateObject) {
        this(parent, specification, null, stateObject);
    }

    public TrimExpressionStateObject(StateObject parent, TrimExpression.Specification specification, StateObject trimCharacter, StateObject stateObject) {
        super(parent, stateObject);
        this.specification = specification;
        this.trimCharacter = this.parent(trimCharacter);
    }

    public TrimExpressionStateObject(StateObject parent, String jpqlFragment) {
        super(parent, jpqlFragment);
    }

    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public TrimExpression getExpression() {
        return (TrimExpression)super.getExpression();
    }

    public String getIdentifier() {
        return "TRIM";
    }

    protected String getQueryBNFId() {
        return "string_primary";
    }

    public TrimExpression.Specification getSpecification() {
        return this.specification;
    }

    public StateObject getTrimCharacter() {
        return this.trimCharacter;
    }

    public boolean hasSpecification() {
        return this.specification != TrimExpression.Specification.DEFAULT;
    }

    public boolean hasTrimCharacter() {
        return this.trimCharacter != null;
    }

    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            TrimExpressionStateObject trim = (TrimExpressionStateObject)stateObject;
            return this.specification == trim.specification && this.areEquivalent(this.trimCharacter, trim.trimCharacter);
        }
        return false;
    }

    public void parse(String jpqlFragment) {
        StringBuilder sb = new StringBuilder();
        sb.append("TRIM");
        sb.append('(');
        sb.append(jpqlFragment);
        sb.append(')');
        JPQLExpression jpqlExpression = new JPQLExpression(sb, this.getGrammar(), "functions_returning_strings", true);
        TrimExpression trimExpression = (TrimExpression)jpqlExpression.getQueryStatement();
        this.setSpecification(trimExpression.getSpecification());
        this.parseTrimCharacter(trimExpression.getTrimCharacter().toParsedText());
        super.parse(trimExpression.getExpression().toParsedText());
        if (!this.hasStateObject() && this.hasTrimCharacter()) {
            this.setStateObject(new StringLiteralStateObject(this, this.trimCharacter.toString()));
            this.trimCharacter = null;
        }
    }

    public void parseTrimCharacter(CharSequence jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "pre_literal");
        this.setTrimCharacter((StateObject)stateObject);
    }

    public void removeSpecification() {
        this.setSpecification(TrimExpression.Specification.DEFAULT);
    }

    public void removeTrimCharacter() {
        this.setTrimCharacter(null);
    }

    public void setExpression(TrimExpression expression) {
        super.setExpression(expression);
    }

    public void setSpecification(TrimExpression.Specification specification) {
        Assert.isNotNull((Object)specification, "The Specification cannot be null");
        TrimExpression.Specification oldSpecification = this.specification;
        this.specification = specification;
        this.firePropertyChanged(SPECIFICATION_PROPERTY, (Object)oldSpecification, (Object)specification);
    }

    public void setStateObject(StateObject stateObject) {
        super.setStateObject(stateObject);
    }

    public void setTrimCharacter(StateObject trimCharacter) {
        StateObject oldTrimCharacter = this.trimCharacter;
        this.trimCharacter = this.parent(trimCharacter);
        this.firePropertyChanged(TRIM_CHARACTER_PROPERTY, oldTrimCharacter, trimCharacter);
    }

    protected void toTextEncapsulatedExpression(Appendable writer) throws IOException {
        if (this.specification != TrimExpression.Specification.DEFAULT) {
            writer.append(this.specification.name());
            writer.append(' ');
        }
        if (this.hasTrimCharacter()) {
            this.trimCharacter.toString(writer);
            writer.append(' ');
        }
        if (this.specification != TrimExpression.Specification.DEFAULT || this.hasTrimCharacter()) {
            writer.append("FROM");
            writer.append(' ');
        }
        super.toTextEncapsulatedExpression(writer);
    }
}

