package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates where a given field can be legally filtered.  By default, any field where {@link
 * com.smartgwt.client.data.DataSourceField#getCanFilter DataSourceField.canFilter} isn't <code>false</code> allows
 * filtering either at the  server or at the {@link com.smartgwt.client.data.ResultSet#getUseClientFiltering client},
 * according to related settings. <p> This is the recommended behavior, but it can be useful or necessary to limit
 * filtering  in some cases.
 */
public enum FieldFilterMode implements ValueEnum {
    /**
     * - filter on the client where possible and contact the server when necessary
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "both".
     */
    BOTH("both"),
    /**
     * - any change to criteria for a field causes cache invalidation and a trip to the server. This mode is quite useful for
     * cases where client filtering can't  replicate server filtering, such as: <ul> <li> search engines that consider
     * something a match based on word roots (like treating  "sunken" as a match for "sink")</li> <li> server-side formatting,
     * where values are delivered as HTML or even as images,  where the value seen in the browser no longer matches the search
     * text</li> <li> searching large files where the files won't be delivered to the client</li> </ul> By using this mode only
     * for fields that are special, you can preserve the performance  benefits of client-side filtering on other fields.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "serverOnly".
     */
    SERVERONLY("serverOnly");
    private String value;

    FieldFilterMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
