package com.smartgwt.sample.showcase.client.reifyIntegration;

import com.google.gwt.core.client.EntryPoint;
import com.smartgwt.client.callbacks.LoadProjectCallback;
import com.smartgwt.client.rpc.LoadProjectSettings;
import com.smartgwt.client.rpc.Project;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.tools.Reify;
import com.smartgwt.client.types.ChartType;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Img;
import com.smartgwt.client.widgets.chart.FacetChart;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.CheckboxItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.events.DataArrivedEvent;
import com.smartgwt.client.widgets.grid.events.DataArrivedHandler;
import com.smartgwt.client.widgets.grid.events.EditCompleteEvent;
import com.smartgwt.client.widgets.grid.events.EditCompleteHandler;
import com.smartgwt.client.widgets.grid.events.SelectionUpdatedEvent;
import com.smartgwt.client.widgets.grid.events.SelectionUpdatedHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.events.ItemClickEvent;
import com.smartgwt.client.widgets.menu.events.ItemClickHandler;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class PlaceholdersReifySample extends ShowcasePanel {
    private static final String DESCRIPTION = "Not everything can be built visually, but Reify makes it "+
    "easy to mix in custom components, even in the middle of a screen design created with Reify."+
    "<P>"+
    "In the sample below, the filterable grid and the toolbar below the chart come from a Reify screen, "+
    "but the chart itself is created manually, after the Reify screen has been loaded."+
    "<P>"+
    "In the Reify screen, an Image component is used as a placeholder for the chart (with a screenshot "+
    "of the chart). Uncheck \"Replace placeholder\" to see how the screen looks if no replacement is done."+
    "<P>"+
    "This placeholder pattern makes it easy for complex components to be injected into a Reify-controlled "+
    "screen layout, and the use of a placeholder image means that the screen design can be easily understood "+
    "when viewed with Reify, or when used for UAT (User Acceptance Tests).";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            PlaceholdersReifySample panel = new PlaceholdersReifySample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    private VLayout chartPlaceholderLayout;
    private ListGrid listGrid;
    
    public Canvas getViewPanel() {
        final VLayout container = new VLayout();
		container.setMembersMargin(10);
		container.setWidth100();
		container.setHeight100();
		

		LoadProjectSettings settings = new LoadProjectSettings();
		settings.setUserName("reifySample");
		settings.setPassword("tryReify");
		settings.setServerURL("https://create.reify.com");
		
		Reify.loadProject("Chart Placeholder", new LoadProjectCallback() {
			@Override
			public void execute(Project project, Project[] projects, RPCResponse rpcResponse) {

				if (rpcResponse.getStatus() == 0) {
					
					final Canvas screen = project.createScreen((project.getScreenNames()[0]));
					final Menu chartTypeMenu = (Menu)screen.getByLocalId("chartTypeMenu");
					final DynamicForm stackedSelectionForm = (DynamicForm)screen.getByLocalId("StackedSelectionForm");
				    final Img placeholderImg = (Img)screen.getByLocalId("placeholder");
				    chartPlaceholderLayout = (VLayout)screen.getByLocalId("chartPlaceholderLayout");
				    listGrid = (ListGrid)screen.getByLocalId("sampleChartDataGrid");

				    final DynamicForm facetChartForm = new DynamicForm();
				    CheckboxItem placeholderCB = new CheckboxItem();
				    placeholderCB.setName("placeholderCB");
				    placeholderCB.setTitle("Replace placeholder");
				    placeholderCB.addChangedHandler(new ChangedHandler() {
						@Override
						public void onChanged(ChangedEvent event) {
							boolean value = (Boolean)event.getValue();
							if (value) {
								boolean stacked = stackedSelectionForm.getValue("Stacked") == null ? false : (Boolean)stackedSelectionForm.getValue("Stacked");
		                        updateChart("Area", stacked);
		                    } else {
		                        chartPlaceholderLayout.replaceMember(chartPlaceholderLayout.getMember(1), placeholderImg);
		                    }
						}
				    });
				    facetChartForm.setFields(placeholderCB);
				    
				    listGrid.addDataArrivedHandler(new DataArrivedHandler() {
						@Override
						public void onDataArrived(DataArrivedEvent event) {
							listGrid.selectRecords(new int[] {0,1,2});
							listGrid.addSelectionUpdatedHandler(new SelectionUpdatedHandler() {
								@Override
								public void onSelectionUpdated(SelectionUpdatedEvent event) {
									if (facetChartForm.getValue("placeholderCB") != null && (Boolean)facetChartForm.getValue("placeholderCB")) {
										boolean stacked = stackedSelectionForm.getValue("Stacked") == null ? false : (Boolean)stackedSelectionForm.getValue("Stacked");
										updateChart(null, stacked);
									}
								}
							});
							
						}
				    });
				    
				    CheckboxItem stackedCB = (CheckboxItem)stackedSelectionForm.getField("Stacked");
				    stackedCB.addChangedHandler(new ChangedHandler() {
						@Override
						public void onChanged(ChangedEvent event) {
							if (facetChartForm.getValue("placeholderCB") != null && (Boolean)facetChartForm.getValue("placeholderCB")) {
								updateChart(null, (Boolean)event.getValue());
							}
						}
				    });
				    
				    chartTypeMenu.addItemClickHandler(new ItemClickHandler() {
						@Override
						public void onItemClick(ItemClickEvent event) {
							if (facetChartForm.getValue("placeholderCB") != null && (Boolean)facetChartForm.getValue("placeholderCB")) {
								boolean stacked = stackedSelectionForm.getValue("Stacked") == null ? false : (Boolean)stackedSelectionForm.getValue("Stacked");
								updateChart(event.getItem().getTitle(), stacked);
							}
						}
				    });
				    
				    container.addMember(facetChartForm);
			        container.addMember(screen);
 
	                
				} else if (rpcResponse.getStatus() < 0) {
					String responseText = rpcResponse.getHttpResponseText();

					if (rpcResponse.getStatus() >= RPCResponse.STATUS_LOGIN_REQUIRED &&
                            rpcResponse.getStatus() <= RPCResponse.STATUS_LOGIN_INCORRECT)
                    {
                        SC.warn("Authorization failed for user 'reifySample'");
            
                    } else if (responseText != null && responseText.contains("Unable to load any of the projects")) {
                    	SC.warn("Couldn't find the requested project in " +
                                "account for user 'reifySample': 'Chart Placeholder'");            
                    } else {
                    	SC.warn("Failure: " + rpcResponse.getDataAsString());
                    }
				}
			}
		}, settings);

        return container;
    }

    private void updateChart(String chartType, boolean stacked) {
		final FacetChart chart = listGrid.chartData("Product",
				new String[] {"Jun","Jul","Aug","Sep","Oct","Nov","Dec"},
				listGrid.getSelectedRecords());  
        chart.setHeight("*");  
        
        listGrid.addEditCompleteHandler(new EditCompleteHandler() {  
            public void onEditComplete(EditCompleteEvent event) {  
                chart.setData(listGrid.getSelectedRecords());  
            }  
        });
        
        chart.setStacked(!!stacked);
        if (chartType != null) {
        	chart.setChartType(ChartType.valueOf(chartType.toUpperCase()));
        	listGrid.setChartType(chart.getChartType());
        } else {
        	chart.setChartType(listGrid.getChartType());
        }

	    chartPlaceholderLayout.replaceMember(chartPlaceholderLayout.getMember(1), chart);
    }

    public String getIntro() {
        return DESCRIPTION;
    }

}
