package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.FetchMode;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.FilterBuilder;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class FilteredAggregationSample extends ShowcasePanel {

    private static final String DESCRIPTION =
		"The Server Summaries feature supports filtering by aggregated fields.\r" +
		"<p>\r" +
		"In the sample below we are performing a custom fetch against the <code>orderItem</code> DataSource.\r" +
		"The data is grouped by item, with field values for <code>quantity</code> and <code>totalSales</code> \r" +
		"aggregated via the <code>sum</code> summary function.<br>\r" +
		"The criteria applied to this fetch include values for both aggregated and non-aggregated fields.\r" +
		"In this case\r" +
		"criteria is automatically split into pre- and post-aggregation parts:\r" +
		"<ul>\r" +
		"<li/>Non-aggregated field \"unitCost\" criteria is applied before aggregation\r" +
		"<li/>Aggregated fields \"quantity\" and \"totalSales\" criteria are applied after aggregation\r" +
		"</ul>\r" +
		"Because criteria are intelligently split between pre- and post-aggregation, client-side filtering\r" +
		"can still take over when the number of results is small. You can see this in action by entering \r" +
		"a restrictive filter that allows the full data set to be loaded on the client - for example \r" +
		"<i>unitCost &gt; 40.00</i> and <i>quantity &gt; 20</i>.";

    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	FilteredAggregationSample panel = new FilteredAggregationSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	DataSource ds = DataSource.get("filteredAggregation_orderItem");
    	final FilterBuilder advancedFilter = new FilterBuilder();
    	advancedFilter.setDataSource(ds);
    	
    	AdvancedCriteria adCriteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{
    	      new Criterion("unitCost", OperatorId.GREATER_THAN, 25),
    	      new Criterion("quantity", OperatorId.GREATER_THAN, 10),
    	      new Criterion("totalSales", OperatorId.GREATER_THAN, 30)
    	});    	
    	advancedFilter.setCriteria(adCriteria);
    	
    	final ListGrid orderItemSummaryList = new ListGrid();
    	orderItemSummaryList.setDataSource(ds);
    	orderItemSummaryList.setWidth(800);
    	orderItemSummaryList.setHeight(320);
    	orderItemSummaryList.setAutoFetchData(false);
    	orderItemSummaryList.setDataFetchMode(FetchMode.BASIC);
    	orderItemSummaryList.setShowAllRecords(true);
    	orderItemSummaryList.setFetchOperation("summary");
    	
    	ListGridField itemName = new ListGridField("itemName");
    	itemName.setWidth(400);
    	ListGridField SKU = new ListGridField("SKU");
    	ListGridField unitCost = new ListGridField("unitCost");
    	unitCost.setType(ListGridFieldType.FLOAT);
    	ListGridField quantity = new ListGridField("quantity");
    	quantity.setTitle("Total qty");
    	quantity.setType(ListGridFieldType.INTEGER);
    	ListGridField totalSales = new ListGridField("totalSales");
    	totalSales.setWidth(100);
    	totalSales.setType(ListGridFieldType.FLOAT);
    	
    	orderItemSummaryList.setFields(itemName,SKU,unitCost,quantity,totalSales);    	
    	
    	IButton filterButton = new IButton();
    	filterButton.setTitle("Filter");
    	filterButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				orderItemSummaryList.fetchData(advancedFilter.getCriteria());
			}
    	});
    	
    	VLayout vLayout = new VLayout();
    	vLayout.setWidth100();
    	vLayout.setMembersMargin(20);
    	vLayout.setMembers(advancedFilter, filterButton, orderItemSummaryList);
        
    	orderItemSummaryList.fetchData(advancedFilter.getCriteria());
    	
        return vLayout;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

	public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("supplyItem.ds.xml", XML, "source/supplyItem.ds.xml.html", true)
        };
    }
}