package com.smartgwt.sample.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import com.isomorphic.jpa.EMF;

@Entity
public class Country implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
    @Column (nullable = false)
    @GeneratedValue (strategy = GenerationType.IDENTITY)
    private Long countryId;

    @Column (nullable = false)
    private String countryCode;

    @Column (nullable = false)
    private String countryName;

    @OneToMany (cascade = CascadeType.ALL, mappedBy="country")
    private List<City> cities;

    public Country ()
    {
        cities = new ArrayList<City>();
    }

    public Long getCountryId ()
    {
        return countryId;
    }

    public void setCountryId (Long countryId)
    {
        this.countryId = countryId;
    }

    public String getCountryCode ()
    {
        return countryCode;
    }

    public void setCountryCode (String countryCode)
    {
        this.countryCode = countryCode;
    }

    public String getCountryName ()
    {
        return countryName;
    }

    public void setCountryName (String countryName)
    {
        this.countryName = countryName;
    }

    public List<City> getCities ()
    {
        return cities;
    }

    public void setCities (List<City> cities)
    {
        this.cities = cities;
    }

	public void addCity(City city) {
		this.cities.add(city);
		city.setCountry(this);
	}
    
    /**
     * Returns a string representation of the object. Resulting string contains
     * full name of the class and list of its properties and their values.
     *
     * @return <code>String</code> representation of this object.
     */
    @Override
    public String toString ()
    {
        return getClass().getName()
               + "["
               + "countryId=" + ((getCountryId() == null) ? "null" : getCountryId().toString())
               + ", "
               + "countryCode=" + ((getCountryCode() == null) ? "null" : getCountryCode().toString())
               + ", "
               + "countryName=" + ((getCountryName() == null) ? "null" : getCountryName().toString())
               + "]";
    }

	public static Country findById(Long countryId) {
		Country retVal = null;
		EntityManager em = null;
        try {
        	em = EMF.getEntityManager();
			retVal = em.find(Country.class, countryId);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			em.close();
		}
		return retVal;
	}
}
