/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.xmlrules;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.binder.AbstractRulesModule;
import org.apache.commons.digester3.binder.DigesterLoader;
import org.apache.commons.digester3.xmlrules.NameSpaceURIRulesBinder;
import org.apache.commons.digester3.xmlrules.XmlRulesModule;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromXmlRulesModule
extends AbstractRulesModule {
    private static final String DIGESTER_PUBLIC_ID = "-//Apache Commons //DTD digester-rules XML V1.0//EN";
    private static final String DIGESTER_DTD_PATH = "digester-rules.dtd";
    private final URL xmlRulesDtdUrl = FromXmlRulesModule.class.getResource("digester-rules.dtd");
    private final List<InputSource> inputSource = new ArrayList<InputSource>();
    private final Set<String> systemIds = new HashSet<String>();
    private String rootPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configure() {
        if (!this.inputSource.isEmpty()) {
            throw new IllegalStateException("Re-entry is not allowed.");
        }
        try {
            this.loadRules();
            XmlRulesModule xmlRulesModule = new XmlRulesModule(new NameSpaceURIRulesBinder(this.rulesBinder()), this.getSystemIds(), this.rootPath);
            Digester digester = DigesterLoader.newLoader(xmlRulesModule).register(DIGESTER_PUBLIC_ID, this.xmlRulesDtdUrl.toString()).setXIncludeAware(true).setValidating(true).newDigester();
            for (InputSource source : this.inputSource) {
                try {
                    digester.parse(source);
                }
                catch (Exception e) {
                    this.addError("Impossible to load XML defined in the InputSource '%s': %s", source.getSystemId(), e.getMessage());
                }
            }
        }
        finally {
            this.inputSource.clear();
        }
    }

    protected abstract void loadRules();

    protected final void loadXMLRules(InputSource inputSource) {
        if (inputSource == null) {
            throw new IllegalArgumentException("Argument 'inputSource' must be not null");
        }
        this.inputSource.add(inputSource);
        String systemId = inputSource.getSystemId();
        if (systemId != null && !this.systemIds.add(systemId)) {
            this.addError("XML rules file '%s' already bound", systemId);
        }
    }

    protected final void loadXMLRules(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("Argument 'input' must be not null");
        }
        this.loadXMLRules(new InputSource(input));
    }

    protected final void loadXMLRules(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Argument 'input' must be not null");
        }
        this.loadXMLRules(new InputSource(reader));
    }

    protected final void loadXMLRules(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'input' must be not null");
        }
        try {
            this.loadXMLRules(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.rulesBinder().addError(e);
        }
    }

    protected final void loadXMLRules(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' must be not null");
        }
        try {
            this.loadXMLRules(new URL(uri));
        }
        catch (MalformedURLException e) {
            this.rulesBinder().addError(e);
        }
    }

    protected final void loadXMLRules(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must be not null");
        }
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            InputStream stream = connection.getInputStream();
            InputSource source = new InputSource(stream);
            source.setSystemId(url.toExternalForm());
            this.loadXMLRules(source);
        }
        catch (Exception e) {
            this.rulesBinder().addError(e);
        }
    }

    protected final void loadXMLRulesFromText(String xmlText) {
        if (xmlText == null) {
            throw new IllegalArgumentException("Argument 'xmlText' must be not null");
        }
        this.loadXMLRules(new StringReader(xmlText));
    }

    protected final void useRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public final Set<String> getSystemIds() {
        return Collections.unmodifiableSet(this.systemIds);
    }
}

