/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointer;

public final class JXPathBeanPointer
extends BeanPointer {
    private static final long serialVersionUID = 1L;
    private final JXPathBeanInfo beanInfo;
    private static final ThreadLocal<Boolean> additionalValidationEnabled = new ThreadLocal();

    public static void enableAdditionalValidation() {
        additionalValidationEnabled.set(Boolean.TRUE);
    }

    public static void disableAdditionalValidation() {
        additionalValidationEnabled.remove();
    }

    public JXPathBeanPointer(NodePointer parent, QName name, Object bean, JXPathBeanInfo beanInfo) {
        super(parent, name, bean, beanInfo);
        this.beanInfo = beanInfo;
    }

    public JXPathBeanPointer(QName name, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
        super(name, bean, beanInfo, locale);
        this.beanInfo = beanInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JXPathBeanPointer other = (JXPathBeanPointer)((Object)obj);
        return !(this.beanInfo == null ? other.beanInfo != null : !this.beanInfo.equals(other.beanInfo));
    }

    public boolean isValidProperty(QName name) {
        if (!super.isValidProperty(name)) {
            return false;
        }
        if (Boolean.TRUE.equals(additionalValidationEnabled.get()) && this.beanInfo.getPropertyDescriptor(name.getName()) == null) {
            throw new JXPathNotFoundException("No pointer for xpath: " + this.toString() + "/" + name);
        }
        return true;
    }
}

