/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.ExtraTypesScanner;
import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.apt.TypeComparator;
import com.google.web.bindery.requestfactory.apt.TypeVisitorBase;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class ReferredTypesCollector
extends ExtraTypesScanner<Void> {
    private final Stack<TypeElement> currentType = new Stack();
    private final SortedSet<TypeElement> seen;
    private final State state;

    public static Set<TypeElement> collect(TypeElement requestFactory, State state) {
        ReferredTypesCollector c = new ReferredTypesCollector(state);
        c.scan((Element)requestFactory, state);
        return c.seen;
    }

    private ReferredTypesCollector(State state) {
        this.seen = new TreeSet<TypeElement>(new TypeComparator(state));
        this.state = state;
    }

    @Override
    public Void visitExecutable(ExecutableElement x, State state) {
        if (this.shouldIgnore(x, state)) {
            return null;
        }
        ExecutableType xType = ReferredTypesCollector.viewIn(this.currentType.peek(), x, state);
        xType.accept(new ElementFinder(), state);
        this.checkForAnnotation(x, state);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitType(TypeElement x, State state) {
        boolean isContext = state.types.isAssignable(x.asType(), state.requestContextType);
        boolean isFactory = state.types.isAssignable(x.asType(), state.requestFactoryType);
        boolean isProxy = state.types.isAssignable(x.asType(), state.baseProxyType);
        if (isProxy || isFactory || isContext) {
            this.currentType.push(x);
            try {
                if ((isContext || isProxy) && !this.seen.add(x)) {
                    Void void_ = null;
                    return void_;
                }
                if (isProxy) {
                    x.getSuperclass().accept(new ElementFinder(), state);
                    for (TypeMirror typeMirror : x.getInterfaces()) {
                        typeMirror.accept(new ElementFinder(), state);
                    }
                }
                this.scanAllInheritedMethods(x, state);
                this.checkForAnnotation(x, state);
            }
            finally {
                this.currentType.pop();
            }
        }
        return null;
    }

    @Override
    protected void scanExtraType(TypeElement extraType) {
        this.scan((Element)extraType, this.state);
    }

    private class ElementFinder
    extends TypeVisitorBase<Void> {
        private ElementFinder() {
        }

        @Override
        public Void visitDeclared(DeclaredType x, State state) {
            Element elt = state.types.asElement(x);
            if (elt != null) {
                ReferredTypesCollector.this.scan(elt, state);
            }
            for (TypeMirror typeMirror : x.getTypeArguments()) {
                typeMirror.accept(this, state);
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableType x, State state) {
            x.getReturnType().accept(this, state);
            for (TypeMirror typeMirror : x.getParameterTypes()) {
                typeMirror.accept(this, state);
            }
            for (TypeMirror typeMirror : x.getTypeVariables()) {
                typeMirror.accept(this, state);
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable x, State state) {
            return state.types.erasure(x).accept(this, state);
        }

        @Override
        public Void visitWildcard(WildcardType x, State state) {
            return state.types.erasure(x).accept(this, state);
        }
    }
}

