/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;

public class JAXBUnmarshalListener
implements XMLUnmarshalListener {
    private Unmarshaller.Listener listener;
    private Map classBasedUnmarshalEvents;
    private Unmarshaller unmarshaller;

    public JAXBUnmarshalListener(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setListener(Unmarshaller.Listener jaxbListener) {
        this.listener = jaxbListener;
    }

    public Unmarshaller.Listener getListener() {
        return this.listener;
    }

    @Override
    public void beforeUnmarshal(Object target, Object parent) {
        block9: {
            UnmarshalCallback callback;
            if (this.classBasedUnmarshalEvents != null && (callback = (UnmarshalCallback)this.classBasedUnmarshalEvents.get(target.getClass().getName())) != null && callback.getBeforeUnmarshalCallback() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(callback.getBeforeUnmarshalCallback(), target, new Object[]{this.unmarshaller, parent}));
                            break block9;
                        }
                        catch (PrivilegedActionException ex) {
                            if (ex.getCause() instanceof IllegalAccessException) {
                                throw (IllegalAccessException)ex.getCause();
                            }
                            if (ex.getCause() instanceof InvocationTargetException) {
                                throw (InvocationTargetException)ex.getCause();
                            }
                            throw (RuntimeException)ex.getCause();
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(callback.getBeforeUnmarshalCallback(), target, new Object[]{this.unmarshaller, parent});
                }
                catch (Exception exception) {}
            }
        }
        if (this.listener != null) {
            this.listener.beforeUnmarshal(target, parent);
        }
    }

    @Override
    public void afterUnmarshal(Object target, Object parent) {
        block9: {
            UnmarshalCallback callback;
            if (this.classBasedUnmarshalEvents != null && (callback = (UnmarshalCallback)this.classBasedUnmarshalEvents.get(target.getClass().getName())) != null && callback.getAfterUnmarshalCallback() != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(callback.getAfterUnmarshalCallback(), target, new Object[]{this.unmarshaller, parent}));
                            break block9;
                        }
                        catch (PrivilegedActionException ex) {
                            if (ex.getCause() instanceof IllegalAccessException) {
                                throw (IllegalAccessException)ex.getCause();
                            }
                            if (ex.getCause() instanceof InvocationTargetException) {
                                throw (InvocationTargetException)ex.getCause();
                            }
                            throw (RuntimeException)ex.getCause();
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(callback.getAfterUnmarshalCallback(), target, new Object[]{this.unmarshaller, parent});
                }
                catch (Exception exception) {}
            }
        }
        if (this.listener != null) {
            this.listener.afterUnmarshal(target, parent);
        }
    }

    public void setClassBasedUnmarshalEvents(Map events) {
        this.classBasedUnmarshalEvents = events;
    }
}

