/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.jpql.AbstractReadAllQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

final class ObjectLevelReadQueryVisitor
extends AbstractReadAllQueryVisitor {
    ObjectLevelReadQueryVisitor(JPQLQueryContext queryContext, ObjectLevelReadQuery query) {
        super(queryContext, query);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        String variableName = expression.getVariableName();
        Collection<Join> joinFetches = this.queryContext.getJoinFetches(variableName);
        if (joinFetches != null) {
            for (Join joinFetch : joinFetches) {
                String joinFetchVariableName = this.queryContext.literal(joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                if (!variableName.equals(joinFetchVariableName)) continue;
                Expression queryExpression = this.queryContext.buildExpression(joinFetch);
                this.query.addJoinedAttribute(queryExpression);
            }
        }
    }

    @Override
    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(SelectClause expression) {
        super.visit(expression);
        expression.getSelectExpression().accept(this);
    }
}

