/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.Serializer;
import java.util.List;

public final class ClientSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private static JavaScriptObject regex = ClientSerializationStreamWriter.getQuotingRegex();
    private StringBuilder encodeBuffer;
    private final String moduleBaseURL;
    private final String serializationPolicyStrongName;
    private final Serializer serializer;

    public static native String quoteString(String var0);

    private static void append(StringBuilder sb, String token) {
        assert (token != null);
        sb.append(token);
        sb.append('|');
    }

    private static native JavaScriptObject getQuotingRegex();

    public ClientSerializationStreamWriter(Serializer serializer, String moduleBaseURL, String serializationPolicyStrongName) {
        this.serializer = serializer;
        this.moduleBaseURL = moduleBaseURL;
        this.serializationPolicyStrongName = serializationPolicyStrongName;
    }

    @Override
    public void prepareToWrite() {
        super.prepareToWrite();
        this.encodeBuffer = new StringBuilder();
        this.writeString(this.moduleBaseURL);
        this.writeString(this.serializationPolicyStrongName);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.writeHeader(buffer);
        this.writeStringTable(buffer);
        this.writePayload(buffer);
        return buffer.toString();
    }

    @Override
    public void writeLong(long value) {
        this.append(ClientSerializationStreamWriter.longToBase64(value));
    }

    @Override
    protected void append(String token) {
        ClientSerializationStreamWriter.append(this.encodeBuffer, token);
    }

    @Override
    protected String getObjectTypeSignature(Object o) {
        Class<Object> clazz = o.getClass();
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            clazz = e.getDeclaringClass();
        }
        return this.serializer.getSerializationSignature(clazz);
    }

    @Override
    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        this.serializer.serialize(this, instance, typeSignature);
    }

    private void writeHeader(StringBuilder buffer) {
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getVersion()));
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getFlags()));
    }

    private void writePayload(StringBuilder buffer) {
        buffer.append(this.encodeBuffer.toString());
    }

    private StringBuilder writeStringTable(StringBuilder buffer) {
        List<String> stringTable = this.getStringTable();
        ClientSerializationStreamWriter.append(buffer, String.valueOf(stringTable.size()));
        for (String s : stringTable) {
            ClientSerializationStreamWriter.append(buffer, ClientSerializationStreamWriter.quoteString(s));
        }
        return buffer;
    }
}

