/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource.cachesync;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.cachesync.GenericRefetchStrategy;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RESTRefetchStrategy
extends GenericRefetchStrategy {
    protected Logger log = new Logger(this.getClass());

    @Override
    public List getCacheSyncData(DSRequest request, DSResponse resp) throws Exception {
        if (!this.isCacheSyncFetchAllowed(request, resp)) {
            return new RequestValuesStrategy().getCacheSyncData(request, resp);
        }
        DataSource ds = request.getDataSource();
        String cacheSyncOp = this.getCacheSyncOperation(request);
        List valueSets = request.getValueSets();
        DSResponse[] related = new DSResponse[valueSets.size() - 1];
        ArrayList<Map> responseData = new ArrayList<Map>();
        for (int i = 0; i < valueSets.size(); ++i) {
            Map fetched = this.performExtraFetchForCacheSync((Map)valueSets.get(i), cacheSyncOp, ds, request);
            responseData.add(fetched);
        }
        return responseData;
    }

    private Map performExtraFetchForCacheSync(Map dsRequestData, String cacheSyncOp, DataSource ds, DSRequest request) throws Exception {
        DSResponse extraFetchResp;
        List<String> identifiers = ds.getPrimaryKeys();
        if (identifiers != null && identifiers.size() > 0) {
            for (int i = identifiers.size() - 1; i >= 0; --i) {
                if (dsRequestData.containsKey(identifiers.get(i))) continue;
                identifiers.remove(i);
            }
        }
        if (identifiers == null || identifiers.size() == 0) {
            identifiers = new ArrayList(dsRequestData.keySet());
        }
        HashMap criteria = new HashMap();
        for (int i = 0; i < identifiers.size(); ++i) {
            criteria.put(identifiers.get(i), dsRequestData.get(identifiers.get(i)));
        }
        DSRequest extraFetch = new DSRequest(ds, "fetch");
        extraFetch.setCriteria(criteria);
        extraFetch.setPrimaryDSRequest(request);
        if (cacheSyncOp != null) {
            extraFetch.setOperationId(cacheSyncOp);
        }
        if ((extraFetchResp = extraFetch.execute()).getStatus() != 0) {
            throw new Exception("Extra REST fetch for cache-sync purposes failed - see server log");
        }
        return extraFetchResp.getDataMap();
    }
}

