/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.RowInsertSimple;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    InputStream inputStream;
    InputStream bufferedStream;
    GZIPInputStream gzipStream;
    RowInputTextLog rowIn;
    boolean isInsert;

    ScriptReaderText(Database database, String string) {
        super(database, string);
    }

    public ScriptReaderText(Database database, String string, boolean bl) throws IOException {
        super(database, string);
        InputStream inputStream;
        this.inputStream = this.database.logger.getFileAccess().openInputStreamElement(string);
        this.bufferedStream = new BufferedInputStream(this.inputStream);
        if (bl) {
            this.gzipStream = new GZIPInputStream(this.bufferedStream);
            inputStream = this.gzipStream;
        } else {
            inputStream = this.bufferedStream;
        }
        this.dataStreamIn = new LineReader(inputStream, JavaSystem.CS_ISO_8859_1);
        this.rowIn = new RowInputTextLog(false);
    }

    @Override
    public void readAll(Session session) {
        int n;
        if (this.database.recoveryMode == 0) {
            this.errorLogger = new RowInsertSimple.DefaultErrorHandler();
            n = 3;
        } else {
            this.errorLogger = new RowInsertSimple.InsertErrorHandler(this.database, this.fileNamePath);
            n = 2;
        }
        this.readDDL(session);
        this.inserter = new RowInsertSimple(session, this.errorLogger, n);
        this.readExistingData(session);
    }

    @Override
    protected void readDDL(Session session) {
        while (true) {
            Statement statement = null;
            Result result = null;
            try {
                boolean bl = this.readLoggedStatement(session);
                if (!bl) break;
                if (this.rowIn.getStatementType() == 3) {
                    this.isInsert = true;
                    break;
                }
                statement = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
            }
            catch (HsqlException hsqlException) {
                result = Result.newErrorResult(hsqlException);
            }
            if (!result.isError() || statement != null && (statement.getType() == 53 || statement.getType() == 69 && result.getMainString().contains("org.hsqldb.Library"))) continue;
            HsqlException hsqlException = this.getError(result.getException(), this.lineCount);
            this.handleError(hsqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExistingData(Session session) {
        block15: {
            String string = null;
            block9: while (true) {
                while (true) {
                    Object object;
                    try {
                        boolean bl = false;
                        if (this.isInsert) {
                            this.isInsert = false;
                            bl = true;
                        } else {
                            bl = this.readLoggedStatement(session);
                        }
                        if (!bl) {
                            this.inserter.finishTable();
                            break block15;
                        }
                        switch (this.statementType) {
                            case 6: {
                                session.setSchema(this.currentSchema);
                                string = null;
                                continue block9;
                            }
                            case 3: {
                                if (!this.rowIn.getTableName().equals(string)) {
                                    this.inserter.finishTable();
                                    string = this.rowIn.getTableName();
                                    object = session.getSchemaName(this.currentSchema);
                                    this.currentTable = this.database.schemaManager.getUserTable(string, (String)object);
                                    this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                                }
                                this.inserter.insert(this.currentTable, this.currentStore, this.rowData);
                                continue block9;
                            }
                        }
                        object = Error.error(458, this.statement);
                        throw object;
                    }
                    catch (Throwable throwable) {
                        object = this.getError(throwable, this.lineCount);
                        this.handleError((HsqlException)object);
                        continue;
                    }
                    break;
                }
                break;
            }
            finally {
                this.inserter.close();
            }
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            try {
                this.rawStatement = this.dataStreamIn.readLine();
            }
            catch (EOFException eOFException) {
                return false;
            }
            catch (IOException iOException) {
                throw Error.error(iOException, 452, null);
            }
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(this.rawStatement);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        if (this.statement.startsWith("/*C")) {
            int n = this.statement.indexOf(42, 4);
            this.sessionNumber = Integer.parseInt(this.statement.substring(3, n));
            this.statement = this.statement.substring(n + 2);
            this.sessionChanged = true;
            this.statementType = 5;
            return;
        }
        this.sessionChanged = false;
        this.rowIn.setSource(session, this.statement);
        this.statementType = this.rowIn.getStatementType();
        switch (this.statementType) {
            case 1: 
            case 4: {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            case 6: {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
        }
        String string = this.rowIn.getTableName();
        String string2 = session.getCurrentSchemaHsqlName().name;
        this.currentTable = this.database.schemaManager.getUserTable(string, string2);
        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
        Type[] typeArray = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
        this.rowData = this.rowIn.readData(typeArray);
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.gzipStream != null) {
                this.gzipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.errorLogger != null) {
                this.errorLogger.close();
            }
            this.database.recoveryMode = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    HsqlException getError(Throwable throwable, long l) {
        HsqlException hsqlException;
        if (throwable instanceof HsqlException && (hsqlException = (HsqlException)throwable).getErrorCode() == -461) {
            return hsqlException;
        }
        return Error.error(throwable, 461, 25, new Object[]{l, throwable.toString()});
    }

    private void handleError(HsqlException hsqlException) {
        this.database.logger.logSevereEvent(hsqlException.getMessage(), hsqlException);
        if (this.database.recoveryMode == 0) {
            throw hsqlException;
        }
        this.errorLogger.writeLogStatement(this.lineCount, this.rawStatement);
    }
}

