/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.Operation;
import com.isomorphic.webdriver.SeleneseTestCase;
import com.isomorphic.webdriver.SeleneseTestOptions;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TimeoutException;

class SeleneseTestCaseParser
extends NodeVisitor {
    private static final String DETAILS_SEPARATOR = "ISC_DEVELOPER_MESSAGES: ";
    private static final String MESSAGES_SEPARATOR = "ISC_SERVER_LOG_MESSAGES: ";
    private SmartClientWebDriver driver;
    private SeleneseTestCase testCase;
    private boolean found;
    private boolean successful = true;
    private SeleneseTestOptions options;
    private PrintStream output;
    private PrintStream error;
    private boolean authed;
    private boolean debug;
    private boolean close;
    private boolean abort;
    private long speed;
    private Date start;
    private Map<String, Object> varMap = new HashMap<String, Object>();

    protected Object storeVariable(String key, Object value, boolean updateJavaScript) {
        if (updateJavaScript) {
            this.driver.storeVariable(key, value);
        }
        return this.varMap.put(key, value);
    }

    public SeleneseTestCaseParser(SmartClientWebDriver driver, String baseUrl, SeleneseTestCase testCase, SeleneseTestOptions options, PrintStream output, PrintStream error, boolean debug, boolean close) {
        if (driver != null) {
            try {
                this.driver = driver;
                if (baseUrl != null) {
                    driver.setBaseUrl(baseUrl);
                }
                if (options != null) {
                    driver.setServerLogMode(options.getServerLogMode());
                }
            }
            catch (Exception e) {
                e.printStackTrace(error);
                this.successful = false;
            }
        }
        this.testCase = testCase;
        this.options = options;
        this.output = output;
        this.error = error;
        this.debug = debug;
        this.close = close;
        this.start = new Date();
    }

    public boolean timedOut() {
        if (this.options == null) {
            return false;
        }
        Integer timeout = this.options.getTimeout();
        if (timeout == null) {
            return false;
        }
        Date now = new Date();
        return now.getTime() - this.start.getTime() > (long)(timeout * 1000);
    }

    PrintStream getOutputStream() {
        return this.output;
    }

    void setOutputStream(PrintStream output) {
        this.output = output;
    }

    PrintStream getErrorStream() {
        return this.error;
    }

    void setErrorStream(PrintStream error) {
        if (this.driver != null) {
            this.driver.setErrorStream(error);
        }
        this.error = error;
    }

    void resetSuccess() {
        this.successful = true;
        this.abort = false;
    }

    public void visitTag(Tag tag) {
        NodeList children;
        if (this.abort) {
            return;
        }
        String name = tag.getTagName();
        if ("tr".equalsIgnoreCase(name) && (children = tag.getChildren()).size() == 6) {
            this.found = true;
            if (this.testCase != null) {
                this.testCase.nextCommand(this);
            }
            RowVisitor rowVisitor = new RowVisitor(this.output);
            try {
                children.visitAllNodesWith((NodeVisitor)rowVisitor);
            }
            catch (ParserException e) {
                this.error.println("!!! Can't parse command <tr> node; skipping command.");
                e.printStackTrace(this.error);
                this.successful = false;
                return;
            }
            Object operation = null;
            boolean status = false;
            String onFailure = this.getOnFailureSetting(tag);
            if ("retry".equals(onFailure)) {
                boolean testCaseWasSuccessful = this.successful;
                int maxRetries = this.getMaxFailureRetries();
                for (int i = 0; !status && i < maxRetries; ++i) {
                    if (i > 0) {
                        long delay;
                        this.resetSuccess();
                        if (this.testCase != null) {
                            this.testCase.resetCurrentCommandOutput();
                        }
                        if (!this.debug && this.speed == 0L && (delay = this.getFailureRetryDelay()) > 0L) {
                            try {
                                Thread.sleep(delay);
                            }
                            catch (InterruptedException e) {
                                this.error.println("!!! Sleep interrupted, but we probably don't care: " + e.getMessage());
                            }
                        }
                    }
                    status = this.executeWaitAndOp(tag, rowVisitor, onFailure);
                }
                if (!testCaseWasSuccessful) {
                    this.successful = false;
                }
            } else {
                status = this.executeWaitAndOp(tag, rowVisitor, onFailure);
            }
            Boolean screenshot = this.getScreenshotSetting(tag);
            if (screenshot == null ? !status : screenshot != false) {
                try {
                    File shotfile = this.testCase.getScreenshotFile();
                    Files.write(shotfile.toPath(), (byte[])this.driver.getScreenshotAs(OutputType.BYTES), new OpenOption[0]);
                    if (this.output != null) {
                        this.output.println("// Snapshot File: " + shotfile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    this.error.println("!!! Unable to take screenshot for command " + this.testCase.getCurrentCommandIndex() + " for test case " + this.testCase.getTestName());
                    e.printStackTrace(this.error);
                }
            }
        }
    }

    private boolean executeWaitAndOp(Tag tag, RowVisitor rowVisitor, String onFailure) {
        Operation operation = rowVisitor.getOperation(this);
        boolean status = true;
        if (this.shouldAddWaitFor(operation, tag) && !this.waitForByLocators(operation, rowVisitor, onFailure)) {
            status = false;
        }
        if (!this.executeOperation(operation, onFailure)) {
            status = false;
        }
        if (this.testCase != null && !status) {
            this.testCase.commandFailure();
        }
        return status;
    }

    private boolean executeOperation(Operation operation, String onFailure) {
        long delay;
        if (this.abort) {
            return false;
        }
        Object result = null;
        boolean status = true;
        boolean mapped = true;
        String label = null;
        try {
            if (this.debug) {
                this.error.println(operation.toString());
            }
            if (Boolean.FALSE.equals(result = operation.execute())) {
                status = false;
            }
            if ("get".equals(operation.getOperator())) {
                if (this.debug) {
                    this.error.println("waitForSystemDone(true/Boolean)");
                }
                this.driver.waitForSystemDone(true);
                if (this.options != null && this.options.isReify()) {
                    if (this.debug) {
                        this.error.println("pause(3000L)");
                    }
                    this.driver.pause(3000L);
                }
            }
        }
        catch (NoSuchMethodException e) {
            String action = "skipping";
            if (this.output != null && operation != null) {
                action = "adding a comment and " + action;
            }
            this.error.println("!!! Unable to map a command from the Selenium HTML file - " + action + ".  " + e.getMessage());
            mapped = false;
        }
        catch (Throwable t) {
            Throwable cause;
            if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
                t = cause;
            }
            if (this.output != null && operation != null) {
                String[] lines;
                label = "^^^ " + t.getClass().getCanonicalName() + " ^^^";
                String message = t.getMessage();
                if (message != null && (lines = message.split("(\r)?\n")).length > 0) {
                    label = label + ": " + lines[0];
                }
            }
            t.printStackTrace(this.error);
            status = false;
            this.successful = false;
        }
        if (operation == null) {
            return status;
        }
        if (this.output != null) {
            if (!mapped) {
                this.output.print("//");
            }
            this.output.println("    " + operation.toJavaString());
            if (operation.getAndWait()) {
                this.output.println("//    driver.pause(3000L);");
            }
            if (label != null) {
                this.output.println("//  " + label);
            }
        }
        if (operation.isVerify() || operation.isWaitFor() || operation.isAssert()) {
            if (result == null) {
                status = Boolean.FALSE;
                result = status;
            }
            boolean bl = this.successful = this.successful && (Boolean)result != false;
            if (result.equals(Boolean.FALSE) && mapped && this.output != null) {
                String operator = operation.getOperator();
                this.output.println("//  ^^^ " + operator + " Failed ^^^");
                Object operand = operation.getOperand(0);
                if (operator.startsWith("waitForElement") && operand instanceof By) {
                    this.output.println("// verifyElementPresent: " + this.driver.verifyElementPresent((By)operand));
                }
                if (this.options != null && this.options.isReify()) {
                    this.output.println("// Component Tree: " + this.driver.getEval("VB.getComponentTreeIDs()", "'(unavailable)'"));
                }
            }
        }
        if (this.shouldAbortTestCase(operation, status, onFailure)) {
            this.abort = true;
            return status;
        }
        if (this.timedOut()) {
            throw new TimeoutException("Timed out in " + this.options.getTimeout() + " seconds with " + (this.successful ? "no failures" : "failures"));
        }
        long l = delay = this.debug ? 5000L : this.speed;
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                this.error.println("!!! Sleep interrupted, but we probably don't care: " + e.getMessage());
            }
        }
        return status;
    }

    public boolean getResult() {
        List<String> messages;
        if (!this.found) {
            this.error.println("!!! No valid selenese found");
        }
        if (this.getSaveMessages() && !(messages = this.driver.getClientLogs()).isEmpty()) {
            this.error.println("ISC_DEVELOPER_MESSAGES: \n" + String.join((CharSequence)"\n", messages));
        }
        if (this.getServerLogMode() != null && !(messages = this.driver.getServerLogs()).isEmpty()) {
            this.error.println("ISC_SERVER_LOG_MESSAGES: \n" + String.join((CharSequence)"\n", messages));
        }
        if (this.driver != null && this.close) {
            this.driver.quit();
        }
        if (this.testCase != null) {
            this.testCase.complete(this);
        }
        return this.successful && this.found;
    }

    void setSpeed(long speed) {
        this.speed = speed;
    }

    SeleneseTestOptions getOptions() {
        return this.options;
    }

    boolean hasDriver() {
        return this.driver != null;
    }

    SmartClientWebDriver getDriver() {
        return this.driver;
    }

    boolean getAdvancedVars() {
        return this.options != null ? this.options.getAdvancedVars() : false;
    }

    private boolean getSaveMessages() {
        return this.options != null ? this.options.getSaveMessages() : false;
    }

    private String getServerLogMode() {
        return this.options != null ? this.options.getServerLogMode() : null;
    }

    private String getMappedVarRegEx(boolean targetJavaScript) {
        if (this.varMap.size() == 0) {
            return null;
        }
        String prefix = targetJavaScript ? "(?!=[A-Za-z_])storedVars\\[(?:\"|'|\\\\\")(" : "\\$\\{(";
        String suffix = targetJavaScript ? ")(?:\"|'|\\\\\")\\]" : ")\\}";
        StringBuffer regex = new StringBuffer();
        for (String scriptVar : this.varMap.keySet()) {
            regex.append(regex.length() > 0 ? "|" : prefix);
            regex.append(scriptVar);
        }
        return regex.append(suffix).toString();
    }

    Object expandVariables(String operand, boolean targetJavaScript) {
        String expanded;
        String regex;
        if (this.getAdvancedVars()) {
            targetJavaScript = false;
        }
        if ((regex = this.getMappedVarRegEx(targetJavaScript)) == null) {
            return operand;
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(operand);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            if (end < start) {
                result.append(operand.substring(end, start));
            }
            end = m.end();
            String key = operand.substring(start, end).replaceFirst(regex, "$1");
            Object value = this.varMap.get(key);
            value = targetJavaScript && value instanceof String ? "\"" + ((String)value).replace("\"", "\\\"") + "\"" : String.valueOf(value);
            result.append(value);
        }
        if (end < operand.length()) {
            result.append(operand.substring(end));
        }
        return Operation.isLong(expanded = result.toString()) ? Long.valueOf(Long.parseLong(expanded)) : expanded;
    }

    String replaceVarsWithJava(String operand, boolean targetJavaScript) {
        String regex;
        if (this.getAdvancedVars()) {
            targetJavaScript = false;
        }
        if ((regex = this.getMappedVarRegEx(targetJavaScript)) == null) {
            return operand;
        }
        return operand.replaceAll(regex, "\" + $1 + \"").replaceAll("(\\s)*\\+(\\s)*\"\"((\\s)*$)?", "");
    }

    private boolean shouldAbortTestCase(Operation operation, boolean status, String onFailure) {
        if (this.testCase == null) {
            return operation.isWaitFor() && !this.successful;
        }
        return "continue".equals(onFailure) ? false : !status;
    }

    private boolean shouldAddWaitFor(Operation operation, Tag tag) {
        if (operation.isWaitFor()) {
            return false;
        }
        boolean value = "true".equals(tag.getAttribute("data-isc-wait-for"));
        return this.options == null || value ? value : this.options.getAddWaitFor();
    }

    private boolean waitForByLocators(Operation operation, RowVisitor visitor, String onFailure) {
        String opName = Operation.keyCommands.contains(operation.getOperator()) ? "waitForElementReadyForKeyPresses" : "waitForElementClickable";
        boolean status = true;
        if (operation.getOperand(0) instanceof By) {
            Operation op1Wait = new Operation(opName, visitor.operand1, null, this);
            boolean bl = status = status && this.executeOperation(op1Wait, onFailure);
        }
        if (operation.getOperand(1) instanceof By) {
            Operation op2Wait = new Operation(opName, visitor.operand2, null, this);
            status = status && this.executeOperation(op2Wait, onFailure);
        }
        return status;
    }

    private Boolean getScreenshotSetting(Tag tag) {
        if (this.testCase == null) {
            return false;
        }
        String attrString = tag.getAttribute("data-isc-screenshot");
        Boolean screenshot = attrString != null ? Boolean.valueOf(Boolean.parseBoolean(attrString)) : null;
        return this.options == null || screenshot != null ? screenshot : this.options.getScreenshot();
    }

    private String getOnFailureSetting(Tag tag) {
        String onFailure = tag.getAttribute("data-isc-on-failure");
        if (onFailure != null) {
            return onFailure;
        }
        if (this.options != null) {
            onFailure = this.options.getOnFailure();
        }
        return onFailure != null ? onFailure : "stop";
    }

    private int getMaxFailureRetries() {
        Integer maxRetries = null;
        if (this.options != null) {
            maxRetries = this.options.getMaxRetries();
        }
        return maxRetries != null ? maxRetries : 3;
    }

    private long getFailureRetryDelay() {
        Long millis = null;
        if (this.options != null) {
            millis = this.options.getRetryDelay();
        }
        return millis != null ? millis : 500L;
    }

    public String getAuthenticatedURL(String url) {
        if (this.options == null || this.authed) {
            return url;
        }
        String username = this.options.getUserName();
        String password = this.options.getPassword();
        if (username == null || password == null) {
            return url;
        }
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            query = query == null ? "" : query + "&";
            query = query + "USERNAME=" + username + "&PASSWORD=" + password;
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
            this.authed = true;
            return uri.toString();
        }
        catch (URISyntaxException e) {
            this.error.println("!!! Bad URL syntax, unable to add auth: " + url);
            return url;
        }
    }

    public String getAutoTestURL(String url, String fragment) {
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            query = query == null ? "" : query + "&";
            query = query + "autotest=selenium";
            if (this.options.isReactMode()) {
                query = query + "&react=1";
            }
            if (this.options.forceSkin()) {
                query = query + "&skin=" + this.options.getSkin();
            }
            if (this.options.hasMapsAPIKey()) {
                query = query + "&google_maps_api_key=" + this.options.getMapsAPIKey();
            }
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, fragment != null ? fragment : uri.getFragment());
            return uri.toString();
        }
        catch (URISyntaxException e) {
            this.error.println("!!! Bad URL syntax, unable to add autotest param: " + url);
            return url;
        }
    }

    void applySelenesePlayerOptions(Map testOptions, Map optionAPIs) {
        this.options = new SeleneseTestOptions();
        Object[] targets = new Object[]{this.options, this.driver};
        for (String optionName : testOptions.keySet()) {
            Object optionValue = testOptions.get(optionName);
            Class<Object> valueClass = optionValue.getClass();
            String methodName = (String)optionAPIs.get(optionName);
            if (methodName == null) {
                methodName = "set" + StringUtils.capitalize((String)optionName);
            }
            try {
                if (Long.class.equals(valueClass)) {
                    valueClass = Long.TYPE;
                }
                if (Integer.class.equals(valueClass)) {
                    valueClass = Integer.TYPE;
                }
                if (Boolean.class.equals(valueClass)) {
                    valueClass = Boolean.TYPE;
                }
                Method method = null;
                int methodMatches = 0;
                for (int i = 0; method == null && i < targets.length; ++i) {
                    try {
                        method = targets[i].getClass().getMethod(methodName, valueClass);
                        method.invoke(targets[i], optionValue);
                        ++methodMatches;
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        if (methodMatches != 0 || i != targets.length - 1) continue;
                        this.error.println("!!! Can't find target class with method " + methodName + ": last tried " + e.getMessage());
                    }
                }
            }
            catch (IllegalAccessException e) {
                this.error.println("!!! " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.error.println("!!! Failed to apply property " + optionName + " from options");
                e.printStackTrace(this.error);
            }
        }
    }

    private static class RowVisitor
    extends NodeVisitor {
        private int col = 0;
        private String operator;
        String operand1;
        String operand2;

        public RowVisitor(PrintStream output) {
        }

        public void reset() {
            this.col = 0;
        }

        public Operation getOperation(SeleneseTestCaseParser parser) {
            return new Operation(this.operator, this.operand1, this.operand2, parser);
        }

        public void visitTag(Tag tag) {
            String name = tag.getTagName();
            if ("td".equalsIgnoreCase(name)) {
                if (this.col == 0) {
                    this.operator = tag.getChildren().asString();
                    ++this.col;
                } else if (this.col == 1) {
                    if (tag.getChildren() != null) {
                        this.operand1 = tag.getChildren().asString();
                        this.operand1 = StringEscapeUtils.unescapeHtml((String)this.operand1);
                    } else {
                        this.operand1 = null;
                    }
                    ++this.col;
                } else if (this.col == 2) {
                    if (tag.getChildren() != null) {
                        this.operand2 = tag.getChildren().asString();
                        this.operand2 = StringEscapeUtils.unescapeHtml((String)this.operand2);
                    } else {
                        this.operand2 = null;
                    }
                    this.reset();
                }
            }
        }
    }
}

