package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VStack;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class BasicAggregationSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "Server summaries may be declared in server-side DataSource definitions via <code>groupBy</code>\r" +
        "and <code>summaryFunctions</code> properties within an <code>operationBinding</code>.\r" +
        "<p>\r" +
        "Click \"View Source\" to see source for this sample.<br>" + 
        "The <code>basicAggregation_orderItem.ds.xml</code> tab contains the server side dataSource definition for this ListGrid.\r" +
        "It has multiple <code>operationBinding</code>s defined with different <code>groupBy</code> and\r" +
        "<code>summaryFunction</code> settings.<br>\r" +
        "The client side Java code (under the <code>Source</code> tab) specifies which operationBinding to invoke.<br>" +
        "The initial fetch uses the specified default <code>fetchOperation</code> for the grid. " +
        "When the user selects a new operation, the change handler for the SelectItem puts together a new fetch request " +
        "and calls <code>requestProperties.setOperationId(...)</code>\r" +
        "to specify which operationBinding should be invoked.\r" +
        "<P>\r" +
        "To see this in action, choose an operation in the \"Operation\" drop-down.<br>\r" +
        "The following server-generated summary views are demonstrated here:\r" +
        "<ul>\r" +
        "<li/>Sum of <code>quantity * unitPrice</code> grouped by item\r" +
        "<li/>Sum of <code>quantity * unitPrice</code> grouped by customer\r" +
        "<li/>Minimum <code>unitPrice</code> grouped by item\r" +
        "<li/>Maximum <code>unitPrice</code> grouped by item\r" +
        "</ul>\r" +
        "Note: To get a total count of aggregated records within each summary row, this sample uses the\r" +
        "<code>count</code> summaryFunction applied to the <code>primaryKey</code> field.";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	BasicAggregationSample panel = new BasicAggregationSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	final ListGrid orderItemList = new ListGrid();
    	orderItemList.setDataSource(DataSource.get("basicAggregation_orderItem"));
    	orderItemList.setWidth(500);
    	orderItemList.setHeight(300);
    	orderItemList.setShowFilterEditor(true);
    	orderItemList.setAutoFetchData(true);
    	orderItemList.setFetchOperation("amountByItem");
    	orderItemList.setCanEdit(false);
    	orderItemList.setCanRemoveRecords(false);
    	
    	ListGridField orderCustomerName = new ListGridField("orderCustomerName");
    	orderCustomerName.setHidden(true);
    	orderCustomerName.setTitle("Customer name");
    	ListGridField itemDescription = new ListGridField("itemDescription");
    	ListGridField unitPrice = new ListGridField("unitPrice");
    	unitPrice.setType(ListGridFieldType.FLOAT);
    	unitPrice.setHidden(true);
    	ListGridField amount = new ListGridField("amount");
    	amount.setType(ListGridFieldType.INTEGER);
    	ListGridField pk = new ListGridField("pk");
    	pk.setTitle("Count");
    	
    	orderItemList.setFields(orderCustomerName,itemDescription,unitPrice,amount,pk);    	
    	
        DynamicForm operationForm = new DynamicForm();
        operationForm.setWidth(300);
        
        SelectItem operationId = new SelectItem();
        operationId.setDefaultToFirstOption(true);
        operationId.setTitle("Operation");
        
        Map<String,String> valueMap = new HashMap<String,String>();
        valueMap.put("amountByItem", "Amount by item");
        valueMap.put("amountByCustomer", "Amount by customer");
        valueMap.put("minPriceByItem", "Minimum price by item");
        valueMap.put("maxPriceByItem", "Maximum price by item");
        
        operationId.setValueMap(valueMap);
        operationId.addChangedHandler(new ChangedHandler() {
			@Override
			public void onChanged(ChangedEvent event) {
				String value = event.getValue().toString();
				DSRequest requestProperties = new DSRequest();
				requestProperties.setOperationId(value);
				orderItemList.fetchData(null, null, requestProperties);
				if (value.endsWith("ByItem")) {
                    orderItemList.hideField("orderCustomerName");
                    orderItemList.showField("itemDescription");
                } else {
                    orderItemList.showField("orderCustomerName");
                    orderItemList.hideField("itemDescription");
                }
                if (value.startsWith("amount")) {
                    orderItemList.hideField("unitPrice");
                    orderItemList.showField("amount");
                } else {
                    orderItemList.showField("unitPrice");
                    orderItemList.hideField("amount");
                }
			}
        });
        operationForm.setFields(operationId);
        		
        VStack vStack = new VStack();
        vStack.setWidth100();
        vStack.setMembersMargin(10);
        vStack.setMembers(operationForm,orderItemList);
        
        return vStack;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("basicAggregation_order.ds.xml", XML, "source/basicAggregation_order.ds.xml.html", true)
        };
    }
}