package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * For a validator of type <code>isUnique</code> in a component listing multiple records such as a ListGrid, can we use the
 * component's fetched data set to check for uniqueness? Used by {@link
 * com.smartgwt.client.widgets.form.validator.Validator#getCheckComponentData Validator.checkComponentData}. <P> It is
 * possible to check for uniqueness against a ListGrid's data set and "shortcut"  the validation process in a couple of
 * cases: <ul><li>If the grid has a complete data set from the DataSource, we can determine         whether a record is
 * unique or not by examining that data without ever querying the          DataSource.</li>     <li>Even if the grid is
 * only displaying a partial data set from the DataSource,          if the user-entered value collides with another loaded
 * record's value,          we can assert that the value is <b>not</b> unique.<br>         However, if the data set is not
 * complete we can only shortcut validation when         we find a collision. If we don't find a loaded record with a
 * matching value,         the DataSource will still need to be queried to definitively determine whether         the value
 * is unique.</li> </ul> Note that component data will <b>only</b> be consulted if the component is bound to a  dataSource
 * and has its data object set to a {@link com.smartgwt.client.data.ResultSet}. Additionally, with the exception of the
 * special <code>"forceBoth"</code> setting, component data will only be used to determine uniqueness if the following
 * conditions are met: <ul><li>The default fetch operation was used (e.g listGrid.fetchOperation has not been          
 * set)</li>     <li>The data object was automatically created by the component          {@link
 * com.smartgwt.client.widgets.grid.ListGrid#fetchData while fetching data},          as opposed to manually instantiated
 * by the application          developer.  This is because with a hand-created ResultSet, you could provide          any
 * set of records you want, so we don't know if they are an exact match for          the default fetch operation on the
 * DataSource.</li> </ul> Also note that, as with any validator understood by the server, uniqueness checking will always
 * be enforced on the server as part of a save operation once data is committed.<br> The <code>checkComponentData</code>
 * setting simply allows developers to optimize  performance by catching duplicate values on the client before the save
 * operation is sent to the server, or avoid hitting the server at all during {@link
 * com.smartgwt.client.widgets.form.DynamicForm#validate validation without saving} in cases where this is possible.
 */
public enum ClientUniquenessCheckCondition implements ValueEnum {
    /**
     * Never consult cached component data. Uniqueness checking will be performed directly against the dataSource data set
     * only.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "none".
     */
    NONE("none"),
    /**
     * If the component has a partial or complete data cache that meets the conditions outlined above, check for another
     * existing record in the cache with an identical field value. If one is found, the validator will fail on the client. If
     * no match is found, standard validation will proceed against the dataSource's full data set.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "earlyFailOnly".
     */
    EARLYFAILONLY("earlyFailOnly"),
    /**
     * If the component has a {@link com.smartgwt.client.data.ResultSet#allRowsCached complete data cache} that meets the
     * conditions outlined above, uniqueness checking will be performed against this data set only rather than querying the
     * dataSource to check for uniqueness.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "both".
     */
    BOTH("both"),
    /**
     * <i>[Advanced Setting]</i> As with <code>checkComponentData:"both"</code>, if a component has a {@link
     * com.smartgwt.client.data.ResultSet#allRowsCached complete data cache}, uniqueness checking will be peformed against this
     * data set instead of querying the dataSource. However unlike <code>checkComponentData:"both"</code>, the
     * <code>"forceBoth"</code> setting enables this behavior even if the component's data object has a custom fetch operation
     * specified, or was created explicitly by application code instead of being automatically created as part of the standard
     * <code>fetchData()</code> flow.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "forceBoth".
     */
    FORCEBOTH("forceBoth");
    private String value;

    ClientUniquenessCheckCondition(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
