/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a request to AI for a response.
 */
@BeanFactory.FrameworkClass
public class AIRequest extends RefDataClass {

    public static AIRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof AIRequest) {
            existingObj.setJsObj(jsObj);
            return (AIRequest)existingObj;
        } else

        {
            return new AIRequest(jsObj);
        }
    }
        


    public AIRequest(){
        
    }

    public AIRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * If provided, the {@link com.smartgwt.client.util.CancellationController} that will be looked to for whether the AI
     * request is canceled.
     *
     * @param cancellationController New cancellationController value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setCancellationController(CancellationController cancellationController) {
        return (AIRequest)setAttribute("cancellationController", cancellationController == null ? null : cancellationController.getOrCreateJsObj());
    }

    /**
     * If provided, the {@link com.smartgwt.client.util.CancellationController} that will be looked to for whether the AI
     * request is canceled.
     *
     * @return Current cancellationController value. Default value is null
     */
    public CancellationController getCancellationController()  {
        return CancellationController.getOrCreateRef(getAttributeAsJavaScriptObject("cancellationController"));
    }
    

    /**
     * When this engine does not support multiple messages, all of the messages of the request must be concatenated together.
     * This text is included verbatim before the concatenation of all-but-the-last non-system message.
     *
     * @param historyConclusion New historyConclusion value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setHistoryConclusion(String historyConclusion) {
        return (AIRequest)setAttribute("historyConclusion", historyConclusion);
    }

    /**
     * When this engine does not support multiple messages, all of the messages of the request must be concatenated together.
     * This text is included verbatim before the concatenation of all-but-the-last non-system message.
     *
     * @return Current historyConclusion value. Default value is null
     */
    public String getHistoryConclusion()  {
        return getAttributeAsString("historyConclusion");
    }
    

    /**
     * When this engine does not support multiple messages, all of the messages of the request must be concatenated together.
     * This maps the {@link com.smartgwt.client.types.AIMessageSource} to the delimiter to be used to enclose the content of
     * the message.
     *
     * @param historyDelimiters New historyDelimiters value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setHistoryDelimiters(Map historyDelimiters) {
        return (AIRequest)setAttribute("historyDelimiters", historyDelimiters);
    }

    /**
     * When this engine does not support multiple messages, all of the messages of the request must be concatenated together.
     * This maps the {@link com.smartgwt.client.types.AIMessageSource} to the delimiter to be used to enclose the content of
     * the message.
     *
     * @return Current historyDelimiters value. Default value is null
     */
    public Map getHistoryDelimiters()  {
        return getAttributeAsMap("historyDelimiters");
    }
    

    /**
     * When this engine does not support multiple messages, all of the messages of the request must be concatenated together.
     * This text is included verbatim before the concatenation of all-but-the-last non-system message.
     *
     * @param historyIntroduction New historyIntroduction value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setHistoryIntroduction(String historyIntroduction) {
        return (AIRequest)setAttribute("historyIntroduction", historyIntroduction);
    }

    /**
     * When this engine does not support multiple messages, all of the messages of the request must be concatenated together.
     * This text is included verbatim before the concatenation of all-but-the-last non-system message.
     *
     * @return Current historyIntroduction value. Default value is null
     */
    public String getHistoryIntroduction()  {
        return getAttributeAsString("historyIntroduction");
    }
    

    /**
     * List of messages forming the request.
     *
     * @param messages New messages value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setMessages(AIMessageWithSource... messages) {
        return (AIRequest)setAttribute("messages", messages);
    }

    /**
     * List of messages forming the request.
     *
     * @return Current messages value. Default value is null
     */
    public AIMessageWithSource[] getMessages()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfAIMessageWithSource(getAttributeAsJavaScriptObject("messages"));
    }
    

    /**
     * Prompt text to AI. If {@link com.smartgwt.client.ai.AIRequest#getMessages messages} are also provided, then this prompt
     * is appended as another message with type "text" and source "user" when submitted to AI.
     *
     * @param prompt New prompt value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setPrompt(String prompt) {
        return (AIRequest)setAttribute("prompt", prompt);
    }

    /**
     * Prompt text to AI. If {@link com.smartgwt.client.ai.AIRequest#getMessages messages} are also provided, then this prompt
     * is appended as another message with type "text" and source "user" when submitted to AI.
     *
     * @return Current prompt value. Default value is null
     */
    public String getPrompt()  {
        return getAttributeAsString("prompt");
    }
    

    /**
     * When the {@link com.smartgwt.client.ai.AIRequest#getResponseType responseType} is "number", the maximum value that the
     * response may take. If not specified, then there is no maximum.
     *
     * @param responseMaximum New responseMaximum value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setResponseMaximum(Integer responseMaximum) {
        return (AIRequest)setAttribute("responseMaximum", responseMaximum);
    }

    /**
     * When the {@link com.smartgwt.client.ai.AIRequest#getResponseType responseType} is "number", the maximum value that the
     * response may take. If not specified, then there is no maximum.
     *
     * @return Current responseMaximum value. Default value is null
     */
    public Integer getResponseMaximum()  {
        return getAttributeAsInt("responseMaximum");
    }
    

    /**
     * When the {@link com.smartgwt.client.ai.AIRequest#getResponseType responseType} is "number", the minimum value that the
     * response may take. If not specified, then there is no minimum.
     *
     * @param responseMinimum New responseMinimum value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setResponseMinimum(Integer responseMinimum) {
        return (AIRequest)setAttribute("responseMinimum", responseMinimum);
    }

    /**
     * When the {@link com.smartgwt.client.ai.AIRequest#getResponseType responseType} is "number", the minimum value that the
     * response may take. If not specified, then there is no minimum.
     *
     * @return Current responseMinimum value. Default value is null
     */
    public Integer getResponseMinimum()  {
        return getAttributeAsInt("responseMinimum");
    }
    

    /**
     * The type of content expected from AI. <p> If this type is "number", then the response from AI is constrained by {@link
     * com.smartgwt.client.ai.AIRequest#getResponseMinimum responseMinimum} and {@link
     * com.smartgwt.client.ai.AIRequest#getResponseMaximum responseMaximum}.
     *
     * @param responseType New responseType value. Default value is "text"
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setResponseType(AIContentType responseType) {
        return (AIRequest)setAttribute("responseType", responseType == null ? null : responseType.getValue());
    }

    /**
     * The type of content expected from AI. <p> If this type is "number", then the response from AI is constrained by {@link
     * com.smartgwt.client.ai.AIRequest#getResponseMinimum responseMinimum} and {@link
     * com.smartgwt.client.ai.AIRequest#getResponseMaximum responseMaximum}.
     *
     * @return Current responseType value. Default value is "text"
     */
    public AIContentType getResponseType()  {
        return EnumUtil.getEnum(AIContentType.values(), getAttribute("responseType"));
    }
    

    /**
     * A number from 0 to 1 representing how much variability or creativity in responses AI should generate. 0 is little-to-no
     * variation. 1 is high variation.
     *
     * @param temperature New temperature value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIRequest AIRequest} instance, for chaining setter calls
     */
    public AIRequest setTemperature(Integer temperature) {
        return (AIRequest)setAttribute("temperature", temperature);
    }

    /**
     * A number from 0 to 1 representing how much variability or creativity in responses AI should generate. 0 is little-to-no
     * variation. 1 is high variation.
     *
     * @return Current temperature value. Default value is null
     */
    public Integer getTemperature()  {
        return getAttributeAsInt("temperature");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
