/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexRule {
    private static Logger log = new Logger(RegexRule.class.getName());
    private static String testPath = "justTesting";
    private static List validActions = Config.getGlobal().getList("RegexRules.validActions");
    public String rule;
    public Pattern pattern;
    public String action;
    public String location;

    public RegexRule(String rule) throws Exception {
        this(rule, "[not specified]");
    }

    public RegexRule(String rule, String location) throws Exception {
        this.location = location;
        this.rule = rule;
        int colonIndex = rule.indexOf(":");
        if (colonIndex == -1) {
            throw new Exception("Malfromed rule: " + this.toString() + " - expected format is action:regex");
        }
        this.action = rule.substring(0, colonIndex);
        String regexRule = rule.substring(colonIndex + 1, rule.length());
        try {
            this.pattern = Pattern.compile(regexRule);
            Matcher matcher = this.pattern.matcher(testPath);
            matcher.find();
        }
        catch (Exception e) {
            log.error((Object)("Malformed regexp in rule: " + rule), e);
            throw e;
        }
        if (validActions == null) {
            throw new Exception("Unable to initialize list of valid regex actions - please set RegexRules.validActions in server.properties to a comma-delimited list of names");
        }
        if (!validActions.contains(this.action)) {
            if (this.action.contains(";")) {
                String parsedAction = this.action.substring(0, this.action.indexOf(";"));
                if (!validActions.contains(parsedAction)) {
                    throw new Exception("Malformed rule: " + this.toString() + " - action: " + this.action + " is invalid - valid actions are: " + validActions.toString());
                }
            } else {
                throw new Exception("Malformed rule: " + this.toString() + " - action: " + this.action + " is invalid - valid actions are: " + validActions.toString());
            }
        }
    }

    public boolean match(String comparePath) throws Exception {
        return this.pattern.matcher(comparePath).find();
    }

    public String getRule() {
        return this.rule;
    }

    public String getAction() {
        return this.action;
    }

    public String getRegexRule() {
        return this.pattern.pattern();
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return this.rule + " located in: " + this.location;
    }
}

