/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.log.Logger;
import com.isomorphic.util.LocaleMessageProvider;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleMessageProviderRegistry {
    private static Logger log = new Logger(LocaleMessageProviderRegistry.class.getName());
    private static Map providers = new LinkedHashMap();
    private static Map dsProviders = new LinkedHashMap();
    private static int counter = 0;
    private static final int DEFAULT_PROVIDER = -1;
    private static Map<Integer, Location> idMap = new HashMap<Integer, Location>();
    private static final Object syncFlag = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addLocaleMessageProvider(LocaleMessageProvider lmp) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.add(providers, lmp, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addLocaleMessageProvider(LocaleMessageProvider lmp, String prefix) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.add(providers, lmp, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addLocaleMessageProvider(LocaleMessageProvider lmp, Pattern regex) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.add(providers, lmp, regex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addDSLocaleMessageProvider(LocaleMessageProvider lmp) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.add(dsProviders, lmp, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addDSLocaleMessageProvider(LocaleMessageProvider lmp, String prefix) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.add(dsProviders, lmp, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addDSLocaleMessageProvider(LocaleMessageProvider lmp, Pattern regex) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.add(dsProviders, lmp, regex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeLocaleMessageProvider(int id) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleMessageProvider getLocaleMessageProvider(String id) {
        Object object = syncFlag;
        synchronized (object) {
            return LocaleMessageProviderRegistry.get(providers, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleMessageProvider getDSLocaleMessageProvider(String id) {
        Object object = syncFlag;
        synchronized (object) {
            LocaleMessageProvider lmp = LocaleMessageProviderRegistry.get(dsProviders, id);
            if (lmp != null) {
                return lmp;
            }
        }
        return LocaleMessageProviderRegistry.getLocaleMessageProvider(id);
    }

    private static int add(Map providersMap, LocaleMessageProvider lmp, Object param) {
        int id = counter++;
        Object value = providersMap.get(param);
        if (value == null || param.equals(-1)) {
            providersMap.put(param, lmp);
        } else if (value instanceof LocaleMessageProvider) {
            LinkedList<Object> lmpList = new LinkedList<Object>();
            lmpList.add(value);
            lmpList.add(lmp);
            providersMap.put(param, lmpList);
        } else if (value instanceof List) {
            ((List)value).add(lmp);
        }
        idMap.put(id, new Location(providersMap, param, lmp));
        return id;
    }

    private static boolean remove(int id) {
        Location loc = idMap.get(id);
        if (loc == null) {
            return false;
        }
        Object value = loc.providersMap.get(loc.param);
        if (value instanceof List) {
            List list = (List)value;
            list.remove(loc.lmp);
            if (list.size() == 1) {
                loc.providersMap.put(loc.param, list.get(0));
            }
            idMap.remove(id);
            return true;
        }
        if (value instanceof LocaleMessageProvider) {
            loc.providersMap.remove(loc.param);
            idMap.remove(id);
            return true;
        }
        if (value == null) {
            idMap.remove(id);
            return false;
        }
        return false;
    }

    private static LocaleMessageProvider get(Map _providersMap, String id) {
        if (id != null) {
            for (Object keyObj : _providersMap.keySet()) {
                Pattern p;
                Matcher m;
                if (!(keyObj instanceof String ? id.startsWith((String)keyObj) : keyObj instanceof Pattern && (m = (p = (Pattern)keyObj).matcher(id)).find())) continue;
                return (LocaleMessageProvider)_providersMap.get(keyObj);
            }
        }
        return (LocaleMessageProvider)_providersMap.get(-1);
    }

    private static class Location {
        Map providersMap;
        Object param;
        LocaleMessageProvider lmp;

        Location(Map _providersMap, Object _param, LocaleMessageProvider _lmp) {
            this.providersMap = _providersMap;
            this.param = _param;
            this.lmp = _lmp;
        }
    }
}

