/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.rg.CssResourceGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MergeIdenticalSelectorsVisitor
extends CssModVisitor {
    private final Map<String, CssRule> canonicalRules = new HashMap<String, CssRule>();
    private final List<CssRule> rulesInOrder = new ArrayList<CssRule>();

    @Override
    public boolean visit(CssIf x, Context ctx) {
        this.visitInNewContext(x.getNodes());
        this.visitInNewContext(x.getElseNodes());
        return false;
    }

    @Override
    public boolean visit(CssMediaRule x, Context ctx) {
        this.visitInNewContext(x.getNodes());
        return false;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        assert (x.getSelectors().size() == 1);
        CssSelector sel = x.getSelectors().get(0);
        if (this.canonicalRules.containsKey(sel.getSelector())) {
            CssRule canonical = this.canonicalRules.get(sel.getSelector());
            boolean hasCommon = false;
            int index = this.rulesInOrder.indexOf(canonical) + 1;
            assert (index != 0);
            ListIterator<CssRule> i = this.rulesInOrder.listIterator(index);
            while (i.hasNext() && !hasCommon) {
                hasCommon = CssResourceGenerator.haveCommonProperties((CssRule)i.next(), x);
            }
            if (!hasCommon) {
                canonical.getProperties().addAll(x.getProperties());
                ctx.removeMe();
                return false;
            }
        }
        this.canonicalRules.put(sel.getSelector(), x);
        this.rulesInOrder.add(x);
        return false;
    }

    private void visitInNewContext(List<CssNode> nodes) {
        MergeIdenticalSelectorsVisitor v = new MergeIdenticalSelectorsVisitor();
        v.acceptWithInsertRemove(nodes);
        this.rulesInOrder.addAll(v.rulesInOrder);
    }
}

