/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authentication;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.Project;
import com.isomorphic.xml.ProjectLoadSettings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProjectLoaderServlet
extends BaseServlet {
    public static final String PARAM_PROJECT_NAME = "projectName";
    public static final String PARAM_SCREEN_NAMES = "screenNames";
    public static final String PARAM_OMIT_DATASOURCES = "omitDataSources";
    public static final String PARAM_CURRENT_SCREEN_NAME = "currentScreenName";
    public static final String PARAM_DRAW_FIRST_SCREEN = "drawFirstScreen";
    public static final String PARAM_INCLUDE_CUSTOM = "includeCustomizations";
    public static final String PARAM_INCLUDE_XML = "includeXML";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_OWNER_ID = "ownerId";
    public static final String PARAM_SHARE_ID = "shareId";
    private static Logger log = new Logger(ProjectLoaderServlet.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/javascript;charset=" + encoding);
        } else {
            response.setContentType("application/javascript");
        }
        String localeName = request.getParameter(PARAM_LOCALE);
        Locale requestLocale = request.getLocale();
        String ownerId = null;
        String owner = request.getParameter(PARAM_OWNER_ID);
        if (owner != null) {
            ownerId = owner;
        }
        if (ownerId == null) {
            ownerId = request.getRemoteUser();
        }
        String shareId = request.getParameter(PARAM_SHARE_ID);
        List<String> screenNames = null;
        String names = request.getParameter(PARAM_SCREEN_NAMES);
        if (names != null) {
            screenNames = Arrays.asList(names.split(","));
        }
        boolean drawFirstScreen = false;
        String drawFirstScreenParam = request.getParameter(PARAM_DRAW_FIRST_SCREEN);
        if (DataTools.parseBoolean(drawFirstScreenParam) == Boolean.TRUE) {
            drawFirstScreen = true;
        }
        boolean includeCustomizations = false;
        String includeCustomParam = request.getParameter(PARAM_INCLUDE_CUSTOM);
        if (DataTools.parseBoolean(includeCustomParam) == Boolean.TRUE) {
            includeCustomizations = true;
        }
        String currentScreenName = request.getParameter(PARAM_CURRENT_SCREEN_NAME);
        AuthenticatedUser user = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            user = (AuthenticatedUser)Authentication.getUser(context);
        }
        catch (Exception e) {
            log.info((Object)"unable to resolve authenticated user", e);
        }
        List<String> excludedDS = null;
        String excludedDSString = request.getParameter(PARAM_OMIT_DATASOURCES);
        if (excludedDSString != null) {
            excludedDS = Arrays.asList(excludedDSString.split(","));
        }
        boolean includeXML = false;
        String includeXMLParam = request.getParameter(PARAM_INCLUDE_XML);
        if (DataTools.parseBoolean(includeXMLParam) == Boolean.TRUE) {
            includeXML = true;
        }
        try {
            StringWriter writer = new StringWriter();
            String projectName = request.getParameter(PARAM_PROJECT_NAME);
            if (projectName == null) {
                log.warn("Parameter \"projectName\" is not specified.");
            } else if ("".equals(projectName.trim())) {
                log.warn("No data specified in parameter \"projectName\".");
            } else {
                log.debug("Requested projects:" + projectName);
                ProjectLoadSettings settings = new ProjectLoadSettings(currentScreenName, ownerId, localeName, requestLocale, shareId, screenNames, drawFirstScreen, includeCustomizations);
                settings.setExcludedDS(excludedDS);
                settings.setCurrentUser(user);
                settings.setIncludeXML(includeXML);
                List project = Project.getResourcesMap(projectName, settings, null);
                JSTranslater jsTrans = JSTranslater.instance();
                jsTrans.setLocale(settings.getLocale());
                jsTrans.setObfuscation(false);
                jsTrans.strictJSONMode();
                jsTrans.toJS(project, writer);
            }
            log.debug("Generated response:" + ((Object)writer).toString());
            response.setStatus(200);
            PrintWriter rw = response.getWriter();
            rw.print(((Object)writer).toString());
            rw.close();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (IOException writer) {}
        }
    }
}

