/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.log.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSFieldFormula {
    private static Logger log = new Logger(DSFieldFormula.class);
    private static final String FUNCTION_NAME = "___FUNCTION_NAME___";
    private static String rename = "^___FUNCTION_NAME___(?= *\\()|(?<=[\\Q+-\\*/( \\E])___FUNCTION_NAME___(?= *\\()";
    private static String rename2 = "^___FUNCTION_NAME___[ *\\(]|(?<=[\\Q+-\\*/( \\E])___FUNCTION_NAME___[ *\\(]";
    private static Map<String, Pattern> patternCache;

    private static Pattern getPattern(String functionName) {
        Pattern pattern;
        if (functionName == null || "".equals(functionName.trim())) {
            return null;
        }
        if (patternCache == null) {
            patternCache = new HashMap<String, Pattern>();
        }
        if ((pattern = patternCache.get(functionName)) == null) {
            String regex = functionName.endsWith("(") ? rename2 : rename;
            String cleanFunctionName = (functionName.contains("(") ? functionName.substring(0, functionName.indexOf("(")) : functionName).trim();
            pattern = Pattern.compile(regex.replaceAll(FUNCTION_NAME, cleanFunctionName), 2);
            patternCache.put(functionName, pattern);
        }
        return pattern;
    }

    public static String replace(String formula, String functionName, String replacement) {
        if (formula == null || "".equals(formula.trim())) {
            return null;
        }
        if (functionName == null || "".equals(functionName.trim())) {
            return formula;
        }
        if (replacement == null || "".equals(replacement.trim())) {
            return formula;
        }
        String cleanFunctionName = (functionName.contains("(") ? functionName.substring(0, functionName.indexOf("(")) : functionName).trim();
        if (!formula.toLowerCase().contains(cleanFunctionName.toLowerCase())) {
            return formula;
        }
        Pattern pattern = DSFieldFormula.getPattern(functionName);
        Matcher m = pattern.matcher(formula);
        return m.replaceAll(replacement);
    }
}

