/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.store.ExpiringCache;
import com.isomorphic.store.ExpiringValue;
import com.isomorphic.util.BMPRContents;
import java.util.List;
import java.util.Map;

public class BMPRReaderDataSource
extends BasicDataSource {
    private static Logger log = new Logger(BMPRReaderDataSource.class.getName());
    private static int CACHE_TIMEOUT = 300000;
    private static int MAX_ENTRIES = 25;
    private static ExpiringCache<String, BMPRContents> cache = new ExpiringCache(CACHE_TIMEOUT, MAX_ENTRIES);

    public static String cacheBMPRContents(BMPRContents contents) {
        String ID = contents.getID();
        cache.put(ID, contents);
        return ID;
    }

    public static BMPRContents getBMPRContents(String ID) {
        BMPRContents contents = null;
        ExpiringValue<BMPRContents> value = cache.get(ID);
        if (value != null) {
            contents = value.get();
        }
        return contents;
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        String ID = (String)req.getCriteria().get("ID");
        String recordType = (String)req.getCriteria().get("recordType");
        String branchId = (String)req.getCriteria().get("branchId");
        List<Map<String, Object>> data = null;
        DSResponse dsResponse = new DSResponse(this);
        BMPRContents contents = BMPRReaderDataSource.getBMPRContents(ID);
        if (contents != null) {
            data = contents.getRecords(recordType, branchId);
        }
        dsResponse.setData(data);
        dsResponse.setStatus(0);
        return dsResponse;
    }
}

